/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.refactoring.UnusedResourcesHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedResourcesQuickFix
implements AndroidLintQuickFix {
    private final String myResource;

    public UnusedResourcesQuickFix(@Nullable String resource) {
        this.myResource = resource;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        Project project = startElement.getProject();
        UnusedResourcesHandler.invoke(project, null, this.myResource, true, true);
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myResource != null ? "Remove Declarations for " + this.myResource : "Remove All Unused Resources";
    }
}

