/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.dom.resources.StyleItem;
import org.jetbrains.android.refactoring.AndroidAttributeInfo;
import org.jetbrains.android.refactoring.StyleRefData;
import org.jetbrains.android.refactoring.StyleUsageData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ParentStyleUsageData
implements StyleUsageData {
    private final AndroidResourceReferenceBase myReference;
    private final Style myStyle;

    public ParentStyleUsageData(@NotNull Style style, @NotNull AndroidResourceReferenceBase reference) {
        this.myReference = reference;
        this.myStyle = style;
    }

    @Override
    public PsiFile getFile() {
        XmlTag tag = this.myStyle.getXmlTag();
        return tag != null ? tag.getContainingFile() : null;
    }

    @Override
    public void inline(@NotNull Map<AndroidAttributeInfo, String> attributeValues, @Nullable StyleRefData parentStyleRef) {
        Map<String, String> id2Value = ParentStyleUsageData.toId2ValueMap(attributeValues);
        for (StyleItem styleItem : this.myStyle.getItems()) {
            String name = styleItem.getName().getStringValue();
            if (name == null) continue;
            id2Value.remove(name);
        }
        for (Map.Entry entry : id2Value.entrySet()) {
            StyleItem newItem = this.myStyle.addItem();
            newItem.getName().setStringValue((String)entry.getKey());
            newItem.setStringValue((String)entry.getValue());
        }
        String styleName = this.myStyle.getName().getStringValue();
        boolean bl = parentStyleRef != null && parentStyleRef.getStylePackage() == null && styleName != null && (styleName.startsWith(parentStyleRef.getStyleName() + ".") || styleName.equals(parentStyleRef.getStyleName()));
        this.myStyle.getParentStyle().setValue(parentStyleRef != null && !bl ? ResourceValue.referenceTo('\u0000', parentStyleRef.getStylePackage(), null, parentStyleRef.getStyleName()) : null);
    }

    private static Map<String, String> toId2ValueMap(Map<AndroidAttributeInfo, String> info2ValueMap) {
        HashMap result = new HashMap(info2ValueMap.size());
        for (Map.Entry<AndroidAttributeInfo, String> entry : info2ValueMap.entrySet()) {
            result.put(entry.getKey().getAttributeId(), entry.getValue());
        }
        return result;
    }

    @Override
    @NotNull
    public AndroidResourceReferenceBase getReference() {
        return this.myReference;
    }
}

