/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.projectView;

import com.android.resources.ResourceFolderType;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.projectView.ResourceDirectoryNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceMergerTreeStructureProvider
implements TreeStructureProvider {
    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children, ViewSettings settings) {
        if (!ApplicationManager.getApplication().isInternal()) {
            return children;
        }
        if (parent instanceof PsiDirectoryNode) {
            PsiDirectory directory = (PsiDirectory)((PsiDirectoryNode)parent).getValue();
            if (!directory.getName().equals("res")) {
                return children;
            }
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)directory);
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) {
                return children;
            }
            return ResourceMergerTreeStructureProvider.mergeResourceDirectories(children, settings);
        }
        return children;
    }

    private static Collection<AbstractTreeNode> mergeResourceDirectories(Collection<AbstractTreeNode> children, ViewSettings settings) {
        ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
        HashMap resourceDirectories = new HashMap();
        for (AbstractTreeNode child : children) {
            if (!(child instanceof PsiDirectoryNode)) {
                result.add(child);
                continue;
            }
            PsiDirectoryNode directoryNode = (PsiDirectoryNode)child;
            PsiDirectory directory = (PsiDirectory)directoryNode.getValue();
            ResourceFolderType type = ResourceFolderType.getFolderType((String)directory.getName());
            if (type == null) {
                result.add(child);
                continue;
            }
            ResourceDirectoryNode node = (ResourceDirectoryNode)((Object)resourceDirectories.get(type));
            if (node != null && directory.getName().contains("-")) continue;
            node = new ResourceDirectoryNode(directoryNode.getProject(), directoryNode, settings);
            resourceDirectories.put(type, node);
        }
        for (ResourceDirectoryNode node : resourceDirectories.values()) {
            node.collectChildren();
            result.add((AbstractTreeNode)node);
        }
        return result;
    }

    @Nullable
    public Object getData(Collection<AbstractTreeNode> selected, String dataName) {
        return null;
    }
}

