/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.projectView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceDirectoryNode
extends ProjectViewNode<PsiDirectory> {
    private final Map<String, AbstractTreeNode> myChildMap = new HashMap();
    private final ArrayList<AbstractTreeNode> myChildren = new ArrayList();
    private final PsiDirectoryNode myBaseNode;

    protected ResourceDirectoryNode(Project project, PsiDirectoryNode directory, ViewSettings viewSettings) {
        super(project, directory.getValue(), viewSettings);
        this.myBaseNode = directory;
    }

    public boolean contains(@NotNull VirtualFile file) {
        return false;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        return this.myChildren;
    }

    protected void update(PresentationData presentation) {
        presentation.clearText();
        presentation.addText(((PsiDirectory)this.getValue()).getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.setPresentableText(((PsiDirectory)this.getValue()).getName());
        presentation.setIcon(((PsiDirectory)this.getValue()).getIcon(0));
    }

    public void collectChildren() {
        for (AbstractTreeNode child : this.myBaseNode.getChildren()) {
            Object value = child.getValue();
            if (value instanceof PsiNamedElement) {
                String name = ((PsiNamedElement)value).getName();
                if (this.myChildMap.containsKey(name)) continue;
                this.myChildMap.put(name, child);
                this.myChildren.add(child);
                continue;
            }
            this.myChildren.add(child);
        }
    }

    @Nullable
    public String getTestPresentation() {
        return "ResourceDirectory:" + ((PsiDirectory)this.getValue()).getName();
    }

    public String toString() {
        return "ResourceDirectory:" + ((PsiDirectory)this.getValue()).getName();
    }
}

