/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.newProject;

import com.android.tools.idea.gradle.util.Projects;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.ProjectTemplatesFactory;
import com.intellij.platform.templates.BuilderBasedTemplate;
import com.intellij.util.ArrayUtil;
import icons.AndroidIcons;
import javax.swing.Icon;
import org.jetbrains.android.newProject.AndroidModuleBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProjectTemplatesFactory
extends ProjectTemplatesFactory {
    public static final String ANDROID = "Android";
    public static final String EMPTY_MODULE = "Empty Module";
    public static final String LIBRARY_MODULE = "Library Module";
    public static final String TEST_MODULE = "Test Module";
    public static final ProjectTemplate[] EMPTY_PROJECT_TEMPLATES = new ProjectTemplate[0];

    @NotNull
    public String[] getGroups() {
        return new String[]{ANDROID};
    }

    public Icon getGroupIcon(String group) {
        return AndroidIcons.Android;
    }

    public String getParentGroup(String group) {
        return "Java";
    }

    @NotNull
    public ProjectTemplate[] createTemplates(@Nullable String group, WizardContext context) {
        Project project = context.getProject();
        if (project != null && Projects.requiresAndroidModel(project)) {
            return EMPTY_PROJECT_TEMPLATES;
        }
        Object[] templates = new ProjectTemplate[]{new BuilderBasedTemplate((ModuleBuilder)new AndroidModuleBuilder()), new AndroidProjectTemplate(EMPTY_MODULE, "Simple Android module with configured Android SDK and without any pre-defined structure", new AndroidModuleBuilder(null){

            @Override
            public String getBuilderId() {
                return "android.empty";
            }

            @Override
            public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
                return ModuleWizardStep.EMPTY_ARRAY;
            }
        }), new AndroidProjectTemplate(LIBRARY_MODULE, "Android library modules hold shared Android source code and resources that can be referenced by other Android modules", new AndroidModuleBuilder.Library())};
        if (project == null) {
            return templates;
        }
        AndroidProjectTemplate test = new AndroidProjectTemplate(TEST_MODULE, "Android test modules contain Android applications that you write using the <a href='http://developer.android.com/tools/testing/index.html'>Testing and Instrumentation framework</a>", new AndroidModuleBuilder.Test());
        return (ProjectTemplate[])ArrayUtil.append((Object[])templates, (Object)((Object)test));
    }

    private static class AndroidProjectTemplate
    extends BuilderBasedTemplate {
        private final String myName;
        private final String myDescription;

        private AndroidProjectTemplate(String name, String description, AndroidModuleBuilder builder) {
            super((ModuleBuilder)builder);
            this.myName = name;
            this.myDescription = description;
        }

        @NotNull
        public String getName() {
            return this.myName;
        }

        @Nullable
        public String getDescription() {
            return this.myDescription;
        }
    }
}

