/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.maven;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.maven.AndroidMavenProvider;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class AndroidMavenUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.maven.AndroidMavenUtil");
    @NonNls
    public static final String APKSOURCES_DEPENDENCY_TYPE = "apksources";
    @NonNls
    public static final String APKLIB_DEPENDENCY_AND_PACKAGING_TYPE = "apklib";
    @NonNls
    public static final String SO_PACKAGING_AND_DEPENDENCY_TYPE = "so";
    @NonNls
    public static final String APK_PACKAGING_TYPE = "apk";
    @NonNls
    public static final String AAR_DEPENDENCY_AND_PACKAGING_TYPE = "aar";
    @NonNls
    public static final String APK_LIB_ARTIFACT_SOURCE_ROOT = "src";
    @NonNls
    public static final String APK_LIB_ARTIFACT_RES_DIR = "res";
    public static final String APK_LIB_ARTIFACT_NATIVE_LIBS_DIR = "libs";
    public static final String APK_LIB_ARTIFACT_MANIFEST_FILE = "AndroidManifest.xml";
    @NonNls
    private static final String APKLIB_MODULE_PREFIX = "~apklib-";
    @NonNls
    private static final String GEN_EXTERNAL_APKLIBS_DIRNAME = "gen-external-apklibs";

    private AndroidMavenUtil() {
    }

    @Nullable
    public static String computePathForGenExternalApklibsDir(@NotNull MavenId mavenId, @NotNull MavenProject project, @NotNull Collection<MavenProject> allProjects) {
        String path = null;
        boolean resultUnderApp = false;
        for (MavenProject p : allProjects) {
            List dependencies = p.findDependencies(mavenId);
            if (dependencies.size() == 0) {
                dependencies = p.findDependencies(mavenId.getGroupId(), mavenId.getArtifactId());
            }
            if (dependencies.size() <= 0 || !AndroidMavenUtil.containsCompileDependency(dependencies)) continue;
            VirtualFile projectDir = p.getDirectoryFile();
            boolean app = APK_PACKAGING_TYPE.equals(p.getPackaging());
            if (path != null && (resultUnderApp || !app)) continue;
            path = projectDir.getPath() + '/' + GEN_EXTERNAL_APKLIBS_DIRNAME;
            resultUnderApp = app;
        }
        if (path == null) {
            path = AndroidMavenUtil.getGenExternalApklibDirInProject(project);
        }
        return path;
    }

    @NotNull
    public static String getGenExternalApklibDirInProject(@NotNull MavenProject project) {
        return project.getDirectoryFile().getPath() + '/' + GEN_EXTERNAL_APKLIBS_DIRNAME;
    }

    private static boolean containsCompileDependency(Collection<MavenArtifact> dependencies) {
        for (MavenArtifact dependency : dependencies) {
            if (!"compile".equals(dependency.getScope())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String getModuleNameForExtApklibArtifact(MavenId mavenId) {
        return APKLIB_MODULE_PREFIX + AndroidMavenUtil.getMavenIdStringForFileName(mavenId);
    }

    @Nullable
    public static String getMavenIdStringByExtApklibModule(@NotNull Module module) {
        String moduleName = module.getName();
        if (!moduleName.startsWith(APKLIB_MODULE_PREFIX)) {
            return null;
        }
        return moduleName.substring(APKLIB_MODULE_PREFIX.length());
    }

    public static boolean isExtApklibModule(@NotNull Module module) {
        return module.getName().startsWith(APKLIB_MODULE_PREFIX);
    }

    @NotNull
    public static String getMavenIdStringForFileName(@NotNull MavenId mavenId) {
        String artifactId = mavenId.getKey().replace(':', '_');
        return artifactId != null ? artifactId : "null";
    }

    public static boolean isMavenizedModule(@NotNull Module module) {
        AndroidMavenProvider mavenProxy = AndroidMavenUtil.getMavenProvider();
        return mavenProxy != null && mavenProxy.isMavenizedModule(module);
    }

    public static boolean isMavenAarDependency(@NotNull Module module, @NotNull OrderEntry entry) {
        if (ApplicationManager.getApplication().isUnitTestMode() && entry.getPresentableName().equals("maven_aar_dependency")) {
            return true;
        }
        if (!(entry instanceof LibraryOrderEntry) || !AndroidMavenUtil.isMavenizedModule(module)) {
            return false;
        }
        Library library = ((LibraryOrderEntry)entry).getLibrary();
        if (library == null) {
            return false;
        }
        MavenProject mavenProject = MavenProjectsManager.getInstance((Project)module.getProject()).findProject(module);
        if (mavenProject == null) {
            return false;
        }
        MavenArtifact artifact = MavenRootModelAdapter.findArtifact((MavenProject)mavenProject, (Library)library);
        return artifact != null && AAR_DEPENDENCY_AND_PACKAGING_TYPE.equals(artifact.getType());
    }

    @Nullable
    public static AndroidMavenProvider getMavenProvider() {
        return (AndroidMavenProvider)ArrayUtil.getFirstElement((Object[])AndroidMavenProvider.EP_NAME.getExtensions());
    }
}

