/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ReplaceStringQuickFix
implements AndroidLintQuickFix {
    private final String myName;
    private final String myRegexp;
    private final String myNewValue;

    ReplaceStringQuickFix(@Nullable String name, @Nullable String regexp, @NotNull String newValue) {
        this.myName = name;
        this.myNewValue = newValue;
        if (regexp != null && regexp.indexOf(40) == -1) {
            regexp = "(" + Pattern.quote(regexp) + ")";
        }
        this.myRegexp = regexp;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myName == null) {
            return "Replace with " + this.myNewValue;
        }
        return this.myName;
    }

    @Nullable
    protected String getNewValue() {
        return this.myNewValue;
    }

    protected void editBefore(@NotNull Document document) {
    }

    protected void editAfter(@NotNull Document document) {
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        Document document = FileDocumentManager.getInstance().getDocument(startElement.getContainingFile().getVirtualFile());
        String newValue = this.getNewValue();
        if (document != null && newValue != null) {
            this.editBefore(document);
            TextRange range = this.getRange(startElement, endElement);
            if (range != null) {
                document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)newValue);
                this.editAfter(document);
            }
        }
    }

    @Nullable
    private TextRange getRange(PsiElement startElement, PsiElement endElement) {
        int end;
        int start;
        block5: {
            if (!startElement.isValid() || !endElement.isValid()) {
                return null;
            }
            start = startElement.getTextOffset();
            end = endElement.getTextOffset() + endElement.getTextLength();
            if (this.myRegexp != null) {
                try {
                    Pattern pattern = Pattern.compile(this.myRegexp, 8);
                    String text = startElement.getContainingFile().getText();
                    String sequence = text.substring(start, end);
                    Matcher matcher = pattern.matcher(sequence);
                    if (matcher.find()) {
                        end = start + matcher.end(1);
                        start += matcher.start(1);
                        break block5;
                    }
                    return null;
                }
                catch (Exception e) {
                    Logger.getInstance(ReplaceStringQuickFix.class).warn("Invalid regular expression " + this.myRegexp);
                    return null;
                }
            }
        }
        return new TextRange(start, end);
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return this.getRange(startElement, endElement) != null;
    }
}

