/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.resources.ResourceUrl;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.actions.OverrideResourceAction;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.android.tools.idea.uibuilder.actions.UpgradeConstraintLayoutFix;
import com.android.tools.lint.checks.AccessibilityDetector;
import com.android.tools.lint.checks.AddJavascriptInterfaceDetector;
import com.android.tools.lint.checks.AlarmDetector;
import com.android.tools.lint.checks.AllowAllHostnameVerifierDetector;
import com.android.tools.lint.checks.AlwaysShowActionDetector;
import com.android.tools.lint.checks.AndroidAutoDetector;
import com.android.tools.lint.checks.AndroidTvDetector;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.checks.AppCompatCallDetector;
import com.android.tools.lint.checks.AppCompatResourceDetector;
import com.android.tools.lint.checks.AppIndexingApiDetector;
import com.android.tools.lint.checks.AppLinksAutoVerifyDetector;
import com.android.tools.lint.checks.ArraySizeDetector;
import com.android.tools.lint.checks.AssertDetector;
import com.android.tools.lint.checks.BadHostnameVerifierDetector;
import com.android.tools.lint.checks.BatteryDetector;
import com.android.tools.lint.checks.ButtonDetector;
import com.android.tools.lint.checks.ByteOrderMarkDetector;
import com.android.tools.lint.checks.CallSuperDetector;
import com.android.tools.lint.checks.ChildCountDetector;
import com.android.tools.lint.checks.CipherGetInstanceDetector;
import com.android.tools.lint.checks.CleanupDetector;
import com.android.tools.lint.checks.CommentDetector;
import com.android.tools.lint.checks.ConstraintLayoutDetector;
import com.android.tools.lint.checks.CustomViewDetector;
import com.android.tools.lint.checks.CutPasteDetector;
import com.android.tools.lint.checks.DateFormatDetector;
import com.android.tools.lint.checks.DeprecationDetector;
import com.android.tools.lint.checks.DetectMissingPrefix;
import com.android.tools.lint.checks.DosLineEndingDetector;
import com.android.tools.lint.checks.DuplicateIdDetector;
import com.android.tools.lint.checks.DuplicateResourceDetector;
import com.android.tools.lint.checks.ExtraTextDetector;
import com.android.tools.lint.checks.FragmentDetector;
import com.android.tools.lint.checks.FullBackupContentDetector;
import com.android.tools.lint.checks.GetSignaturesDetector;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.checks.GridLayoutDetector;
import com.android.tools.lint.checks.HandlerDetector;
import com.android.tools.lint.checks.HardcodedDebugModeDetector;
import com.android.tools.lint.checks.HardcodedValuesDetector;
import com.android.tools.lint.checks.HardwareIdDetector;
import com.android.tools.lint.checks.IconDetector;
import com.android.tools.lint.checks.IncludeDetector;
import com.android.tools.lint.checks.InefficientWeightDetector;
import com.android.tools.lint.checks.JavaPerformanceDetector;
import com.android.tools.lint.checks.JavaScriptInterfaceDetector;
import com.android.tools.lint.checks.LabelForDetector;
import com.android.tools.lint.checks.LayoutConsistencyDetector;
import com.android.tools.lint.checks.LayoutInflationDetector;
import com.android.tools.lint.checks.LeakDetector;
import com.android.tools.lint.checks.LocaleDetector;
import com.android.tools.lint.checks.LocaleFolderDetector;
import com.android.tools.lint.checks.LogDetector;
import com.android.tools.lint.checks.ManifestDetector;
import com.android.tools.lint.checks.ManifestResourceDetector;
import com.android.tools.lint.checks.MathDetector;
import com.android.tools.lint.checks.MergeRootFrameLayoutDetector;
import com.android.tools.lint.checks.MissingClassDetector;
import com.android.tools.lint.checks.MissingIdDetector;
import com.android.tools.lint.checks.NamespaceDetector;
import com.android.tools.lint.checks.NegativeMarginDetector;
import com.android.tools.lint.checks.NestedScrollingWidgetDetector;
import com.android.tools.lint.checks.NfcTechListDetector;
import com.android.tools.lint.checks.NonInternationalizedSmsDetector;
import com.android.tools.lint.checks.ObsoleteLayoutParamsDetector;
import com.android.tools.lint.checks.OverdrawDetector;
import com.android.tools.lint.checks.OverrideConcreteDetector;
import com.android.tools.lint.checks.ParcelDetector;
import com.android.tools.lint.checks.PluralsDetector;
import com.android.tools.lint.checks.PreferenceActivityDetector;
import com.android.tools.lint.checks.PrivateKeyDetector;
import com.android.tools.lint.checks.PrivateResourceDetector;
import com.android.tools.lint.checks.ProguardDetector;
import com.android.tools.lint.checks.PropertyFileDetector;
import com.android.tools.lint.checks.PxUsageDetector;
import com.android.tools.lint.checks.ReadParcelableDetector;
import com.android.tools.lint.checks.RecyclerViewDetector;
import com.android.tools.lint.checks.RegistrationDetector;
import com.android.tools.lint.checks.RelativeOverlapDetector;
import com.android.tools.lint.checks.RequiredAttributeDetector;
import com.android.tools.lint.checks.ResourceCycleDetector;
import com.android.tools.lint.checks.ResourcePrefixDetector;
import com.android.tools.lint.checks.RestrictionsDetector;
import com.android.tools.lint.checks.RtlDetector;
import com.android.tools.lint.checks.SQLiteDetector;
import com.android.tools.lint.checks.ScrollViewChildDetector;
import com.android.tools.lint.checks.SdCardDetector;
import com.android.tools.lint.checks.SecureRandomDetector;
import com.android.tools.lint.checks.SecurityDetector;
import com.android.tools.lint.checks.ServiceCastDetector;
import com.android.tools.lint.checks.SetJavaScriptEnabledDetector;
import com.android.tools.lint.checks.SetTextDetector;
import com.android.tools.lint.checks.SignatureOrSystemDetector;
import com.android.tools.lint.checks.SslCertificateSocketFactoryDetector;
import com.android.tools.lint.checks.StateListDetector;
import com.android.tools.lint.checks.StringAuthLeakDetector;
import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.checks.SystemPermissionsDetector;
import com.android.tools.lint.checks.TextFieldDetector;
import com.android.tools.lint.checks.TextViewDetector;
import com.android.tools.lint.checks.TitleDetector;
import com.android.tools.lint.checks.ToastDetector;
import com.android.tools.lint.checks.TooManyViewsDetector;
import com.android.tools.lint.checks.TranslationDetector;
import com.android.tools.lint.checks.TrustAllX509TrustManagerDetector;
import com.android.tools.lint.checks.TypoDetector;
import com.android.tools.lint.checks.TypographyDetector;
import com.android.tools.lint.checks.UnsafeBroadcastReceiverDetector;
import com.android.tools.lint.checks.UnsafeNativeCodeDetector;
import com.android.tools.lint.checks.UnusedResourceDetector;
import com.android.tools.lint.checks.UseCompoundDrawableDetector;
import com.android.tools.lint.checks.UselessViewDetector;
import com.android.tools.lint.checks.Utf8Detector;
import com.android.tools.lint.checks.VectorDetector;
import com.android.tools.lint.checks.VectorDrawableCompatDetector;
import com.android.tools.lint.checks.ViewConstructorDetector;
import com.android.tools.lint.checks.ViewHolderDetector;
import com.android.tools.lint.checks.ViewTagDetector;
import com.android.tools.lint.checks.ViewTypeDetector;
import com.android.tools.lint.checks.WebViewDetector;
import com.android.tools.lint.checks.WrongCallDetector;
import com.android.tools.lint.checks.WrongCaseDetector;
import com.android.tools.lint.checks.WrongIdDetector;
import com.android.tools.lint.checks.WrongImportDetector;
import com.android.tools.lint.checks.WrongLocationDetector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.TextFormat;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.AddMissingPrefixQuickFix;
import org.jetbrains.android.inspections.lint.AddTargetApiQuickFix;
import org.jetbrains.android.inspections.lint.AddTargetVersionCheckQuickFix;
import org.jetbrains.android.inspections.lint.AndroidAddStringResourceQuickFix;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.inspections.lint.ConvertNamespaceQuickFix;
import org.jetbrains.android.inspections.lint.ConvertToDpQuickFix;
import org.jetbrains.android.inspections.lint.DefaultLintQuickFix;
import org.jetbrains.android.inspections.lint.InefficientWeightQuickFix;
import org.jetbrains.android.inspections.lint.IntellijLintIssueRegistry;
import org.jetbrains.android.inspections.lint.MigrateDrawableToMipmapFix;
import org.jetbrains.android.inspections.lint.MoveToDebugManifestQuickFix;
import org.jetbrains.android.inspections.lint.ParcelableQuickFix;
import org.jetbrains.android.inspections.lint.RemoveAttributeQuickFix;
import org.jetbrains.android.inspections.lint.RemoveUselessViewQuickFix;
import org.jetbrains.android.inspections.lint.RenameAttributeQuickFix;
import org.jetbrains.android.inspections.lint.ReplaceStringQuickFix;
import org.jetbrains.android.inspections.lint.SetAttributeQuickFix;
import org.jetbrains.android.inspections.lint.SetScrollViewSizeQuickFix;
import org.jetbrains.android.inspections.lint.ShowCustomIssueExplanationFix;
import org.jetbrains.android.inspections.lint.SingleLineTrueQuickFix;
import org.jetbrains.android.inspections.lint.TypographyQuickFix;
import org.jetbrains.android.refactoring.UnusedResourcesQuickFix;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class AndroidLintInspectionToolProvider {
    private static final Pattern QUOTED_PARAMETER = Pattern.compile("`.+:(.+)=\"(.*)\"`");

    private static AndroidLintQuickFix[] getAppIndexingQuickFix(PsiElement startElement, PsiElement endElement, String message) {
        AppIndexingApiDetector.IssueType type = AppIndexingApiDetector.IssueType.parse((String)message);
        switch (type) {
            case SCHEME_MISSING: 
            case URL_MISSING: {
                return new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set scheme", "scheme", "http")};
            }
            case HOST_MISSING: {
                return new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set host", "host", null)};
            }
            case MISSING_SLASH: {
                XmlAttribute attr;
                String path;
                PsiElement parent = startElement.getParent();
                if (!(parent instanceof XmlAttribute) || (path = (attr = (XmlAttribute)parent).getValue()) == null) break;
                return new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Replace with /" + path, path, "/" + path)};
            }
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }

    private static AndroidLintQuickFix[] getApiDetectorFixes(@NotNull Issue issue, @NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        int api = ApiDetector.getRequiredVersion((Issue)issue, (String)message, (TextFormat)TextFormat.RAW);
        if (api != -1) {
            ArrayList list = Lists.newArrayList();
            PsiFile file = startElement.getContainingFile();
            boolean isXml = false;
            if (file instanceof XmlFile) {
                FolderConfiguration config;
                isXml = true;
                ResourceFolderType folderType = ResourceHelper.getFolderType(file);
                if (folderType != null && (config = ResourceHelper.getFolderConfiguration(file)) != null) {
                    config.setVersionQualifier(new VersionQualifier(api));
                    String folder = config.getFolderName(folderType);
                    list.add(OverrideResourceAction.createFix(folder));
                }
            }
            list.add(new AddTargetVersionCheckQuickFix(api));
            list.add(new AddTargetApiQuickFix(api, false, startElement));
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!isXml && JavaPsiFacade.getInstance((Project)startElement.getProject()).findClass("android.support.annotation.RequiresApi", GlobalSearchScope.allScope((Project)startElement.getProject())) != null) {
                list.add(new AddTargetApiQuickFix(api, true, startElement));
            }
            return list.toArray(new AndroidLintQuickFix[list.size()]);
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }

    public static class AndroidLintUnsupportedTvHardwareInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUnsupportedTvHardwareInspection() {
            super(AndroidBundle.message("android.lint.inspections.unsupported.tv.hardware", new Object[0]), AndroidTvDetector.UNSUPPORTED_TV_HARDWARE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            if (startElement.textMatches((CharSequence)"android:required")) {
                XmlAttribute attr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class);
                assert (attr != null);
                return new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Replace with required=\"false\"", null, "android:required=\"false\"")};
            }
            if (startElement.textMatches((CharSequence)"uses-feature")) {
                return new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set required=\"false\"", "required", "false")};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintUnsafeProtectedBroadcastReceiverInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUnsafeProtectedBroadcastReceiverInspection() {
            super(AndroidBundle.message("android.lint.inspections.unsafe.protected.broadcast.receiver", new Object[0]), UnsafeBroadcastReceiverDetector.ACTION_STRING);
        }
    }

    public static class AndroidLintUnsafeNativeCodeLocationInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUnsafeNativeCodeLocationInspection() {
            super(AndroidBundle.message("android.lint.inspections.unsafe.native.code.location", new Object[0]), UnsafeNativeCodeDetector.UNSAFE_NATIVE_CODE_LOCATION);
        }
    }

    public static class AndroidLintUnsafeDynamicallyLoadedCodeInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUnsafeDynamicallyLoadedCodeInspection() {
            super(AndroidBundle.message("android.lint.inspections.unsafe.dynamically.loaded.code", new Object[0]), UnsafeNativeCodeDetector.LOAD);
        }
    }

    public static class AndroidLintPermissionImpliesUnsupportedHardwareInspection
    extends AndroidLintInspectionBase {
        public AndroidLintPermissionImpliesUnsupportedHardwareInspection() {
            super(AndroidBundle.message("android.lint.inspections.permission.implies.unsupported.hardware", new Object[0]), AndroidTvDetector.PERMISSION_IMPLIES_UNSUPPORTED_HARDWARE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            final String hardwareFeatureName = AndroidTvDetector.getHardwareFeature((String)message, (TextFormat)TextFormat.RAW);
            if (hardwareFeatureName != null) {
                return new AndroidLintQuickFix[]{new DefaultLintQuickFix("Add uses-feature tag"){

                    @Override
                    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                        XmlTag parent;
                        XmlTag usesPermissionTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
                        if (startElement.textMatches((CharSequence)"uses-permission") && usesPermissionTag != null && (parent = (XmlTag)usesPermissionTag.getParent()) != null) {
                            XmlTag usesFeatureTag = parent.createChildTag("uses-feature", null, null, false);
                            usesFeatureTag = parent.addSubTag(usesFeatureTag, true);
                            usesFeatureTag.setAttribute("name", "http://schemas.android.com/apk/res/android", hardwareFeatureName);
                            usesFeatureTag.setAttribute("required", "http://schemas.android.com/apk/res/android", String.valueOf(false));
                        }
                    }
                }};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintPendingBindingsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintPendingBindingsInspection() {
            super(AndroidBundle.message("android.lint.inspections.pending.bindings", new Object[0]), RecyclerViewDetector.DATA_BINDER);
        }
    }

    public static class AndroidLintMissingTvBannerInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMissingTvBannerInspection() {
            super(AndroidBundle.message("android.lint.inspections.missing.tv.banner", new Object[0]), AndroidTvDetector.MISSING_BANNER);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            return new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set banner attribute", "banner", null)};
        }
    }

    public static class AndroidLintMissingLeanbackSupportInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMissingLeanbackSupportInspection() {
            super(AndroidBundle.message("android.lint.inspections.missing.leanback.support", new Object[0]), AndroidTvDetector.MISSING_LEANBACK_SUPPORT);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new DefaultLintQuickFix("Add uses-feature tag"){

                @Override
                public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                    XmlTag parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
                    if (parent != null) {
                        XmlTag usesFeatureTag = parent.createChildTag("uses-feature", null, null, false);
                        usesFeatureTag = parent.addSubTag(usesFeatureTag, true);
                        usesFeatureTag.setAttribute("name", "http://schemas.android.com/apk/res/android", "android.software.leanback");
                        usesFeatureTag.setAttribute("required", "http://schemas.android.com/apk/res/android", String.valueOf(false));
                    }
                }
            }};
        }
    }

    public static class AndroidLintMissingLeanbackLauncherInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMissingLeanbackLauncherInspection() {
            super(AndroidBundle.message("android.lint.inspections.missing.leanback.launcher", new Object[0]), AndroidTvDetector.MISSING_LEANBACK_LAUNCHER);
        }
    }

    public static class AndroidLintWrongFolderInspection
    extends AndroidLintInspectionBase {
        public AndroidLintWrongFolderInspection() {
            super(AndroidBundle.message("android.lint.inspections.wrong.folder", new Object[0]), WrongLocationDetector.ISSUE);
        }
    }

    public static class AndroidLintWrongCaseInspection
    extends AndroidLintInspectionBase {
        public AndroidLintWrongCaseInspection() {
            super(AndroidBundle.message("android.lint.inspections.wrong.case", new Object[0]), WrongCaseDetector.WRONG_CASE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            final String current = WrongCaseDetector.getOldValue((String)message, (TextFormat)TextFormat.RAW);
            final String proposed = WrongCaseDetector.getNewValue((String)message, (TextFormat)TextFormat.RAW);
            if (proposed != null && current != null) {
                return new AndroidLintQuickFix[]{new ReplaceStringQuickFix(null, current, proposed){

                    @Override
                    protected void editAfter(@NotNull Document document) {
                        String text = document.getText();
                        int index = text.indexOf("</" + current + ">");
                        if (index != -1) {
                            document.replaceString(index + 2, index + 2 + current.length(), (CharSequence)proposed);
                        }
                    }
                }};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintWrongCallInspection
    extends AndroidLintInspectionBase {
        public AndroidLintWrongCallInspection() {
            super(AndroidBundle.message("android.lint.inspections.wrong.call", new Object[0]), WrongCallDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            String current = WrongCallDetector.getOldValue((String)message, (TextFormat)TextFormat.RAW);
            String proposed = WrongCallDetector.getNewValue((String)message, (TextFormat)TextFormat.RAW);
            if (proposed != null && current != null) {
                return new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Replace call with " + proposed + "()", current, proposed)};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintWorldReadableFilesInspection
    extends AndroidLintInspectionBase {
        public AndroidLintWorldReadableFilesInspection() {
            super(AndroidBundle.message("android.lint.inspections.world.readable.files", new Object[0]), SecurityDetector.WORLD_READABLE);
        }
    }

    public static class AndroidLintUnlocalizedSmsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUnlocalizedSmsInspection() {
            super(AndroidBundle.message("android.lint.inspections.unlocalized.sms", new Object[0]), NonInternationalizedSmsDetector.ISSUE);
        }
    }

    public static class AndroidLintUniquePermissionInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUniquePermissionInspection() {
            super(AndroidBundle.message("android.lint.inspections.unique.permission", new Object[0]), ManifestDetector.UNIQUE_PERMISSION);
        }
    }

    public static class AndroidLintUniqueConstantsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUniqueConstantsInspection() {
            super(AndroidBundle.message("android.lint.inspections.unique.constants", new Object[0]), AnnotationDetector.UNIQUE);
        }
    }

    public static class AndroidLintTyposInspection
    extends AndroidLintInspectionBase {
        public AndroidLintTyposInspection() {
            super(AndroidBundle.message("android.lint.inspections.typos", new Object[0]), TypoDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            TypoDetector.TypoSuggestionInfo info = TypoDetector.getSuggestions((String)message, (TextFormat)TextFormat.RAW);
            List suggestions = info.getReplacements();
            if (!suggestions.isEmpty()) {
                ArrayList fixes = Lists.newArrayListWithExpectedSize((int)suggestions.size());
                String originalPattern = '(' + Pattern.quote(info.getOriginal()) + ')';
                for (String suggestion : suggestions) {
                    fixes.add(new ReplaceStringQuickFix("Replace with \"" + suggestion + "\"", originalPattern, suggestion));
                }
                return fixes.toArray(new AndroidLintQuickFix[fixes.size()]);
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintSuspicious0dpInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSuspicious0dpInspection() {
            super(AndroidBundle.message("android.lint.inspections.suspicious0dp", new Object[0]), InefficientWeightDetector.WRONG_0DP);
        }
    }

    public static class AndroidLintSupportAnnotationUsageInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSupportAnnotationUsageInspection() {
            super(AndroidBundle.message("android.lint.inspections.support.annotation.usage", new Object[0]), AnnotationDetector.ANNOTATION_USAGE);
        }
    }

    public static class AndroidLintStringShouldBeIntInspection
    extends AndroidLintInspectionBase {
        public AndroidLintStringShouldBeIntInspection() {
            super(AndroidBundle.message("android.lint.inspections.string.should.be.int", new Object[0]), GradleDetector.STRING_INTEGER);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            String current = GradleDetector.getOldValue((Issue)GradleDetector.STRING_INTEGER, (String)message, (TextFormat)TextFormat.RAW);
            String proposed = GradleDetector.getNewValue((Issue)GradleDetector.STRING_INTEGER, (String)message, (TextFormat)TextFormat.RAW);
            if (proposed != null && current != null) {
                return new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Replace with integer", current, proposed)};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintStopShipInspection
    extends AndroidLintInspectionBase {
        public AndroidLintStopShipInspection() {
            super(AndroidBundle.message("android.lint.inspections.stop.ship", new Object[0]), CommentDetector.STOP_SHIP);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Remove STOPSHIP", "(\\s*STOPSHIP)", "")};
        }
    }

    public static class AndroidLintStaticFieldLeakInspection
    extends AndroidLintInspectionBase {
        public AndroidLintStaticFieldLeakInspection() {
            super(AndroidBundle.message("android.lint.inspections.static.field.leak", new Object[0]), LeakDetector.ISSUE);
        }
    }

    public static class AndroidLintSpUsageInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSpUsageInspection() {
            super(AndroidBundle.message("android.lint.inspections.sp.usage", new Object[0]), PxUsageDetector.DP_ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new ReplaceStringQuickFix(null, "\\d+(di?p)", "sp")};
        }
    }

    public static class AndroidLintSmallSpInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSmallSpInspection() {
            super(AndroidBundle.message("android.lint.inspections.small.sp", new Object[0]), PxUsageDetector.SMALL_SP_ISSUE);
        }
    }

    public static class AndroidLintSimpleDateFormatInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSimpleDateFormatInspection() {
            super(AndroidBundle.message("android.lint.inspections.simple.date.format", new Object[0]), DateFormatDetector.DATE_FORMAT);
        }
    }

    public static class AndroidLintSignatureOrSystemPermissionsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSignatureOrSystemPermissionsInspection() {
            super(AndroidBundle.message("android.lint.inspections.signature.or.system.permissions", new Object[0]), SignatureOrSystemDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new ReplaceStringQuickFix(null, "signatureOrSystem", "signature")};
        }
    }

    public static class AndroidLintShowToastInspection
    extends AndroidLintInspectionBase {
        public AndroidLintShowToastInspection() {
            super(AndroidBundle.message("android.lint.inspections.show.toast", new Object[0]), ToastDetector.ISSUE);
        }
    }

    public static class AndroidLintShortAlarmInspection
    extends AndroidLintInspectionBase {
        public AndroidLintShortAlarmInspection() {
            super(AndroidBundle.message("android.lint.inspections.short.alarm", new Object[0]), AlarmDetector.ISSUE);
        }
    }

    public static class AndroidLintShiftFlagsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintShiftFlagsInspection() {
            super(AndroidBundle.message("android.lint.inspections.shift.flags", new Object[0]), AnnotationDetector.FLAG_STYLE);
        }
    }

    public static class AndroidLintSetWorldWritableInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSetWorldWritableInspection() {
            super(AndroidBundle.message("android.lint.inspections.set.world.writable", new Object[0]), SecurityDetector.SET_WRITABLE);
        }
    }

    public static class AndroidLintSetWorldReadableInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSetWorldReadableInspection() {
            super(AndroidBundle.message("android.lint.inspections.set.world.readable", new Object[0]), SecurityDetector.SET_READABLE);
        }
    }

    public static class AndroidLintSetTextI18nInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSetTextI18nInspection() {
            super(AndroidBundle.message("android.lint.inspections.set.text.i18n", new Object[0]), SetTextDetector.SET_TEXT_I18N);
        }
    }

    public static class AndroidLintSetJavaScriptEnabledInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSetJavaScriptEnabledInspection() {
            super(AndroidBundle.message("android.lint.inspections.set.java.script.enabled", new Object[0]), SetJavaScriptEnabledDetector.ISSUE);
        }
    }

    public static class AndroidLintServiceCastInspection
    extends AndroidLintInspectionBase {
        public AndroidLintServiceCastInspection() {
            super(AndroidBundle.message("android.lint.inspections.service.cast", new Object[0]), ServiceCastDetector.ISSUE);
        }
    }

    public static class AndroidLintSelectableTextInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSelectableTextInspection() {
            super(AndroidBundle.message("android.lint.inspections.selectable.text", new Object[0]), TextViewDetector.SELECTABLE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set android:textIsSelectable=true", "textIsSelectable", "true")};
        }
    }

    public static class AndroidLintSecureRandomInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSecureRandomInspection() {
            super(AndroidBundle.message("android.lint.inspections.secure.random", new Object[0]), SecureRandomDetector.ISSUE);
        }
    }

    public static class AndroidLintResAutoInspection
    extends AndroidLintInspectionBase {
        public AndroidLintResAutoInspection() {
            super(AndroidBundle.message("android.lint.inspections.res.auto", new Object[0]), NamespaceDetector.RES_AUTO);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new ConvertNamespaceQuickFix()};
        }
    }

    public static class AndroidLintRequiredSizeInspection
    extends AndroidLintInspectionBase {
        public AndroidLintRequiredSizeInspection() {
            super(AndroidBundle.message("android.lint.inspections.required.size", new Object[0]), RequiredAttributeDetector.ISSUE);
        }
    }

    public static class AndroidLintRelativeOverlapInspection
    extends AndroidLintInspectionBase {
        public AndroidLintRelativeOverlapInspection() {
            super(AndroidBundle.message("android.lint.inspections.relative.overlap", new Object[0]), RelativeOverlapDetector.ISSUE);
        }
    }

    public static class AndroidLintRegisteredInspection
    extends AndroidLintInspectionBase {
        public AndroidLintRegisteredInspection() {
            super(AndroidBundle.message("android.lint.inspections.registered", new Object[0]), RegistrationDetector.ISSUE);
        }
    }

    public static class AndroidLintReferenceTypeInspection
    extends AndroidLintInspectionBase {
        public AndroidLintReferenceTypeInspection() {
            super(AndroidBundle.message("android.lint.inspections.reference.type", new Object[0]), DuplicateResourceDetector.TYPE_MISMATCH);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            String expected = DuplicateResourceDetector.getExpectedType((String)message, (TextFormat)TextFormat.RAW);
            if (expected != null) {
                return new AndroidLintQuickFix[]{new ReplaceStringQuickFix(null, "(@.*/)", "@" + expected + "/")};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintRecyclerViewInspection
    extends AndroidLintInspectionBase {
        public AndroidLintRecyclerViewInspection() {
            super(AndroidBundle.message("android.lint.inspections.recycler.view", new Object[0]), RecyclerViewDetector.FIXED_POSITION);
        }
    }

    public static class AndroidLintRecycleInspection
    extends AndroidLintInspectionBase {
        public AndroidLintRecycleInspection() {
            super(AndroidBundle.message("android.lint.inspections.recycle", new Object[0]), CleanupDetector.RECYCLE_RESOURCE);
        }
    }

    public static class AndroidLintProtectedPermissionsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintProtectedPermissionsInspection() {
            super(AndroidBundle.message("android.lint.inspections.protected.permissions", new Object[0]), SystemPermissionsDetector.ISSUE);
        }
    }

    public static class AndroidLintPropertyEscapeInspection
    extends AndroidLintInspectionBase {
        public AndroidLintPropertyEscapeInspection() {
            super(AndroidBundle.message("android.lint.inspections.property.escape", new Object[0]), PropertyFileDetector.ESCAPE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            String escaped = PropertyFileDetector.getSuggestedEscape((String)message, (TextFormat)TextFormat.RAW);
            if (escaped != null) {
                return new AndroidLintQuickFix[]{new ReplaceStringQuickFix(null, null, escaped)};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintPackagedPrivateKeyInspection
    extends AndroidLintInspectionBase {
        public AndroidLintPackagedPrivateKeyInspection() {
            super(AndroidBundle.message("android.lint.inspections.packaged.private.key", new Object[0]), PrivateKeyDetector.ISSUE);
        }
    }

    public static class AndroidLintOverrideAbstractInspection
    extends AndroidLintInspectionBase {
        public AndroidLintOverrideAbstractInspection() {
            super(AndroidBundle.message("android.lint.inspections.override.abstract", new Object[0]), OverrideConcreteDetector.ISSUE);
        }
    }

    public static class AndroidLintOrientationInspection
    extends AndroidLintInspectionBase {
        public AndroidLintOrientationInspection() {
            super(AndroidBundle.message("android.lint.inspections.orientation", new Object[0]), InefficientWeightDetector.ORIENTATION);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set orientation=\"horizontal\" (default)", "orientation", "horizontal"), new SetAttributeQuickFix("Set orientation=\"vertical\" (changes layout)", "orientation", "vertical")};
        }
    }

    public static class AndroidLintOldTargetApiInspection
    extends AndroidLintInspectionBase {
        public AndroidLintOldTargetApiInspection() {
            super(AndroidBundle.message("android.lint.inspections.old.target.api", new Object[0]), ManifestDetector.TARGET_NEWER);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            String highest = Integer.toString(AndroidLintOldTargetApiInspection.getHighestApi(startElement));
            String label = "Update targetSdkVersion to " + highest;
            if (startElement.getContainingFile() instanceof XmlFile) {
                return new AndroidLintQuickFix[]{new ReplaceStringQuickFix(label, "targetSdkVersion\\s*=\\s*[\"'](.*)[\"']", highest)};
            }
            if (startElement.getContainingFile() instanceof GroovyFile) {
                return new AndroidLintQuickFix[]{new ReplaceStringQuickFix(label, null, highest)};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }

        private static int getHighestApi(PsiElement element) {
            AndroidSdkData sdkData;
            int max = 24;
            AndroidFacet instance = AndroidFacet.getInstance(element);
            if (instance != null && (sdkData = instance.getSdkData()) != null) {
                for (IAndroidTarget target : sdkData.getTargets()) {
                    AndroidVersion version;
                    if (!target.isPlatform() || (version = target.getVersion()).getApiLevel() <= max || version.isPreview()) continue;
                    max = version.getApiLevel();
                }
            }
            return max;
        }
    }

    public static class AndroidLintMissingVersionInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMissingVersionInspection() {
            super(AndroidBundle.message("android.lint.inspections.missing.version", new Object[0]), ManifestDetector.SET_VERSION);
        }
    }

    public static class AndroidLintMissingOnPlayFromSearchInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMissingOnPlayFromSearchInspection() {
            super(AndroidBundle.message("android.lint.inspections.missing.on.play.from.search", new Object[0]), AndroidAutoDetector.MISSING_ON_PLAY_FROM_SEARCH);
        }
    }

    public static class AndroidLintMissingMediaBrowserServiceIntentFilterInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMissingMediaBrowserServiceIntentFilterInspection() {
            super(AndroidBundle.message("android.lint.inspections.missing.media.browser.service.intent.filter", new Object[0]), AndroidAutoDetector.MISSING_MEDIA_BROWSER_SERVICE_ACTION_ISSUE);
        }
    }

    public static class AndroidLintMissingIntentFilterForMediaSearchInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMissingIntentFilterForMediaSearchInspection() {
            super(AndroidBundle.message("android.lint.inspections.missing.intent.filter.for.media.search", new Object[0]), AndroidAutoDetector.MISSING_INTENT_FILTER_FOR_MEDIA_SEARCH);
        }
    }

    public static class AndroidLintMissingIdInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMissingIdInspection() {
            super(AndroidBundle.message("android.lint.inspections.missing.id", new Object[0]), MissingIdDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set id", "id", null)};
        }
    }

    public static class AndroidLintMissingConstraintsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMissingConstraintsInspection() {
            super(AndroidBundle.message("android.lint.inspections.missing.constraints", new Object[0]), ConstraintLayoutDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            if (ConstraintLayoutDetector.isUpgradeDependencyError((String)message, (TextFormat)TextFormat.RAW)) {
                return new AndroidLintQuickFix[]{new UpgradeConstraintLayoutFix()};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintMenuTitleInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMenuTitleInspection() {
            super(AndroidBundle.message("android.lint.inspections.menu.title", new Object[0]), TitleDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set title", "title", null)};
        }
    }

    public static class AndroidLintManifestResourceInspection
    extends AndroidLintInspectionBase {
        public AndroidLintManifestResourceInspection() {
            super(AndroidBundle.message("android.lint.inspections.manifest.resource", new Object[0]), ManifestResourceDetector.ISSUE);
        }
    }

    public static class AndroidLintMangledCRLFInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMangledCRLFInspection() {
            super(AndroidBundle.message("android.lint.inspections.mangled.crlf", new Object[0]), DosLineEndingDetector.ISSUE);
        }
    }

    public static class AndroidLintLongLogTagInspection
    extends AndroidLintInspectionBase {
        public AndroidLintLongLogTagInspection() {
            super(AndroidBundle.message("android.lint.inspections.long.log.tag", new Object[0]), LogDetector.LONG_TAG);
        }
    }

    public static class AndroidLintLogTagMismatchInspection
    extends AndroidLintInspectionBase {
        public AndroidLintLogTagMismatchInspection() {
            super(AndroidBundle.message("android.lint.inspections.log.tag.mismatch", new Object[0]), LogDetector.WRONG_TAG);
        }
    }

    public static class AndroidLintLogConditionalInspection
    extends AndroidLintInspectionBase {
        public AndroidLintLogConditionalInspection() {
            super(AndroidBundle.message("android.lint.inspections.log.conditional", new Object[0]), LogDetector.CONDITIONAL);
        }
    }

    public static class AndroidLintLocalSuppressInspection
    extends AndroidLintInspectionBase {
        public AndroidLintLocalSuppressInspection() {
            super(AndroidBundle.message("android.lint.inspections.local.suppress", new Object[0]), AnnotationDetector.INSIDE_METHOD);
        }
    }

    public static class AndroidLintLocaleFolderInspection
    extends AndroidLintInspectionBase {
        public AndroidLintLocaleFolderInspection() {
            super(AndroidBundle.message("android.lint.inspections.locale.folder", new Object[0]), LocaleFolderDetector.DEPRECATED_CODE);
        }
    }

    public static class AndroidLintLabelForInspection
    extends AndroidLintInspectionBase {
        public AndroidLintLabelForInspection() {
            super(AndroidBundle.message("android.lint.inspections.label.for", new Object[0]), LabelForDetector.ISSUE);
        }
    }

    public static class AndroidLintJavascriptInterfaceInspection
    extends AndroidLintInspectionBase {
        public AndroidLintJavascriptInterfaceInspection() {
            super(AndroidBundle.message("android.lint.inspections.javascript.interface", new Object[0]), JavaScriptInterfaceDetector.ISSUE);
        }
    }

    public static class AndroidLintInvalidUsesTagAttributeInspection
    extends AndroidLintInspectionBase {
        public AndroidLintInvalidUsesTagAttributeInspection() {
            super(AndroidBundle.message("android.lint.inspections.invalid.uses.tag.attribute", new Object[0]), AndroidAutoDetector.INVALID_USES_TAG_ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            XmlAttributeValue attributeValue;
            XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class);
            XmlAttributeValue xmlAttributeValue = attributeValue = attribute == null ? null : attribute.getValueElement();
            if (attributeValue != null && attributeValue.getTextLength() != 0) {
                String value = StringUtil.unquoteString((String)attributeValue.getText());
                String regexp = "(" + value + ")";
                String[] suggestions = AndroidAutoDetector.getAllowedAutomotiveAppTypes();
                ArrayList fixes = Lists.newArrayListWithExpectedSize((int)suggestions.length);
                for (String suggestion : suggestions) {
                    fixes.add(new ReplaceStringQuickFix("Replace with \"" + suggestion + "\"", regexp, suggestion));
                }
                return fixes.toArray(new AndroidLintQuickFix[fixes.size()]);
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintInvalidResourceFolderInspection
    extends AndroidLintInspectionBase {
        public AndroidLintInvalidResourceFolderInspection() {
            super(AndroidBundle.message("android.lint.inspections.invalid.resource.folder", new Object[0]), LocaleFolderDetector.INVALID_FOLDER);
        }
    }

    public static class AndroidLintInvalidIdInspection
    extends AndroidLintInspectionBase {
        public AndroidLintInvalidIdInspection() {
            super(AndroidBundle.message("android.lint.inspections.invalid.id", new Object[0]), WrongIdDetector.INVALID);
        }
    }

    public static class AndroidLintInnerclassSeparatorInspection
    extends AndroidLintInspectionBase {
        public AndroidLintInnerclassSeparatorInspection() {
            super(AndroidBundle.message("android.lint.inspections.innerclass.separator", new Object[0]), MissingClassDetector.INNERCLASS);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            String current = MissingClassDetector.getOldValue((Issue)MissingClassDetector.INNERCLASS, (String)message, (TextFormat)TextFormat.RAW);
            String proposed = MissingClassDetector.getNewValue((Issue)MissingClassDetector.INNERCLASS, (String)message, (TextFormat)TextFormat.RAW);
            if (proposed != null && current != null) {
                return new AndroidLintQuickFix[]{new ReplaceStringQuickFix(null, current, proposed)};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintInOrMmUsageInspection
    extends AndroidLintInspectionBase {
        public AndroidLintInOrMmUsageInspection() {
            super(AndroidBundle.message("android.lint.inspections.in.or.mm.usage", new Object[0]), PxUsageDetector.IN_MM_ISSUE);
        }
    }

    public static class AndroidLintInflateParamsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintInflateParamsInspection() {
            super(AndroidBundle.message("android.lint.inspections.inflate.params", new Object[0]), LayoutInflationDetector.ISSUE);
        }
    }

    public static class AndroidLintIncludeLayoutParamInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIncludeLayoutParamInspection() {
            super(AndroidBundle.message("android.lint.inspections.include.layout.param", new Object[0]), IncludeDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            ArrayList fixes = Lists.newArrayListWithExpectedSize((int)2);
            if (IncludeDetector.requestsWidth((String)message)) {
                fixes.add(new SetAttributeQuickFix("Set layout_width", "layout_width", null));
            }
            if (IncludeDetector.requestsHeight((String)message)) {
                fixes.add(new SetAttributeQuickFix("Set layout_height", "layout_height", null));
            }
            return fixes.toArray(new AndroidLintQuickFix[fixes.size()]);
        }
    }

    public static class AndroidLintAuthLeakInspection
    extends AndroidLintInspectionBase {
        public AndroidLintAuthLeakInspection() {
            super(AndroidBundle.message("android.lint.inspections.credential.leak", new Object[0]), StringAuthLeakDetector.AUTH_LEAK);
        }
    }

    public static class AndroidLintImpliedQuantityInspection
    extends AndroidLintInspectionBase {
        public AndroidLintImpliedQuantityInspection() {
            super(AndroidBundle.message("android.lint.inspections.implied.quantity", new Object[0]), PluralsDetector.IMPLIED_QUANTITY);
        }
    }

    public static class AndroidLintIllegalResourceRefInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIllegalResourceRefInspection() {
            super(AndroidBundle.message("android.lint.inspections.illegal.resource.ref", new Object[0]), ManifestDetector.ILLEGAL_REFERENCE);
        }
    }

    public static class AndroidLintIconXmlAndPngInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconXmlAndPngInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.xml.and.png", new Object[0]), IconDetector.ICON_XML_AND_PNG);
        }
    }

    public static class AndroidLintIconLauncherShapeInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconLauncherShapeInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.launcher.shape", new Object[0]), IconDetector.ICON_LAUNCHER_SHAPE);
        }
    }

    public static class AndroidLintIconExtensionInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconExtensionInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.extension", new Object[0]), IconDetector.ICON_EXTENSION);
        }
    }

    public static class AndroidLintIconColorsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconColorsInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.colors", new Object[0]), IconDetector.ICON_COLORS);
        }
    }

    public static class AndroidLintExportedReceiverInspection
    extends AndroidLintInspectionBase {
        public AndroidLintExportedReceiverInspection() {
            super(AndroidBundle.message("android.lint.inspections.exported.receiver", new Object[0]), SecurityDetector.EXPORTED_RECEIVER);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set permission attribute", "permission", null)};
        }
    }

    public static class AndroidLintExportedPreferenceActivityInspection
    extends AndroidLintInspectionBase {
        public AndroidLintExportedPreferenceActivityInspection() {
            super(AndroidBundle.message("android.lint.inspections.exported.preference.activity", new Object[0]), PreferenceActivityDetector.ISSUE);
        }
    }

    public static class AndroidLintExportedContentProviderInspection
    extends AndroidLintInspectionBase {
        public AndroidLintExportedContentProviderInspection() {
            super(AndroidBundle.message("android.lint.inspections.exported.content.provider", new Object[0]), SecurityDetector.EXPORTED_PROVIDER);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set exported=\"false\"", "exported", "false")};
        }
    }

    public static class AndroidLintEasterEggInspection
    extends AndroidLintInspectionBase {
        public AndroidLintEasterEggInspection() {
            super(AndroidBundle.message("android.lint.inspections.easter.egg", new Object[0]), CommentDetector.EASTER_EGG);
        }
    }

    public static class AndroidLintDuplicateDefinitionInspection
    extends AndroidLintInspectionBase {
        public AndroidLintDuplicateDefinitionInspection() {
            super(AndroidBundle.message("android.lint.inspections.duplicate.definition", new Object[0]), DuplicateResourceDetector.ISSUE);
        }
    }

    public static class AndroidLintDuplicateActivityInspection
    extends AndroidLintInspectionBase {
        public AndroidLintDuplicateActivityInspection() {
            super(AndroidBundle.message("android.lint.inspections.duplicate.activity", new Object[0]), ManifestDetector.DUPLICATE_ACTIVITY);
        }
    }

    public static class AndroidLintCutPasteIdInspection
    extends AndroidLintInspectionBase {
        public AndroidLintCutPasteIdInspection() {
            super(AndroidBundle.message("android.lint.inspections.cut.paste.id", new Object[0]), CutPasteDetector.ISSUE);
        }
    }

    public static class AndroidLintCustomViewStyleableInspection
    extends AndroidLintInspectionBase {
        public AndroidLintCustomViewStyleableInspection() {
            super(AndroidBundle.message("android.lint.inspections.custom.view.styleable", new Object[0]), CustomViewDetector.ISSUE);
        }
    }

    public static class AndroidLintCommitPrefEditsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintCommitPrefEditsInspection() {
            super(AndroidBundle.message("android.lint.inspections.commit.pref.edits", new Object[0]), CleanupDetector.SHARED_PREF);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message.contains("commit") && message.contains("apply")) {
                return new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Replace commit() with apply()", "(commit)\\s*\\(", "apply")};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintByteOrderMarkInspection
    extends AndroidLintInspectionBase {
        public AndroidLintByteOrderMarkInspection() {
            super(AndroidBundle.message("android.lint.inspections.byte.order.mark", new Object[0]), ByteOrderMarkDetector.BOM);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            return new AndroidLintQuickFix[]{new DefaultLintQuickFix("Remove byte order marks"){

                @Override
                public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                    Document document = FileDocumentManager.getInstance().getDocument(startElement.getContainingFile().getVirtualFile());
                    if (document != null) {
                        String text = document.getText();
                        for (int i = text.length() - 1; i >= 0; --i) {
                            char c = text.charAt(i);
                            if (c != '\ufeff') continue;
                            document.deleteString(i, i + 1);
                        }
                    }
                }
            }};
        }
    }

    public static class AndroidLintButtonStyleInspection
    extends AndroidLintInspectionBase {
        public AndroidLintButtonStyleInspection() {
            super(AndroidBundle.message("android.lint.inspections.button.style", new Object[0]), ButtonDetector.STYLE);
        }
    }

    public static class AndroidLintAllowBackupInspection
    extends AndroidLintInspectionBase {
        public AndroidLintAllowBackupInspection() {
            super(AndroidBundle.message("android.lint.inspections.allow.backup", new Object[0]), ManifestDetector.ALLOW_BACKUP);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            return new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set backup attribute", "allowBackup", null)};
        }
    }

    public static class AndroidLintAllowAllHostnameVerifierInspection
    extends AndroidLintInspectionBase {
        public AndroidLintAllowAllHostnameVerifierInspection() {
            super(AndroidBundle.message("android.lint.inspections.allow.all.hostname.verifier", new Object[0]), AllowAllHostnameVerifierDetector.ISSUE);
        }
    }

    public static class AndroidLintAddJavascriptInterfaceInspection
    extends AndroidLintInspectionBase {
        public AndroidLintAddJavascriptInterfaceInspection() {
            super(AndroidBundle.message("android.lint.inspections.add.javascript.interface", new Object[0]), AddJavascriptInterfaceDetector.ISSUE);
        }
    }

    public static class AndroidLintRtlSymmetryInspection
    extends AndroidLintInspectionBase {
        public AndroidLintRtlSymmetryInspection() {
            super(AndroidBundle.message("android.lint.inspections.rtl.symmetry", new Object[0]), RtlDetector.SYMMETRY);
        }
    }

    public static class AndroidLintRtlHardcodedInspection
    extends AndroidLintInspectionBase {
        public AndroidLintRtlHardcodedInspection() {
            super(AndroidBundle.message("android.lint.inspections.rtl.hardcoded", new Object[0]), RtlDetector.USE_START);
        }
    }

    public static class AndroidLintRtlEnabledInspection
    extends AndroidLintInspectionBase {
        public AndroidLintRtlEnabledInspection() {
            super(AndroidBundle.message("android.lint.inspections.rtl.enabled", new Object[0]), RtlDetector.ENABLED);
        }
    }

    public static class AndroidLintRtlCompatInspection
    extends AndroidLintInspectionBase {
        public AndroidLintRtlCompatInspection() {
            super(AndroidBundle.message("android.lint.inspections.rtl.compat", new Object[0]), RtlDetector.COMPAT);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            Matcher matcher;
            if (message.startsWith("To support older versions than API 17") && (matcher = QUOTED_PARAMETER.matcher(message)).find()) {
                String name = matcher.group(1);
                String value = matcher.group(2);
                return new AndroidLintQuickFix[]{new SetAttributeQuickFix(String.format("Set %s", name), name, value)};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintResourceNameInspection
    extends AndroidLintInspectionBase {
        public AndroidLintResourceNameInspection() {
            super(AndroidBundle.message("android.lint.inspections.resource.name", new Object[0]), ResourcePrefixDetector.ISSUE);
        }
    }

    public static class AndroidLintResourceCycleInspection
    extends AndroidLintInspectionBase {
        public AndroidLintResourceCycleInspection() {
            super(AndroidBundle.message("android.lint.inspections.resource.cycle", new Object[0]), ResourceCycleDetector.CYCLE);
        }
    }

    public static class AndroidLintMissingApplicationIconInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMissingApplicationIconInspection() {
            super(AndroidBundle.message("android.lint.inspections.missing.application.icon", new Object[0]), ManifestDetector.APPLICATION_ICON);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            return new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set application icon", "icon", null)};
        }
    }

    public static class AndroidLintMipmapIconsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMipmapIconsInspection() {
            super(AndroidBundle.message("android.lint.inspections.mipmap.icons", new Object[0]), ManifestDetector.MIPMAP);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            ResourceUrl url;
            XmlAttribute attribute;
            String value;
            PsiElement parent = startElement.getParent();
            if (parent instanceof XmlAttribute && (value = (attribute = (XmlAttribute)parent).getValue()) != null && (url = ResourceUrl.parse((String)value)) != null && !url.framework) {
                return new AndroidLintQuickFix[]{new MigrateDrawableToMipmapFix(url)};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintDuplicateUsesFeatureInspection
    extends AndroidLintInspectionBase {
        public AndroidLintDuplicateUsesFeatureInspection() {
            super(AndroidBundle.message("android.lint.inspections.duplicate.uses.feature", new Object[0]), ManifestDetector.DUPLICATE_USES_FEATURE);
        }
    }

    public static class AndroidLintOverrideInspection
    extends AndroidLintInspectionBase {
        public AndroidLintOverrideInspection() {
            super(AndroidBundle.message("android.lint.inspections.override", new Object[0]), ApiDetector.OVERRIDE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            return AndroidLintInspectionToolProvider.getApiDetectorFixes(ApiDetector.INLINED, startElement, endElement, message);
        }
    }

    public static class AndroidLintInlinedApiInspection
    extends AndroidLintInspectionBase {
        public AndroidLintInlinedApiInspection() {
            super(AndroidBundle.message("android.lint.inspections.inlined.api", new Object[0]), ApiDetector.INLINED);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            return AndroidLintInspectionToolProvider.getApiDetectorFixes(ApiDetector.INLINED, startElement, endElement, message);
        }
    }

    public static class AndroidLintNewApiInspection
    extends AndroidLintInspectionBase {
        public AndroidLintNewApiInspection() {
            super(AndroidBundle.message("android.lint.inspections.new.api", new Object[0]), ApiDetector.UNSUPPORTED);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            return AndroidLintInspectionToolProvider.getApiDetectorFixes(ApiDetector.UNSUPPORTED, startElement, endElement, message);
        }
    }

    private static abstract class AndroidLintTypographyInspectionBase
    extends AndroidLintInspectionBase {
        public AndroidLintTypographyInspectionBase(String displayName, Issue issue) {
            super(displayName, issue);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new TypographyQuickFix(this.myIssue, message)};
        }
    }

    public static class AndroidLintUselessLeafInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUselessLeafInspection() {
            super(AndroidBundle.message("android.lint.inspections.useless.leaf", new Object[0]), UselessViewDetector.USELESS_LEAF);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new RemoveUselessViewQuickFix(this.myIssue)};
        }
    }

    public static class AndroidLintUselessParentInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUselessParentInspection() {
            super(AndroidBundle.message("android.lint.inspections.useless.parent", new Object[0]), UselessViewDetector.USELESS_PARENT);
        }
    }

    public static class AndroidLintUseCompoundDrawablesInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUseCompoundDrawablesInspection() {
            super(AndroidBundle.message("android.lint.inspections.use.compound.drawables", new Object[0]), UseCompoundDrawableDetector.ISSUE);
        }
    }

    public static class AndroidLintUseAlpha2Inspection
    extends AndroidLintInspectionBase {
        public AndroidLintUseAlpha2Inspection() {
            super(AndroidBundle.message("android.lint.inspections.use.alpha2", new Object[0]), LocaleFolderDetector.USE_ALPHA_2);
        }
    }

    public static class AndroidLintTypographyOtherInspection
    extends AndroidLintTypographyInspectionBase {
        public AndroidLintTypographyOtherInspection() {
            super(AndroidBundle.message("android.lint.inspections.typography.other", new Object[0]), TypographyDetector.OTHER);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new TypographyQuickFix(this.myIssue, message)};
        }
    }

    public static class AndroidLintTypographyEllipsisInspection
    extends AndroidLintTypographyInspectionBase {
        public AndroidLintTypographyEllipsisInspection() {
            super(AndroidBundle.message("android.lint.inspections.typography.ellipsis", new Object[0]), TypographyDetector.ELLIPSIS);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new TypographyQuickFix(this.myIssue, message)};
        }
    }

    public static class AndroidLintTypographyFractionsInspection
    extends AndroidLintTypographyInspectionBase {
        public AndroidLintTypographyFractionsInspection() {
            super(AndroidBundle.message("android.lint.inspections.typography.fractions", new Object[0]), TypographyDetector.FRACTIONS);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new TypographyQuickFix(this.myIssue, message)};
        }
    }

    public static class AndroidLintTypographyQuotesInspection
    extends AndroidLintTypographyInspectionBase {
        public AndroidLintTypographyQuotesInspection() {
            super(AndroidBundle.message("android.lint.inspections.typography.quotes", new Object[0]), TypographyDetector.QUOTES);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new TypographyQuickFix(this.myIssue, message)};
        }
    }

    public static class AndroidLintTypographyDashesInspection
    extends AndroidLintTypographyInspectionBase {
        public AndroidLintTypographyDashesInspection() {
            super(AndroidBundle.message("android.lint.inspections.typography.dashes", new Object[0]), TypographyDetector.DASHES);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new TypographyQuickFix(this.myIssue, message)};
        }
    }

    public static class AndroidLintTrustAllX509TrustManagerInspection
    extends AndroidLintInspectionBase {
        public AndroidLintTrustAllX509TrustManagerInspection() {
            super(AndroidBundle.message("android.lint.inspections.trust.all.x509.trust.manager", new Object[0]), TrustAllX509TrustManagerDetector.ISSUE);
        }
    }

    public static class AndroidLintTooDeepLayoutInspection
    extends AndroidLintInspectionBase {
        public AndroidLintTooDeepLayoutInspection() {
            super(AndroidBundle.message("android.lint.inspections.too.deep.layout", new Object[0]), TooManyViewsDetector.TOO_DEEP);
        }
    }

    public static class AndroidLintTooManyViewsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintTooManyViewsInspection() {
            super(AndroidBundle.message("android.lint.inspections.too.many.views", new Object[0]), TooManyViewsDetector.TOO_MANY);
        }
    }

    public static class AndroidLintTextFieldsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintTextFieldsInspection() {
            super(AndroidBundle.message("android.lint.inspections.text.fields", new Object[0]), TextFieldDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new SetAttributeQuickFix(AndroidBundle.message("android.lint.fix.add.input.type.attribute", new Object[0]), "inputType", null)};
        }
    }

    public static class AndroidLintSwitchIntDefInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSwitchIntDefInspection() {
            super(AndroidBundle.message("android.lint.inspections.switch.int.def", new Object[0]), AnnotationDetector.SWITCH_TYPE_DEF);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            final List missingCases = AnnotationDetector.getMissingCases((String)message, (TextFormat)TextFormat.RAW);
            if (missingCases != null && !missingCases.isEmpty()) {
                return new AndroidLintQuickFix[]{new AndroidLintQuickFix(){

                    @Override
                    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                        if (startElement.getParent() instanceof PsiSwitchStatement) {
                            PsiSwitchStatement switchStatement = (PsiSwitchStatement)startElement.getParent();
                            Project project = switchStatement.getProject();
                            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                            PsiCodeBlock body = switchStatement.getBody();
                            if (body == null) {
                                return;
                            }
                            PsiElement anchor = body.getLastChild();
                            for (String constant : missingCases) {
                                PsiElement parent = anchor.getParent();
                                PsiStatement caseStatement = factory.createStatementFromText("case " + constant + ":", anchor);
                                parent.addBefore((PsiElement)caseStatement, anchor);
                                PsiStatement breakStatement = factory.createStatementFromText("break;", anchor);
                                parent.addBefore((PsiElement)breakStatement, anchor);
                            }
                            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)switchStatement);
                        }
                    }

                    @Override
                    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
                        return startElement.isValid();
                    }

                    @Override
                    @NotNull
                    public String getName() {
                        return "Add Missing @IntDef Constants";
                    }
                }};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintStateListReachableInspection
    extends AndroidLintInspectionBase {
        public AndroidLintStateListReachableInspection() {
            super(AndroidBundle.message("android.lint.inspections.state.list.reachable", new Object[0]), StateListDetector.ISSUE);
        }
    }

    public static class AndroidLintSSLCertificateSocketFactoryGetInsecureInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSSLCertificateSocketFactoryGetInsecureInspection() {
            super(AndroidBundle.message("android.lint.inspections.sslcertificate.socket.factory.get.insecure", new Object[0]), SslCertificateSocketFactoryDetector.GET_INSECURE);
        }
    }

    public static class AndroidLintSSLCertificateSocketFactoryCreateSocketInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSSLCertificateSocketFactoryCreateSocketInspection() {
            super(AndroidBundle.message("android.lint.inspections.sslcertificate.socket.factory.create.socket", new Object[0]), SslCertificateSocketFactoryDetector.CREATE_SOCKET);
        }
    }

    public static class AndroidLintWorldWriteableFilesInspection
    extends AndroidLintInspectionBase {
        public AndroidLintWorldWriteableFilesInspection() {
            super(AndroidBundle.message("android.lint.inspections.world.writeable.files", new Object[0]), SecurityDetector.WORLD_WRITEABLE);
        }
    }

    public static class AndroidLintGrantAllUrisInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGrantAllUrisInspection() {
            super(AndroidBundle.message("android.lint.inspections.grant.all.uris", new Object[0]), SecurityDetector.OPEN_PROVIDER);
        }
    }

    public static class AndroidLintGradlePluginVersionInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGradlePluginVersionInspection() {
            super(AndroidBundle.message("android.lint.inspections.gradle.plugin.version", new Object[0]), GradleDetector.GRADLE_PLUGIN_COMPATIBILITY);
        }
    }

    public static class AndroidLintGradlePathInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGradlePathInspection() {
            super(AndroidBundle.message("android.lint.inspections.gradle.path", new Object[0]), GradleDetector.PATH);
        }
    }

    public static class AndroidLintGradleOverridesInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGradleOverridesInspection() {
            super(AndroidBundle.message("android.lint.inspections.gradle.overrides", new Object[0]), ManifestDetector.GRADLE_OVERRIDES);
        }
    }

    public static class AndroidLintGradleIdeErrorInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGradleIdeErrorInspection() {
            super(AndroidBundle.message("android.lint.inspections.gradle.ide.error", new Object[0]), GradleDetector.IDE_SUPPORT);
        }
    }

    public static class AndroidLintGradleGetterInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGradleGetterInspection() {
            super(AndroidBundle.message("android.lint.inspections.gradle.getter", new Object[0]), GradleDetector.GRADLE_GETTER);
        }
    }

    public static class AndroidLintGradleDynamicVersionInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGradleDynamicVersionInspection() {
            super(AndroidBundle.message("android.lint.inspections.gradle.dynamic.version", new Object[0]), GradleDetector.PLUS);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(final @NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            GradleCoordinate plus;
            String before = GradleDetector.getOldValue((Issue)GradleDetector.PLUS, (String)message, (TextFormat)TextFormat.RAW);
            if (before != null && before.contains("+") && (plus = GradleCoordinate.parseCoordinateString((String)before)) != null && plus.getArtifactId() != null) {
                return new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Replace with specific version", plus.getRevision(), "specific version"){

                    @Override
                    @Nullable
                    protected String getNewValue() {
                        return RepositoryUrlManager.get().resolveDynamicCoordinateVersion(plus, startElement.getProject());
                    }
                }};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintGradleDeprecatedInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGradleDeprecatedInspection() {
            super(AndroidBundle.message("android.lint.inspections.gradle.deprecated", new Object[0]), GradleDetector.DEPRECATED);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            String before = GradleDetector.getOldValue((Issue)GradleDetector.DEPRECATED, (String)message, (TextFormat)TextFormat.RAW);
            String after = GradleDetector.getNewValue((Issue)GradleDetector.DEPRECATED, (String)message, (TextFormat)TextFormat.RAW);
            if (before != null && after != null) {
                return new AndroidLintQuickFix[]{new ReplaceStringQuickFix(null, before, after)};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintGradleDependencyInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGradleDependencyInspection() {
            super(AndroidBundle.message("android.lint.inspections.gradle.dependency", new Object[0]), GradleDetector.DEPENDENCY);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            String before = GradleDetector.getOldValue((Issue)GradleDetector.DEPENDENCY, (String)message, (TextFormat)TextFormat.RAW);
            String after = GradleDetector.getNewValue((Issue)GradleDetector.DEPENDENCY, (String)message, (TextFormat)TextFormat.RAW);
            if (before != null && after != null) {
                return new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Change to " + after, before, after)};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintGradleCompatibleInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGradleCompatibleInspection() {
            super(AndroidBundle.message("android.lint.inspections.gradle.compatible", new Object[0]), GradleDetector.COMPATIBILITY);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            String before = GradleDetector.getOldValue((Issue)GradleDetector.COMPATIBILITY, (String)message, (TextFormat)TextFormat.RAW);
            String after = GradleDetector.getNewValue((Issue)GradleDetector.COMPATIBILITY, (String)message, (TextFormat)TextFormat.RAW);
            if (before != null && after != null) {
                return new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Change to " + after, before, after)};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintExportedServiceInspection
    extends AndroidLintInspectionBase {
        public AndroidLintExportedServiceInspection() {
            super(AndroidBundle.message("android.lint.inspections.exported.service", new Object[0]), SecurityDetector.EXPORTED_SERVICE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new SetAttributeQuickFix(AndroidBundle.message("android.lint.fix.add.permission.attribute", new Object[0]), "permission", null)};
        }
    }

    public static class AndroidLintScrollViewSizeInspection
    extends AndroidLintInspectionBase {
        public AndroidLintScrollViewSizeInspection() {
            super(AndroidBundle.message("android.lint.inspections.scroll.view.size", new Object[0]), ScrollViewChildDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new SetScrollViewSizeQuickFix()};
        }
    }

    public static class AndroidLintPxUsageInspection
    extends AndroidLintInspectionBase {
        public AndroidLintPxUsageInspection() {
            super(AndroidBundle.message("android.lint.inspections.px.usage", new Object[0]), PxUsageDetector.PX_ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new ConvertToDpQuickFix()};
        }
    }

    public static class AndroidLintProguardSplitInspection
    extends AndroidLintInspectionBase {
        public AndroidLintProguardSplitInspection() {
            super(AndroidBundle.message("android.lint.inspections.proguard.split", new Object[0]), ProguardDetector.SPLIT_CONFIG);
        }
    }

    public static class AndroidLintProguardInspection
    extends AndroidLintInspectionBase {
        public AndroidLintProguardInspection() {
            super(AndroidBundle.message("android.lint.inspections.proguard", new Object[0]), ProguardDetector.WRONG_KEEP);
        }
    }

    public static class AndroidLintObsoleteLayoutParamInspection
    extends AndroidLintInspectionBase {
        public AndroidLintObsoleteLayoutParamInspection() {
            super(AndroidBundle.message("android.lint.inspections.obsolete.layout.param", new Object[0]), ObsoleteLayoutParamsDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new RemoveAttributeQuickFix()};
        }
    }

    public static class AndroidLintNotSiblingInspection
    extends AndroidLintInspectionBase {
        public AndroidLintNotSiblingInspection() {
            super(AndroidBundle.message("android.lint.inspections.not.sibling", new Object[0]), WrongIdDetector.NOT_SIBLING);
        }
    }

    public static class AndroidLintNotInterpolatedInspection
    extends AndroidLintInspectionBase {
        public AndroidLintNotInterpolatedInspection() {
            super(AndroidBundle.message("android.lint.inspections.not.interpolated", new Object[0]), GradleDetector.NOT_INTERPOLATED);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            String s = endElement.getText();
            if (s.startsWith("'") && s.endsWith("'") && s.length() > 2) {
                return new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Replace single quotes with double quotes", s, "\"" + s.substring(1, s.length() - 1) + "\"")};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintNfcTechWhitespaceInspection
    extends AndroidLintInspectionBase {
        public AndroidLintNfcTechWhitespaceInspection() {
            super(AndroidBundle.message("android.lint.inspections.nfc.tech.whitespace", new Object[0]), NfcTechListDetector.ISSUE);
        }
    }

    public static class AndroidLintNewerVersionAvailableInspection
    extends AndroidLintInspectionBase {
        public AndroidLintNewerVersionAvailableInspection() {
            super(AndroidBundle.message("android.lint.inspections.newer.version.available", new Object[0]), GradleDetector.REMOTE_VERSION);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            String obsolete = GradleDetector.getOldValue((Issue)GradleDetector.DEPENDENCY, (String)message, (TextFormat)TextFormat.RAW);
            String available = GradleDetector.getNewValue((Issue)GradleDetector.DEPENDENCY, (String)message, (TextFormat)TextFormat.RAW);
            if (obsolete != null && available != null) {
                return new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Update to " + available, obsolete, available)};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintNestedScrollingInspection
    extends AndroidLintInspectionBase {
        public AndroidLintNestedScrollingInspection() {
            super(AndroidBundle.message("android.lint.inspections.nested.scrolling", new Object[0]), NestedScrollingWidgetDetector.ISSUE);
        }
    }

    public static class AndroidLintNegativeMarginInspection
    extends AndroidLintInspectionBase {
        public AndroidLintNegativeMarginInspection() {
            super(AndroidBundle.message("android.lint.inspections.negative.margin", new Object[0]), NegativeMarginDetector.ISSUE);
        }
    }

    public static class AndroidLintMergeRootFrameInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMergeRootFrameInspection() {
            super(AndroidBundle.message("android.lint.inspections.merge.root.frame", new Object[0]), MergeRootFrameLayoutDetector.ISSUE);
        }
    }

    public static class AndroidLintWearableBindListenerInspection
    extends AndroidLintInspectionBase {
        public AndroidLintWearableBindListenerInspection() {
            super(AndroidBundle.message("android.lint.inspections.wearable.bind.listener", new Object[0]), ManifestDetector.WEARABLE_BIND_LISTENER);
        }
    }

    public static class AndroidLintWebViewLayoutInspection
    extends AndroidLintInspectionBase {
        public AndroidLintWebViewLayoutInspection() {
            super(AndroidBundle.message("android.lint.inspections.web.view.layout", new Object[0]), WebViewDetector.ISSUE);
        }
    }

    public static class AndroidLintViewTagInspection
    extends AndroidLintInspectionBase {
        public AndroidLintViewTagInspection() {
            super(AndroidBundle.message("android.lint.inspections.view.tag", new Object[0]), ViewTagDetector.ISSUE);
        }
    }

    public static class AndroidLintViewHolderInspection
    extends AndroidLintInspectionBase {
        public AndroidLintViewHolderInspection() {
            super(AndroidBundle.message("android.lint.inspections.view.holder", new Object[0]), ViewHolderDetector.ISSUE);
        }
    }

    public static class AndroidLintViewConstructorInspection
    extends AndroidLintInspectionBase {
        public AndroidLintViewConstructorInspection() {
            super(AndroidBundle.message("android.lint.inspections.view.constructor", new Object[0]), ViewConstructorDetector.ISSUE);
        }
    }

    public static class AndroidLintVectorRasterInspection
    extends AndroidLintInspectionBase {
        public AndroidLintVectorRasterInspection() {
            super(AndroidBundle.message("android.lint.inspections.vector.raster", new Object[0]), VectorDetector.ISSUE);
        }
    }

    public static class AndroidLintVectorDrawableCompatInspection
    extends AndroidLintInspectionBase {
        public AndroidLintVectorDrawableCompatInspection() {
            super(AndroidBundle.message("android.lint.inspections.vector.drawable.compat", new Object[0]), VectorDrawableCompatDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class, (boolean)false);
            if (attribute != null && "src".equals(attribute.getLocalName())) {
                return new AndroidLintQuickFix[]{new RenameAttributeQuickFix("http://schemas.android.com/apk/res-auto", "srcCompat")};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintValidRestrictionsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintValidRestrictionsInspection() {
            super(AndroidBundle.message("android.lint.inspections.valid.restrictions", new Object[0]), RestrictionsDetector.ISSUE);
        }
    }

    public static class AndroidLintValidFragmentInspection
    extends AndroidLintInspectionBase {
        public AndroidLintValidFragmentInspection() {
            super(AndroidBundle.message("android.lint.inspections.valid.fragment", new Object[0]), FragmentDetector.ISSUE);
        }
    }

    public static class AndroidLintUsingHttpInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUsingHttpInspection() {
            super(AndroidBundle.message("android.lint.inspections.using.http", new Object[0]), PropertyFileDetector.HTTP);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            String escaped = PropertyFileDetector.getSuggestedEscape((String)message, (TextFormat)TextFormat.RAW);
            if (escaped != null) {
                return new AndroidLintQuickFix[]{new ReplaceStringQuickFix(null, null, escaped)};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintUsesMinSdkAttributesInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUsesMinSdkAttributesInspection() {
            super(AndroidBundle.message("android.lint.inspections.uses.min.sdk.attributes", new Object[0]), ManifestDetector.USES_SDK);
        }
    }

    public static class AndroidLintMultipleUsesSdkInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMultipleUsesSdkInspection() {
            super(AndroidBundle.message("android.lint.inspections.multiple.uses.sdk", new Object[0]), ManifestDetector.MULTIPLE_USES_SDK);
        }
    }

    public static class AndroidLintMockLocationInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMockLocationInspection() {
            super(AndroidBundle.message("android.lint.inspections.mock.location", new Object[0]), ManifestDetector.MOCK_LOCATION);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new MoveToDebugManifestQuickFix()};
        }
    }

    public static class AndroidLintManifestOrderInspection
    extends AndroidLintInspectionBase {
        public AndroidLintManifestOrderInspection() {
            super(AndroidBundle.message("android.lint.inspections.manifest.order", new Object[0]), ManifestDetector.ORDER);
        }
    }

    public static class AndroidLintDisableBaselineAlignmentInspection
    extends AndroidLintInspectionBase {
        public AndroidLintDisableBaselineAlignmentInspection() {
            super(AndroidBundle.message("android.lint.inspections.disable.baseline.alignment", new Object[0]), InefficientWeightDetector.BASELINE_WEIGHTS);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new SetAttributeQuickFix(AndroidBundle.message("android.lint.fix.set.baseline.attribute", new Object[0]), "baselineAligned", "false")};
        }
    }

    public static class AndroidLintDeviceAdminInspection
    extends AndroidLintInspectionBase {
        public AndroidLintDeviceAdminInspection() {
            super(AndroidBundle.message("android.lint.inspections.device.admin", new Object[0]), ManifestDetector.DEVICE_ADMIN);
        }
    }

    public static class AndroidLintDeprecatedInspection
    extends AndroidLintInspectionBase {
        public AndroidLintDeprecatedInspection() {
            super(AndroidBundle.message("android.lint.inspections.deprecated", new Object[0]), DeprecationDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            return new AndroidLintQuickFix[]{new SingleLineTrueQuickFix(), new RemoveAttributeQuickFix()};
        }
    }

    public static class AndroidLintDefaultLocaleInspection
    extends AndroidLintInspectionBase {
        public AndroidLintDefaultLocaleInspection() {
            super(AndroidBundle.message("android.lint.inspections.default.locale", new Object[0]), LocaleDetector.STRING_LOCALE);
        }
    }

    public static class AndroidLintNestedWeightsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintNestedWeightsInspection() {
            super(AndroidBundle.message("android.lint.inspections.nested.weights", new Object[0]), InefficientWeightDetector.NESTED_WEIGHTS);
        }
    }

    public static class AndroidLintInefficientWeightInspection
    extends AndroidLintInspectionBase {
        public AndroidLintInefficientWeightInspection() {
            super(AndroidBundle.message("android.lint.inspections.inefficient.weight", new Object[0]), InefficientWeightDetector.INEFFICIENT_WEIGHT);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new InefficientWeightQuickFix()};
        }
    }

    public static class AndroidLintHardcodedTextInspection
    extends AndroidLintInspectionBase {
        public AndroidLintHardcodedTextInspection() {
            super(AndroidBundle.message("android.lint.inspections.hardcoded.text", new Object[0]), HardcodedValuesDetector.ISSUE);
        }

        @Override
        @NotNull
        public IntentionAction[] getIntentions(@NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            return new IntentionAction[]{new AndroidAddStringResourceQuickFix(startElement)};
        }
    }

    public static class AndroidLintGridLayoutInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGridLayoutInspection() {
            super(AndroidBundle.message("android.lint.inspections.grid.layout", new Object[0]), GridLayoutDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(final @NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            String obsolete = GridLayoutDetector.getOldValue((String)message, (TextFormat)TextFormat.RAW);
            String available = GridLayoutDetector.getNewValue((String)message, (TextFormat)TextFormat.RAW);
            if (obsolete != null && available != null) {
                return new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Update to " + available, obsolete, available){

                    @Override
                    protected void editBefore(@NotNull Document document) {
                        Project project = startElement.getProject();
                        XmlFile file = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlFile.class);
                        if (file != null) {
                            AndroidResourceUtil.ensureNamespaceImported(file, "http://schemas.android.com/apk/res-auto", null);
                            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
                        }
                    }
                }};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintDuplicateIdsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintDuplicateIdsInspection() {
            super(AndroidBundle.message("android.lint.inspections.duplicate.ids", new Object[0]), DuplicateIdDetector.WITHIN_LAYOUT);
        }
    }

    public static class AndroidLintUnusedQuantityInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUnusedQuantityInspection() {
            super(AndroidBundle.message("android.lint.inspections.unused.quantity", new Object[0]), PluralsDetector.EXTRA);
        }
    }

    public static class AndroidLintMissingQuantityInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMissingQuantityInspection() {
            super(AndroidBundle.message("android.lint.inspections.missing.quantity", new Object[0]), PluralsDetector.MISSING);
        }
    }

    public static class AndroidLintMissingPrefixInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMissingPrefixInspection() {
            super(AndroidBundle.message("android.lint.inspections.missing.prefix", new Object[0]), DetectMissingPrefix.MISSING_NAMESPACE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new AddMissingPrefixQuickFix()};
        }
    }

    public static class AndroidLintScrollViewCountInspection
    extends AndroidLintInspectionBase {
        public AndroidLintScrollViewCountInspection() {
            super(AndroidBundle.message("android.lint.inspections.scroll.view.count", new Object[0]), ChildCountDetector.SCROLLVIEW_ISSUE);
        }
    }

    public static class AndroidLintSQLiteStringInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSQLiteStringInspection() {
            super(AndroidBundle.message("android.lint.inspections.sqlite.string", new Object[0]), SQLiteDetector.ISSUE);
        }
    }

    public static class AndroidLintAdapterViewChildrenInspection
    extends AndroidLintInspectionBase {
        public AndroidLintAdapterViewChildrenInspection() {
            super(AndroidBundle.message("android.lint.inspections.adapter.view.children", new Object[0]), ChildCountDetector.ADAPTER_VIEW_ISSUE);
        }
    }

    public static class AndroidLintAccidentalOctalInspection
    extends AndroidLintInspectionBase {
        public AndroidLintAccidentalOctalInspection() {
            super(AndroidBundle.message("android.lint.inspections.accidental.octal", new Object[0]), GradleDetector.ACCIDENTAL_OCTAL);
        }
    }

    public static class AndroidLintSuspiciousImportInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSuspiciousImportInspection() {
            super(AndroidBundle.message("android.lint.inspections.suspicious.import", new Object[0]), WrongImportDetector.ISSUE);
        }
    }

    public static class AndroidLintUnknownIdInLayoutInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUnknownIdInLayoutInspection() {
            super(AndroidBundle.message("android.lint.inspections.unknown.id.in.layout", new Object[0]), WrongIdDetector.UNKNOWN_ID_LAYOUT);
        }
    }

    public static class AndroidLintEnforceUTF8Inspection
    extends AndroidLintInspectionBase {
        public AndroidLintEnforceUTF8Inspection() {
            super(AndroidBundle.message("android.lint.inspections.enforce.utf8", new Object[0]), Utf8Detector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new ReplaceStringQuickFix(null, null, "utf-8")};
        }
    }

    public static class AndroidLintTextViewEditsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintTextViewEditsInspection() {
            super(AndroidBundle.message("android.lint.inspections.text.view.edits", new Object[0]), TextViewDetector.ISSUE);
        }
    }

    public static class AndroidLintSdCardPathInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSdCardPathInspection() {
            super(AndroidBundle.message("android.lint.inspections.sd.card.path", new Object[0]), SdCardDetector.ISSUE);
        }
    }

    public static class AndroidLintPrivateResourceInspection
    extends AndroidLintInspectionBase {
        public AndroidLintPrivateResourceInspection() {
            super(AndroidBundle.message("android.lint.inspections.private.resource", new Object[0]), PrivateResourceDetector.ISSUE);
        }
    }

    public static class AndroidLintPluralsCandidateInspection
    extends AndroidLintInspectionBase {
        public AndroidLintPluralsCandidateInspection() {
            super(AndroidBundle.message("android.lint.inspections.plurals.candidate", new Object[0]), StringFormatDetector.POTENTIAL_PLURAL);
        }
    }

    public static class AndroidLintParcelCreatorInspection
    extends AndroidLintInspectionBase {
        public AndroidLintParcelCreatorInspection() {
            super(AndroidBundle.message("android.lint.inspections.parcel.creator", new Object[0]), ParcelDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new ParcelableQuickFix(AndroidBundle.message("implement.parcelable.intention.text", new Object[0]), ParcelableQuickFix.Operation.IMPLEMENT)};
        }
    }

    public static class AndroidLintParcelClassLoaderInspection
    extends AndroidLintInspectionBase {
        public AndroidLintParcelClassLoaderInspection() {
            super(AndroidBundle.message("android.lint.inspections.parcel.class.loader", new Object[0]), ReadParcelableDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            String replace = "null)";
            if (endElement.getPrevSibling() instanceof PsiJavaToken && ((PsiJavaToken)endElement.getPrevSibling()).getTokenType() == JavaTokenType.LPARENTH) {
                replace = ")";
            }
            return new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Use getClass().getClassLoader()", replace, "getClass().getClassLoader())")};
        }
    }

    public static class AndroidLintPackageManagerGetSignaturesInspection
    extends AndroidLintInspectionBase {
        public AndroidLintPackageManagerGetSignaturesInspection() {
            super(AndroidBundle.message("android.lint.inspections.package.manager.get.signatures", new Object[0]), GetSignaturesDetector.ISSUE);
        }
    }

    public static class AndroidLintLibraryCustomViewInspection
    extends AndroidLintInspectionBase {
        public AndroidLintLibraryCustomViewInspection() {
            super(AndroidBundle.message("android.lint.inspections.library.custom.view", new Object[0]), NamespaceDetector.CUSTOM_VIEW);
        }
    }

    public static class AndroidLintUseValueOfInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUseValueOfInspection() {
            super(AndroidBundle.message("android.lint.inspections.use.value.of", new Object[0]), JavaPerformanceDetector.USE_VALUE_OF);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            String replacedType = JavaPerformanceDetector.getReplacedType((String)message, (TextFormat)TextFormat.RAW);
            if (replacedType != null) {
                return new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Replace with valueOf()", "(new\\s+" + replacedType + ")", replacedType + ".valueOf")};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintUseSparseArraysInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUseSparseArraysInspection() {
            super(AndroidBundle.message("android.lint.inspections.use.sparse.arrays", new Object[0]), JavaPerformanceDetector.USE_SPARSE_ARRAY);
        }
    }

    public static class AndroidLintDrawAllocationInspection
    extends AndroidLintInspectionBase {
        public AndroidLintDrawAllocationInspection() {
            super(AndroidBundle.message("android.lint.inspections.draw.allocation", new Object[0]), JavaPerformanceDetector.PAINT_ALLOC);
        }
    }

    public static class AndroidLintHardwareIdsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintHardwareIdsInspection() {
            super(AndroidBundle.message("android.lint.inspections.hardware.ids", new Object[0]), HardwareIdDetector.ISSUE);
        }
    }

    public static class AndroidLintHardcodedDebugModeInspection
    extends AndroidLintInspectionBase {
        public AndroidLintHardcodedDebugModeInspection() {
            super(AndroidBundle.message("android.lint.inspections.hardcoded.debug.mode", new Object[0]), HardcodedDebugModeDetector.ISSUE);
        }
    }

    public static class AndroidLintHandlerLeakInspection
    extends AndroidLintInspectionBase {
        public AndroidLintHandlerLeakInspection() {
            super(AndroidBundle.message("android.lint.inspections.handler.leak", new Object[0]), HandlerDetector.ISSUE);
        }
    }

    public static class AndroidLintExtraTextInspection
    extends AndroidLintInspectionBase {
        public AndroidLintExtraTextInspection() {
            super(AndroidBundle.message("android.lint.inspections.extra.text", new Object[0]), ExtraTextDetector.ISSUE);
        }
    }

    public static class AndroidLintButtonCaseInspection
    extends AndroidLintInspectionBase {
        public AndroidLintButtonCaseInspection() {
            super(AndroidBundle.message("android.lint.inspections.button.case", new Object[0]), ButtonDetector.CASE);
        }
    }

    public static class AndroidLintBatteryLifeInspection
    extends AndroidLintInspectionBase {
        public AndroidLintBatteryLifeInspection() {
            super(AndroidBundle.message("android.lint.inspections.battery.life", new Object[0]), BatteryDetector.ISSUE);
        }
    }

    public static class AndroidLintBadHostnameVerifierInspection
    extends AndroidLintInspectionBase {
        public AndroidLintBadHostnameVerifierInspection() {
            super(AndroidBundle.message("android.lint.inspections.bad.hostname.verifier", new Object[0]), BadHostnameVerifierDetector.ISSUE);
        }
    }

    public static class AndroidLintBackButtonInspection
    extends AndroidLintInspectionBase {
        public AndroidLintBackButtonInspection() {
            super(AndroidBundle.message("android.lint.inspections.back.button", new Object[0]), ButtonDetector.BACK_BUTTON);
        }
    }

    public static class AndroidLintButtonOrderInspection
    extends AndroidLintInspectionBase {
        public AndroidLintButtonOrderInspection() {
            super(AndroidBundle.message("android.lint.inspections.button.order", new Object[0]), ButtonDetector.ORDER);
        }
    }

    public static class AndroidLintContentDescriptionInspection
    extends AndroidLintInspectionBase {
        public AndroidLintContentDescriptionInspection() {
            super(AndroidBundle.message("android.lint.inspections.content.description", new Object[0]), AccessibilityDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new SetAttributeQuickFix(AndroidBundle.message("android.lint.fix.add.content.description", new Object[0]), "contentDescription", null)};
        }
    }

    public static class AndroidLintCommitTransactionInspection
    extends AndroidLintInspectionBase {
        public AndroidLintCommitTransactionInspection() {
            super(AndroidBundle.message("android.lint.inspections.commit.transaction", new Object[0]), CleanupDetector.COMMIT_FRAGMENT);
        }
    }

    public static class AndroidLintUnknownIdInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUnknownIdInspection() {
            super(AndroidBundle.message("android.lint.inspections.unknown.id", new Object[0]), WrongIdDetector.UNKNOWN_ID);
        }
    }

    public static class AndroidLintWrongViewCastInspection
    extends AndroidLintInspectionBase {
        public AndroidLintWrongViewCastInspection() {
            super(AndroidBundle.message("android.lint.inspections.wrong.view.cast", new Object[0]), ViewTypeDetector.ISSUE);
        }
    }

    public static class AndroidLintWrongRegionInspection
    extends AndroidLintInspectionBase {
        public AndroidLintWrongRegionInspection() {
            super(AndroidBundle.message("android.lint.inspections.wrong.region", new Object[0]), LocaleFolderDetector.WRONG_REGION);
        }
    }

    public static class AndroidLintStringFormatInvalidInspection
    extends AndroidLintInspectionBase {
        public AndroidLintStringFormatInvalidInspection() {
            super(AndroidBundle.message("android.lint.inspections.string.format.invalid", new Object[0]), StringFormatDetector.INVALID);
        }
    }

    public static class AndroidLintStringFormatMatchesInspection
    extends AndroidLintInspectionBase {
        public AndroidLintStringFormatMatchesInspection() {
            super(AndroidBundle.message("android.lint.inspections.string.format.matches", new Object[0]), StringFormatDetector.ARG_TYPES);
        }
    }

    public static class AndroidLintStringFormatCountInspection
    extends AndroidLintInspectionBase {
        public AndroidLintStringFormatCountInspection() {
            super(AndroidBundle.message("android.lint.inspections.string.format.count", new Object[0]), StringFormatDetector.ARG_COUNT);
        }
    }

    public static class AndroidLintAssertInspection
    extends AndroidLintInspectionBase {
        public AndroidLintAssertInspection() {
            super(AndroidBundle.message("android.lint.inspections.assert", new Object[0]), AssertDetector.ISSUE);
        }
    }

    public static class AndroidLintAppLinksAutoVerifyWarningInspection
    extends AndroidLintInspectionBase {
        public AndroidLintAppLinksAutoVerifyWarningInspection() {
            super(AndroidBundle.message("android.lint.inspections.app.links.auto.verify.warning", new Object[0]), AppLinksAutoVerifyDetector.ISSUE_WARNING);
        }
    }

    public static class AndroidLintAppLinksAutoVerifyErrorInspection
    extends AndroidLintInspectionBase {
        public AndroidLintAppLinksAutoVerifyErrorInspection() {
            super(AndroidBundle.message("android.lint.inspections.app.links.auto.verify.error", new Object[0]), AppLinksAutoVerifyDetector.ISSUE_ERROR);
        }
    }

    public static class AndroidLintGoogleAppIndexingApiWarningInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGoogleAppIndexingApiWarningInspection() {
            super(AndroidBundle.message("android.lint.inspections.google.app.indexing.api.warning", new Object[0]), AppIndexingApiDetector.ISSUE_APP_INDEXING_API);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            return AndroidLintInspectionToolProvider.getAppIndexingQuickFix(startElement, endElement, message);
        }
    }

    public static class AndroidLintGoogleAppIndexingWarningInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGoogleAppIndexingWarningInspection() {
            super(AndroidBundle.message("android.lint.inspections.google.app.indexing.warning", new Object[0]), AppIndexingApiDetector.ISSUE_APP_INDEXING);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            return AndroidLintInspectionToolProvider.getAppIndexingQuickFix(startElement, endElement, message);
        }
    }

    public static class AndroidLintGoogleAppIndexingUrlErrorInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGoogleAppIndexingUrlErrorInspection() {
            super(AndroidBundle.message("android.lint.inspections.google.app.indexing.url.error", new Object[0]), AppIndexingApiDetector.ISSUE_URL_ERROR);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            return AndroidLintInspectionToolProvider.getAppIndexingQuickFix(startElement, endElement, message);
        }
    }

    public static class AndroidLintAppCompatResourceInspection
    extends AndroidLintInspectionBase {
        public AndroidLintAppCompatResourceInspection() {
            super(AndroidBundle.message("android.lint.inspections.app.compat.resource", new Object[0]), AppCompatResourceDetector.ISSUE);
        }
    }

    public static class AndroidLintAppCompatMethodInspection
    extends AndroidLintInspectionBase {
        public AndroidLintAppCompatMethodInspection() {
            super(AndroidBundle.message("android.lint.inspections.app.compat.method", new Object[0]), AppCompatCallDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            String oldCall = AppCompatCallDetector.getOldCall((String)message, (TextFormat)TextFormat.RAW);
            String newCall = AppCompatCallDetector.getNewCall((String)message, (TextFormat)TextFormat.RAW);
            if (oldCall != null && newCall != null) {
                return new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Replace with " + newCall + "()", oldCall, newCall)};
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintAlwaysShowActionInspection
    extends AndroidLintInspectionBase {
        public AndroidLintAlwaysShowActionInspection() {
            super(AndroidBundle.message("android.lint.inspections.always.show.action", new Object[0]), AlwaysShowActionDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            return new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Replace with ifRoom", "(always)", "ifRoom")};
        }
    }

    public static class AndroidLintUnusedIdsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUnusedIdsInspection() {
            super(AndroidBundle.message("android.lint.inspections.unused.ids", new Object[0]), UnusedResourceDetector.ISSUE_IDS);
        }
    }

    public static class AndroidLintUnusedAttributeInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUnusedAttributeInspection() {
            super(AndroidBundle.message("android.lint.inspections.unused.attribute", new Object[0]), ApiDetector.UNUSED);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            return AndroidLintInspectionToolProvider.getApiDetectorFixes(ApiDetector.INLINED, startElement, endElement, message);
        }
    }

    public static class AndroidLintUnprotectedSMSBroadcastReceiverInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUnprotectedSMSBroadcastReceiverInspection() {
            super(AndroidBundle.message("android.lint.inspections.unprotected.smsbroadcast.receiver", new Object[0]), UnsafeBroadcastReceiverDetector.BROADCAST_SMS);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            return new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set permission attribute", "permission", "android.permission.BROADCAST_SMS")};
        }
    }

    public static class AndroidLintUnusedResourcesInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUnusedResourcesInspection() {
            super(AndroidBundle.message("android.lint.inspections.unused.resources", new Object[0]), UnusedResourceDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            String resource = UnusedResourceDetector.getUnusedResource((String)message, (TextFormat)TextFormat.RAW);
            if (resource != null) {
                String resourceUrl = "@" + resource.substring(2).replace('.', '/');
                return new AndroidLintQuickFix[]{new UnusedResourcesQuickFix(null), new UnusedResourcesQuickFix(resource), new SetAttributeQuickFix("Add a tools:keep attribute to mark as implicitly used", "keep", "http://schemas.android.com/tools", resourceUrl)};
            }
            return new AndroidLintQuickFix[]{new UnusedResourcesQuickFix(null)};
        }
    }

    public static class AndroidLintExtraTranslationInspection
    extends AndroidLintInspectionBase {
        public AndroidLintExtraTranslationInspection() {
            super(AndroidBundle.message("android.lint.inspections.extra.translation", new Object[0]), TranslationDetector.EXTRA);
        }
    }

    public static class AndroidLintMissingTranslationInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMissingTranslationInspection() {
            super(AndroidBundle.message("android.lint.inspections.missing.translation", new Object[0]), TranslationDetector.MISSING);
        }
    }

    public static class AndroidLintMissingSuperCallInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMissingSuperCallInspection() {
            super(AndroidBundle.message("android.lint.inspections.missing.super.call", new Object[0]), CallSuperDetector.ISSUE);
        }
    }

    public static class AndroidLintOverdrawInspection
    extends AndroidLintInspectionBase {
        public AndroidLintOverdrawInspection() {
            super(AndroidBundle.message("android.lint.inspections.overdraw", new Object[0]), OverdrawDetector.ISSUE);
        }
    }

    public static class AndroidLintIconNoDpiInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconNoDpiInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.no.dpi", new Object[0]), IconDetector.ICON_NODPI);
        }
    }

    public static class AndroidLintIconDuplicatesConfigInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconDuplicatesConfigInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.duplicates.config", new Object[0]), IconDetector.DUPLICATES_CONFIGURATIONS);
        }
    }

    public static class AndroidLintIconDuplicatesInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconDuplicatesInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.duplicates", new Object[0]), IconDetector.DUPLICATES_NAMES);
        }
    }

    public static class AndroidLintGifUsageInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGifUsageInspection() {
            super(AndroidBundle.message("android.lint.inspections.gif.usage", new Object[0]), IconDetector.GIF_USAGE);
        }
    }

    public static class AndroidLintGetInstanceInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGetInstanceInspection() {
            super(AndroidBundle.message("android.lint.inspections.get.instance", new Object[0]), CipherGetInstanceDetector.ISSUE);
        }
    }

    public static class AndroidLintFullBackupContentInspection
    extends AndroidLintInspectionBase {
        public AndroidLintFullBackupContentInspection() {
            super(AndroidBundle.message("android.lint.inspections.full.backup.content", new Object[0]), FullBackupContentDetector.ISSUE);
        }
    }

    public static class AndroidLintFloatMathInspection
    extends AndroidLintInspectionBase {
        public AndroidLintFloatMathInspection() {
            super(AndroidBundle.message("android.lint.inspections.float.math", new Object[0]), MathDetector.ISSUE);
        }
    }

    public static class AndroidLintIconMixedNinePatchInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconMixedNinePatchInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.mixed.nine.patch", new Object[0]), IconDetector.ICON_MIX_9PNG);
        }
    }

    public static class AndroidLintIconMissingDensityFolderInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconMissingDensityFolderInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.missing.density.folder", new Object[0]), IconDetector.ICON_MISSING_FOLDER);
        }
    }

    public static class AndroidLintIconDensitiesInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconDensitiesInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.densities", new Object[0]), IconDetector.ICON_DENSITIES);
        }
    }

    public static class AndroidLintIconLocationInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconLocationInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.location", new Object[0]), IconDetector.ICON_LOCATION);
        }
    }

    public static class AndroidLintIconDipSizeInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconDipSizeInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.dip.size", new Object[0]), IconDetector.ICON_DIP_SIZE);
        }
    }

    public static class AndroidLintIconExpectedSizeInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconExpectedSizeInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.expected.size", new Object[0]), IconDetector.ICON_EXPECTED_SIZE);
        }
    }

    public static class AndroidLintDuplicateIncludedIdsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintDuplicateIncludedIdsInspection() {
            super(AndroidBundle.message("android.lint.inspections.duplicate.included.ids", new Object[0]), DuplicateIdDetector.CROSS_LAYOUT);
        }
    }

    public static class AndroidLintInconsistentLayoutInspection
    extends AndroidLintInspectionBase {
        public AndroidLintInconsistentLayoutInspection() {
            super(AndroidBundle.message("android.lint.inspections.inconsistent.layout", new Object[0]), LayoutConsistencyDetector.INCONSISTENT_IDS);
        }
    }

    public static class AndroidLintInconsistentArraysInspection
    extends AndroidLintInspectionBase {
        public AndroidLintInconsistentArraysInspection() {
            super(AndroidBundle.message("android.lint.inspections.inconsistent.arrays", new Object[0]), ArraySizeDetector.INCONSISTENT);
        }
    }

    public static class AndroidLintAaptCrashInspection
    extends AndroidLintInspectionBase {
        public AndroidLintAaptCrashInspection() {
            super(AndroidBundle.message("android.lint.inspections.aapt.crash", new Object[0]), ResourceCycleDetector.CRASH);
        }
    }

    public static class AndroidLintCustomWarningInspection
    extends AndroidLintInspectionBase {
        public AndroidLintCustomWarningInspection() {
            super("Warning from Custom Lint Check", IntellijLintIssueRegistry.CUSTOM_WARNING);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            return ShowCustomIssueExplanationFix.getFixes(startElement, message);
        }
    }

    public static class AndroidLintCustomErrorInspection
    extends AndroidLintInspectionBase {
        public AndroidLintCustomErrorInspection() {
            super("Error from Custom Lint Check", IntellijLintIssueRegistry.CUSTOM_ERROR);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            return ShowCustomIssueExplanationFix.getFixes(startElement, message);
        }
    }
}

