/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.formatter;

import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.Indent;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.xml.XmlPolicy;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.android.formatter.AndroidXmlCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidXmlPolicy
extends XmlPolicy {
    private final AndroidXmlCodeStyleSettings.MySettings myCustomSettings;

    public AndroidXmlPolicy(CodeStyleSettings settings, AndroidXmlCodeStyleSettings.MySettings customSettings, FormattingDocumentModel documentModel) {
        super(settings, documentModel);
        this.myCustomSettings = customSettings;
    }

    public WrapType getWrappingTypeForTagBegin(XmlTag tag) {
        PsiElement element = AndroidXmlPolicy.getNextSiblingElement((PsiElement)tag);
        if (element instanceof XmlTag && this.insertLineBreakBeforeTag((XmlTag)element)) {
            return WrapType.NORMAL;
        }
        return super.getWrappingTypeForTagBegin(tag);
    }

    public int getAttributesWrap() {
        return this.myCustomSettings.WRAP_ATTRIBUTES;
    }

    public boolean insertLineBreakBeforeFirstAttribute(XmlAttribute attribute) {
        if (this.myCustomSettings.INSERT_LINE_BREAK_BEFORE_FIRST_ATTRIBUTE) {
            boolean hasNamespace = false;
            for (XmlAttribute xmlAttribute : attribute.getParent().getAttributes()) {
                if (!xmlAttribute.isNamespaceDeclaration()) continue;
                hasNamespace = true;
                break;
            }
            if (hasNamespace) {
                return this.myCustomSettings.INSERT_LINE_BREAK_BEFORE_NAMESPACE_DECLARATION;
            }
            if (!attribute.isNamespaceDeclaration()) {
                return attribute.getParent().getAttributes().length > 1;
            }
        }
        return false;
    }

    public boolean insertLineBreakAfterLastAttribute(XmlAttribute attribute) {
        if (!this.myCustomSettings.INSERT_LINE_BREAK_AFTER_LAST_ATTRIBUTE) {
            return false;
        }
        return attribute.getParent().getAttributes().length > 1;
    }

    @Nullable
    protected static PsiElement getPrevSiblingElement(@NotNull PsiElement element) {
        ASTNode prevNode;
        PsiElement prev = element.getPrevSibling();
        for (prevNode = SourceTreeToPsiMap.psiElementToTree((PsiElement)prev); prevNode != null && FormatterUtil.containsWhiteSpacesOnly((ASTNode)prevNode); prevNode = prevNode.getTreePrev()) {
        }
        return SourceTreeToPsiMap.treeElementToPsi((ASTNode)prevNode);
    }

    @Nullable
    protected static PsiElement getNextSiblingElement(@NotNull PsiElement element) {
        ASTNode nextNode;
        PsiElement next = element.getNextSibling();
        for (nextNode = SourceTreeToPsiMap.psiElementToTree((PsiElement)next); nextNode != null && FormatterUtil.containsWhiteSpacesOnly((ASTNode)nextNode); nextNode = nextNode.getTreeNext()) {
        }
        return SourceTreeToPsiMap.treeElementToPsi((ASTNode)nextNode);
    }

    public int getBlankLinesBeforeTag(XmlTag xmlTag) {
        return 1;
    }

    public Indent getTagEndIndent() {
        return null;
    }
}

