/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.CustomFormattingModelBuilder;
import com.intellij.formatting.DelegatingFormattingModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.xml.XmlFormattingModelBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlPolicy;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomManager;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.dom.color.ColorDomFileDescription;
import org.jetbrains.android.dom.drawable.fileDescriptions.DrawableStateListDomFileDescription;
import org.jetbrains.android.dom.layout.LayoutDomFileDescription;
import org.jetbrains.android.dom.manifest.ManifestDomFileDescription;
import org.jetbrains.android.dom.resources.ResourcesDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.formatter.AndroidXmlCodeStyleSettings;
import org.jetbrains.android.formatter.ContextSpecificSettingsProviders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidXmlFormattingModelBuilder
implements CustomFormattingModelBuilder {
    private final XmlFormattingModelBuilder myXmlFormattingModelBuilder = new XmlFormattingModelBuilder();

    public boolean isEngagedToFormat(PsiElement context) {
        return AndroidXmlFormattingModelBuilder.getContextSpecificSettings(context) != null;
    }

    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        FormattingModel baseModel = this.myXmlFormattingModelBuilder.createModel(element, settings);
        AndroidXmlCodeStyleSettings baseSettings = AndroidXmlCodeStyleSettings.getInstance(settings);
        if (!baseSettings.USE_CUSTOM_SETTINGS) {
            return baseModel;
        }
        ContextSpecificSettingsProviders.Provider provider = AndroidXmlFormattingModelBuilder.getContextSpecificSettings(element);
        AndroidXmlCodeStyleSettings.MySettings s = provider != null ? (AndroidXmlCodeStyleSettings.MySettings)provider.getSettings(baseSettings) : null;
        return s != null ? new DelegatingFormattingModel(baseModel, AndroidXmlFormattingModelBuilder.createDelegatingBlock(baseModel, s, settings)) : baseModel;
    }

    private static Block createDelegatingBlock(FormattingModel model, AndroidXmlCodeStyleSettings.MySettings customSettings, CodeStyleSettings settings) {
        Block block = model.getRootBlock();
        if (block instanceof XmlBlock) {
            XmlBlock b = (XmlBlock)block;
            XmlPolicy policy = customSettings.createXmlPolicy(settings, model.getDocumentModel());
            return new XmlBlock(b.getNode(), b.getWrap(), b.getAlignment(), (XmlFormattingPolicy)policy, b.getIndent(), b.getTextRange()){

                protected XmlTagBlock createTagBlock(ASTNode child, Indent indent, Wrap wrap, Alignment alignment) {
                    return new XmlTagBlock(child, wrap, alignment, this.myXmlFormattingPolicy, indent != null ? indent : Indent.getNoneIndent(), this.isPreserveSpace());
                }
            };
        }
        return block;
    }

    @Nullable
    public TextRange getRangeAffectingIndent(PsiFile file, int offset, ASTNode elementAtOffset) {
        return this.myXmlFormattingModelBuilder.getRangeAffectingIndent(file, offset, elementAtOffset);
    }

    @Nullable
    private static ContextSpecificSettingsProviders.Provider getContextSpecificSettings(PsiElement context) {
        PsiFile file = context.getContainingFile();
        if (!(file instanceof XmlFile) || AndroidFacet.getInstance((PsiElement)file) == null) {
            return null;
        }
        DomFileDescription description = DomManager.getDomManager((Project)context.getProject()).getDomFileDescription((XmlFile)file);
        if (description instanceof LayoutDomFileDescription) {
            return ContextSpecificSettingsProviders.LAYOUT;
        }
        if (description instanceof ManifestDomFileDescription) {
            return ContextSpecificSettingsProviders.MANIFEST;
        }
        if (description instanceof ResourcesDomFileDescription || description instanceof DrawableStateListDomFileDescription || description instanceof ColorDomFileDescription) {
            return ContextSpecificSettingsProviders.VALUE_RESOURCE_FILE;
        }
        if (description instanceof AndroidResourceDomFileDescription) {
            return ContextSpecificSettingsProviders.OTHER;
        }
        return null;
    }
}

