/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.tools.idea.res.ResourceHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.ArrayUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutViewClassUtils {
    private LayoutViewClassUtils() {
    }

    @NotNull
    public static String[] getTagNamesByClass(final @NotNull PsiClass c, final int apiLevel) {
        return (String[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<String[]>(){

            public String[] compute() {
                String name = c.getName();
                if (name == null) {
                    return ArrayUtil.EMPTY_STRING_ARRAY;
                }
                String qualifiedName = c.getQualifiedName();
                if (qualifiedName == null) {
                    return new String[]{name};
                }
                if (ResourceHelper.isClassPackageNeeded(qualifiedName, c, apiLevel)) {
                    return new String[]{qualifiedName};
                }
                return new String[]{name, qualifiedName};
            }
        });
    }

    @Nullable
    public static PsiClass findClassByTagName(@NotNull AndroidFacet facet, @NotNull String name, @NotNull PsiClass baseClass) {
        Module module = facet.getModule();
        Project project = module.getProject();
        if (!name.contains(".")) {
            PsiClass[] classes = PsiShortNamesCache.getInstance((Project)project).getClassesByName(name, module.getModuleWithLibrariesScope());
            int apiLevel = facet.getModuleMinApi();
            for (PsiClass aClass : classes) {
                String qualifiedName = aClass.getQualifiedName();
                if (qualifiedName == null || ResourceHelper.isClassPackageNeeded(qualifiedName, baseClass, apiLevel) || !aClass.isInheritor(baseClass, true)) continue;
                return aClass;
            }
        } else {
            PsiClass[] classes;
            for (PsiClass aClass : classes = JavaPsiFacade.getInstance((Project)project).findClasses(name, module.getModuleWithDependenciesAndLibrariesScope(false))) {
                if (!aClass.isInheritor(baseClass, true)) continue;
                return aClass;
            }
        }
        return null;
    }

    @Nullable
    public static PsiClass findClassByTagName(@NotNull AndroidFacet facet, @NotNull String name, @NotNull String baseClassQName) {
        PsiClass baseClass = JavaPsiFacade.getInstance((Project)facet.getModule().getProject()).findClass(baseClassQName, facet.getModule().getModuleWithLibrariesScope());
        return baseClass != null ? LayoutViewClassUtils.findClassByTagName(facet, name, baseClass) : null;
    }
}

