/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.sdklib.IAndroidTarget;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetEditorTab;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.util.AndroidNativeLibData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.AndroidImportableProperty;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;
import org.jetbrains.jps.util.JpsPathUtil;

public class AndroidFacetConfiguration
implements FacetConfiguration,
PersistentStateComponent<JpsAndroidModuleProperties> {
    private static final FacetEditorTab[] NO_EDITOR_TABS = new FacetEditorTab[0];
    private AndroidFacet myFacet = null;
    private JpsAndroidModuleProperties myProperties = new JpsAndroidModuleProperties();

    public void init(@NotNull Module module, @NotNull VirtualFile contentRoot) {
        this.init(module, contentRoot.getPath());
    }

    public void init(@NotNull Module module, @NotNull String baseDirectoryPath) {
        String s = AndroidRootUtil.getPathRelativeToModuleDir(module, baseDirectoryPath);
        if (s == null || s.length() == 0) {
            return;
        }
        this.myProperties.GEN_FOLDER_RELATIVE_PATH_APT = '/' + s + this.myProperties.GEN_FOLDER_RELATIVE_PATH_APT;
        this.myProperties.GEN_FOLDER_RELATIVE_PATH_AIDL = '/' + s + this.myProperties.GEN_FOLDER_RELATIVE_PATH_AIDL;
        this.myProperties.MANIFEST_FILE_RELATIVE_PATH = '/' + s + this.myProperties.MANIFEST_FILE_RELATIVE_PATH;
        this.myProperties.RES_FOLDER_RELATIVE_PATH = '/' + s + this.myProperties.RES_FOLDER_RELATIVE_PATH;
        this.myProperties.ASSETS_FOLDER_RELATIVE_PATH = '/' + s + this.myProperties.ASSETS_FOLDER_RELATIVE_PATH;
        this.myProperties.LIBS_FOLDER_RELATIVE_PATH = '/' + s + this.myProperties.LIBS_FOLDER_RELATIVE_PATH;
        this.myProperties.PROGUARD_LOGS_FOLDER_RELATIVE_PATH = '/' + s + this.myProperties.PROGUARD_LOGS_FOLDER_RELATIVE_PATH;
        for (int i = 0; i < this.myProperties.RES_OVERLAY_FOLDERS.size(); ++i) {
            this.myProperties.RES_OVERLAY_FOLDERS.set(i, '/' + s + (String)this.myProperties.RES_OVERLAY_FOLDERS.get(i));
        }
    }

    @Nullable
    public AndroidPlatform getAndroidPlatform() {
        return AndroidPlatform.getInstance(this.myFacet.getModule());
    }

    @Nullable
    public AndroidSdkData getAndroidSdk() {
        AndroidPlatform platform = this.getAndroidPlatform();
        return platform != null ? platform.getSdkData() : null;
    }

    @Nullable
    public IAndroidTarget getAndroidTarget() {
        AndroidPlatform platform = this.getAndroidPlatform();
        return platform != null ? platform.getTarget() : null;
    }

    public void setFacet(@NotNull AndroidFacet facet) {
        this.myFacet = facet;
        facet.androidPlatformChanged();
    }

    public FacetEditorTab[] createEditorTabs(FacetEditorContext editorContext, FacetValidatorsManager validatorsManager) {
        JpsAndroidModuleProperties state = this.getState();
        assert (state != null);
        if (state.ALLOW_USER_CONFIGURATION) {
            return new FacetEditorTab[]{new AndroidFacetEditorTab(editorContext, this)};
        }
        return NO_EDITOR_TABS;
    }

    public void readExternal(Element element) throws InvalidDataException {
    }

    public void writeExternal(Element element) throws WriteExternalException {
    }

    @NotNull
    public List<AndroidNativeLibData> getAdditionalNativeLibraries() {
        ArrayList<AndroidNativeLibData> libDatas = new ArrayList<AndroidNativeLibData>();
        for (JpsAndroidModuleProperties.AndroidNativeLibDataEntry nativeLib : this.myProperties.myNativeLibs) {
            if (nativeLib.myArchitecture == null || nativeLib.myUrl == null || nativeLib.myTargetFileName == null) continue;
            libDatas.add(new AndroidNativeLibData(nativeLib.myArchitecture, JpsPathUtil.urlToPath((String)nativeLib.myUrl), nativeLib.myTargetFileName));
        }
        return libDatas;
    }

    public void setAdditionalNativeLibraries(@NotNull List<AndroidNativeLibData> additionalNativeLibraries) {
        this.myProperties.myNativeLibs = new ArrayList(additionalNativeLibraries.size());
        for (AndroidNativeLibData lib : additionalNativeLibraries) {
            JpsAndroidModuleProperties.AndroidNativeLibDataEntry data = new JpsAndroidModuleProperties.AndroidNativeLibDataEntry();
            data.myArchitecture = lib.getArchitecture();
            data.myUrl = VfsUtilCore.pathToUrl((String)lib.getPath());
            data.myTargetFileName = lib.getTargetFileName();
            this.myProperties.myNativeLibs.add(data);
        }
    }

    public boolean isImportedProperty(@NotNull AndroidImportableProperty property) {
        return !this.myProperties.myNotImportedProperties.contains(property);
    }

    public boolean isIncludeAssetsFromLibraries() {
        return this.myProperties.myIncludeAssetsFromLibraries;
    }

    public void setIncludeAssetsFromLibraries(boolean includeAssetsFromLibraries) {
        this.myProperties.myIncludeAssetsFromLibraries = includeAssetsFromLibraries;
    }

    @Nullable
    public JpsAndroidModuleProperties getState() {
        return this.myProperties;
    }

    public void loadState(JpsAndroidModuleProperties properties) {
        this.myProperties = properties;
    }
}

