/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.res.AppResourceRepository;
import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.android.dom.AdditionalConverter;
import org.jetbrains.android.dom.AndroidResourceType;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.converters.AndroidResourceReference;
import org.jetbrains.android.dom.converters.AttributeValueDocumentationProvider;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.CreateFileResourceQuickFix;
import org.jetbrains.android.inspections.CreateValueResourceQuickFix;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceReferenceConverter
extends ResolvingConverter<ResourceValue>
implements CustomReferenceConverter<ResourceValue>,
AttributeValueDocumentationProvider {
    private static final ImmutableSet<String> TOP_PRIORITY_VALUES = ImmutableSet.of((Object)"match_parent", (Object)"wrap_content");
    private final Set<ResourceType> myResourceTypes;
    private ResolvingConverter<String> myAdditionalConverter;
    private boolean myAdditionalConverterSoft = false;
    private boolean myWithPrefix = true;
    private boolean myWithExplicitResourceType = true;
    private boolean myQuiet = false;
    private boolean myAllowAttributeReferences = true;
    private boolean myExpandedCompletionSuggestion = true;
    private boolean myAllowLiterals = true;
    @Nullable
    private AttributeDefinition myAttributeDefinition = null;

    public ResourceReferenceConverter() {
        this(EnumSet.noneOf(ResourceType.class));
    }

    public ResourceReferenceConverter(@NotNull Collection<ResourceType> resourceTypes) {
        this.myResourceTypes = EnumSet.copyOf(resourceTypes);
    }

    public ResourceReferenceConverter(@NotNull Collection<ResourceType> resourceTypes, @Nullable AttributeDefinition attributeDefinition) {
        this.myResourceTypes = EnumSet.copyOf(resourceTypes);
        this.myAttributeDefinition = attributeDefinition;
    }

    public void setAllowLiterals(boolean allowLiterals) {
        this.myAllowLiterals = allowLiterals;
    }

    public ResourceReferenceConverter(@NotNull ResourceType resourceType, boolean withPrefix, boolean withExplicitResourceType) {
        this.myResourceTypes = EnumSet.of(resourceType);
        this.myWithPrefix = withPrefix;
        this.myWithExplicitResourceType = withExplicitResourceType;
    }

    public void setAdditionalConverter(@Nullable ResolvingConverter<String> additionalConverter, boolean soft) {
        this.myAdditionalConverter = additionalConverter;
        this.myAdditionalConverterSoft = soft;
    }

    public void setQuiet(boolean quiet) {
        this.myQuiet = quiet;
    }

    public void setExpandedCompletionSuggestion(boolean expandedCompletionSuggestion) {
        this.myExpandedCompletionSuggestion = expandedCompletionSuggestion;
    }

    public void setAllowAttributeReferences(boolean allowAttributeReferences) {
        this.myAllowAttributeReferences = allowAttributeReferences;
    }

    @NotNull
    private static String getPackagePrefix(@Nullable String resourcePackage, boolean withPrefix) {
        String prefix;
        String string = prefix = withPrefix ? "@" : "";
        if (resourcePackage == null) {
            return prefix;
        }
        return prefix + resourcePackage + ':';
    }

    @Nullable
    static String getValue(XmlElement element) {
        if (element instanceof XmlAttribute) {
            return ((XmlAttribute)element).getValue();
        }
        if (element instanceof XmlTag) {
            return ((XmlTag)element).getValue().getText();
        }
        return null;
    }

    @NotNull
    public Collection<? extends ResourceValue> getVariants(ConvertContext context) {
        ResolvingConverter<String> additionalConverter;
        XmlElement element;
        HashSet<ResourceValue> result = new HashSet<ResourceValue>();
        Module module = context.getModule();
        if (module == null) {
            return result;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return result;
        }
        Set<ResourceType> recommendedTypes = this.getResourceTypes(context);
        if (recommendedTypes.contains(ResourceType.ID) && recommendedTypes.size() == 1) {
            result.add(ResourceValue.reference("@+id/"));
        }
        if ((element = context.getXmlElement()) == null) {
            return result;
        }
        String value = ResourceReferenceConverter.getValue(element);
        assert (value != null);
        boolean startsWithRefChar = StringUtil.startsWithChar((CharSequence)value, (char)'@');
        if (!this.myQuiet || startsWithRefChar) {
            char prefix;
            String resourcePackage = null;
            String systemPrefix = ResourceReferenceConverter.getPackagePrefix("android", this.myWithPrefix || startsWithRefChar);
            if (value.startsWith(systemPrefix)) {
                resourcePackage = "android";
            } else {
                result.add(ResourceValue.literal(systemPrefix));
            }
            char c = prefix = this.myWithPrefix || startsWithRefChar ? (char)'@' : '\u0000';
            if (value.startsWith("@+id/")) {
                this.addVariantsForIdDeclaration(result, facet, prefix, value);
            }
            if (recommendedTypes.size() >= 1 && this.myExpandedCompletionSuggestion) {
                boolean explicitResourceType = startsWithRefChar || this.myWithExplicitResourceType;
                for (ResourceType type : recommendedTypes) {
                    ResourceReferenceConverter.addResourceReferenceValues(facet, prefix, type, resourcePackage, result, explicitResourceType);
                }
            } else {
                Set<ResourceType> filteringSet = "android".equals(resourcePackage) ? null : ResourceReferenceConverter.getResourceTypesInCurrentModule(facet);
                for (ResourceType resourceType : ResourceType.values()) {
                    String type = resourceType.getName();
                    String typePrefix = ResourceReferenceConverter.getTypePrefix(resourcePackage, type);
                    if (value.startsWith(typePrefix)) {
                        ResourceReferenceConverter.addResourceReferenceValues(facet, prefix, resourceType, resourcePackage, result, true);
                        continue;
                    }
                    if (!recommendedTypes.contains(resourceType) || filteringSet != null && !filteringSet.contains(resourceType)) continue;
                    result.add(ResourceValue.literal(typePrefix));
                }
            }
        }
        if (this.myAllowAttributeReferences) {
            ResourceReferenceConverter.completeAttributeReferences(value, facet, result);
        }
        if ((additionalConverter = this.getAdditionalConverter(context)) != null) {
            for (String variant : additionalConverter.getVariants(context)) {
                result.add(ResourceValue.literal(variant));
            }
        }
        return result;
    }

    private void addVariantsForIdDeclaration(Set<ResourceValue> result, AndroidFacet facet, char prefix, String value) {
        for (String name : facet.getLocalResourceManager().getIds(false)) {
            ResourceValue ref = ResourceReferenceConverter.referenceTo(prefix, "+id", null, name, true);
            if (value.startsWith(this.doToString(ref))) continue;
            result.add(ref);
        }
    }

    private static void completeAttributeReferences(String value, AndroidFacet facet, Set<ResourceValue> result) {
        if (StringUtil.startsWith((CharSequence)value, (CharSequence)"?attr/")) {
            ResourceReferenceConverter.addResourceReferenceValues(facet, '?', ResourceType.ATTR, null, result, true);
        } else if (StringUtil.startsWith((CharSequence)value, (CharSequence)"?android:attr/")) {
            ResourceReferenceConverter.addResourceReferenceValues(facet, '?', ResourceType.ATTR, "android", result, true);
        } else if (StringUtil.startsWithChar((CharSequence)value, (char)'?')) {
            ResourceReferenceConverter.addResourceReferenceValues(facet, '?', ResourceType.ATTR, null, result, false);
            ResourceReferenceConverter.addResourceReferenceValues(facet, '?', ResourceType.ATTR, "android", result, false);
            result.add(ResourceValue.literal("?attr/"));
            result.add(ResourceValue.literal("?android:attr/"));
        }
    }

    @NotNull
    public static Set<ResourceType> getResourceTypesInCurrentModule(@NotNull AndroidFacet facet) {
        EnumSet<ResourceType> result = EnumSet.noneOf(ResourceType.class);
        AppResourceRepository resourceRepository = facet.getAppResources(true);
        for (ResourceType type : ResourceType.values()) {
            if (!resourceRepository.hasResourcesOfType(type)) continue;
            if (type == ResourceType.DECLARE_STYLEABLE) {
                result.add(ResourceType.STYLEABLE);
                continue;
            }
            result.add(type);
        }
        return result;
    }

    @NotNull
    private static String getTypePrefix(String resourcePackage, String type) {
        String typePart = type + '/';
        return ResourceReferenceConverter.getPackagePrefix(resourcePackage, true) + typePart;
    }

    private Set<ResourceType> getResourceTypes(ConvertContext context) {
        return this.getResourceTypes(context.getInvocationElement());
    }

    @NotNull
    public Set<ResourceType> getResourceTypes(@NotNull DomElement element) {
        ResourceType t;
        String s;
        AndroidResourceType resourceType = (AndroidResourceType)element.getAnnotation(AndroidResourceType.class);
        EnumSet<ResourceType> types = EnumSet.copyOf(this.myResourceTypes);
        if (resourceType != null && (s = resourceType.value()) != null && (t = ResourceType.getEnum((String)s)) != null) {
            types.add(t);
        }
        if (types.size() == 0) {
            types.addAll(AndroidResourceUtil.VALUE_RESOURCE_TYPES);
        } else if (types.contains(ResourceType.DRAWABLE)) {
            types.add(ResourceType.COLOR);
        }
        return types;
    }

    private static void addResourceReferenceValues(AndroidFacet facet, char prefix, ResourceType type, @Nullable String resPackage, Collection<ResourceValue> result, boolean explicitResourceType) {
        ResourceManager manager = facet.getResourceManager(resPackage);
        String typeName = type.getName();
        if (manager != null) {
            for (String name : manager.getResourceNames(type, true)) {
                result.add(ResourceReferenceConverter.referenceTo(prefix, typeName, resPackage, name, explicitResourceType));
            }
        }
    }

    private static ResourceValue referenceTo(char prefix, String type, String resPackage, String name, boolean explicitResourceType) {
        return ResourceValue.referenceTo(prefix, resPackage, explicitResourceType ? type : null, name);
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        if (s == null || s.isEmpty()) {
            return "Missing value";
        }
        ResourceValue parsed = ResourceValue.parse(s, true, this.myWithPrefix, false);
        if (parsed == null || !parsed.isReference()) {
            ResolvingConverter<String> additionalConverter = this.getAdditionalConverter(context);
            if (additionalConverter != null) {
                return additionalConverter.getErrorMessage(s, context);
            }
        } else {
            String errorMessage = parsed.getErrorMessage();
            if (errorMessage != null) {
                return errorMessage;
            }
        }
        return super.getErrorMessage(s, context);
    }

    @Nullable
    public LookupElement createLookupElement(ResourceValue resourceValue) {
        String value = resourceValue.toString();
        boolean deprecated = false;
        String doc = null;
        if (this.myAttributeDefinition != null) {
            doc = this.myAttributeDefinition.getValueDoc(value);
            deprecated = this.myAttributeDefinition.isValueDeprecated(value);
        }
        LookupElementBuilder builder = doc == null ? LookupElementBuilder.create((String)value) : LookupElementBuilder.create((Object)new DocumentationHolder(value, doc.trim()), (String)value);
        builder = builder.withCaseSensitivity(true).withStrikeoutness(deprecated);
        String resourceName = resourceValue.getResourceName();
        if (resourceName != null) {
            builder = builder.withLookupString(resourceName);
        }
        int priority = deprecated ? 0 : (TOP_PRIORITY_VALUES.contains((Object)value) ? 2 : 1);
        return PrioritizedLookupElement.withPriority((LookupElement)builder, (double)priority);
    }

    public ResourceValue fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        if (DataBindingUtil.isBindingExpression(s)) {
            return ResourceValue.INVALID;
        }
        ResourceValue parsed = ResourceValue.parse(s, true, this.myWithPrefix, true);
        ResolvingConverter<String> additionalConverter = this.getAdditionalConverter(context);
        if (parsed == null || !parsed.isReference()) {
            if (additionalConverter != null) {
                String value = (String)additionalConverter.fromString(s, context);
                if (value != null) {
                    return ResourceValue.literal(value);
                }
                if (!this.myAdditionalConverterSoft) {
                    return null;
                }
            } else if (!this.myAllowLiterals) {
                return null;
            }
        }
        if (parsed != null) {
            String resType = parsed.getResourceType();
            if (parsed.getPrefix() == '?') {
                if (!this.myAllowAttributeReferences) {
                    return null;
                }
                if (resType == null) {
                    parsed.setResourceType(ResourceType.ATTR.getName());
                } else if (!ResourceType.ATTR.getName().equals(resType)) {
                    return null;
                }
            } else if (resType == null && parsed.isReference()) {
                if (this.myWithExplicitResourceType && !"@null".equals(s)) {
                    return null;
                }
                if (this.myResourceTypes.size() == 1) {
                    parsed.setResourceType(this.myResourceTypes.iterator().next().getName());
                }
            }
        }
        return parsed;
    }

    @Nullable
    private ResolvingConverter<String> getAdditionalConverter(ConvertContext context) {
        Class<? extends ResolvingConverter> converterClass;
        if (this.myAdditionalConverter != null) {
            return this.myAdditionalConverter;
        }
        AdditionalConverter additionalConverterAnnotation = (AdditionalConverter)context.getInvocationElement().getAnnotation(AdditionalConverter.class);
        if (additionalConverterAnnotation != null && (converterClass = additionalConverterAnnotation.value()) != null) {
            ConverterManager converterManager = (ConverterManager)ServiceManager.getService(ConverterManager.class);
            return (ResolvingConverter)converterManager.getConverterInstance(converterClass);
        }
        return null;
    }

    public String toString(@Nullable ResourceValue element, ConvertContext context) {
        return this.doToString(element);
    }

    private String doToString(ResourceValue element) {
        if (element == null) {
            return null;
        }
        if (this.myWithExplicitResourceType || !element.isReference()) {
            return element.toString();
        }
        return ResourceValue.referenceTo(element.getPrefix(), element.getNamespace(), null, element.getResourceName()).toString();
    }

    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        ResourceValue resourceValue;
        String value;
        DomElement domElement;
        AndroidFacet facet = AndroidFacet.getInstance(context);
        if (facet != null && (domElement = context.getInvocationElement()) instanceof GenericDomValue && (value = ((GenericDomValue)domElement).getStringValue()) != null && (resourceValue = ResourceValue.parse(value, false, this.myWithPrefix, true)) != null) {
            String aPackage = resourceValue.getNamespace();
            ResourceType resType = resourceValue.getType();
            if (resType == null && this.myResourceTypes.size() == 1) {
                resType = this.myResourceTypes.iterator().next();
            }
            String resourceName = resourceValue.getResourceName();
            if (aPackage == null && resType != null && resourceName != null && AndroidResourceUtil.isCorrectAndroidResourceName(resourceName)) {
                ArrayList<Object> fixes = new ArrayList<Object>();
                ResourceFolderType folderType = AndroidResourceUtil.XML_FILE_RESOURCE_TYPES.get(resType);
                if (folderType != null) {
                    fixes.add(new CreateFileResourceQuickFix(facet, folderType, resourceName, (PsiFile)context.getFile(), false));
                }
                if (AndroidResourceUtil.VALUE_RESOURCE_TYPES.contains(resType) && resType != ResourceType.LAYOUT) {
                    fixes.add(new CreateValueResourceQuickFix(facet, resType, resourceName, (PsiFile)context.getFile(), false));
                }
                return fixes.toArray(new LocalQuickFix[fixes.size()]);
            }
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<ResourceValue> value, PsiElement element, ConvertContext context) {
        ResourceValue resValue;
        AndroidFacet facet;
        if ("@null".equals(value.getStringValue())) {
            return PsiReference.EMPTY_ARRAY;
        }
        Module module = context.getModule();
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (resValue = (ResourceValue)value.getValue()) != null && resValue.isReference()) {
            XmlAttribute attribute;
            String resType = resValue.getResourceType();
            if (resType == null) {
                return PsiReference.EMPTY_ARRAY;
            }
            if (resValue.getNamespace() == null && "+id".equals(resType) && element != null && element.getParent() instanceof XmlAttribute && "id".equals((attribute = (XmlAttribute)element.getParent()).getLocalName()) && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespace())) {
                return PsiReference.EMPTY_ARRAY;
            }
            return new PsiReference[]{new AndroidResourceReference(value, facet, resValue, null)};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @Override
    public String getDocumentation(@NotNull String value) {
        return this.myAdditionalConverter instanceof AttributeValueDocumentationProvider ? ((AttributeValueDocumentationProvider)this.myAdditionalConverter).getDocumentation(value) : null;
    }

    public static class DocumentationHolder {
        @NotNull
        private final String myValue;
        @NotNull
        private final String myDocumentation;

        public DocumentationHolder(@NotNull String value, @NotNull String documentation) {
            this.myValue = value;
            this.myDocumentation = documentation;
        }

        @NotNull
        public String getValue() {
            return this.myValue;
        }

        @NotNull
        public String getDocumentation() {
            return this.myDocumentation;
        }
    }
}

