/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.attrs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeDefinition {
    private final String myName;
    private final List<String> myParentStyleables = ContainerUtil.newSmartList();
    private final Set<AttributeFormat> myFormats = EnumSet.noneOf(AttributeFormat.class);
    private final List<String> myValues = new ArrayList<String>();
    private final Map<String, String> myStyleable2DocValue = new HashMap<String, String>();
    private final Map<String, String> myValueDoc = new HashMap<String, String>();
    private String myGlobalDocValue;
    private String myAttrGroup;

    public AttributeDefinition(@NotNull String name) {
        this(name, null, Collections.emptySet());
    }

    public AttributeDefinition(@NotNull String name, @Nullable String parentStyleableName, @NotNull Collection<AttributeFormat> formats) {
        this.myName = name;
        if (parentStyleableName != null && !this.myParentStyleables.contains(parentStyleableName)) {
            this.myParentStyleables.add(parentStyleableName);
        }
        this.myFormats.addAll(formats);
    }

    public void addValue(@NotNull String name) {
        this.myValues.add(name);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public List<String> getParentStyleables() {
        return this.myParentStyleables;
    }

    @NotNull
    public Set<AttributeFormat> getFormats() {
        return Collections.unmodifiableSet(this.myFormats);
    }

    @Nullable
    public String getAttrGroup() {
        return this.myAttrGroup;
    }

    public void setAttrGroup(@Nullable String attrGroup) {
        this.myAttrGroup = attrGroup;
    }

    public void addFormats(@NotNull Collection<AttributeFormat> format) {
        this.myFormats.addAll(format);
    }

    @NotNull
    public String[] getValues() {
        return ArrayUtil.toStringArray(this.myValues);
    }

    @Nullable
    public String getDocValue(@Nullable String parentStyleable) {
        if (parentStyleable == null || !this.myStyleable2DocValue.containsKey(parentStyleable)) {
            return this.myGlobalDocValue;
        }
        return this.myStyleable2DocValue.get(parentStyleable);
    }

    public void addDocValue(@NotNull String docValue, @Nullable String parentStyleable) {
        if (parentStyleable == null || this.myGlobalDocValue == null) {
            this.myGlobalDocValue = docValue;
        }
        if (parentStyleable != null) {
            this.myStyleable2DocValue.put(parentStyleable, docValue);
        }
    }

    public String toString() {
        return this.myName + " [" + this.myFormats + ']';
    }

    public void addValueDoc(@NotNull String value, @NotNull String doc) {
        this.myValueDoc.put(value, doc);
    }

    @Nullable
    public String getValueDoc(@NotNull String value) {
        return this.myValueDoc.get(value);
    }

    public boolean isAttributeDeprecated() {
        String doc = this.getDocValue(null);
        return doc != null && StringUtil.containsIgnoreCase((String)doc, (String)"deprecated");
    }

    public boolean isValueDeprecated(@NotNull String value) {
        String doc = this.myValueDoc.get(value);
        return doc != null && StringUtil.containsIgnoreCase((String)doc, (String)"deprecated");
    }
}

