/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xml.XmlName;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AttributeProcessingUtil;
import org.jetbrains.android.dom.layout.LayoutElement;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.xml.PreferenceElement;
import org.jetbrains.android.dom.xml.XmlResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubtagsProcessingUtil {
    private SubtagsProcessingUtil() {
    }

    private static boolean isPreference(@NotNull Map<String, PsiClass> preferenceClassMap, @Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        PsiClass preferenceClass = preferenceClassMap.get("Preference");
        return preferenceClass != null && (preferenceClass == psiClass || psiClass.isInheritor(preferenceClass, true));
    }

    public static void registerXmlResourcesSubtags(AndroidFacet facet, XmlTag tag, XmlResourceElement element, SubtagProcessor subtagProcessor) {
        String tagName;
        switch (tagName = tag.getName()) {
            case "searchable": {
                subtagProcessor.processSubtag("actionkey", (Type)((Object)XmlResourceElement.class));
                break;
            }
            case "Keyboard": {
                subtagProcessor.processSubtag("Row", (Type)((Object)XmlResourceElement.class));
                break;
            }
            case "Row": {
                subtagProcessor.processSubtag("Key", (Type)((Object)XmlResourceElement.class));
                break;
            }
            case "device-admin": {
                subtagProcessor.processSubtag("uses-policies", (Type)((Object)XmlResourceElement.class));
                break;
            }
            case "uses-policies": {
                subtagProcessor.processSubtag("limit-password", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("watch-login", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("reset-password", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("force-lock", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("wipe-data", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("set-global-proxy", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("expire-password", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("encrypted-storage", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("disable-camera", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("disable-keyguard-features", (Type)((Object)XmlResourceElement.class));
                break;
            }
            case "preference-headers": {
                subtagProcessor.processSubtag("header", (Type)((Object)PreferenceElement.class));
            }
        }
        Map<String, PsiClass> prefClassMap = AttributeProcessingUtil.getPreferencesClassMap(facet);
        String prefClassName = element.getXmlTag().getName();
        PsiClass psiClass = prefClassMap.get(prefClassName);
        if (SubtagsProcessingUtil.isPreference(prefClassMap, psiClass)) {
            SubtagsProcessingUtil.registerClassNameSubtags(tag, prefClassMap, PreferenceElement.class, subtagProcessor);
        }
    }

    private static void registerClassNameSubtags(XmlTag tag, Map<String, PsiClass> classMap, Type type, SubtagProcessor subtagProcessor) {
        HashSet<String> allAllowedTags = new HashSet<String>();
        HashMap class2Name = new HashMap();
        for (Map.Entry<String, PsiClass> entry : classMap.entrySet()) {
            String tagName = entry.getKey();
            PsiClass aClass = entry.getValue();
            if (AndroidUtils.isAbstract(aClass)) continue;
            allAllowedTags.add(tagName);
            String qName = aClass.getQualifiedName();
            String prevTagName = (String)class2Name.get(qName);
            if (prevTagName != null && tagName.indexOf(46) != -1) continue;
            class2Name.put(qName, tagName);
        }
        SubtagsProcessingUtil.registerSubtags(tag, allAllowedTags, class2Name.values(), type, subtagProcessor);
    }

    private static void registerSubtags(XmlTag tag, Set<String> allowedTags, Collection<String> tagsToComplete, Type type, SubtagProcessor subtagProcessor) {
        for (String tagName : tagsToComplete) {
            subtagProcessor.processSubtag(tagName, type);
        }
        SubtagsProcessingUtil.registerExistingSubtags(tag, allowedTags::contains, type, subtagProcessor);
    }

    public static void processSubtags(@NotNull AndroidFacet facet, @NotNull AndroidDomElement element, @NotNull SubtagProcessor subtagProcessor) {
        if (element instanceof LayoutElement) {
            SubtagsProcessingUtil.registerClassNameSubtags(element.getXmlTag(), AttributeProcessingUtil.getViewClassMap(facet), LayoutViewElement.class, subtagProcessor);
        } else if (element instanceof XmlResourceElement) {
            SubtagsProcessingUtil.registerXmlResourcesSubtags(facet, element.getXmlTag(), (XmlResourceElement)element, subtagProcessor);
        }
    }

    private static void registerExistingSubtags(@NotNull XmlTag tag, @NotNull Predicate<String> filter, @NotNull Type type, @NotNull SubtagProcessor subtagProcessor) {
        XmlTag[] subtags;
        for (XmlTag subtag : subtags = tag.getSubTags()) {
            String localName = subtag.getLocalName();
            if (!filter.test(localName) || localName.endsWith(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED)) continue;
            subtagProcessor.processSubtag(new XmlName(localName), type);
        }
    }

    public static interface SubtagProcessor {
        public void processSubtag(@NotNull XmlName var1, @NotNull Type var2);

        default public void processSubtag(@NotNull String xmlName, @NotNull Type type) {
            this.processSubtag(new XmlName(xmlName), type);
        }
    }
}

