/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.tools.idea.AndroidTextUtils;
import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomExtension;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.RequiredImpl;
import org.jetbrains.android.dom.Styleable;
import org.jetbrains.android.dom.animation.InterpolatorElement;
import org.jetbrains.android.dom.animation.fileDescriptions.InterpolatorDomFileDescription;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.dom.attrs.StyleableDefinition;
import org.jetbrains.android.dom.attrs.ToolsAttributeUtil;
import org.jetbrains.android.dom.converters.CompositeConverter;
import org.jetbrains.android.dom.converters.ManifestPlaceholderConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.layout.Data;
import org.jetbrains.android.dom.layout.DataBindingElement;
import org.jetbrains.android.dom.layout.Fragment;
import org.jetbrains.android.dom.layout.Include;
import org.jetbrains.android.dom.layout.LayoutElement;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.layout.Tag;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.ManifestElement;
import org.jetbrains.android.dom.manifest.UsesSdk;
import org.jetbrains.android.dom.raw.XmlRawResourceElement;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.dom.xml.Intent;
import org.jetbrains.android.dom.xml.XmlResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.LayoutViewClassUtils;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeProcessingUtil {
    private static final String PREFERENCE_TAG_NAME = "Preference";
    private static final ImmutableSet<String> SIZE_NOT_REQUIRED_TAG_NAMES = ImmutableSet.of((Object)"merge", (Object)"TableRow", (Object)"include", (Object)"requestFocus", (Object)"layout", (Object)"data", (Object[])new String[]{"import", "tag"});
    private static final ImmutableSet<String> SIZE_NOT_REQUIRED_PARENT_TAG_NAMES = ImmutableSet.of((Object)"TableRow", (Object)"TableLayout", (Object)"merge", (Object)"GridLayout", (Object)"android.support.v7.widget.GridLayout", (Object)"android.support.percent.PercentRelativeLayout", (Object[])new String[]{"android.support.percent.PercentFrameLayout"});

    private AttributeProcessingUtil() {
    }

    private static Logger getLog() {
        return Logger.getInstance(AttributeProcessingUtil.class);
    }

    public static boolean isLayoutAttributeRequired(@NotNull XmlName attributeName, @NotNull DomElement element) {
        String localName = attributeName.getLocalName();
        if (!"layout_width".equals(localName) && !"layout_height".equals(localName)) {
            return false;
        }
        if ((element instanceof LayoutViewElement || element instanceof Fragment) && "http://schemas.android.com/apk/res/android".equals(attributeName.getNamespaceKey())) {
            String tagName;
            XmlElement xmlElement = element.getXmlElement();
            XmlTag tag = xmlElement instanceof XmlTag ? (XmlTag)xmlElement : null;
            String string = tagName = tag != null ? tag.getName() : null;
            if (!(SIZE_NOT_REQUIRED_TAG_NAMES.contains((Object)tagName) || tag != null && tag.getAttribute("style") != null)) {
                String parentTagName;
                XmlTag parentTag = tag != null ? tag.getParentTag() : null;
                String string2 = parentTagName = parentTag != null ? parentTag.getName() : null;
                if (!SIZE_NOT_REQUIRED_PARENT_TAG_NAMES.contains((Object)parentTagName)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public static String getNamespaceKeyByResourcePackage(@NotNull AndroidFacet facet, @Nullable String resPackage) {
        if (resPackage == null) {
            String aPackage;
            if (facet.getProperties().LIBRARY_PROJECT || facet.requiresAndroidModel()) {
                return "http://schemas.android.com/apk/res-auto";
            }
            Manifest manifest = facet.getManifest();
            if (manifest != null && (aPackage = (String)manifest.getPackage().getValue()) != null && aPackage.length() > 0) {
                return "http://schemas.android.com/apk/res/" + aPackage;
            }
        } else if (resPackage.equals("android")) {
            return "http://schemas.android.com/apk/res/android";
        }
        return null;
    }

    private static void registerStyleableAttributes(@NotNull DomElement element, @NotNull StyleableDefinition styleable, @Nullable String namespace, @NotNull AttributeProcessor callback, @NotNull Set<XmlName> skippedAttributes) {
        for (AttributeDefinition attrDef : styleable.getAttributes()) {
            String attrName = attrDef.getName();
            XmlName xmlName = new XmlName(attrName, namespace);
            if (skippedAttributes.contains(xmlName)) continue;
            skippedAttributes.add(xmlName);
            AttributeProcessingUtil.registerAttribute(attrDef, styleable.getName(), namespace, element, callback);
        }
    }

    private static boolean mustBeSoft(@NotNull Converter converter, @NotNull Collection<AttributeFormat> formats) {
        if (converter instanceof CompositeConverter || converter instanceof ResourceReferenceConverter) {
            return false;
        }
        return formats.size() > 1;
    }

    private static void registerAttribute(@NotNull AttributeDefinition attrDef, @Nullable String parentStyleableName, @Nullable String namespaceKey, @NotNull DomElement element, @NotNull AttributeProcessor callback) {
        XmlName xmlName;
        DomExtension extension;
        String name = attrDef.getName();
        if (!"http://schemas.android.com/apk/res/android".equals(namespaceKey) && name.startsWith("android:")) {
            name = name.substring("android:".length());
            namespaceKey = "http://schemas.android.com/apk/res/android";
        }
        if ((extension = callback.processAttribute(xmlName = new XmlName(name, namespaceKey), attrDef, parentStyleableName)) == null) {
            return;
        }
        Object converter = AndroidDomUtil.getSpecificConverter(xmlName, element);
        if (converter == null) {
            if ("http://schemas.android.com/tools".equals(namespaceKey)) {
                converter = ToolsAttributeUtil.getConverter(attrDef);
            } else {
                converter = AndroidDomUtil.getConverter(attrDef);
                if (converter != null && element.getParentOfType(Manifest.class, true) != null) {
                    converter = new ManifestPlaceholderConverter((Converter)converter);
                }
            }
        }
        if (converter != null) {
            extension.setConverter(converter, AttributeProcessingUtil.mustBeSoft(converter, attrDef.getFormats()));
        }
        if (element instanceof LayoutElement && AttributeProcessingUtil.isLayoutAttributeRequired(xmlName, element) || element instanceof ManifestElement && AndroidManifestUtils.isRequiredAttribute(xmlName, element)) {
            extension.addCustomAnnotation((Annotation)((Object)new RequiredImpl()));
        }
    }

    private static void registerAttributes(AndroidFacet facet, DomElement element, @NotNull String styleableName, AttributeProcessor callback, Set<XmlName> skipNames) {
        AttributeProcessingUtil.registerAttributes(facet, element, styleableName, null, callback, skipNames);
        AttributeProcessingUtil.registerAttributes(facet, element, styleableName, "android", callback, skipNames);
    }

    private static void registerAttributes(AndroidFacet facet, DomElement element, @NotNull String styleableName, @Nullable String resPackage, AttributeProcessor callback, Set<XmlName> skipNames) {
        ResourceManager manager = facet.getResourceManager(resPackage);
        if (manager == null) {
            return;
        }
        AttributeDefinitions attrDefs = manager.getAttributeDefinitions();
        if (attrDefs == null) {
            return;
        }
        String namespace = AttributeProcessingUtil.getNamespaceKeyByResourcePackage(facet, resPackage);
        StyleableDefinition styleable = attrDefs.getStyleableByName(styleableName);
        if (styleable != null) {
            AttributeProcessingUtil.registerStyleableAttributes(element, styleable, namespace, callback, skipNames);
        }
    }

    private static void registerAttributesForClassAndSuperclasses(AndroidFacet facet, DomElement element, PsiClass c, AttributeProcessor callback, Set<XmlName> skipNames) {
        while (c != null) {
            String styleableName = c.getName();
            if (styleableName != null) {
                AttributeProcessingUtil.registerAttributes(facet, element, styleableName, callback, skipNames);
            }
            c = AttributeProcessingUtil.getSuperclass(c);
        }
    }

    @Nullable
    private static PsiClass getSuperclass(@NotNull PsiClass c) {
        return (PsiClass)ApplicationManager.getApplication().runReadAction(() -> c.isValid() ? c.getSuperClass() : null);
    }

    public static void processXmlAttributes(@NotNull AndroidFacet facet, @NotNull XmlTag tag, @NotNull XmlResourceElement element, @NotNull Set<XmlName> skipAttrNames, @NotNull AttributeProcessor callback) {
        String tagName = tag.getName();
        String styleableName = (String)AndroidXmlResourcesUtil.SPECIAL_STYLEABLE_NAMES.get((Object)tagName);
        if (styleableName != null) {
            HashSet<XmlName> newSkipAttrNames = new HashSet<XmlName>();
            if (element instanceof Intent) {
                newSkipAttrNames.add(new XmlName("action", "http://schemas.android.com/apk/res/android"));
            }
            AttributeProcessingUtil.registerAttributes(facet, element, styleableName, "android", callback, newSkipAttrNames);
        }
        Map<String, PsiClass> prefClassMap = AttributeProcessingUtil.getPreferencesClassMap(facet);
        String prefClassName = element.getXmlTag().getName();
        PsiClass c = prefClassMap.get(prefClassName);
        AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet, element, c, callback, skipAttrNames);
        String widgetClassName = AndroidTextUtils.trimEndOrNullize(prefClassName, PREFERENCE_TAG_NAME);
        if (widgetClassName != null) {
            PsiClass widgetClass = LayoutViewClassUtils.findClassByTagName(facet, widgetClassName, "android.view.View");
            AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet, element, widgetClass, callback, skipAttrNames);
        }
    }

    @NotNull
    public static Map<String, PsiClass> getPreferencesClassMap(@NotNull AndroidFacet facet) {
        return facet.getClassMap("android.preference.Preference");
    }

    public static Map<String, PsiClass> getViewClassMap(@NotNull AndroidFacet facet) {
        if (DumbService.isDumb((Project)facet.getModule().getProject())) {
            return Collections.emptyMap();
        }
        return facet.getClassMap("android.view.View");
    }

    private static void registerAttributesFromSuffixedStyleables(@NotNull AndroidFacet facet, @NotNull DomElement element, @NotNull PsiClass psiClass, @NotNull AttributeProcessor callback, @NotNull Set<XmlName> skipAttrNames) {
        String styleableName;
        String viewName = psiClass.getName();
        if (viewName == null) {
            return;
        }
        switch (viewName) {
            case "ViewGroup": {
                styleableName = "ViewGroup_MarginLayout";
                break;
            }
            case "TableRow": {
                styleableName = "TableRow_Cell";
                break;
            }
            case "CollapsingToolbarLayout": {
                AttributeProcessingUtil.registerAttributes(facet, element, "CollapsingAppBarLayout_LayoutParams", callback, skipAttrNames);
                styleableName = viewName + "_Layout";
                break;
            }
            case "CoordinatorLayout": {
                AttributeProcessingUtil.registerAttributes(facet, element, "CoordinatorLayout_LayoutParams", callback, skipAttrNames);
                styleableName = viewName + "_Layout";
                break;
            }
            case "AppBarLayout": {
                AttributeProcessingUtil.registerAttributes(facet, element, "AppBarLayout_LayoutParams", callback, skipAttrNames);
                styleableName = viewName + "_Layout";
                break;
            }
            default: {
                styleableName = viewName + "_Layout";
            }
        }
        AttributeProcessingUtil.registerAttributes(facet, element, styleableName, callback, skipAttrNames);
    }

    public static void processLayoutAttributes(@NotNull AndroidFacet facet, @NotNull XmlTag tag, @NotNull LayoutElement element, @NotNull Set<XmlName> skipAttrNames, @NotNull AttributeProcessor callback) {
        String tagName;
        Map<String, PsiClass> map = AttributeProcessingUtil.getViewClassMap(facet);
        if (!(element instanceof DataBindingElement)) {
            PsiClass drawerLayout;
            AttributeProcessingUtil.registerToolsAttribute("targetApi", callback);
            if (tag.getParentTag() == null) {
                AttributeProcessingUtil.registerToolsAttribute("context", callback);
                AttributeProcessingUtil.registerToolsAttribute("menu", callback);
                AttributeProcessingUtil.registerToolsAttribute("actionBarNavMode", callback);
                AttributeProcessingUtil.registerToolsAttribute("showIn", callback);
            }
            PsiClass adapterView = map.get("AdapterView");
            String psiClass = map.get(tag.getName());
            if (adapterView != null && psiClass != null && psiClass.isInheritor(adapterView, true)) {
                AttributeProcessingUtil.registerToolsAttribute("listitem", callback);
                AttributeProcessingUtil.registerToolsAttribute("listheader", callback);
                AttributeProcessingUtil.registerToolsAttribute("listfooter", callback);
            }
            if ((drawerLayout = map.get("android.support.v4.widget.DrawerLayout")) != null && psiClass != null && (psiClass.isEquivalentTo((PsiElement)drawerLayout) || psiClass.isInheritor(drawerLayout, true))) {
                AttributeProcessingUtil.registerToolsAttribute("openDrawer", callback);
            }
        }
        if (element instanceof Tag || element instanceof Include || element instanceof Data) {
            return;
        }
        switch (tagName = tag.getName()) {
            case "view": {
                for (PsiClass aClass : map.values()) {
                    String name = aClass.getName();
                    if (name == null) continue;
                    AttributeProcessingUtil.registerAttributes(facet, element, name, callback, skipAttrNames);
                }
                break;
            }
            case "merge": {
                if (tag.getParentTag() == null) {
                    AttributeProcessingUtil.registerToolsAttribute("parentTag", callback);
                }
                AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet, element, map.get("merge"), callback, skipAttrNames);
                String parentTagName = tag.getAttributeValue("parentTag", "http://schemas.android.com/tools");
                if (parentTagName == null) break;
                AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet, element, map.get(parentTagName), callback, skipAttrNames);
                break;
            }
            default: {
                PsiClass c = map.get(tagName);
                AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet, element, c, callback, skipAttrNames);
            }
        }
        if (tagName.equals("merge")) {
            return;
        }
        XmlTag parentTag = tag.getParentTag();
        if (parentTag != null) {
            String parentTagName = parentTag.getName();
            if ("merge".equals(parentTagName)) {
                parentTagName = parentTag.getAttributeValue("parentTag", "http://schemas.android.com/tools");
            }
            if ("layout".equals(parentTagName)) {
                parentTagName = "ViewGroup";
            }
            if (parentTagName != null) {
                PsiClass c = map.get(parentTagName);
                while (c != null) {
                    AttributeProcessingUtil.registerAttributesFromSuffixedStyleables(facet, element, c, callback, skipAttrNames);
                    c = AttributeProcessingUtil.getSuperclass(c);
                }
                return;
            }
        }
        for (PsiClass c : map.values()) {
            AttributeProcessingUtil.registerAttributesFromSuffixedStyleables(facet, element, c, callback, skipAttrNames);
        }
    }

    public static void processAttributes(@NotNull AndroidDomElement element, @NotNull AndroidFacet facet, boolean processAllExistingAttrsFirst, @NotNull AttributeProcessor callback) {
        String styleableName;
        HashSet<XmlName> skippedAttributes;
        XmlTag tag = element.getXmlTag();
        Set<XmlName> set = skippedAttributes = processAllExistingAttrsFirst ? AttributeProcessingUtil.registerExistingAttributes(facet, tag, element, callback) : new HashSet<XmlName>();
        if (element instanceof ManifestElement) {
            AttributeProcessingUtil.processManifestAttributes(tag, element, callback);
        } else if (element instanceof LayoutElement) {
            AttributeProcessingUtil.processLayoutAttributes(facet, tag, (LayoutElement)element, skippedAttributes, callback);
        } else if (element instanceof XmlResourceElement) {
            AttributeProcessingUtil.processXmlAttributes(facet, tag, (XmlResourceElement)element, skippedAttributes, callback);
        } else if (element instanceof XmlRawResourceElement) {
            AttributeProcessingUtil.processRawAttributes(tag, callback);
        }
        Styleable styleableAnnotation = (Styleable)element.getAnnotation(Styleable.class);
        if (styleableAnnotation == null) {
            return;
        }
        SystemResourceManager manager = facet.getSystemResourceManager();
        if (manager == null) {
            return;
        }
        AttributeDefinitions definitions = manager.getAttributeDefinitions();
        if (definitions == null) {
            return;
        }
        for (String styleableName2 : styleableAnnotation.value()) {
            StyleableDefinition styleable = definitions.getStyleableByName(styleableName2);
            if (styleable == null) {
                AttributeProcessingUtil.getLog().warn(String.format("@Styleable(%s) annotation doesn't point to existing styleable", styleableName2));
                continue;
            }
            AttributeProcessingUtil.registerStyleableAttributes(element, styleable, "http://schemas.android.com/apk/res/android", callback, skippedAttributes);
        }
        if (element instanceof InterpolatorElement && (styleableName = InterpolatorDomFileDescription.getInterpolatorStyleableByTagName(tag.getName())) != null) {
            StyleableDefinition styleable = definitions.getStyleableByName(styleableName);
            if (styleable == null) {
                AttributeProcessingUtil.getLog().warn(String.format("%s doesn't point to existing styleable for interpolator", styleableName));
            } else {
                AttributeProcessingUtil.registerStyleableAttributes(element, styleable, "http://schemas.android.com/apk/res/android", callback, skippedAttributes);
            }
        }
    }

    public static void processRawAttributes(@NotNull XmlTag tag, @NotNull AttributeProcessor callback) {
        if ("resources".equals(tag.getName())) {
            AttributeProcessingUtil.registerToolsAttribute("shrinkMode", callback);
            AttributeProcessingUtil.registerToolsAttribute("keep", callback);
            AttributeProcessingUtil.registerToolsAttribute("discard", callback);
        }
    }

    public static void processManifestAttributes(@NotNull XmlTag tag, @NotNull AndroidDomElement element, @NotNull AttributeProcessor callback) {
        if (tag.getParentTag() != null) {
            AttributeProcessingUtil.registerToolsAttribute("node", callback);
            AttributeProcessingUtil.registerToolsAttribute("strict", callback);
            AttributeProcessingUtil.registerToolsAttribute("remove", callback);
            AttributeProcessingUtil.registerToolsAttribute("replace", callback);
        }
        if (element instanceof UsesSdk) {
            AttributeProcessingUtil.registerToolsAttribute("overrideLibrary", callback);
        }
    }

    private static void registerToolsAttribute(@NotNull String attributeName, @NotNull AttributeProcessor callback) {
        AttributeDefinition definition = ToolsAttributeUtil.getAttrDefByName(attributeName);
        if (definition != null) {
            XmlName name = new XmlName(attributeName, "http://schemas.android.com/tools");
            DomExtension domExtension = callback.processAttribute(name, definition, null);
            ResolvingConverter converter = ToolsAttributeUtil.getConverter(definition);
            if (domExtension != null && converter != null) {
                domExtension.setConverter((Converter)converter);
            }
        } else {
            AttributeProcessingUtil.getLog().warn("No attribute definition for tools attribute " + attributeName);
        }
    }

    @NotNull
    private static Set<XmlName> registerExistingAttributes(@NotNull AndroidFacet facet, @NotNull XmlTag tag, @NotNull AndroidDomElement element, @NotNull AttributeProcessor callback) {
        XmlAttribute[] attrs;
        HashSet<XmlName> result = new HashSet<XmlName>();
        for (XmlAttribute attr : attrs = tag.getAttributes()) {
            AttributeDefinition attrDef;
            String localName = attr.getLocalName();
            if (localName.endsWith(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED) || "xmlns".equals(attr.getNamespacePrefix()) || (attrDef = AndroidDomUtil.getAttributeDefinition(facet, attr)) == null) continue;
            String namespace = attr.getNamespace();
            result.add(new XmlName(attr.getLocalName(), attr.getNamespace()));
            AttributeProcessingUtil.registerAttribute(attrDef, null, namespace.length() > 0 ? namespace : null, element, callback);
        }
        return result;
    }

    public static interface AttributeProcessor {
        @Nullable
        public DomExtension processAttribute(@NotNull XmlName var1, @NotNull AttributeDefinition var2, @Nullable String var3);
    }
}

