/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import javax.swing.Icon;
import org.jetbrains.android.dom.AndroidAnyAttributeDescriptor;
import org.jetbrains.android.dom.AndroidAnyTagDescriptor;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.LayoutViewClassUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidXmlTagDescriptor
implements XmlElementDescriptor,
PsiPresentableMetaData {
    private final XmlElementDescriptor myParentDescriptor;
    private final PsiClass myDeclarationClass;
    private final Icon myIcon;
    private final String myBaseClassName;

    public AndroidXmlTagDescriptor(@Nullable PsiClass declarationClass, @NotNull XmlElementDescriptor parentDescriptor, @Nullable String baseClassName, @Nullable Icon icon) {
        this.myParentDescriptor = parentDescriptor;
        this.myDeclarationClass = declarationClass;
        this.myIcon = icon;
        this.myBaseClassName = baseClassName;
    }

    public String getQualifiedName() {
        return this.myParentDescriptor.getQualifiedName();
    }

    public String getDefaultName() {
        return this.myParentDescriptor.getDefaultName();
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        XmlElementDescriptor[] descriptors = this.myParentDescriptor.getElementsDescriptors(context);
        if (this.myBaseClassName == null || context == null) {
            return descriptors;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)context);
        if (facet == null) {
            return descriptors;
        }
        XmlElementDescriptor[] androidDescriptors = new XmlElementDescriptor[descriptors.length];
        DomElement domElement = DomManager.getDomManager((Project)context.getProject()).getDomElement(context);
        PsiClass baseClass = JavaPsiFacade.getInstance((Project)context.getProject()).findClass(this.myBaseClassName, facet.getModule().getModuleWithLibrariesScope());
        for (int i = 0; i < descriptors.length; ++i) {
            XmlElementDescriptor descriptor = descriptors[i];
            String tagName = descriptor.getName();
            PsiClass aClass = tagName != null && baseClass != null ? LayoutViewClassUtils.findClassByTagName(facet, tagName, baseClass) : null;
            Icon icon = AndroidDomElementDescriptorProvider.getIconForTag(tagName, domElement);
            androidDescriptors[i] = new AndroidXmlTagDescriptor(aClass, descriptor, this.myBaseClassName, icon);
        }
        return androidDescriptors;
    }

    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        XmlElementDescriptor descriptor = this.myParentDescriptor.getElementDescriptor(childTag, contextTag);
        if (descriptor != null) {
            return descriptor;
        }
        XmlNSDescriptor nsDescriptor = this.getNSDescriptor();
        return nsDescriptor != null ? new AndroidAnyTagDescriptor(nsDescriptor) : null;
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        XmlAttributeDescriptor[] descriptors = this.myParentDescriptor.getAttributesDescriptors(context);
        int layoutWidthIndex = -1;
        int layoutHeightIndex = -1;
        for (int i = 0; i < descriptors.length; ++i) {
            String name = descriptors[i].getName();
            if ("layout_width".equals(name)) {
                layoutWidthIndex = i;
                continue;
            }
            if (!"layout_height".equals(name)) continue;
            layoutHeightIndex = i;
        }
        if (layoutWidthIndex >= 0 && layoutHeightIndex >= 0 && layoutWidthIndex > layoutHeightIndex) {
            Object[] result = (XmlAttributeDescriptor[])descriptors.clone();
            ArrayUtil.swap((Object[])result, (int)layoutWidthIndex, (int)layoutHeightIndex);
            return result;
        }
        return descriptors;
    }

    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
        XmlAttributeDescriptor descriptor = this.myParentDescriptor.getAttributeDescriptor(attributeName, context);
        return descriptor != null ? descriptor : new AndroidAnyAttributeDescriptor(attributeName);
    }

    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        XmlAttributeDescriptor descriptor = this.myParentDescriptor.getAttributeDescriptor(attribute);
        return descriptor != null ? descriptor : new AndroidAnyAttributeDescriptor(attribute.getName());
    }

    public XmlNSDescriptor getNSDescriptor() {
        return this.myParentDescriptor.getNSDescriptor();
    }

    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        if (this.myDeclarationClass != null) {
            PsiClass viewGroup;
            GlobalSearchScope scope = this.myDeclarationClass.getResolveScope();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myDeclarationClass.getProject());
            PsiClass view = facade.findClass("android.view.View", scope);
            if (view != null && this.myDeclarationClass.isInheritor(view, true) && (viewGroup = facade.findClass("android.view.ViewGroup", scope)) != null) {
                return this.myDeclarationClass.isInheritor(viewGroup, true) ? 3 : 0;
            }
        }
        return this.myParentDescriptor.getContentType();
    }

    public String getDefaultValue() {
        return null;
    }

    public PsiElement getDeclaration() {
        return this.myDeclarationClass != null ? this.myDeclarationClass : this.myParentDescriptor.getDeclaration();
    }

    public String getName(PsiElement context) {
        return this.getDefaultName();
    }

    public String getName() {
        return this.myParentDescriptor.getName();
    }

    public void init(PsiElement element) {
        this.myParentDescriptor.init(element);
    }

    public Object[] getDependences() {
        return this.myParentDescriptor.getDependences();
    }

    public String getTypeName() {
        return null;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }
}

