/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.artifact;

import com.intellij.CommonBundle;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.exportSignedPackage.NewKeyForm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseKeyDialog
extends DialogWrapper {
    private JPanel myNewKeyPanel;
    private JBRadioButton myCreateNewKeyRadioButton;
    private JBRadioButton myUseExistingKeyRadioButton;
    private JComboBox myKeyCombo;
    private JPanel myPanel;
    private final NewKeyForm myNewKeyForm;
    private final Project myProject;
    private final String myKeyStorePath;
    private final char[] myKeyStorePassword;
    private final List<String> myExistingKeys;

    public ChooseKeyDialog(@NotNull Project project, @NotNull String keyStorePath, @NotNull char[] password, @NotNull List<String> existingKeys, @Nullable String keyToSelect) {
        super(project);
        this.$$$setupUI$$$();
        this.myNewKeyForm = new MyNewKeyForm();
        this.myProject = project;
        this.myKeyStorePath = keyStorePath;
        this.myKeyStorePassword = password;
        this.myExistingKeys = existingKeys;
        this.myKeyCombo.setModel(new CollectionComboBoxModel(existingKeys, (Object)existingKeys.get(0)));
        if (keyToSelect != null && existingKeys.contains(keyToSelect)) {
            this.myKeyCombo.setSelectedItem(keyToSelect);
        }
        this.myNewKeyPanel.add((Component)this.myNewKeyForm.getContentPanel(), "Center");
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIUtil.setEnabled((Component)ChooseKeyDialog.this.myNewKeyPanel, (boolean)ChooseKeyDialog.this.myCreateNewKeyRadioButton.isSelected(), (boolean)true);
            }
        };
        this.myCreateNewKeyRadioButton.addActionListener(listener);
        this.myUseExistingKeyRadioButton.addActionListener(listener);
        boolean useExisting = existingKeys.size() > 0;
        this.myUseExistingKeyRadioButton.setSelected(useExisting);
        this.myCreateNewKeyRadioButton.setSelected(!useExisting);
        UIUtil.setEnabled((Component)this.myNewKeyPanel, (!useExisting ? 1 : 0) != 0, (boolean)true);
        this.setTitle("Choose Key");
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void doOKAction() {
        if (this.myCreateNewKeyRadioButton.isSelected()) {
            try {
                this.myNewKeyForm.createKey();
            }
            catch (CommitStepException e) {
                Messages.showErrorDialog((Component)this.myPanel, (String)e.getMessage(), (String)CommonBundle.getErrorTitle());
                return;
            }
        }
        super.doOKAction();
    }

    @Nullable
    public String getChosenKey() {
        return this.myUseExistingKeyRadioButton.isSelected() ? (String)this.myKeyCombo.getSelectedItem() : this.myNewKeyForm.getKeyAlias();
    }

    @Nullable
    public char[] getChosenKeyPassword() {
        return this.myCreateNewKeyRadioButton.isSelected() ? this.myNewKeyForm.getKeyPassword() : null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JPanel jPanel;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myUseExistingKeyRadioButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setText("Use an existing key:");
        jBRadioButton2.setMnemonic('U');
        jBRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myCreateNewKeyRadioButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("Create a new key");
        jBRadioButton.setMnemonic('N');
        jBRadioButton.setDisplayedMnemonicIndex(9);
        jPanel2.add((Component)jBRadioButton, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myNewKeyPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 2));
        this.myKeyCombo = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class MyNewKeyForm
    extends NewKeyForm {
        private MyNewKeyForm() {
        }

        @Override
        protected List<String> getExistingKeyAliasList() {
            return ChooseKeyDialog.this.myExistingKeys;
        }

        @Override
        @NotNull
        protected Project getProject() {
            return ChooseKeyDialog.this.myProject;
        }

        @Override
        @NotNull
        protected char[] getKeyStorePassword() {
            return ChooseKeyDialog.this.myKeyStorePassword;
        }

        @Override
        @NotNull
        protected String getKeyStoreLocation() {
            return ChooseKeyDialog.this.myKeyStorePath;
        }
    }
}

