/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.artifact;

import com.intellij.compiler.ant.Generator;
import com.intellij.facet.Facet;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.FacetBasedPackagingElement;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import com.intellij.packaging.impl.ui.DelegatedPackagingElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.packaging.ui.TreeNodePresentation;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.compiler.artifact.AndroidFinalPackageElementType;
import org.jetbrains.android.compiler.artifact.AndroidFinalPackagePresentation;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFinalPackageElement
extends PackagingElement<AndroidFinalPackageElementState>
implements FacetBasedPackagingElement,
ModuleOutputPackagingElement {
    @NonNls
    static final String FACET_ATTRIBUTE = "facet";
    private FacetPointer<AndroidFacet> myFacetPointer;
    private final Project myProject;

    public AndroidFinalPackageElement(@NotNull Project project, @Nullable AndroidFacet facet) {
        super((PackagingElementType)AndroidFinalPackageElementType.getInstance());
        this.myProject = project;
        this.myFacetPointer = facet != null ? FacetPointersManager.getInstance((Project)this.myProject).create((Facet)facet) : null;
    }

    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        return new DelegatedPackagingElementPresentation((TreeNodePresentation)new AndroidFinalPackagePresentation(this.myFacetPointer));
    }

    @Nullable
    private String getApkPath() {
        if (this.myFacetPointer == null) {
            return null;
        }
        AndroidFacet facet = (AndroidFacet)this.myFacetPointer.getFacet();
        if (facet == null) {
            return null;
        }
        String apkPath = AndroidRootUtil.getApkPath(facet);
        String path = apkPath != null ? AndroidCommonUtils.addSuffixToFileName((String)apkPath, (String)".afp") : null;
        return path != null ? FileUtil.toSystemIndependentName((String)path) + "!/" : null;
    }

    public List<? extends Generator> computeAntInstructions(@NotNull PackagingElementResolvingContext resolvingContext, @NotNull AntCopyInstructionCreator creator, @NotNull ArtifactAntGenerationContext generationContext, @NotNull ArtifactType artifactType) {
        String apkPath = this.getApkPath();
        if (apkPath != null) {
            return Collections.singletonList(creator.createExtractedDirectoryInstruction(apkPath));
        }
        return Collections.emptyList();
    }

    @Nullable
    public AndroidFacet getFacet() {
        return this.myFacetPointer != null ? (AndroidFacet)this.myFacetPointer.getFacet() : null;
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (!(element instanceof AndroidFinalPackageElement)) {
            return false;
        }
        AndroidFinalPackageElement packageElement = (AndroidFinalPackageElement)element;
        return this.myFacetPointer == null ? packageElement.myFacetPointer == null : this.myFacetPointer.equals(packageElement.myFacetPointer);
    }

    public AndroidFinalPackageElementState getState() {
        AndroidFinalPackageElementState state = new AndroidFinalPackageElementState();
        state.myFacetPointer = this.myFacetPointer != null ? this.myFacetPointer.getId() : null;
        return state;
    }

    public AndroidFacet findFacet(@NotNull PackagingElementResolvingContext context) {
        return this.myFacetPointer != null ? (AndroidFacet)this.myFacetPointer.findFacet(context.getModulesProvider(), context.getFacetsProvider()) : null;
    }

    public void loadState(AndroidFinalPackageElementState state) {
        this.myFacetPointer = state.myFacetPointer != null ? FacetPointersManager.getInstance((Project)this.myProject).create(state.myFacetPointer) : null;
    }

    public String getModuleName() {
        return this.myFacetPointer != null ? this.myFacetPointer.getModuleName() : null;
    }

    public Module findModule(PackagingElementResolvingContext context) {
        AndroidFacet facet = this.findFacet(context);
        return facet != null ? facet.getModule() : null;
    }

    @NotNull
    public Collection<VirtualFile> getSourceRoots(PackagingElementResolvingContext context) {
        return Collections.emptyList();
    }

    public static class AndroidFinalPackageElementState {
        @Attribute(value="facet")
        public String myFacetPointer;
    }
}

