/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.artifact;

import com.intellij.CommonBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactType;
import org.jetbrains.android.compiler.artifact.AndroidFinalPackageElement;
import org.jetbrains.android.compiler.artifact.AndroidFinalPackageElementType;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidArtifactUtil {
    private AndroidArtifactUtil() {
    }

    public static boolean containsAndroidPackage(ArtifactEditorContext editorContext, Artifact artifact) {
        return !ArtifactUtil.processPackagingElements((Artifact)artifact, (PackagingElementType)AndroidFinalPackageElementType.getInstance(), (Processor)new Processor<AndroidFinalPackageElement>(){

            public boolean process(AndroidFinalPackageElement e) {
                return false;
            }
        }, (PackagingElementResolvingContext)editorContext, (boolean)true);
    }

    public static boolean isRelatedArtifact(@NotNull Artifact artifact, @NotNull Module module) {
        if (!(artifact.getArtifactType() instanceof AndroidApplicationArtifactType)) {
            return false;
        }
        AndroidFacet facet = AndroidArtifactUtil.getPackagedFacet(module.getProject(), artifact);
        return facet != null && module.equals(facet.getModule());
    }

    @Nullable
    public static AndroidFacet getPackagedFacet(Project project, Artifact artifact) {
        final Ref elementRef = Ref.create(null);
        PackagingElementResolvingContext resolvingContext = ArtifactManager.getInstance((Project)project).getResolvingContext();
        ArtifactUtil.processPackagingElements((Artifact)artifact, (PackagingElementType)AndroidFinalPackageElementType.getInstance(), (Processor)new Processor<AndroidFinalPackageElement>(){

            public boolean process(AndroidFinalPackageElement e) {
                elementRef.set((Object)e);
                return false;
            }
        }, (PackagingElementResolvingContext)resolvingContext, (boolean)true);
        AndroidFinalPackageElement element = (AndroidFinalPackageElement)((Object)elementRef.get());
        return element != null ? element.getFacet() : null;
    }

    @Nullable
    public static AndroidFacet chooseAndroidApplicationModule(@NotNull Project project, @NotNull List<AndroidFacet> facets) {
        HashMap map = new HashMap();
        for (AndroidFacet facet : facets) {
            map.put(facet.getModule(), facet);
        }
        String message = "Selected Android application module will be included in the created artifact with all dependencies";
        ChooseModulesDialog dialog = new ChooseModulesDialog(project, new ArrayList(map.keySet()), "Select Module", message);
        dialog.setSingleSelectionMode();
        dialog.show();
        List selected = dialog.getChosenElements();
        if (selected.isEmpty()) {
            return null;
        }
        assert (selected.size() == 1);
        Module module = (Module)selected.get(0);
        String moduleName = module.getName();
        AndroidFacet facet = (AndroidFacet)((Object)map.get(module));
        if (facet == null) {
            message = "Cannot find Android facet for module " + moduleName;
            Messages.showErrorDialog((Project)project, (String)message, (String)CommonBundle.getErrorTitle());
            return null;
        }
        return facet;
    }
}

