/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.XmlSchemaProvider;
import gnu.trove.THashMap;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.ManifestDomFileDescription;
import org.jetbrains.android.dom.raw.RawDomFileDescription;
import org.jetbrains.android.dom.xml.XmlResourceDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidXmlSchemaProvider
extends XmlSchemaProvider {
    private static final Key<Map<String, CachedValue<XmlFile>>> DESCRIPTORS_MAP_IN_MODULE = Key.create((String)"ANDROID_DESCRIPTORS_MAP_IN_MODULE");

    public XmlFile getSchema(@NotNull @NonNls String url, final @Nullable Module module, @NotNull PsiFile baseFile) {
        CachedValue reference;
        if (module == null || AndroidFacet.getInstance(module) == null) {
            return null;
        }
        Map descriptors = (Map)module.getUserData(DESCRIPTORS_MAP_IN_MODULE);
        if (descriptors == null) {
            descriptors = new THashMap();
            module.putUserData(DESCRIPTORS_MAP_IN_MODULE, (Object)descriptors);
        }
        if ((reference = (CachedValue)descriptors.get(url)) != null) {
            return (XmlFile)reference.getValue();
        }
        CachedValuesManager manager = CachedValuesManager.getManager((Project)module.getProject());
        reference = manager.createCachedValue((CachedValueProvider)new CachedValueProvider<XmlFile>(){

            public CachedValueProvider.Result<XmlFile> compute() {
                URL resource = AndroidXmlSchemaProvider.class.getResource("android.xsd");
                VirtualFile fileByURL = VfsUtil.findFileByURL((URL)resource);
                XmlFile result = (XmlFile)PsiManager.getInstance((Project)module.getProject()).findFile(fileByURL).copy();
                return new CachedValueProvider.Result((Object)result, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        }, false);
        descriptors.put(url, reference);
        return (XmlFile)reference.getValue();
    }

    public boolean isAvailable(@NotNull XmlFile file) {
        PsiFile f = file.getOriginalFile();
        if (!(f instanceof XmlFile)) {
            return false;
        }
        final XmlFile originalFile = (XmlFile)f;
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                if (AndroidXmlSchemaProvider.isXmlResourceFile(originalFile) || ManifestDomFileDescription.isManifestFile(originalFile) || RawDomFileDescription.isRawFile(originalFile)) {
                    return AndroidFacet.getInstance((PsiElement)originalFile) != null;
                }
                return false;
            }
        });
    }

    private static boolean isXmlResourceFile(XmlFile file) {
        if (!AndroidResourceUtil.isInResourceSubdirectory((PsiFile)file, null)) {
            return false;
        }
        PsiDirectory parent = file.getParent();
        if (parent == null) {
            return false;
        }
        ResourceFolderType resType = ResourceFolderType.getFolderType((String)parent.getName());
        if (resType == null) {
            return false;
        }
        if (resType == ResourceFolderType.XML) {
            return XmlResourceDomFileDescription.isXmlResourceFile(file);
        }
        return resType != ResourceFolderType.RAW;
    }

    @NotNull
    public Set<String> getAvailableNamespaces(@NotNull XmlFile file, @Nullable String tagName) {
        HashSet<String> result = new HashSet<String>();
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet != null) {
            result.add("http://schemas.android.com/tools");
            ResourceFolderType type = ResourceHelper.getFolderType(file.getOriginalFile());
            if (type == ResourceFolderType.VALUES) {
                result.add("urn:oasis:names:tc:xliff:document:1.2");
            } else if (type != ResourceFolderType.MIPMAP && type != ResourceFolderType.RAW) {
                result.add("http://schemas.android.com/apk/res/android");
                String localNs = AndroidXmlSchemaProvider.getLocalXmlNamespace(facet);
                if (localNs != null) {
                    result.add(localNs);
                }
                if (type == ResourceFolderType.XML) {
                    result.add("urn:oasis:names:tc:xliff:document:1.2");
                }
            }
        }
        return result;
    }

    public String getDefaultPrefix(@NotNull @NonNls String namespace, @NotNull XmlFile context) {
        if ("http://schemas.android.com/apk/res/android".equals(namespace)) {
            return "android";
        }
        if (namespace.equals("http://schemas.android.com/tools")) {
            return "tools";
        }
        if (namespace.equals("http://schemas.android.com/apk/res-auto") || namespace.startsWith("http://schemas.android.com/apk/res/")) {
            return "app";
        }
        if (namespace.equals("xliff")) {
            return "xliff";
        }
        return null;
    }

    @Nullable
    public static String getLocalXmlNamespace(@NotNull AndroidFacet facet) {
        String aPackage;
        if (facet.isLibraryProject() || facet.requiresAndroidModel()) {
            return "http://schemas.android.com/apk/res-auto";
        }
        final Manifest manifest = facet.getManifest();
        if (manifest != null && (aPackage = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            @Nullable
            public String compute() {
                return (String)manifest.getPackage().getValue();
            }
        })) != null && aPackage.length() != 0) {
            return "http://schemas.android.com/apk/res/" + aPackage;
        }
        return null;
    }
}

