/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.swing.layoutlib;

import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.layoutlib.UnsupportedJavaRuntimeException;
import com.android.tools.idea.rendering.DomPullParser;
import com.android.tools.swing.layoutlib.AlreadyDisposedException;
import com.android.tools.swing.layoutlib.GraphicsLayoutRenderer;
import com.android.tools.swing.layoutlib.InitializationException;
import com.android.tools.swing.layoutlib.UnsupportedLayoutlibException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import javax.swing.SwingWorker;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

public class AndroidPreviewPanel
extends JComponent
implements Scrollable {
    private static final Logger LOG = Logger.getInstance(AndroidPreviewPanel.class);
    public static final int VERTICAL_SCROLLING_UNIT_INCREMENT = 5;
    public static final int VERTICAL_SCROLLING_BLOCK_INCREMENT = 10;
    private final AtomicBoolean myRunningInvalidates = new AtomicBoolean(false);
    private final AtomicBoolean myPendingInvalidates = new AtomicBoolean(false);
    private final Runnable myInvalidateRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object = AndroidPreviewPanel.this.myGraphicsLayoutRendererLock;
                synchronized (object) {
                    if (AndroidPreviewPanel.this.myGraphicsLayoutRenderer != null) {
                        AndroidPreviewPanel.this.myGraphicsLayoutRenderer.dispose();
                        AndroidPreviewPanel.this.myGraphicsLayoutRenderer = null;
                    }
                }
                DomPullParser parser = new DomPullParser(AndroidPreviewPanel.this.myDocument.getDocumentElement());
                GraphicsLayoutRenderer graphicsLayoutRenderer = GraphicsLayoutRenderer.create(AndroidPreviewPanel.this.myConfiguration, (ILayoutPullParser)parser, AndroidPreviewPanel.this.getBackground(), false, true);
                graphicsLayoutRenderer.setScale(AndroidPreviewPanel.this.myScale);
                graphicsLayoutRenderer.setSize(AndroidPreviewPanel.this.getWidth(), 1);
                Object object2 = AndroidPreviewPanel.this.myGraphicsLayoutRendererLock;
                synchronized (object2) {
                    AndroidPreviewPanel.this.myGraphicsLayoutRenderer = graphicsLayoutRenderer;
                }
            }
            catch (AlreadyDisposedException parser) {
            }
            catch (UnsupportedLayoutlibException e) {
                AndroidPreviewPanel.notifyUnsupportedLayoutlib();
            }
            catch (InitializationException e) {
                Throwable cause = e.getCause();
                if (cause instanceof UnsupportedJavaRuntimeException) {
                    AndroidPreviewPanel.notifyUnsupportedJavaRuntime(((UnsupportedJavaRuntimeException)cause).getPresentableMessage());
                }
                LOG.error((Throwable)e);
            }
        }
    };
    private static final Notification UNSUPPORTED_LAYOUTLIB_NOTIFICATION = new Notification("Android", "Preview", "The Theme Editor preview requires at least Android M Platform SDK", NotificationType.ERROR);
    private static final AtomicBoolean ourLayoutlibNotification = new AtomicBoolean(false);
    private static final AtomicBoolean ourJavaRuntimeNotification = new AtomicBoolean(false);
    private final DumbService myDumbService;
    private final Object myGraphicsLayoutRendererLock = new Object();
    private GraphicsLayoutRenderer myGraphicsLayoutRenderer;
    private Configuration myConfiguration;
    private Document myDocument;
    private double myScale = 1.0;
    private Dimension myLastRenderedSize;
    private Dimension myCachedPreferredSize;
    private int myCurrentWidth;

    public AndroidPreviewPanel(@NotNull Configuration configuration) {
        this.myConfiguration = configuration;
        this.myDumbService = DumbService.getInstance((Project)this.myConfiguration.getModule().getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBounds(int x, int y, int width, int height) {
        Dimension previousSize = this.getSize();
        super.setBounds(x, y, width, height);
        Dimension currentSize = this.getSize();
        Object object = this.myGraphicsLayoutRendererLock;
        synchronized (object) {
            if (this.myGraphicsLayoutRenderer != null && !currentSize.equals(previousSize)) {
                this.myGraphicsLayoutRenderer.setSize(width, this.myCurrentWidth < width ? 1 : height);
                this.myCurrentWidth = width;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScale(double scale) {
        this.myScale = scale;
        Object object = this.myGraphicsLayoutRendererLock;
        synchronized (object) {
            if (this.myGraphicsLayoutRenderer != null) {
                this.myGraphicsLayoutRenderer.setScale(scale);
            }
        }
    }

    public void invalidateGraphicsRenderer() {
        if (this.myDocument != null) {
            this.myPendingInvalidates.set(true);
            if (!this.myRunningInvalidates.get()) {
                new InvalidateTask().execute();
            }
        }
    }

    public void updateConfiguration(@NotNull Configuration configuration) {
        this.myConfiguration = configuration;
        this.invalidateGraphicsRenderer();
    }

    public void setDocument(@NotNull Document document) {
        this.myDocument = document;
        this.invalidateGraphicsRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics graphics) {
        Object object = this.myGraphicsLayoutRendererLock;
        synchronized (object) {
            if (this.myGraphicsLayoutRenderer != null) {
                this.myGraphicsLayoutRenderer.render((Graphics2D)graphics);
                Dimension renderSize = this.myGraphicsLayoutRenderer.getPreferredSize();
                if (!renderSize.equals(this.myLastRenderedSize)) {
                    this.myLastRenderedSize = renderSize;
                    this.revalidate();
                }
            }
        }
    }

    private static void notifyUnsupportedLayoutlib() {
        if (ourLayoutlibNotification.compareAndSet(false, true)) {
            Notifications.Bus.notify((Notification)UNSUPPORTED_LAYOUTLIB_NOTIFICATION);
        }
    }

    private static void notifyUnsupportedJavaRuntime(String message) {
        if (ourJavaRuntimeNotification.compareAndSet(false, true)) {
            Notifications.Bus.notify((Notification)new Notification("Android", "Preview", message, NotificationType.ERROR));
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize() {
        Object object = this.myGraphicsLayoutRendererLock;
        synchronized (object) {
            if (this.isPreferredSizeSet() || this.myGraphicsLayoutRenderer == null) {
                return this.myCachedPreferredSize == null ? super.getPreferredSize() : this.myCachedPreferredSize;
            }
            this.myCachedPreferredSize = this.myGraphicsLayoutRenderer.getPreferredSize();
            return this.myCachedPreferredSize;
        }
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 5;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getUsedAttrs() {
        Object object = this.myGraphicsLayoutRendererLock;
        synchronized (object) {
            if (this.myGraphicsLayoutRenderer == null) {
                return Collections.emptySet();
            }
            return this.myGraphicsLayoutRenderer.getUsedAttrs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewInfo findViewAtPoint(Point p) {
        Object object = this.myGraphicsLayoutRendererLock;
        synchronized (object) {
            return this.myGraphicsLayoutRenderer != null ? this.myGraphicsLayoutRenderer.findViewAtPoint(p) : null;
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.invalidateGraphicsRenderer();
    }

    private class InvalidateTask
    extends SwingWorker<Void, Void> {
        private InvalidateTask() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            do {
                AndroidPreviewPanel.this.myRunningInvalidates.set(true);
                AndroidPreviewPanel.this.myPendingInvalidates.set(false);
                AndroidPreviewPanel.this.myDumbService.runWhenSmart(AndroidPreviewPanel.this.myInvalidateRunnable);
                AndroidPreviewPanel.this.myRunningInvalidates.set(false);
            } while (AndroidPreviewPanel.this.myPendingInvalidates.get());
            return null;
        }

        @Override
        protected void done() {
            try {
                this.get();
            }
            catch (ExecutionException ex) {
                Throwable t = ex.getCause();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new RuntimeException(t);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            AndroidPreviewPanel.this.repaint();
        }
    }
}

