/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.model;

import com.android.tools.idea.ui.properties.BindingsManager;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.properties.core.ObservableOptional;
import com.android.tools.idea.ui.properties.core.ObservableString;
import com.android.tools.idea.ui.properties.core.OptionalProperty;
import com.android.tools.idea.ui.properties.core.OptionalValueProperty;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.core.StringValueProperty;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.containers.Stack;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModelWizard
implements Disposable {
    private final List<ModelWizardStep> mySteps;
    private final Map<ModelWizardStep, ModelWizardStep> myStepOwners = Maps.newHashMap();
    private final BindingsManager myBindings = new BindingsManager();
    private final BoolProperty myCanGoBack = new BoolValueProperty();
    private final BoolProperty myCanGoForward = new BoolValueProperty();
    private final BoolProperty myOnLastStep = new BoolValueProperty();
    private final OptionalProperty<Action> myExtraAction = new OptionalValueProperty<Action>();
    private final Stack<ModelWizardStep> myPrevSteps = new Stack();
    private final StringProperty myTitle = new StringValueProperty();
    private final JPanel myContentPanel = new JPanel(new CardLayout());
    private final List<ResultListener> myResultListeners = Lists.newArrayListWithExpectedSize((int)1);
    private int myCurrIndex = -1;

    private ModelWizard(@NotNull Collection<ModelWizardStep> steps) {
        boolean bl;
        this.mySteps = Lists.newArrayListWithExpectedSize((int)steps.size());
        for (ModelWizardStep modelWizardStep : steps) {
            this.addStep(modelWizardStep);
        }
        if (this.mySteps.isEmpty()) {
            throw new IllegalStateException("Can't create a wizard with no steps");
        }
        this.myCanGoForward.addListener(sender -> {
            if (((Boolean)this.myCanGoForward.get()).booleanValue()) {
                this.myOnLastStep.set(this.isOnLastVisibleStep());
            }
        });
        HashSet seenModels = Sets.newHashSet();
        for (ModelWizardStep modelWizardStep : this.mySteps) {
            Disposer.register((Disposable)this, (Disposable)modelWizardStep);
            Object model = modelWizardStep.getModel();
            if (seenModels.contains(model)) continue;
            Disposer.register((Disposable)this, model);
            seenModels.add(model);
        }
        Facade facade = new Facade();
        for (ModelWizardStep step : this.mySteps) {
            step.onWizardStarting(facade);
        }
        boolean bl2 = false;
        for (ModelWizardStep step : this.mySteps) {
            if (!this.shouldShowStep(step)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            Disposer.dispose((Disposable)this);
            throw new IllegalStateException("Trying to create a wizard but no steps are visible");
        }
        this.goForward();
    }

    @NotNull
    public ObservableBool canGoBack() {
        return this.myCanGoBack;
    }

    @NotNull
    public ObservableBool canGoForward() {
        return this.myCanGoForward;
    }

    @NotNull
    public ObservableBool onLastStep() {
        return this.myOnLastStep;
    }

    @NotNull
    public ObservableString title() {
        return this.myTitle;
    }

    @Nullable
    public JComponent getPreferredFocusComponent() {
        if (this.isFinished()) {
            return null;
        }
        ModelWizardStep step = this.mySteps.get(this.myCurrIndex);
        return step.getPreferredFocusComponent();
    }

    private void addStep(@NotNull ModelWizardStep<?> step) {
        this.myContentPanel.add((Component)step.getComponent(), Integer.toString(this.mySteps.size()));
        this.mySteps.add(step);
        for (ModelWizardStep subStep : step.createDependentSteps()) {
            this.myStepOwners.put(subStep, step);
            this.addStep(subStep);
        }
    }

    @NotNull
    ModelWizardStep getCurrentStep() {
        return this.mySteps.get(this.myCurrIndex);
    }

    @NotNull
    ObservableOptional<Action> getExtraAction() {
        return this.myExtraAction;
    }

    @NotNull
    public JPanel getContentPanel() {
        return this.myContentPanel;
    }

    public void goForward() {
        block3: {
            ModelWizardStep step;
            this.ensureWizardIsRunning();
            if (this.myCurrIndex >= 0) {
                ModelWizardStep currStep = this.mySteps.get(this.myCurrIndex);
                if (!((Boolean)currStep.canGoForward().get()).booleanValue()) {
                    throw new IllegalStateException("Can't call goForward on wizard when the step prevents it");
                }
                this.myPrevSteps.add((Object)currStep);
                currStep.onProceeding();
            }
            do {
                ++this.myCurrIndex;
                if (this.myCurrIndex < this.mySteps.size()) continue;
                this.handleFinished(true);
                break block3;
            } while (!this.shouldShowStep(step = this.mySteps.get(this.myCurrIndex)));
            this.updateNavigationProperties();
            step.onEntering();
            this.showCurrentStep();
        }
    }

    public void goBack() {
        this.ensureWizardIsRunning();
        if (this.myPrevSteps.empty()) {
            throw new IllegalStateException("Calling back on wizard without any previous pages");
        }
        ModelWizardStep currStep = this.mySteps.get(this.myCurrIndex);
        if (!currStep.canGoBack()) {
            throw new IllegalStateException("Can't call goBack on wizard when the step prevents it");
        }
        this.myCurrIndex = this.mySteps.indexOf(this.myPrevSteps.pop());
        this.updateNavigationProperties();
        this.showCurrentStep();
    }

    public void cancel() {
        this.ensureWizardIsRunning();
        this.handleFinished(false);
    }

    public void addResultListener(@NotNull ResultListener listener) {
        this.myResultListeners.add(listener);
    }

    public void removeResultListener(@NotNull ResultListener listener) {
        this.myResultListeners.remove(listener);
    }

    public boolean isFinished() {
        return this.myCurrIndex >= this.mySteps.size();
    }

    private void ensureWizardIsRunning() {
        if (this.isFinished()) {
            throw new IllegalStateException("Invalid operation attempted after wizard already finished");
        }
    }

    private void handleFinished(boolean success) {
        if (success) {
            HashSet seenModels = Sets.newHashSet();
            for (ModelWizardStep step : this.myPrevSteps) {
                Object model = step.getModel();
                if (seenModels.contains(model)) continue;
                seenModels.add(model);
                ((WizardModel)model).handleFinished();
            }
        }
        this.myCurrIndex = this.mySteps.size();
        this.myPrevSteps.clear();
        this.myCanGoBack.set(false);
        this.myCanGoForward.set(false);
        this.myOnLastStep.set(false);
        ArrayList listenersCopy = Lists.newArrayList(this.myResultListeners);
        for (ResultListener listener : listenersCopy) {
            listener.onWizardFinished(success);
        }
    }

    private void showCurrentStep() {
        ModelWizardStep step = this.mySteps.get(this.myCurrIndex);
        this.myTitle.set(step.getTitle());
        this.myExtraAction.setNullableValue(step.getExtraAction());
        ((CardLayout)this.myContentPanel.getLayout()).show(this.myContentPanel, Integer.toString(this.myCurrIndex));
        JComponent focusedComponent = step.getPreferredFocusComponent();
        if (focusedComponent != null) {
            IdeFocusManager.findInstanceByComponent((Component)focusedComponent).requestFocus((Component)focusedComponent, false);
        }
    }

    private void updateNavigationProperties() {
        this.myOnLastStep.set(this.isOnLastVisibleStep());
        ModelWizardStep step = this.mySteps.get(this.myCurrIndex);
        this.myBindings.bind(this.myCanGoForward, step.canGoForward());
        this.myCanGoBack.set(!this.myPrevSteps.empty() && step.canGoBack());
    }

    private boolean shouldShowStep(ModelWizardStep step) {
        ModelWizardStep currStep = step;
        do {
            if (currStep.shouldShow()) continue;
            return false;
        } while ((currStep = this.myStepOwners.get(currStep)) != null);
        return true;
    }

    private boolean isOnLastVisibleStep() {
        float size = this.mySteps.size();
        boolean currPageIsLast = true;
        int i = this.myCurrIndex + 1;
        while ((float)i < size) {
            ModelWizardStep step = this.mySteps.get(i);
            if (this.shouldShowStep(step)) {
                currPageIsLast = false;
                break;
            }
            ++i;
        }
        return currPageIsLast;
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myResultListeners.clear();
    }

    public final class Facade {
        public void updateNavigationProperties() {
            if (ModelWizard.this.myCurrIndex < 0) {
                return;
            }
            ModelWizard.this.updateNavigationProperties();
        }

        public boolean goForward() {
            if (ModelWizard.this.myCurrIndex < 0) {
                throw new IllegalStateException("Attempting to goForward before the wizard has even started");
            }
            if (((Boolean)ModelWizard.this.canGoForward().get()).booleanValue()) {
                ModelWizard.this.goForward();
                return true;
            }
            return false;
        }

        public void cancel() {
            if (ModelWizard.this.myCurrIndex < 0) {
                throw new IllegalStateException("Attempting to cancel before the wizard has even started");
            }
            ModelWizard.this.cancel();
        }
    }

    public static final class Builder {
        private final List<ModelWizardStep> mySteps;

        public Builder(ModelWizardStep ... steps) {
            this.mySteps = Lists.newArrayList((Object[])steps);
        }

        public Builder addStep(@NotNull ModelWizardStep step) {
            this.mySteps.add(step);
            return this;
        }

        public ModelWizard build() {
            return new ModelWizard(this.mySteps);
        }
    }

    public static interface ResultListener {
        public void onWizardFinished(boolean var1);
    }
}

