/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.dynamic;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopedStateStore
implements Function<Key<?>, Object> {
    private Map<Key, Object> myState = Maps.newHashMap();
    private Set<Key> myRecentlyUpdated = Sets.newHashSet();
    private Scope myScope;
    private final Collection<WeakReference<ScopedStoreListener>> myListeners = Lists.newArrayListWithCapacity((int)4);
    @Nullable
    private ScopedStateStore myParent;
    private final ScopedStoreListener myParentListener = new ScopedStoreListener(){

        @Override
        public <T> void invokeUpdate(@Nullable Key<T> changedKey) {
            ScopedStateStore.this.notifyListeners(changedKey);
        }
    };

    public ScopedStateStore(@NotNull Scope scope, @Nullable ScopedStateStore parent, @Nullable ScopedStoreListener listener) {
        this.myScope = scope;
        if (this.myParent != null && this.myScope.isGreaterThan(this.myParent.myScope)) {
            throw new IllegalArgumentException("Attempted to add store of scope " + this.myScope.toString() + " as child of lesser scope " + this.myParent.myScope.toString());
        }
        this.myParent = parent;
        if (listener != null) {
            this.addListener(listener);
        }
        if (this.myParent != null) {
            this.myParent.addListener(this.myParentListener);
        }
    }

    public final void addListener(@NotNull ScopedStoreListener listener) {
        this.myListeners.add(new WeakReference<ScopedStoreListener>(listener));
    }

    @Nullable
    public <T> T get(@NotNull Key<T> key) {
        if (this.myScope.equals((Object)key.scope) && this.myState.containsKey(key)) {
            try {
                return key.expectedClass.cast(this.myState.get(key));
            }
            catch (ClassCastException e) {
                return null;
            }
        }
        if (this.myParent != null) {
            return this.myParent.get(key);
        }
        return null;
    }

    @NotNull
    public <T> T getNotNull(@NotNull Key<T> key, @NotNull T defaultValue) {
        T value = this.get(key);
        return value == null ? defaultValue : value;
    }

    public <T> boolean put(@NotNull Key<T> key, @Nullable T value) {
        boolean stateChanged;
        if (this.myScope.isGreaterThan(key.scope)) {
            throw new IllegalArgumentException("Attempted to store a value of scope " + key.scope.name() + " in greater scope of " + this.myScope.name());
        }
        if (this.myScope.equals((Object)key.scope)) {
            stateChanged = !this.myState.containsKey(key) || !ScopedStateStore.equals(this.myState.get(key), value);
            this.myState.put(key, value);
            if (stateChanged) {
                this.notifyListeners(key);
            }
        } else if (key.scope.isGreaterThan(this.myScope) && this.myParent != null) {
            stateChanged = this.myParent.put(key, value);
        } else {
            throw new IllegalArgumentException("Attempted to store a value of scope " + key.scope.toString() + " in lesser scope of " + this.myScope.toString() + " which does not have a parent of the proper scope");
        }
        return stateChanged;
    }

    private <T> void notifyListeners(@Nullable Key<T> key) {
        this.myRecentlyUpdated.add(key);
        Iterator<WeakReference<ScopedStoreListener>> iterator = this.myListeners.iterator();
        while (iterator.hasNext()) {
            ScopedStoreListener listener = (ScopedStoreListener)iterator.next().get();
            if (listener == null) {
                iterator.remove();
                continue;
            }
            listener.invokeUpdate(key);
        }
    }

    public <T> boolean listPush(@NotNull Key<List<T>> key, @NotNull T value) {
        List<Object> list = null;
        if (this.containsKey(key)) {
            list = this.get(key);
        }
        if (list == null) {
            list = Lists.newArrayList();
        }
        boolean stateChanged = list.add(value);
        this.put(key, list);
        if (stateChanged) {
            this.notifyListeners(key);
        }
        return stateChanged;
    }

    public <T extends List> int listSize(@NotNull Key<T> key) {
        List list;
        if (this.containsKey(key) && (list = (List)this.get(key)) != null) {
            return list.size();
        }
        return 0;
    }

    public <T extends List<? super V>, V> boolean listRemove(@NotNull Key<T> key, @NotNull V value) {
        List list;
        boolean stateChanged = false;
        if (this.containsKey(key) && (list = (List)this.get(key)) != null) {
            stateChanged = list.remove(value);
        }
        if (stateChanged) {
            this.notifyListeners(key);
        }
        return stateChanged;
    }

    public <T> void unsafePut(Key<T> key, @Nullable Object object) {
        this.put(key, key.expectedClass.cast(object));
    }

    private static boolean equals(@Nullable Object o, @Nullable Object o2) {
        if (o == null && o2 == null) {
            return true;
        }
        if (o != null) {
            return o.equals(o2);
        }
        return false;
    }

    public <T> void putAll(@NotNull Map<Key<T>, T> map) {
        for (Key<T> key : map.keySet()) {
            this.put(key, map.get(key));
        }
    }

    public void putAllInWizardScope(@NotNull ScopedStateStore store) {
        for (Key key : store.getAllKeys()) {
            this.copyValue(store, key);
        }
    }

    private <T> void copyValue(@NotNull ScopedStateStore store, @NotNull Key<T> key) {
        Key newKey = new Key(key.name, Scope.WIZARD, key.expectedClass);
        this.put(newKey, store.get(key));
    }

    public <T> boolean remove(@NotNull Key<T> key) {
        boolean stateChanged;
        if (this.myScope.isGreaterThan(key.scope)) {
            throw new IllegalArgumentException("Attempted to remove a value of scope " + (Object)((Object)key.scope) + " from greater scope of " + this.myScope.name());
        }
        if (this.myScope.equals((Object)key.scope)) {
            stateChanged = this.myState.containsKey(key);
            this.myState.remove(key);
        } else if (key.scope.isGreaterThan(this.myScope) && this.myParent != null) {
            stateChanged = this.myParent.remove(key);
        } else {
            throw new IllegalArgumentException("Attempted to remove a value of scope " + (Object)((Object)key.scope) + " from lesser scope of " + this.myScope.toString() + " which does not have a parent of the proper scope");
        }
        if (stateChanged) {
            this.notifyListeners(key);
        }
        return stateChanged;
    }

    public <T> boolean containsKey(@NotNull Key<T> key) {
        if (this.myScope.equals((Object)key.scope)) {
            return this.myState.containsKey(key);
        }
        if (this.myParent != null && key.scope.isGreaterThan(this.myScope)) {
            return this.myParent.containsKey(key);
        }
        return false;
    }

    public Map<String, Object> flatten() {
        HashMap toReturn = this.myParent != null ? this.myParent.flatten() : Maps.newHashMapWithExpectedSize((int)this.myState.size());
        for (Key key : this.myState.keySet()) {
            toReturn.put(key.name, this.myState.get(key));
        }
        return toReturn;
    }

    public Set<Key> getRecentUpdates() {
        return this.myRecentlyUpdated;
    }

    public void clearRecentUpdates() {
        this.myRecentlyUpdated.clear();
    }

    public static <T> Key<T> createKey(@NotNull String name, @NotNull Scope scope, @NotNull Class<T> clazz) {
        return new Key(name, scope, clazz);
    }

    public <T> Key<T> createKey(@NotNull String name, @NotNull Class<T> clazz) {
        return ScopedStateStore.createKey(name, this.myScope, clazz);
    }

    public Object apply(Key<?> input) {
        return this.get(input);
    }

    public Set<Key> getAllKeys() {
        if (this.myParent == null) {
            return ImmutableSet.copyOf(this.myState.keySet());
        }
        return ImmutableSet.copyOf((Iterable)Iterables.concat(this.myState.keySet(), this.myParent.getAllKeys()));
    }

    public static enum Scope {
        STEP,
        PATH,
        WIZARD;


        public boolean isGreaterThan(@Nullable Scope other) {
            if (other == null) {
                return false;
            }
            return this.ordinal() > other.ordinal();
        }
    }

    public static class Key<T> {
        @NotNull
        public final Class<T> expectedClass;
        @NotNull
        public final String name;
        @NotNull
        public final Scope scope;

        private Key(@NotNull String name, @NotNull Scope scope, @NotNull Class<T> clazz) {
            this.expectedClass = clazz;
            this.name = name;
            this.scope = scope;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.expectedClass.equals(key.expectedClass)) {
                return false;
            }
            if (!this.name.equals(key.name)) {
                return false;
            }
            return this.scope == key.scope;
        }

        public int hashCode() {
            int result = this.expectedClass.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.scope.hashCode();
            return result;
        }

        public String toString() {
            return "Key{" + this.expectedClass.getSimpleName() + " " + (Object)((Object)this.scope) + "#" + this.name + '}';
        }
    }

    public static interface ScopedStoreListener {
        public <T> void invokeUpdate(@Nullable Key<T> var1);
    }
}

