/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.npw.WizardUtils;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.ComponentTreeNode;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.wizard.FirstRunWizardStep;
import com.android.tools.idea.welcome.wizard.WelcomeUIUtils;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.ImmutableList;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkComponentsStep
extends FirstRunWizardStep {
    public static final String FIELD_SDK_LOCATION = "SDK location";
    @NotNull
    private final ComponentTreeNode myRootNode;
    @NotNull
    private final FirstRunWizardMode myMode;
    @NotNull
    private final ScopedStateStore.Key<Boolean> myKeyCustomInstall;
    private final ScopedStateStore.Key<String> mySdkDownloadPathKey;
    private final ComponentsTableModel myTableModel;
    private JPanel myContents;
    private JBTable myComponentsTable;
    private JTextPane myComponentDescription;
    private JLabel myNeededSpace;
    private JLabel myAvailableSpace;
    private JLabel myErrorMessage;
    private TextFieldWithBrowseButton myPath;
    private JPanel myBody;
    private boolean myUserEditedPath = false;
    private WizardUtils.ValidationResult mySdkDirectoryValidationResult;
    private boolean myWasVisible = false;

    public SdkComponentsStep(@NotNull ComponentTreeNode rootNode, @NotNull ScopedStateStore.Key<Boolean> keyCustomInstall, @NotNull ScopedStateStore.Key<String> sdkDownloadPathKey, @NotNull FirstRunWizardMode mode) {
        super("SDK Components Setup");
        this.$$$setupUI$$$();
        this.myPath.setEditable(false);
        this.myRootNode = rootNode;
        this.myMode = mode;
        this.myKeyCustomInstall = keyCustomInstall;
        this.myPath.addBrowseFolderListener("Android SDK", "Select Android SDK install directory", null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.mySdkDownloadPathKey = sdkDownloadPathKey;
        JBFont smallLabelFont = JBUI.Fonts.smallFont();
        this.myNeededSpace.setFont((Font)smallLabelFont);
        this.myAvailableSpace.setFont((Font)smallLabelFont);
        this.myErrorMessage.setText(null);
        this.myTableModel = new ComponentsTableModel(rootNode);
        this.myComponentsTable.setModel((TableModel)this.myTableModel);
        this.myComponentsTable.setTableHeader(null);
        this.myComponentsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = SdkComponentsStep.this.myComponentsTable.getSelectedRow();
                SdkComponentsStep.this.myComponentDescription.setText(row < 0 ? "" : SdkComponentsStep.this.myTableModel.getComponentDescription(row));
            }
        });
        TableColumn column = this.myComponentsTable.getColumnModel().getColumn(0);
        column.setCellRenderer(new SdkComponentRenderer());
        column.setCellEditor(new SdkComponentRenderer());
        this.setComponent(this.myContents);
    }

    @Nullable
    private static File getExistingParentFile(@Nullable String path) {
        File file;
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        for (file = new File(path).getAbsoluteFile(); file != null && !file.exists(); file = file.getParentFile()) {
        }
        return file;
    }

    private static String getDiskSpace(@Nullable String path) {
        File file = SdkComponentsStep.getTargetFilesystem(path);
        if (file == null) {
            return "";
        }
        String available = WelcomeUIUtils.getSizeLabel(file.getFreeSpace());
        if (SystemInfo.isWindows) {
            while (file.getParentFile() != null) {
                file = file.getParentFile();
            }
            return String.format("Disk space available on drive %s: %s", file.getName(), available);
        }
        return String.format("Available disk space: %s", available);
    }

    @Nullable
    private static File getTargetFilesystem(@Nullable String path) {
        File[] files;
        File file = SdkComponentsStep.getExistingParentFile(path);
        if (file == null && (files = File.listRoots()).length != 0) {
            file = files[0];
        }
        return file;
    }

    @Contract(value="null->false")
    private static boolean isExistingSdk(@Nullable String path) {
        if (!StringUtil.isEmptyOrSpaces((String)path)) {
            File file = new File(path);
            return file.isDirectory() && IdeSdks.isValidAndroidSdkPath(file);
        }
        return false;
    }

    private static boolean isNonEmptyNonSdk(@Nullable String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        if (file.exists() && FileOpUtils.create().listFiles(file).length != 0) {
            return AndroidSdkData.getSdkData(file) == null;
        }
        return false;
    }

    @Override
    public boolean validate() {
        String message;
        String path = this.myState.get(this.mySdkDownloadPathKey);
        if (!StringUtil.isEmpty((String)path)) {
            this.myUserEditedPath = true;
        }
        this.mySdkDirectoryValidationResult = WizardUtils.validateLocation(path, FIELD_SDK_LOCATION, false, WizardUtils.WritableCheckMode.NOT_WRITABLE_IS_WARNING);
        boolean ok = this.mySdkDirectoryValidationResult.isOk();
        WizardUtils.ValidationResult.Status status = this.mySdkDirectoryValidationResult.getStatus();
        String string = message = ok ? null : this.mySdkDirectoryValidationResult.getFormattedMessage();
        if (ok) {
            File filesystem = SdkComponentsStep.getTargetFilesystem(path);
            if (filesystem != null && filesystem.getFreeSpace() <= this.getComponentsSize()) {
                status = WizardUtils.ValidationResult.Status.ERROR;
                message = "Target drive does not have enough free space.";
            } else if (SdkComponentsStep.isNonEmptyNonSdk(path)) {
                status = WizardUtils.ValidationResult.Status.WARN;
                message = "Target folder is neither empty nor does it point to an existing SDK installation.";
            } else if (SdkComponentsStep.isExistingSdk(path)) {
                status = WizardUtils.ValidationResult.Status.WARN;
                message = "An existing Android SDK was detected. The setup wizard will only download missing or outdated SDK components.";
            }
        }
        switch (status) {
            case WARN: {
                this.myErrorMessage.setIcon(AllIcons.General.BalloonWarning);
                break;
            }
            case ERROR: {
                this.myErrorMessage.setIcon(AllIcons.General.BalloonError);
                break;
            }
            default: {
                this.myErrorMessage.setIcon(null);
            }
        }
        this.setErrorHtml(this.myUserEditedPath ? message : null);
        return !this.mySdkDirectoryValidationResult.isError();
    }

    @Override
    public void deriveValues(Set<ScopedStateStore.Key> modified) {
        super.deriveValues(modified);
        if (modified.contains(this.mySdkDownloadPathKey) || this.myRootNode.componentStateChanged(modified)) {
            String path = this.myState.get(this.mySdkDownloadPathKey);
            this.myAvailableSpace.setText(SdkComponentsStep.getDiskSpace(path));
            long selected = this.getComponentsSize();
            this.myNeededSpace.setText(String.format("Total download size: %s", WelcomeUIUtils.getSizeLabel(selected)));
        }
    }

    private long getComponentsSize() {
        long size = 0L;
        for (InstallableComponent component : this.myRootNode.getChildrenToInstall()) {
            size += component.getDownloadSize();
        }
        return size;
    }

    @Override
    public void init() {
        this.register(this.mySdkDownloadPathKey, this.myPath);
        if (!this.myRootNode.getImmediateChildren().isEmpty()) {
            this.myComponentsTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    @Override
    @NotNull
    public JLabel getMessageLabel() {
        return this.myErrorMessage;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myComponentsTable;
    }

    @Override
    public boolean isStepVisible() {
        if (this.myWasVisible) {
            return true;
        }
        if (this.myMode.hasValidSdkLocation()) {
            return false;
        }
        if (this.myState.getNotNull(this.myKeyCustomInstall, true).booleanValue()) {
            this.myWasVisible = true;
            return true;
        }
        this.validate();
        this.myWasVisible = !this.mySdkDirectoryValidationResult.isOk();
        return this.myWasVisible;
    }

    private void createUIComponents() {
        Splitter splitter = new Splitter(false, 0.5f, 0.2f, 0.8f);
        this.myBody = splitter;
        this.myComponentsTable = new JBTable();
        this.myComponentDescription = new JTextPane();
        splitter.setShowDividerIcon(false);
        splitter.setShowDividerControls(false);
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myComponentsTable, (boolean)false));
        splitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myComponentDescription, (boolean)false));
        this.myComponentDescription.setFont(UIUtil.getLabelFont());
        this.myComponentDescription.setEditable(false);
        this.myComponentDescription.setBorder(BorderFactory.createEmptyBorder(WizardConstants.STUDIO_WIZARD_INSET_SIZE, WizardConstants.STUDIO_WIZARD_INSET_SIZE, WizardConstants.STUDIO_WIZARD_INSET_SIZE, WizardConstants.STUDIO_WIZARD_INSET_SIZE));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myContents = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Check the components you want to update/install. Click Next to continue.");
        jPanel.add((Component)jLabel4, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        JPanel jPanel2 = this.myBody;
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Android SDK Location:");
        jPanel.add((Component)jLabel5, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 1, 2, 1, 0, 3, 0, 3, null, null, null));
        this.myNeededSpace = jLabel3 = new JLabel();
        jLabel3.setText("Total download size: 5.1Gb");
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myAvailableSpace = jLabel2 = new JLabel();
        jLabel2.setText("Available disk space: 23.0Gb");
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myErrorMessage = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(5, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        jLabel5.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContents;
    }

    private static final class ComponentsTableModel
    extends AbstractTableModel {
        private final List<Pair<ComponentTreeNode, Integer>> myComponents;

        public ComponentsTableModel(ComponentTreeNode component) {
            ImmutableList.Builder components = ImmutableList.builder();
            ComponentsTableModel.traverse(component.getImmediateChildren(), 0, (ImmutableList.Builder<Pair<ComponentTreeNode, Integer>>)components);
            this.myComponents = components.build();
        }

        private static void traverse(Collection<ComponentTreeNode> children, int indent, ImmutableList.Builder<Pair<ComponentTreeNode, Integer>> components) {
            for (ComponentTreeNode child : children) {
                components.add((Object)Pair.create((Object)child, (Object)indent));
                ComponentsTableModel.traverse(child.getImmediateChildren(), indent + 1, components);
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0 && this.getInstallableComponent(rowIndex).isOptional();
        }

        @Override
        public int getRowCount() {
            return this.myComponents.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.myComponents.get(rowIndex);
        }

        @NotNull
        private ComponentTreeNode getInstallableComponent(int rowIndex) {
            return (ComponentTreeNode)this.myComponents.get(rowIndex).getFirst();
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            ComponentTreeNode node = this.getInstallableComponent(row);
            node.toggle((Boolean)aValue);
            this.fireTableRowsUpdated(0, this.getRowCount());
        }

        public String getComponentDescription(int index) {
            return this.getInstallableComponent(index).getDescription();
        }
    }

    private final class SdkComponentRenderer
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        private final RendererPanel myPanel = new RendererPanel();
        private final RendererCheckBox myCheckBox = new RendererCheckBox();
        private Border myEmptyBorder;

        public SdkComponentRenderer() {
            this.myCheckBox.setOpaque(false);
            this.myCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SdkComponentsStep.this.myComponentsTable.isEditing()) {
                        SdkComponentRenderer.this.stopCellEditing();
                    } else {
                        SdkComponentsStep.this.myTableModel.setValueAt(SdkComponentRenderer.this.myCheckBox.isSelected(), SdkComponentRenderer.this.myCheckBox.getRow(), 0);
                    }
                }
            });
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setupControl(table, value, row, isSelected, hasFocus);
            return this.myPanel;
        }

        private void setupControl(JTable table, Object value, int row, boolean isSelected, boolean hasFocus) {
            Color foreground;
            Color background;
            this.myCheckBox.setRow(row);
            this.myPanel.setBorder(this.getCellBorder(table, isSelected && hasFocus));
            if (isSelected) {
                background = table.getSelectionBackground();
                foreground = table.getSelectionForeground();
            } else {
                background = table.getBackground();
                foreground = table.getForeground();
            }
            this.myPanel.setBackground(background);
            this.myCheckBox.setForeground(foreground);
            this.myPanel.remove(this.myCheckBox);
            Pair pair = (Pair)value;
            int indent = 0;
            if (pair != null) {
                ComponentTreeNode node = (ComponentTreeNode)pair.getFirst();
                this.myCheckBox.setEnabled(node.isOptional());
                this.myCheckBox.setText(node.getLabel());
                this.myCheckBox.setSelected(node.isChecked());
                indent = (Integer)pair.getSecond();
            }
            this.myPanel.add((Component)this.myCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, indent * 2));
        }

        private Border getCellBorder(JTable table, boolean isSelectedFocus) {
            Border border;
            Border focusedBorder = UIUtil.getTableFocusCellHighlightBorder();
            if (isSelectedFocus) {
                border = focusedBorder;
            } else {
                if (this.myEmptyBorder == null) {
                    this.myEmptyBorder = new EmptyBorder(focusedBorder.getBorderInsets(table));
                }
                border = this.myEmptyBorder;
            }
            return border;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.setupControl(table, value, row, true, true);
            return this.myPanel;
        }

        @Override
        public Object getCellEditorValue() {
            return this.myCheckBox.isSelected();
        }

        protected class RendererCheckBox
        extends JCheckBox {
            private int myRow;

            protected RendererCheckBox() {
            }

            public int getRow() {
                return this.myRow;
            }

            public void setRow(int row) {
                this.myRow = row;
            }

            public boolean _processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                return super.processKeyBinding(ks, e, condition, pressed);
            }

            public void _processKeyEvent(KeyEvent e) {
                super.processKeyEvent(e);
            }

            @Override
            public void requestFocus() {
                if (SdkComponentsStep.this.myComponentsTable.isEditing()) {
                    return;
                }
                super.requestFocus();
            }
        }

        protected class RendererPanel
        extends JPanel {
            public RendererPanel() {
                super((LayoutManager)new GridLayoutManager(1, 1));
            }

            @Override
            protected void processKeyEvent(KeyEvent e) {
                if (SdkComponentsStep.this.myComponentsTable.isEditing()) {
                    SdkComponentRenderer.this.myCheckBox._processKeyEvent(e);
                } else {
                    super.processKeyEvent(e);
                }
            }

            @Override
            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (SdkComponentsStep.this.myComponentsTable.isEditing()) {
                    return SdkComponentRenderer.this.myCheckBox._processKeyBinding(ks, e, condition, pressed);
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new AccessibleRendererPanel();
                }
                return this.accessibleContext;
            }

            protected class AccessibleRendererPanel
            extends AccessibleContextDelegate {
                public AccessibleRendererPanel() {
                    super(SdkComponentRenderer.this.myCheckBox.getAccessibleContext());
                }

                public Accessible getAccessibleParent() {
                    if (this.accessibleParent != null) {
                        return this.accessibleParent;
                    }
                    Container parent = RendererPanel.this.getParent();
                    if (parent instanceof Accessible) {
                        return (Accessible)((Object)parent);
                    }
                    return null;
                }

                public String getAccessibleDescription() {
                    return SdkComponentsStep.this.myTableModel.getComponentDescription(SdkComponentRenderer.this.myCheckBox.getRow());
                }
            }
        }
    }
}

