/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.intellij.util.IJSwingUtilities;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FirstRunWizardStep
extends DynamicWizardStep {
    public static final String SETUP_WIZARD = "Setup Wizard";
    @NotNull
    private final String myName;
    @Nullable
    private final String myDescription;
    private JComponent myComponent;
    private boolean myComponentUpdated;

    public FirstRunWizardStep(@Nullable String name) {
        this(name == null ? SETUP_WIZARD : name, null);
    }

    public FirstRunWizardStep(@NotNull String name, @Nullable String description) {
        this.myName = name;
        this.myDescription = description;
    }

    @Override
    public void onEnterStep() {
        super.onEnterStep();
        if (!this.myComponentUpdated) {
            IJSwingUtilities.updateComponentTreeUI((Component)this.myComponent);
            this.myComponentUpdated = true;
        }
    }

    @Override
    @NotNull
    public final String getStepName() {
        return this.myName;
    }

    @Override
    @NotNull
    protected String getStepTitle() {
        return this.myName;
    }

    @Override
    @NotNull
    protected Component createStepBody() {
        assert (this.myComponent != null) : "setComponent was not called when constructing the wizard step";
        return this.myComponent;
    }

    protected final void setComponent(@NotNull JComponent component) {
        int inset = 36;
        component.setBorder(BorderFactory.createEmptyBorder(inset, inset, inset, inset));
        this.myComponent = component;
    }

    @Override
    @Nullable
    protected String getStepDescription() {
        return this.myDescription;
    }
}

