/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallOperation;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.WelcomeUIUtils;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.templates.github.ZipUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class UnpackOperation
extends InstallOperation<File, File> {
    public static final String EXTRACT_OPERATION_OUTPUT = "x ";
    public static final String TAR_FLAGS_EXTRACT_UNPACK_VERBOSE_FILENAME_TARGETDIR = "xzvfC";
    public static final String DEFAULT_TAR_EXECUTABLE_PATH = "/usr/bin/tar";
    private final InstallContext myContext;

    public UnpackOperation(@NotNull InstallContext context, double progressShare) {
        super(context, progressShare);
        this.myContext = context;
    }

    @NotNull
    private static File unzip(File archive, File destination, @NotNull InstallContext context, ProgressIndicator progressIndicator) throws IOException {
        ZipUtil.unzip((ProgressIndicator)progressIndicator, (File)destination, (File)archive, null, null, (boolean)true);
        if (archive.getCanonicalPath().startsWith(context.getTempDirectory().getCanonicalPath())) {
            FileUtil.delete((File)archive);
        }
        return destination;
    }

    @NotNull
    private static File untar(File archive, File destination, final InstallContext context, final ProgressIndicator indicator) throws IOException, WizardException {
        if (!destination.mkdirs()) {
            throw new WizardException("Cannot create temporary directory to extract files");
        }
        indicator.start();
        indicator.setFraction(0.0);
        try {
            GeneralCommandLine line = new GeneralCommandLine(new String[]{UnpackOperation.getTarExecutablePath(), TAR_FLAGS_EXTRACT_UNPACK_VERBOSE_FILENAME_TARGETDIR, archive.getAbsolutePath(), destination.getAbsolutePath()});
            CapturingAnsiEscapesAwareProcessHandler handler = new CapturingAnsiEscapesAwareProcessHandler(line);
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    String string = event.getText();
                    if (!StringUtil.isEmptyOrSpaces((String)string)) {
                        if (string.startsWith(UnpackOperation.EXTRACT_OPERATION_OUTPUT)) {
                            String fileName = string.substring(UnpackOperation.EXTRACT_OPERATION_OUTPUT.length()).trim();
                            indicator.setText(fileName);
                        } else if (ProcessOutputTypes.STDOUT.equals((Object)outputType)) {
                            indicator.setText(string.trim());
                        } else {
                            context.print(string, ConsoleViewContentType.getConsoleViewType((Key)outputType));
                        }
                    }
                }
            });
            if (handler.runProcess().getExitCode() != 0) {
                throw new IOException("Unable to unpack archive file");
            }
            File file = destination;
            return file;
        }
        catch (ExecutionException e) {
            throw new WizardException("Unable to run tar utility");
        }
        finally {
            indicator.setFraction(1.0);
            indicator.stop();
        }
    }

    @NotNull
    private static String getTarExecutablePath() {
        File file = new File(DEFAULT_TAR_EXECUTABLE_PATH);
        if (file.isFile()) {
            return file.getAbsolutePath();
        }
        return "tar";
    }

    @Override
    @NotNull
    protected File perform(@NotNull ProgressIndicator indicator, @NotNull File archive) throws WizardException {
        String fileName = archive.getName();
        ArchiveType archiveType = ArchiveType.fromFileName(fileName);
        this.myContext.print(String.format("Unpacking %s\n", fileName), ConsoleViewContentType.SYSTEM_OUTPUT);
        File dir = new File(this.myContext.getTempDirectory(), fileName + "-unpacked");
        while (true) {
            try {
                return archiveType.unpack(archive, dir, this.myContext, indicator);
            }
            catch (IOException e) {
                String failure = String.format("Unable to unpack file %1$s", fileName);
                String message = WelcomeUIUtils.getMessageWithDetails(failure, e.getMessage());
                this.promptToRetry(message + " Make sure you have enough disk space on destination drive and retry.", message, e);
                continue;
            }
            break;
        }
    }

    @Override
    public void cleanup(@NotNull File result) {
        if (result.exists()) {
            FileUtil.delete((File)result);
        }
    }

    private static enum ArchiveType {
        ZIP,
        TAR,
        NOT_AN_ARCHIVE;

        private static final String[] TAR_EXTENSIONS;
        private static final String[] ZIP_EXTENSIONS;

        @NotNull
        public static ArchiveType fromFileName(@NotNull String fileName) {
            String lowerCaseName = fileName.toLowerCase();
            if (ArchiveType.extensionIsOneOf(lowerCaseName, TAR_EXTENSIONS)) {
                return TAR;
            }
            if (ArchiveType.extensionIsOneOf(lowerCaseName, ZIP_EXTENSIONS)) {
                return ZIP;
            }
            return NOT_AN_ARCHIVE;
        }

        private static boolean extensionIsOneOf(@NotNull String name, @NotNull String[] extensions) {
            for (String extension : extensions) {
                if (!FileUtilRt.extensionEquals((String)name, (String)extension)) continue;
                return true;
            }
            return false;
        }

        public File unpack(@NotNull File archive, @NotNull File destination, @NotNull InstallContext context, @NotNull ProgressIndicator indicator) throws IOException, WizardException {
            switch (this) {
                case ZIP: {
                    return UnpackOperation.unzip(archive, destination, context, indicator);
                }
                case TAR: {
                    return UnpackOperation.untar(archive, destination, context, indicator);
                }
                case NOT_AN_ARCHIVE: {
                    throw new WizardException(String.format("Unrecognized archive file format for file %s", archive.getName()));
                }
            }
            throw new IllegalArgumentException(String.format("Archive %s has format %s", archive.getName(), this.name()));
        }

        static {
            TAR_EXTENSIONS = new String[]{"tgz", "tar", "tar.gz"};
            ZIP_EXTENSIONS = new String[]{"zip"};
        }
    }
}

