/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.tools.idea.welcome.install.InstallContext;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkManagerProgressIndicatorIntegration
extends ProgressIndicatorAdapter {
    private final ProgressIndicator myIndicator;
    private final InstallContext myContext;
    private StringBuffer myErrors = new StringBuffer();

    public SdkManagerProgressIndicatorIntegration(@NotNull ProgressIndicator indicator, @NotNull InstallContext context) {
        this.myIndicator = indicator;
        this.myContext = context;
    }

    public void setFraction(double progress) {
        this.myIndicator.setFraction(progress);
    }

    public void setText(@Nullable String title) {
        this.myIndicator.setText(title);
    }

    public void setSecondaryText(@Nullable String s) {
        this.myIndicator.setText2(s);
    }

    public void logInfo(String s) {
        this.myContext.print(s, ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    public void logError(String s, @Nullable Throwable e) {
        if (e != null) {
            this.myErrors.append(String.format("%s: %s\n", e.getClass().getName(), e.getMessage()));
        }
        this.myErrors.append(s);
    }

    public void logWarning(String s, @Nullable Throwable e) {
        if (e != null) {
            this.myErrors.append(String.format("%s: %s\n", e.getClass().getName(), e.getMessage()));
        }
        this.myErrors.append(String.format("Warning: %s\n", s));
    }

    public String getErrors() {
        return this.myErrors.toString();
    }
}

