/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.ddms.screenshot.DeviceArtPainter;
import com.android.tools.idea.rendering.RenderErrorPanel;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.editor.NlActionManager;
import com.android.tools.idea.uibuilder.editor.NlEditorPanel;
import com.android.tools.idea.uibuilder.editor.NlPreviewForm;
import com.android.tools.idea.uibuilder.graphics.NlConstants;
import com.android.tools.idea.uibuilder.model.ModelListener;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlLayoutType;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.model.SelectionListener;
import com.android.tools.idea.uibuilder.model.SelectionModel;
import com.android.tools.idea.uibuilder.surface.BlueprintLayer;
import com.android.tools.idea.uibuilder.surface.CanvasResizeLayer;
import com.android.tools.idea.uibuilder.surface.ConstraintsLayer;
import com.android.tools.idea.uibuilder.surface.DesignSurfaceListener;
import com.android.tools.idea.uibuilder.surface.InteractionManager;
import com.android.tools.idea.uibuilder.surface.Layer;
import com.android.tools.idea.uibuilder.surface.PanZoomListener;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.idea.uibuilder.surface.ScreenViewLayer;
import com.android.tools.idea.uibuilder.surface.SelectionLayer;
import com.android.tools.idea.uibuilder.surface.WarningLayer;
import com.android.tools.idea.uibuilder.surface.ZoomType;
import com.google.common.collect.Lists;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.Magnificator;
import com.intellij.util.Alarm;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.plaf.ScrollBarUI;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DesignSurface
extends JPanel
implements Disposable {
    public static final boolean SIZE_ERROR_PANEL_DYNAMICALLY = true;
    private static final Integer LAYER_PROGRESS = JLayeredPane.POPUP_LAYER + 100;
    private final Project myProject;
    private final DesignerEditorPanelFacade myDesigner;
    private boolean myRenderHasProblems;
    private boolean myStackVertically;
    private boolean myIsCanvasResizing = false;
    private boolean myZoomFitted = true;
    @NotNull
    private static ScreenMode ourDefaultScreenMode = ScreenMode.loadDefault();
    @NotNull
    private ScreenMode myScreenMode = ourDefaultScreenMode;
    @Nullable
    private ScreenView myScreenView;
    @Nullable
    private ScreenView myBlueprintView;
    private int myScreenX = 70;
    private int myScreenY = 70;
    private double myScale = -1.0;
    @NotNull
    private final JScrollPane myScrollPane;
    private final MyLayeredPane myLayeredPane;
    private boolean myDeviceFrames = false;
    private final List<Layer> myLayers = Lists.newArrayList();
    private final InteractionManager myInteractionManager;
    private final GlassPane myGlassPane;
    private final RenderErrorPanel myErrorPanel;
    private List<DesignSurfaceListener> myListeners;
    private List<PanZoomListener> myZoomListeners;
    private boolean myCentered;
    private final NlActionManager myActionManager = new NlActionManager(this);
    private final SelectionListener mySelectionListener = new SelectionListener(){

        @Override
        public void selectionChanged(@NotNull SelectionModel model, @NotNull List<NlComponent> selection) {
            if (DesignSurface.this.myScreenView != null) {
                DesignSurface.this.notifySelectionListeners(selection);
            } else {
                DesignSurface.this.notifySelectionListeners(Collections.emptyList());
            }
        }
    };
    private final ModelListener myModelListener = new ModelListener(){

        @Override
        public void modelChanged(@NotNull NlModel model) {
            model.render();
        }

        @Override
        public void modelRendered(@NotNull NlModel model) {
            if (DesignSurface.this.myScreenView != null) {
                DesignSurface.this.updateErrorDisplay(DesignSurface.this.myScreenView.getResult());
                DesignSurface.this.repaint();
                DesignSurface.this.positionScreens();
            }
        }
    };
    private final Object myErrorQueueLock = new Object();
    private MergingUpdateQueue myErrorQueue;
    private final List<ProgressIndicator> myProgressIndicators = new ArrayList<ProgressIndicator>();
    private final MyProgressPanel myProgressPanel;

    public DesignSurface(@NotNull Project project, @NotNull DesignerEditorPanelFacade designer) {
        super(new BorderLayout());
        this.myProject = project;
        this.myDesigner = designer;
        this.setOpaque(true);
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.myInteractionManager = new InteractionManager(this);
        this.myLayeredPane = new MyLayeredPane();
        this.myLayeredPane.setBounds(0, 0, 100, 100);
        this.myGlassPane = new GlassPane();
        this.myLayeredPane.add((Component)this.myGlassPane, JLayeredPane.DRAG_LAYER);
        this.myProgressPanel = new MyProgressPanel();
        this.myProgressPanel.setName("Layout Editor Progress Panel");
        this.myLayeredPane.add((Component)this.myProgressPanel, LAYER_PROGRESS);
        this.myScrollPane = new MyScrollPane();
        this.myScrollPane.setViewportView(this.myLayeredPane);
        this.myScrollPane.setBorder(null);
        this.myScrollPane.setVerticalScrollBarPolicy(22);
        this.myScrollPane.setHorizontalScrollBarPolicy(32);
        this.myScrollPane.getHorizontalScrollBar().addAdjustmentListener(this::notifyPanningChanged);
        this.myScrollPane.getVerticalScrollBar().addAdjustmentListener(this::notifyPanningChanged);
        this.add((Component)this.myScrollPane, "Center");
        this.myErrorPanel = new RenderErrorPanel();
        this.myErrorPanel.setName("Layout Editor Error Panel");
        this.myErrorPanel.setVisible(false);
        this.myLayeredPane.add((Component)this.myErrorPanel, JLayeredPane.POPUP_LAYER);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (DesignSurface.this.isShowing() && DesignSurface.this.getWidth() > 0 && DesignSurface.this.getHeight() > 0 && DesignSurface.this.myZoomFitted) {
                    DesignSurface.this.zoomToFit();
                }
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
        this.myInteractionManager.registerListeners();
        this.myActionManager.registerActions(this.myLayeredPane);
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public boolean isPreviewSurface() {
        return this.myDesigner instanceof NlPreviewForm;
    }

    @NotNull
    public NlLayoutType getLayoutType() {
        XmlFile file;
        if (this.myDesigner instanceof NlEditorPanel) {
            file = ((NlEditorPanel)this.myDesigner).getFile();
        } else if (this.myDesigner instanceof NlPreviewForm) {
            file = ((NlPreviewForm)this.myDesigner).getFile();
            assert (file != null);
        } else {
            throw new IllegalStateException(this.myDesigner.toString());
        }
        return NlLayoutType.typeOf(file);
    }

    public void minimizePaletteOnPreview() {
        if (this.isPreviewSurface()) {
            ApplicationManager.getApplication().invokeLater(((NlPreviewForm)this.myDesigner)::minimizePalette);
        }
    }

    @NotNull
    public NlActionManager getActionManager() {
        return this.myActionManager;
    }

    public void setCentered(boolean centered) {
        this.myCentered = centered;
    }

    public void setResizeMode(boolean isResizing) {
        this.myIsCanvasResizing = isResizing;
    }

    public boolean isCanvasResizing() {
        return this.myIsCanvasResizing;
    }

    @NotNull
    public ScreenMode getScreenMode() {
        return this.myScreenMode;
    }

    public void setScreenMode(@NotNull ScreenMode screenMode, boolean setAsDefault) {
        if (setAsDefault && ourDefaultScreenMode != screenMode) {
            ourDefaultScreenMode = screenMode;
            ScreenMode.saveDefault(screenMode);
        }
        if (screenMode != this.myScreenMode) {
            boolean adjustZoom = screenMode == ScreenMode.BOTH || this.myScreenMode == ScreenMode.BOTH;
            this.myScreenMode = screenMode;
            if (this.myScreenView != null) {
                NlModel model = this.myScreenView.getModel();
                this.setModel(null);
                this.setModel(model);
                if (adjustZoom) {
                    this.zoomToFit();
                }
            }
        }
    }

    public void setModel(@Nullable NlModel model) {
        if (model == null && this.myScreenView == null) {
            return;
        }
        List<Object> selectionBefore = Collections.emptyList();
        List<NlComponent> selectionAfter = Collections.emptyList();
        if (this.myScreenView != null) {
            this.myScreenView.getModel().removeListener(this.myModelListener);
            SelectionModel selectionModel = this.myScreenView.getSelectionModel();
            selectionBefore = selectionModel.getSelection();
            selectionModel.removeListener(this.mySelectionListener);
            this.myScreenView = null;
        }
        this.myLayers.clear();
        if (model != null) {
            this.myScreenView = new ScreenView(this, ScreenView.ScreenViewType.NORMAL, model);
            this.myScreenView.getModel().addListener(this.myModelListener);
            this.updateErrorDisplay(this.myScreenView.getResult());
            this.myLayeredPane.setPreferredSize(this.myScreenView.getPreferredSize());
            NlLayoutType layoutType = this.myScreenView.getModel().getType();
            if (layoutType.equals((Object)NlLayoutType.MENU) || layoutType.equals((Object)NlLayoutType.PREFERENCE_SCREEN)) {
                this.myScreenMode = ScreenMode.SCREEN_ONLY;
            }
            this.myScreenView.setType(this.myScreenMode.getScreenViewType());
            this.addLayers(model);
            this.positionScreens();
            SelectionModel selectionModel = model.getSelectionModel();
            selectionModel.addListener(this.mySelectionListener);
            selectionAfter = selectionModel.getSelection();
        } else {
            this.myScreenView = null;
            this.myBlueprintView = null;
        }
        this.repaint();
        if (!selectionBefore.equals(selectionAfter)) {
            this.notifySelectionListeners(selectionAfter);
        }
        this.notifyScreenViewChanged();
    }

    private void addLayers(@NotNull NlModel model) {
        assert (this.myScreenView != null);
        switch (this.myScreenMode) {
            case SCREEN_ONLY: {
                this.addScreenLayers();
                break;
            }
            case BLUEPRINT_ONLY: {
                this.addBlueprintLayers(this.myScreenView);
                break;
            }
            case BOTH: {
                this.myBlueprintView = new ScreenView(this, ScreenView.ScreenViewType.BLUEPRINT, model);
                this.myBlueprintView.setLocation(this.myScreenX + this.myScreenView.getPreferredSize().width + 10, this.myScreenY);
                this.addScreenLayers();
                this.addBlueprintLayers(this.myBlueprintView);
                break;
            }
            default: {
                assert (false) : this.myScreenMode;
                break;
            }
        }
    }

    private void addScreenLayers() {
        assert (this.myScreenView != null);
        this.myLayers.add(new ScreenViewLayer(this.myScreenView));
        this.myLayers.add(new SelectionLayer(this.myScreenView));
        if (this.myScreenView.getModel().getType().isLayout()) {
            this.myLayers.add(new ConstraintsLayer(this, this.myScreenView, true));
        }
        this.myLayers.add(new WarningLayer(this.myScreenView));
        this.myLayers.add(new CanvasResizeLayer(this, this.myScreenView));
    }

    private void addBlueprintLayers(@NotNull ScreenView view) {
        this.myLayers.add(new BlueprintLayer(view));
        this.myLayers.add(new SelectionLayer(view));
        this.myLayers.add(new CanvasResizeLayer(this, view));
    }

    public void dispose() {
        this.myErrorPanel.dispose();
    }

    @Nullable
    private Dimension updateScrolledAreaSize() {
        if (this.myScreenView == null) {
            return null;
        }
        Dimension size = this.myScreenView.getSize();
        Dimension dimension = new Dimension(size.width + 100, size.height + 100);
        if (this.myScreenMode == ScreenMode.BOTH) {
            if (this.isStackVertically()) {
                dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)size.height + 10.0);
            } else {
                dimension.setSize(dimension.getWidth() + (double)size.width + 10.0, dimension.getHeight());
            }
        }
        this.myLayeredPane.setBounds(0, 0, dimension.width, dimension.height);
        this.myLayeredPane.setPreferredSize(dimension);
        this.myScrollPane.revalidate();
        this.myProgressPanel.setBounds(this.myScreenX, this.myScreenY, size.width, size.height);
        return dimension;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGlassPane;
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        if (this.isFocusOwner()) {
            graphics.setColor(UIUtil.getFocusedBoundsColor());
            graphics.drawRect(this.getX(), this.getY(), this.getWidth() - 1, this.getHeight() - 1);
        }
    }

    @Nullable
    public ScreenView getCurrentScreenView() {
        return this.myScreenView;
    }

    @Nullable
    public ScreenView getScreenView(int x, int y) {
        if (this.myBlueprintView != null && x >= this.myBlueprintView.getX() && y >= this.myBlueprintView.getY()) {
            return this.myBlueprintView;
        }
        return this.myScreenView;
    }

    @Nullable
    private ScreenView getHoverScreenView(int x, int y) {
        if (this.myBlueprintView != null && x >= this.myBlueprintView.getX() && x <= this.myBlueprintView.getX() + this.myBlueprintView.getSize().width && y >= this.myBlueprintView.getY() && y <= this.myBlueprintView.getY() + this.myBlueprintView.getSize().height) {
            return this.myBlueprintView;
        }
        if (this.myScreenView != null && x >= this.myScreenView.getX() && x <= this.myScreenView.getX() + this.myScreenView.getSize().width && y >= this.myScreenView.getY() && y <= this.myScreenView.getY() + this.myScreenView.getSize().height) {
            return this.myScreenView;
        }
        return null;
    }

    public void startDragDropInteraction() {
        for (Layer layer : this.myLayers) {
            ConstraintsLayer constraintsLayer;
            if (!(layer instanceof ConstraintsLayer) || (constraintsLayer = (ConstraintsLayer)layer).isShowOnHover()) continue;
            constraintsLayer.setShowOnHover(true);
            this.repaint();
        }
    }

    public void stopDragDropInteraction() {
        for (Layer layer : this.myLayers) {
            ConstraintsLayer constraintsLayer;
            if (!(layer instanceof ConstraintsLayer) || !(constraintsLayer = (ConstraintsLayer)layer).isShowOnHover()) continue;
            constraintsLayer.setShowOnHover(false);
            this.repaint();
        }
    }

    @Nullable
    public ScreenView getBlueprintView() {
        return this.myBlueprintView;
    }

    @NotNull
    public Dimension getContentSize(@Nullable Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension();
        }
        if (this.myScreenMode == ScreenMode.BOTH && this.myScreenView != null && this.myBlueprintView != null) {
            if (this.isStackVertically()) {
                dimension.setSize(this.myScreenView.getSize().getWidth(), this.myScreenView.getSize().getHeight() + this.myBlueprintView.getSize().getHeight());
            } else {
                dimension.setSize(this.myScreenView.getSize().getWidth() + this.myBlueprintView.getSize().getWidth(), this.myScreenView.getSize().getHeight());
            }
        } else if (this.getCurrentScreenView() != null) {
            dimension.setSize(this.getCurrentScreenView().getSize().getWidth(), this.getCurrentScreenView().getSize().getHeight());
        }
        return dimension;
    }

    public void hover(int x, int y) {
        ScreenView current = this.getHoverScreenView(x, y);
        for (Layer layer : this.myLayers) {
            if (layer instanceof ConstraintsLayer) {
                ConstraintsLayer constraintsLayer = (ConstraintsLayer)layer;
                boolean show = false;
                if (constraintsLayer.getScreenView() == current) {
                    show = true;
                }
                if (constraintsLayer.isShowOnHover() == show) continue;
                constraintsLayer.setShowOnHover(show);
                this.repaint();
                continue;
            }
            if (!(layer instanceof CanvasResizeLayer) || !((CanvasResizeLayer)layer).changeHovering(x, y)) continue;
            this.repaint();
        }
        if (this.myErrorPanel.isVisible() && this.myRenderHasProblems) {
            return;
        }
        for (Layer layer : this.myLayers) {
            String tooltip = layer.getTooltip(x, y);
            if (tooltip == null) continue;
            this.myErrorPanel.showWarning(tooltip);
            if (!this.myErrorPanel.isVisible()) {
                this.myErrorPanel.setVisible(true);
                this.revalidate();
                break;
            }
            this.repaint();
            break;
        }
    }

    public void resetHover() {
        if (this.myRenderHasProblems) {
            return;
        }
        this.myErrorPanel.setVisible(false);
    }

    public void zoom(@NotNull ZoomType type) {
        this.myZoomFitted = false;
        switch (type) {
            case IN: {
                double currentScale = this.myScale;
                if (SystemInfo.isMac && UIUtil.isRetina()) {
                    currentScale *= 2.0;
                }
                int current = (int)(currentScale * 100.0);
                double scale = (double)ZoomType.zoomIn(current) / 100.0;
                if (SystemInfo.isMac && UIUtil.isRetina()) {
                    scale /= 2.0;
                }
                this.setScale(scale);
                this.repaint();
                break;
            }
            case OUT: {
                double currentScale = this.myScale;
                if (SystemInfo.isMac && UIUtil.isRetina()) {
                    currentScale *= 2.0;
                }
                int current = (int)(currentScale * 100.0);
                double scale = (double)ZoomType.zoomOut(current) / 100.0;
                if (SystemInfo.isMac && UIUtil.isRetina()) {
                    scale /= 2.0;
                }
                this.setScale(scale);
                this.repaint();
                break;
            }
            case ACTUAL: {
                if (SystemInfo.isMac && UIUtil.isRetina()) {
                    this.setScale(0.5);
                } else {
                    this.setScale(1.0);
                }
                this.repaint();
                break;
            }
            case FIT: 
            case FIT_INTO: {
                this.myZoomFitted = true;
                if (this.myScreenView == null) {
                    return;
                }
                int availableWidth = this.myScrollPane.getWidth() - this.myScrollPane.getVerticalScrollBar().getWidth();
                int availableHeight = this.myScrollPane.getHeight() - this.myScrollPane.getHorizontalScrollBar().getHeight();
                Dimension preferredSize = this.myScreenView.getPreferredSize();
                int requiredWidth = preferredSize.width;
                int requiredHeight = preferredSize.height;
                availableWidth -= 120;
                availableHeight -= 120;
                if (this.myScreenMode == ScreenMode.BOTH) {
                    if (DesignSurface.isVerticalScreenConfig(availableWidth, availableHeight, preferredSize)) {
                        requiredHeight *= 2;
                        requiredHeight += 10;
                    } else {
                        requiredWidth *= 2;
                        requiredWidth += 10;
                    }
                }
                double scaleX = (double)availableWidth / (double)requiredWidth;
                double scaleY = (double)availableHeight / (double)requiredHeight;
                double scale = Math.min(scaleX, scaleY);
                if (type == ZoomType.FIT_INTO) {
                    scale = Math.min(1.0, scale);
                }
                this.setScale(scale);
                this.repaint();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not yet implemented: " + (Object)((Object)type));
            }
        }
    }

    public void zoomActual() {
        this.zoom(ZoomType.ACTUAL);
    }

    public void zoomIn() {
        this.zoom(ZoomType.IN);
    }

    public void zoomOut() {
        this.zoom(ZoomType.OUT);
    }

    public void zoomToFit() {
        this.zoom(ZoomType.FIT);
    }

    public boolean isZoomFitted() {
        return this.myZoomFitted;
    }

    private static boolean isVerticalScreenConfig(int availableWidth, int availableHeight, @NotNull Dimension preferredSize) {
        boolean stackVertically;
        boolean bl = stackVertically = preferredSize.width > preferredSize.height;
        if (availableWidth > 10 && availableHeight > 3 * availableWidth / 2) {
            stackVertically = true;
        }
        return stackVertically;
    }

    public double getScale() {
        return this.myScale;
    }

    public Configuration getConfiguration() {
        return this.myScreenView != null ? this.myScreenView.getConfiguration() : null;
    }

    public void setConfiguration(@NotNull Configuration configuration) {
        if (this.myScreenView != null) {
            this.myScreenView.setConfiguration(configuration);
        }
    }

    public void setScrollPosition(int x, int y) {
        this.setScrollPosition(new Point(x, y));
    }

    public void setScrollPosition(Point p) {
        JScrollBar horizontalScrollBar = this.myScrollPane.getHorizontalScrollBar();
        JScrollBar verticalScrollBar = this.myScrollPane.getVerticalScrollBar();
        p.setLocation(Math.max(horizontalScrollBar.getMinimum(), p.x), Math.max(verticalScrollBar.getMinimum(), p.y));
        p.setLocation(Math.min(horizontalScrollBar.getMaximum() - horizontalScrollBar.getVisibleAmount(), p.x), Math.min(verticalScrollBar.getMaximum() - verticalScrollBar.getVisibleAmount(), p.y));
        this.myScrollPane.getViewport().setViewPosition(p);
    }

    public Point getScrollPosition() {
        return this.myScrollPane.getViewport().getViewPosition();
    }

    private void setScale(double scale) {
        Point viewPosition = this.myScrollPane.getViewport().getViewPosition();
        Dimension oldSize = this.myScrollPane.getViewport().getViewSize();
        double normalizedX = ((double)viewPosition.x + (double)this.myScrollPane.getWidth() / 2.0) / oldSize.getWidth();
        double normalizedY = ((double)viewPosition.y + (double)this.myScrollPane.getHeight() / 2.0) / oldSize.getHeight();
        if (scale < 0.0) {
            scale = -1.0;
        } else if (Math.abs(scale - 1.0) < 1.0E-4) {
            scale = 1.0;
        } else if (scale < 0.01) {
            scale = 0.01;
        } else if (scale > 10.0) {
            scale = 10.0;
        }
        this.myScale = scale;
        this.positionScreens();
        Dimension newSize = this.updateScrolledAreaSize();
        if (newSize != null) {
            viewPosition.setLocation(normalizedX * newSize.getWidth() - (double)this.myScrollPane.getWidth() / 2.0, normalizedY * newSize.getHeight() - (double)this.myScrollPane.getHeight() / 2.0);
            this.myScrollPane.getViewport().setViewPosition(viewPosition);
        }
        this.notifyScaleChanged();
    }

    private void notifyScaleChanged() {
        if (this.myZoomListeners != null) {
            for (PanZoomListener myZoomListener : this.myZoomListeners) {
                myZoomListener.zoomChanged(this);
            }
        }
    }

    private void notifyPanningChanged(AdjustmentEvent adjustmentEvent) {
        if (this.myZoomListeners != null) {
            for (PanZoomListener myZoomListener : this.myZoomListeners) {
                myZoomListener.panningChanged(adjustmentEvent);
            }
        }
    }

    private void positionScreens() {
        if (this.myScreenView == null) {
            return;
        }
        Dimension screenViewSize = this.myScreenView.getSize();
        int availableWidth = this.myScrollPane.getWidth();
        int availableHeight = this.myScrollPane.getHeight();
        this.myStackVertically = DesignSurface.isVerticalScreenConfig(availableWidth, availableHeight, screenViewSize);
        if (!this.myIsCanvasResizing) {
            if (this.myCentered && availableWidth > 10 && availableHeight > 10) {
                int requiredWidth = screenViewSize.width;
                if (this.myScreenMode == ScreenMode.BOTH && !this.myStackVertically) {
                    requiredWidth += 10;
                    requiredWidth += screenViewSize.width;
                }
                this.myScreenX = requiredWidth < availableWidth ? (availableWidth - requiredWidth) / 2 : 0;
                int requiredHeight = screenViewSize.height;
                if (this.myScreenMode == ScreenMode.BOTH && this.myStackVertically) {
                    requiredHeight += 10;
                    requiredHeight += screenViewSize.height;
                }
                this.myScreenY = requiredHeight < availableHeight ? (availableHeight - requiredHeight) / 2 : 0;
            } else if (this.myDeviceFrames) {
                this.myScreenX = 120;
                this.myScreenY = 120;
            } else {
                this.myScreenX = 70;
                this.myScreenY = 70;
            }
        }
        this.myScreenView.setLocation(this.myScreenX, this.myScreenY);
        if (this.myBlueprintView != null) {
            if (this.myStackVertically) {
                this.myBlueprintView.setLocation(this.myScreenX, this.myScreenY + screenViewSize.height + 10);
            } else {
                this.myBlueprintView.setLocation(this.myScreenX + screenViewSize.width + 10, this.myScreenY);
            }
        }
    }

    public boolean isStackVertically() {
        return this.myStackVertically;
    }

    public void toggleDeviceFrames() {
        this.myDeviceFrames = !this.myDeviceFrames;
        this.positionScreens();
        this.repaint();
    }

    @NotNull
    public JComponent getLayeredPane() {
        return this.myLayeredPane;
    }

    private void notifySelectionListeners(@NotNull List<NlComponent> newSelection) {
        if (this.myListeners != null) {
            ArrayList listeners = Lists.newArrayList(this.myListeners);
            for (DesignSurfaceListener listener : listeners) {
                listener.componentSelectionChanged(this, newSelection);
            }
        }
    }

    private void notifyScreenViewChanged() {
        NlModel model;
        ScreenView screenView = this.myScreenView;
        NlModel nlModel = model = this.myScreenView != null ? this.myScreenView.getModel() : null;
        if (this.myListeners != null) {
            ArrayList listeners = Lists.newArrayList(this.myListeners);
            for (DesignSurfaceListener listener : listeners) {
                listener.modelChanged(this, model);
                listener.screenChanged(this, screenView);
            }
        }
    }

    void notifyActivateComponent(@NotNull NlComponent component) {
        block1: {
            DesignSurfaceListener listener;
            if (this.myListeners == null) break block1;
            ArrayList listeners = Lists.newArrayList(this.myListeners);
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext() && !(listener = (DesignSurfaceListener)iterator.next()).activatePreferredEditor(this, component)) {
            }
        }
    }

    public void addListener(@NotNull DesignSurfaceListener listener) {
        if (this.myListeners == null) {
            this.myListeners = Lists.newArrayList();
        } else {
            this.myListeners.remove(listener);
        }
        this.myListeners.add(listener);
    }

    public void removeListener(@NotNull DesignSurfaceListener listener) {
        if (this.myListeners != null) {
            this.myListeners.remove(listener);
        }
    }

    public void addPanZoomListener(PanZoomListener listener) {
        if (this.myZoomListeners == null) {
            this.myZoomListeners = Lists.newArrayList();
        } else {
            this.myZoomListeners.remove(listener);
        }
        this.myZoomListeners.add(listener);
    }

    public void removePanZoomListener(PanZoomListener listener) {
        if (this.myZoomListeners != null) {
            this.myZoomListeners.remove(listener);
        }
    }

    public void activate() {
        if (this.myScreenView != null) {
            this.myScreenView.getModel().activate();
        }
    }

    public void deactivate() {
        if (this.myScreenView != null) {
            this.myScreenView.getModel().deactivate();
        }
        this.myInteractionManager.cancelInteraction();
    }

    private void positionErrorPanel() {
        if (!this.myErrorPanel.isVisible()) {
            return;
        }
        int height = this.getHeight();
        int width = this.getWidth();
        boolean showingErrors = HighlightSeverity.ERROR.equals((Object)this.myErrorPanel.getSeverity());
        int size = DesignSurface.computeErrorPanelHeight(showingErrors, height, this.myErrorPanel.getPreferredHeight(width) + 16);
        this.myErrorPanel.setSize(width, size);
        this.myErrorPanel.setLocation(20, height - size);
    }

    private static int computeErrorPanelHeight(boolean showingErrors, int designerHeight, int preferredHeight) {
        int minSize;
        int maxSize = designerHeight * 3 / 4;
        int n = minSize = showingErrors ? designerHeight / 4 : 16;
        if (preferredHeight < maxSize) {
            return Math.max(preferredHeight, minSize);
        }
        return maxSize;
    }

    public void updateErrorDisplay(@Nullable RenderResult result) {
        assert (ApplicationManager.getApplication().isDispatchThread() || !ApplicationManager.getApplication().isReadAccessAllowed()) : "Do not hold read lock when calling updateErrorDisplay!";
        this.getErrorQueue().cancelAllUpdates();
        boolean bl = this.myRenderHasProblems = result != null && result.getLogger().hasProblems();
        if (this.myRenderHasProblems) {
            this.updateErrors(result);
        } else {
            UIUtil.invokeLaterIfNeeded(() -> {
                this.myErrorPanel.setVisible(false);
                this.repaint();
            });
        }
    }

    private void updateErrors(@Nullable RenderResult result) {
        assert (result != null && result.getLogger().hasProblems());
        this.getErrorQueue().cancelAllUpdates();
        this.getErrorQueue().queue(new Update("errors"){

            public void run() {
                RenderResult result;
                RenderResult renderResult = result = DesignSurface.this.myScreenView != null ? DesignSurface.this.myScreenView.getResult() : null;
                if (result == null) {
                    return;
                }
                DesignSurface.this.myErrorPanel.showErrors(result);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!DesignSurface.this.myErrorPanel.isVisible()) {
                        DesignSurface.this.myErrorPanel.setVisible(true);
                    }
                    DesignSurface.this.revalidate();
                    DesignSurface.this.repaint();
                });
            }

            public boolean canEat(Update update) {
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private MergingUpdateQueue getErrorQueue() {
        Object object = this.myErrorQueueLock;
        synchronized (object) {
            if (this.myErrorQueue == null) {
                this.myErrorQueue = new MergingUpdateQueue("android.error.computation", 200, true, null, (Disposable)this.myProject, null, Alarm.ThreadToUse.POOLED_THREAD);
            }
            return this.myErrorQueue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIndicator(@NotNull ProgressIndicator indicator) {
        if (this.myProject.isDisposed()) {
            return;
        }
        List<ProgressIndicator> list = this.myProgressIndicators;
        synchronized (list) {
            this.myProgressIndicators.add(indicator);
            this.myProgressPanel.showProgressIcon();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterIndicator(@NotNull ProgressIndicator indicator) {
        List<ProgressIndicator> list = this.myProgressIndicators;
        synchronized (list) {
            this.myProgressIndicators.remove(indicator);
            if (this.myProgressIndicators.size() == 0) {
                this.myProgressPanel.hideProgressIcon();
            }
        }
    }

    public void requestRender(boolean invalidateModel) {
        ScreenView screenView = this.getCurrentScreenView();
        if (screenView != null) {
            if (invalidateModel) {
                screenView.getModel().notifyModified(NlModel.ChangeType.REQUEST_RENDER);
            } else {
                screenView.getModel().requestRender();
            }
        }
    }

    @NotNull
    public JScrollPane getScrollPane() {
        return this.myScrollPane;
    }

    public void requestRender() {
        this.requestRender(true);
    }

    private class MyProgressPanel
    extends JPanel {
        private AsyncProcessIcon mySmallProgressIcon;
        private AsyncProcessIcon myLargeProgressIcon;
        private boolean mySmall;
        private boolean myProgressVisible;

        private MyProgressPanel() {
            super(new BorderLayout());
            this.setOpaque(false);
            this.setVisible(false);
        }

        private void setSmallIcon(boolean small) {
            if (small != this.mySmall) {
                if (this.myProgressVisible && this.getComponentCount() != 0) {
                    AsyncProcessIcon oldIcon = this.getProgressIcon();
                    oldIcon.suspend();
                }
                this.mySmall = true;
                this.removeAll();
                AsyncProcessIcon icon = this.getProgressIcon();
                this.add((Component)icon, "Center");
                if (this.myProgressVisible) {
                    icon.setVisible(true);
                    icon.resume();
                }
            }
        }

        public void showProgressIcon() {
            if (!this.myProgressVisible) {
                boolean hasResult = DesignSurface.this.myScreenView != null && DesignSurface.this.myScreenView.getResult() != null;
                this.setSmallIcon(hasResult);
                this.myProgressVisible = true;
                this.setVisible(true);
                AsyncProcessIcon icon = this.getProgressIcon();
                if (this.getComponentCount() == 0) {
                    this.add((Component)this.getProgressIcon(), "Center");
                } else {
                    icon.setVisible(true);
                }
                icon.resume();
            }
        }

        public void hideProgressIcon() {
            if (this.myProgressVisible) {
                this.myProgressVisible = false;
                this.setVisible(false);
                AsyncProcessIcon icon = this.getProgressIcon();
                icon.setVisible(false);
                icon.suspend();
            }
        }

        @Override
        public void doLayout() {
            super.doLayout();
            this.setBackground((Color)JBColor.RED);
            if (!this.myProgressVisible) {
                return;
            }
            AsyncProcessIcon icon = this.getProgressIcon();
            Dimension size = icon.getPreferredSize();
            if (this.mySmall) {
                icon.setBounds(this.getWidth() - size.width - 1, 1, size.width, size.height);
            } else {
                icon.setBounds(this.getWidth() / 2 - size.width / 2, this.getHeight() / 2 - size.height / 2, size.width, size.height);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getProgressIcon().getPreferredSize();
        }

        @NotNull
        private AsyncProcessIcon getProgressIcon() {
            return this.getProgressIcon(this.mySmall);
        }

        @NotNull
        private AsyncProcessIcon getProgressIcon(boolean small) {
            if (small) {
                if (this.mySmallProgressIcon == null) {
                    this.mySmallProgressIcon = new AsyncProcessIcon("Android layout rendering");
                    Disposer.register((Disposable)DesignSurface.this, (Disposable)this.mySmallProgressIcon);
                }
                return this.mySmallProgressIcon;
            }
            if (this.myLargeProgressIcon == null) {
                this.myLargeProgressIcon = new AsyncProcessIcon.Big("Android layout rendering");
                Disposer.register((Disposable)DesignSurface.this, (Disposable)this.myLargeProgressIcon);
            }
            return this.myLargeProgressIcon;
        }
    }

    private static class GlassPane
    extends JComponent {
        private static final long EVENT_FLAGS = 56L;

        public GlassPane() {
            this.enableEvents(56L);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (enabled) {
                this.enableEvents(56L);
            } else {
                this.disableEvents(56L);
            }
        }

        @Override
        protected void processKeyEvent(KeyEvent event) {
            if (!event.isConsumed()) {
                super.processKeyEvent(event);
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent event) {
            if (event.getID() == 501) {
                this.requestFocusInWindow();
            }
            super.processMouseEvent(event);
        }
    }

    private class MyLayeredPane
    extends JLayeredPane
    implements Magnificator,
    DataProvider {
        public MyLayeredPane() {
            this.setOpaque(true);
            this.setBackground(UIUtil.TRANSPARENT_COLOR);
            this.putClientProperty(Magnificator.CLIENT_PROPERTY_KEY, this);
        }

        public Point magnify(double scale, Point at) {
            DesignSurface.this.setScale(scale * DesignSurface.this.myScale);
            DesignSurface.this.repaint();
            return new Point((int)((double)at.x * scale), (int)((double)at.y * scale));
        }

        @Override
        protected void paintComponent(@NotNull Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D g2d = (Graphics2D)graphics;
            int tlx = DesignSurface.this.myScrollPane.getHorizontalScrollBar().getValue();
            int tly = DesignSurface.this.myScrollPane.getVerticalScrollBar().getValue();
            this.paintBackground(g2d, tlx, tly);
            if (DesignSurface.this.myScreenView == null) {
                return;
            }
            Composite oldComposite = g2d.getComposite();
            RenderResult result = DesignSurface.this.myScreenView.getResult();
            boolean paintedFrame = false;
            if (DesignSurface.this.myDeviceFrames && result != null && result.getRenderedImage() != null) {
                Configuration configuration = DesignSurface.this.myScreenView.getConfiguration();
                Device device = configuration.getDevice();
                State deviceState = configuration.getDeviceState();
                DeviceArtPainter painter = DeviceArtPainter.getInstance();
                if (device != null && painter.hasDeviceFrame(device) && deviceState != null) {
                    paintedFrame = true;
                    g2d.setComposite(AlphaComposite.getInstance(3, 0.8f));
                    painter.paintFrame(g2d, device, deviceState.getOrientation(), true, DesignSurface.this.myScreenX, DesignSurface.this.myScreenY, (int)(DesignSurface.this.myScale * (double)result.getRenderedImage().getHeight()));
                }
            }
            if (paintedFrame) {
                g2d.setComposite(AlphaComposite.getInstance(3, 0.9f));
            } else {
                this.paintBoundsRectangle(g2d);
            }
            g2d.setComposite(oldComposite);
            for (Layer layer : DesignSurface.this.myLayers) {
                if (layer.isHidden()) continue;
                layer.paint(g2d);
            }
            List<Layer> layers = DesignSurface.this.myInteractionManager.getLayers();
            if (layers != null) {
                for (Layer layer : layers) {
                    if (layer.isHidden()) continue;
                    layer.paint(g2d);
                }
            }
        }

        private void paintBackground(@NotNull Graphics2D graphics, int lx, int ly) {
            int width = DesignSurface.this.myScrollPane.getWidth() - 20;
            int height = DesignSurface.this.myScrollPane.getHeight() - 20;
            graphics.setColor((Color)NlConstants.DESIGN_SURFACE_BG);
            graphics.fillRect(20 + lx, 20 + ly, width, height);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintRulers(@NotNull Graphics2D g, int lx, int ly) {
            Graphics2D graphics = (Graphics2D)g.create();
            try {
                int width = DesignSurface.this.myScrollPane.getWidth();
                int height = DesignSurface.this.myScrollPane.getHeight();
                graphics.setColor((Color)NlConstants.RULER_BG);
                graphics.fillRect(lx, ly, width, 20);
                graphics.fillRect(lx, ly + 20, 20, height - 20);
                graphics.setColor((Color)NlConstants.RULER_TICK_COLOR);
                graphics.setStroke(NlConstants.SOLID_STROKE);
                int x = DesignSurface.this.myScreenX + lx - lx % 100;
                int px2 = x + 10 - 100;
                int i = 1;
                while (i < 10) {
                    if (px2 >= DesignSurface.this.myScreenX + lx - 100) {
                        graphics.drawLine(px2, ly, px2, ly + 6);
                    }
                    ++i;
                    px2 += 10;
                }
                int px = 0;
                while (px < width) {
                    graphics.drawLine(x, ly, x, ly + 19);
                    px2 = x + 10;
                    int i2 = 1;
                    while (i2 < 10) {
                        graphics.drawLine(px2, ly, px2, ly + 6);
                        ++i2;
                        px2 += 10;
                    }
                    px += 100;
                    x += 100;
                }
                int y = DesignSurface.this.myScreenY + ly - ly % 100;
                int py2 = y + 10 - 100;
                int i3 = 1;
                while (i3 < 10) {
                    if (py2 >= DesignSurface.this.myScreenY + ly - 100) {
                        graphics.drawLine(lx, py2, lx + 6, py2);
                    }
                    ++i3;
                    py2 += 10;
                }
                int py = 0;
                while (py < height) {
                    graphics.drawLine(lx, y, lx + 19, y);
                    py2 = y + 10;
                    int i4 = 1;
                    while (i4 < 10) {
                        graphics.drawLine(lx, py2, lx + 6, py2);
                        ++i4;
                        py2 += 10;
                    }
                    py += 100;
                    y += 100;
                }
                graphics.setColor((Color)NlConstants.RULER_TEXT_COLOR);
                graphics.setFont(NlConstants.RULER_TEXT_FONT);
                int xDelta = lx - lx % 100;
                x = DesignSurface.this.myScreenX + 2 + xDelta;
                int px3 = 0;
                while (px3 < width) {
                    graphics.drawString(Integer.toString(px3 + xDelta), x, ly + 19);
                    px3 += 100;
                    x += 100;
                }
                graphics.rotate(-1.5707963267948966);
                int yDelta = ly - ly % 100;
                y = DesignSurface.this.myScreenY - 2 + yDelta;
                int py3 = 0;
                while (py3 < height) {
                    graphics.drawString(Integer.toString(py3 + yDelta), -y, lx + 19);
                    py3 += 100;
                    y += 100;
                }
            }
            finally {
                graphics.dispose();
            }
        }

        private void paintBoundsRectangle(Graphics2D g2d) {
            if (DesignSurface.this.myScreenView == null) {
                return;
            }
            g2d.setColor((Color)NlConstants.BOUNDS_RECT_COLOR);
            int x = DesignSurface.this.myScreenX;
            int y = DesignSurface.this.myScreenY;
            Dimension size = DesignSurface.this.myScreenView.getSize();
            Stroke prevStroke = g2d.getStroke();
            g2d.setStroke(NlConstants.DASHED_STROKE);
            Shape screenShape = DesignSurface.this.myScreenView.getScreenShape();
            if (screenShape == null) {
                g2d.drawLine(x - 1, y - 20, x - 1, y + size.height + 20);
                g2d.drawLine(x - 20, y - 1, x + size.width + 20, y - 1);
                g2d.drawLine(x + size.width, y - 20, x + size.width, y + size.height + 20);
                g2d.drawLine(x - 20, y + size.height, x + size.width + 20, y + size.height);
            } else {
                g2d.draw(screenShape);
            }
            g2d.setStroke(prevStroke);
        }

        @Override
        protected void paintChildren(@NotNull Graphics graphics) {
            super.paintChildren(graphics);
            Graphics2D g2d = (Graphics2D)graphics;
            int tlx = DesignSurface.this.myScrollPane.getHorizontalScrollBar().getValue();
            int tly = DesignSurface.this.myScrollPane.getVerticalScrollBar().getValue();
            this.paintRulers(g2d, tlx, tly);
        }

        @Override
        public void doLayout() {
            super.doLayout();
            DesignSurface.this.positionErrorPanel();
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            SelectionModel selectionModel;
            NlComponent primary;
            if (CommonDataKeys.PSI_ELEMENT.is(dataId) && DesignSurface.this.myScreenView != null && (primary = (selectionModel = DesignSurface.this.myScreenView.getSelectionModel()).getPrimary()) != null) {
                return primary.getTag();
            }
            if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId) && DesignSurface.this.myScreenView != null) {
                selectionModel = DesignSurface.this.myScreenView.getSelectionModel();
                List<NlComponent> selection = selectionModel.getSelection();
                ArrayList list = Lists.newArrayListWithCapacity((int)selection.size());
                for (NlComponent component : selection) {
                    list.add(component.getTag());
                }
                return list.toArray(new XmlTag[0]);
            }
            return null;
        }
    }

    private static class MyScrollBar
    extends JBScrollBar
    implements IdeGlassPane.TopComponent {
        private ScrollBarUI myPersistentUI;

        private MyScrollBar(@JdkConstants.AdjustableOrientation int orientation) {
            super(orientation);
            this.setOpaque(false);
        }

        public boolean canBePreprocessed(MouseEvent e) {
            return JBScrollPane.canBePreprocessed((MouseEvent)e, (JScrollBar)((Object)this));
        }

        public void setUI(ScrollBarUI ui) {
            if (this.myPersistentUI == null) {
                this.myPersistentUI = ui;
            }
            super.setUI(this.myPersistentUI);
            this.setOpaque(false);
        }

        public int getUnitIncrement(int direction) {
            return 5;
        }

        public int getBlockIncrement(int direction) {
            return 1;
        }
    }

    private static class MyScrollPane
    extends JBScrollPane {
        private MyScrollPane() {
            super(0);
            this.setOpaque(true);
            this.setBackground(UIUtil.TRANSPARENT_COLOR);
            this.setupCorners();
        }

        @NotNull
        public JScrollBar createVerticalScrollBar() {
            return new MyScrollBar(1);
        }

        @NotNull
        public JScrollBar createHorizontalScrollBar() {
            return new MyScrollBar(0);
        }

        protected boolean isOverlaidScrollbar(@Nullable JScrollBar scrollbar) {
            ScrollBarUI vsbUI = scrollbar == null ? null : scrollbar.getUI();
            return vsbUI instanceof ButtonlessScrollBarUI && !((ButtonlessScrollBarUI)vsbUI).alwaysShowTrack();
        }
    }

    public static enum ScreenMode {
        SCREEN_ONLY(ScreenView.ScreenViewType.NORMAL),
        BLUEPRINT_ONLY(ScreenView.ScreenViewType.BLUEPRINT),
        BOTH(ScreenView.ScreenViewType.NORMAL);

        private final ScreenView.ScreenViewType myScreenViewType;
        private static final String SCREEN_MODE_PROPERTY = "NlScreenMode";

        private ScreenMode(ScreenView.ScreenViewType screenViewType) {
            this.myScreenViewType = screenViewType;
        }

        @NotNull
        public ScreenMode next() {
            ScreenMode[] values = ScreenMode.values();
            return values[(this.ordinal() + 1) % values.length];
        }

        @NotNull
        private ScreenView.ScreenViewType getScreenViewType() {
            return this.myScreenViewType;
        }

        @NotNull
        public static ScreenMode loadDefault() {
            String modeName = PropertiesComponent.getInstance().getValue(SCREEN_MODE_PROPERTY);
            for (ScreenMode mode : ScreenMode.values()) {
                if (!mode.name().equals(modeName)) continue;
                return mode;
            }
            return BOTH;
        }

        public static void saveDefault(@NotNull ScreenMode mode) {
            PropertiesComponent.getInstance().setValue(SCREEN_MODE_PROPERTY, mode.name());
        }
    }
}

