/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.ItemTransferable;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlDropEvent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.structure.NlComponentTree;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.utils.Pair;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Rectangle;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlDropListener
extends DropTargetAdapter {
    private final List<NlComponent> myDragged = new ArrayList<NlComponent>();
    private final NlComponentTree myTree;
    private DnDTransferItem myTransferItem;
    private NlComponent myDragReceiver;
    private NlComponent myNextDragSibling;

    public NlDropListener(@NotNull NlComponentTree tree) {
        this.myTree = tree;
    }

    @Override
    public void dragEnter(@NotNull DropTargetDragEvent dragEvent) {
        NlDropEvent event = new NlDropEvent(dragEvent);
        this.captureDraggedComponents(event, true);
        this.updateInsertionPoint(event);
    }

    @Override
    public void dragOver(@NotNull DropTargetDragEvent dragEvent) {
        NlDropEvent event = new NlDropEvent(dragEvent);
        this.updateInsertionPoint(event);
    }

    @Override
    public void dragExit(@NotNull DropTargetEvent event) {
        this.clearInsertionPoint();
        this.clearDraggedComponents();
    }

    @Override
    public void drop(@NotNull DropTargetDropEvent dropEvent) {
        NlDropEvent event = new NlDropEvent(dropEvent);
        InsertType insertType = this.captureDraggedComponents(event, false);
        if (this.findInsertionPoint(event) != null) {
            this.performDrop(dropEvent, insertType);
        }
        this.clearInsertionPoint();
        this.clearDraggedComponents();
    }

    @Nullable
    private InsertType captureDraggedComponents(@NotNull NlDropEvent event, boolean isPreview) {
        this.clearDraggedComponents();
        ScreenView screenView = this.myTree.getScreenView();
        if (screenView == null) {
            return null;
        }
        NlModel model = screenView.getModel();
        if (event.isDataFlavorSupported(ItemTransferable.DESIGNER_FLAVOR)) {
            try {
                this.myTransferItem = (DnDTransferItem)event.getTransferable().getTransferData(ItemTransferable.DESIGNER_FLAVOR);
                InsertType insertType = this.determineInsertType(event, isPreview);
                if (insertType.isMove()) {
                    this.myDragged.addAll(model.getSelectionModel().getSelection());
                } else {
                    Collection captured = (Collection)ApplicationManager.getApplication().runWriteAction(() -> model.createComponents(screenView, this.myTransferItem, insertType));
                    if (captured != null) {
                        this.myDragged.addAll(captured);
                    }
                }
                return insertType;
            }
            catch (UnsupportedFlavorException | IOException exception) {
                Logger.getInstance(NlDropListener.class).warn((Throwable)exception);
            }
        }
        return null;
    }

    @NotNull
    private InsertType determineInsertType(@NotNull NlDropEvent event, boolean isPreview) {
        NlModel model = this.myTree.getDesignerModel();
        if (model == null || this.myTransferItem == null) {
            return InsertType.MOVE_INTO;
        }
        DragType dragType = event.getDropAction() == 1 ? DragType.COPY : DragType.MOVE;
        return model.determineInsertType(dragType, this.myTransferItem, isPreview);
    }

    private void clearDraggedComponents() {
        this.myDragged.clear();
    }

    private void updateInsertionPoint(@NotNull NlDropEvent event) {
        Pair<TreePath, NlComponentTree.InsertionPoint> point = this.findInsertionPoint(event);
        if (point == null) {
            this.clearInsertionPoint();
            event.reject();
        } else {
            this.myTree.markInsertionPoint((TreePath)point.getFirst(), (NlComponentTree.InsertionPoint)((Object)point.getSecond()));
            event.accept(this.determineInsertType(event, true) == InsertType.COPY ? event.getDropAction() : 1);
        }
    }

    @Nullable
    private Pair<TreePath, NlComponentTree.InsertionPoint> findInsertionPoint(@NotNull NlDropEvent event) {
        this.myDragReceiver = null;
        this.myNextDragSibling = null;
        TreePath path = this.myTree.getClosestPathForLocation(event.getLocation().x, event.getLocation().y);
        if (path == null) {
            return null;
        }
        ScreenView screenView = this.myTree.getScreenView();
        if (screenView == null) {
            return null;
        }
        NlModel model = screenView.getModel();
        NlComponent component = (NlComponent)path.getLastPathComponent();
        if (component == null) {
            return null;
        }
        Rectangle bounds = this.myTree.getPathBounds(path);
        if (bounds == null) {
            return null;
        }
        NlComponentTree.InsertionPoint insertionPoint = NlDropListener.findTreeStateInsertionPoint(event.getLocation().y, bounds);
        ViewHandler handler = component.getViewHandler();
        if (insertionPoint == NlComponentTree.InsertionPoint.INSERT_INTO && handler instanceof ViewGroupHandler) {
            if (!model.canAddComponents(this.myDragged, component, component.getChild(0))) {
                return null;
            }
            this.myDragReceiver = component;
            this.myNextDragSibling = component.getChild(0);
        } else {
            NlComponent parent = component.getParent();
            if (parent == null) {
                return null;
            }
            if (parent.getViewHandler() == null || !model.canAddComponents(this.myDragged, parent, component)) {
                return null;
            }
            insertionPoint = (double)event.getLocation().y > bounds.getCenterY() ? NlComponentTree.InsertionPoint.INSERT_AFTER : NlComponentTree.InsertionPoint.INSERT_BEFORE;
            this.myDragReceiver = parent;
            this.myNextDragSibling = insertionPoint == NlComponentTree.InsertionPoint.INSERT_BEFORE ? component : component.getNextSibling();
        }
        return Pair.of((Object)path, (Object)((Object)insertionPoint));
    }

    @NotNull
    private static NlComponentTree.InsertionPoint findTreeStateInsertionPoint(int y, @NotNull Rectangle bounds) {
        int delta = bounds.height / 9;
        if (bounds.y + delta > y) {
            return NlComponentTree.InsertionPoint.INSERT_BEFORE;
        }
        if (bounds.y + bounds.height - delta < y) {
            return NlComponentTree.InsertionPoint.INSERT_AFTER;
        }
        return NlComponentTree.InsertionPoint.INSERT_INTO;
    }

    private void clearInsertionPoint() {
        this.myTree.markInsertionPoint(null, NlComponentTree.InsertionPoint.INSERT_BEFORE);
    }

    private void performDrop(@NotNull DropTargetDropEvent event, InsertType insertType) {
        this.myTree.skipNextUpdateDelay();
        NlModel model = this.myTree.getDesignerModel();
        assert (model != null);
        try {
            model.addComponents(this.myDragged, this.myDragReceiver, this.myNextDragSibling, insertType);
            event.acceptDrop(insertType == InsertType.COPY ? event.getDropAction() : 1);
            event.dropComplete(true);
            model.notifyModified(NlModel.ChangeType.DROP);
        }
        catch (Exception exception) {
            Logger.getInstance(NlDropListener.class).warn((Throwable)exception);
            event.rejectDrop();
        }
    }
}

