/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.renderer;

import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.renderer.NlAttributeRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlBooleanRenderer
extends NlAttributeRenderer {
    private final ThreeStateCheckBox myCheckbox;
    private final SimpleColoredComponent myLabel;

    public NlBooleanRenderer() {
        JPanel panel = this.getContentPanel();
        this.myCheckbox = new ThreeStateCheckBox();
        panel.add((Component)this.myCheckbox, "Before");
        this.myLabel = new SimpleColoredComponent();
        panel.add((Component)this.myLabel, "Center");
    }

    @Override
    public void customizeRenderContent(@NotNull JTable table, @NotNull NlProperty p, boolean selected, boolean hasFocus, int row, int col) {
        ResourceResolver resourceResolver;
        this.myCheckbox.setEnabled(true);
        this.myLabel.clear();
        String propValue = p.getValue();
        ThreeStateCheckBox.State state = NlBooleanRenderer.getState(propValue);
        if (state == null && propValue != null && (resourceResolver = p.getResolver()) != null) {
            this.myLabel.append(propValue, NlBooleanRenderer.modifyAttributes(selected, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES));
            String resolvedValue = resourceResolver.findResValue(propValue, false).getValue();
            state = NlBooleanRenderer.getState(resolvedValue);
        }
        if (state != null) {
            this.myCheckbox.setEnabled(true);
            this.myCheckbox.setState(state);
        } else {
            this.myCheckbox.setEnabled(false);
        }
    }

    @NotNull
    private static SimpleTextAttributes modifyAttributes(boolean selected, SimpleTextAttributes attributes) {
        return selected ? new SimpleTextAttributes(attributes.getStyle(), UIUtil.getTableSelectionForeground()) : attributes;
    }

    @Nullable
    public static ThreeStateCheckBox.State getState(@Nullable String s) {
        if (s == null) {
            return ThreeStateCheckBox.State.DONT_CARE;
        }
        if ("true".equalsIgnoreCase(s)) {
            return ThreeStateCheckBox.State.SELECTED;
        }
        if ("false".equalsIgnoreCase(s)) {
            return ThreeStateCheckBox.State.NOT_SELECTED;
        }
        return null;
    }

    @Nullable
    public static Boolean getBoolean(ThreeStateCheckBox.State state) {
        switch (state) {
            case DONT_CARE: {
                return null;
            }
            case SELECTED: {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public static Boolean getNextState(ThreeStateCheckBox.State state) {
        switch (state) {
            case DONT_CARE: {
                return Boolean.TRUE;
            }
            case SELECTED: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @Override
    public boolean canRender(@NotNull NlProperty item, @NotNull Set<AttributeFormat> formats) {
        return formats.contains((Object)AttributeFormat.Boolean);
    }
}

