/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.inspector.InspectorComponent;
import com.android.tools.idea.uibuilder.property.inspector.InspectorPanel;
import com.android.tools.idea.uibuilder.property.inspector.InspectorProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import icons.AndroidIcons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewInspectorProvider
implements InspectorProvider,
ProjectComponent,
LafManagerListener {
    private static final Set<String> TAG_EXCEPTIONS = ImmutableSet.of((Object)"TextView", (Object)"ProgressBar");
    private final ViewHandlerManager myViewHandlerManager;
    private final Map<String, InspectorComponent> myInspectors;

    @NotNull
    public static ViewInspectorProvider getInstance(@NotNull Project project) {
        return (ViewInspectorProvider)project.getComponent(ViewInspectorProvider.class);
    }

    private ViewInspectorProvider(@NotNull Project project) {
        this.myViewHandlerManager = ViewHandlerManager.get(project);
        this.myInspectors = new HashMap<String, InspectorComponent>();
    }

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components.size() != 1) {
            return false;
        }
        String tagName = components.get(0).getTagName();
        if (TAG_EXCEPTIONS.contains(tagName)) {
            return false;
        }
        if (this.myInspectors.containsKey(tagName)) {
            return true;
        }
        ViewHandler handler = this.myViewHandlerManager.getHandler(tagName);
        if (handler == null || handler.getInspectorProperties().isEmpty()) {
            return false;
        }
        this.myInspectors.put(tagName, new ViewInspectorComponent(tagName, properties, propertiesManager, handler.getInspectorProperties()));
        return true;
    }

    @Override
    @NotNull
    public InspectorComponent createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        assert (components.size() == 1);
        String tagName = components.get(0).getTagName();
        InspectorComponent inspector = this.myInspectors.get(tagName);
        assert (inspector != null);
        inspector.updateProperties(components, properties, propertiesManager);
        return inspector;
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void initComponent() {
        LafManager.getInstance().addLafManagerListener((LafManagerListener)this);
    }

    public void disposeComponent() {
        LafManager.getInstance().removeLafManagerListener((LafManagerListener)this);
    }

    public void lookAndFeelChanged(LafManager source) {
        this.myInspectors.clear();
    }

    @NotNull
    public String getComponentName() {
        return ViewInspectorProvider.class.getSimpleName();
    }

    private static class ViewInspectorComponent
    implements InspectorComponent {
        private static final List<String> LAYOUT_PROPERTIES = ImmutableList.of((Object)"layout_scrollFlags", (Object)"layout_collapseMode", (Object)"layout_collapseParallaxMultiplier", (Object)"layout_behavior");
        private final String myComponentName;
        private final List<String> myPropertyNames;
        private final Map<String, NlComponentEditor> myEditors;
        private Map<String, NlProperty> myProperties;

        public ViewInspectorComponent(@NotNull String tagName, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager, @NotNull List<String> propertyNames) {
            this.myComponentName = tagName.substring(tagName.lastIndexOf(46) + 1);
            this.myPropertyNames = ViewInspectorComponent.combineLists(propertyNames, LAYOUT_PROPERTIES);
            this.useSrcCompatIfExist(properties);
            this.myEditors = new HashMap<String, NlComponentEditor>(propertyNames.size());
            this.myProperties = properties;
            for (String propertyName : propertyNames) {
                NlProperty property = properties.get(propertyName);
                if (property == null) continue;
                this.myEditors.put(propertyName, propertiesManager.getPropertyEditors().create(property));
            }
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            this.myProperties = properties;
            for (String propertyName : this.myPropertyNames) {
                NlProperty property = properties.get(propertyName);
                if (property == null || this.myEditors.containsKey(propertyName)) continue;
                this.myEditors.put(propertyName, propertiesManager.getPropertyEditors().create(property));
            }
        }

        @Override
        public int getMaxNumberOfRows() {
            return 1 + this.myEditors.size();
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            this.refresh();
            inspector.addTitle(this.myComponentName);
            for (String propertyName : this.myPropertyNames) {
                if (!this.myProperties.containsKey(propertyName)) continue;
                NlProperty property = this.myProperties.get(propertyName);
                JLabel label = inspector.addComponent(propertyName, property.getTooltipText(), this.myEditors.get(propertyName).getComponent());
                if (!"http://schemas.android.com/tools".equals(property.getNamespace())) continue;
                label.setIcon(AndroidIcons.NeleIcons.DesignProperty);
            }
        }

        @Override
        public void refresh() {
            for (String propertyName : this.myPropertyNames) {
                if (!this.myProperties.containsKey(propertyName)) continue;
                this.myEditors.get(propertyName).setProperty(this.myProperties.get(propertyName));
            }
        }

        @Override
        @Nullable
        public NlComponentEditor getEditorForProperty(@NotNull String propertyName) {
            return this.myEditors.get(propertyName);
        }

        @NotNull
        private static List<String> combineLists(@NotNull List<String> list1, @NotNull List<String> list2) {
            ArrayList<String> combined = new ArrayList<String>(list1.size() + list2.size());
            combined.addAll(list1);
            combined.addAll(list2);
            return combined;
        }

        private void useSrcCompatIfExist(@NotNull Map<String, NlProperty> properties) {
            int index;
            if (properties.containsKey("srcCompat") && (index = this.myPropertyNames.indexOf("src")) >= 0) {
                this.myPropertyNames.set(index, "srcCompat");
            }
        }
    }
}

