/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlDesignProperties;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.inspector.IdInspectorProvider;
import com.android.tools.idea.uibuilder.property.inspector.InspectorComponent;
import com.android.tools.idea.uibuilder.property.inspector.InspectorProvider;
import com.android.tools.idea.uibuilder.property.inspector.ProgressBarInspectorProvider;
import com.android.tools.idea.uibuilder.property.inspector.TextInspectorProvider;
import com.android.tools.idea.uibuilder.property.inspector.ViewInspectorProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectorPanel
extends JPanel {
    private static final List<String> PREFERRED_PROPERTY_NAMES = ImmutableList.of((Object)"text", (Object)"src", (Object)"id");
    private static final int HORIZONTAL_SPACING = 6;
    private final JComponent myAllPropertiesLink;
    private final List<InspectorProvider> myProviders;
    private final NlDesignProperties myDesignProperties;
    private final Font myBoldLabelFont = UIUtil.getLabelFont().deriveFont(1);
    private final Icon myExpandedIcon;
    private final Icon myCollapsedIcon;
    private final JPanel myInspector;
    private List<InspectorComponent> myInspectors = Collections.emptyList();
    private List<Component> myGroup;
    private boolean myGroupInitiallyOpen;
    private GridConstraints myConstraints = new GridConstraints();
    private int myRow;
    private boolean myActivateEditorAfterLoad;

    public InspectorPanel(@NotNull Project project, @NotNull JComponent allPropertiesLink) {
        super(new BorderLayout());
        this.myAllPropertiesLink = allPropertiesLink;
        this.myAllPropertiesLink.setBorder(BorderFactory.createEmptyBorder(5, 0, 10, 0));
        this.myProviders = InspectorPanel.createProviders(project);
        this.myDesignProperties = new NlDesignProperties();
        this.myExpandedIcon = (Icon)UIManager.get("Tree.expandedIcon");
        this.myCollapsedIcon = (Icon)UIManager.get("Tree.collapsedIcon");
        this.myInspector = new GridInspectorPanel();
        this.myInspector.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        this.add((Component)this.myInspector, "Center");
    }

    private static List<InspectorProvider> createProviders(@NotNull Project project) {
        return ImmutableList.of((Object)new IdInspectorProvider(), (Object)ViewInspectorProvider.getInstance(project), (Object)new ProgressBarInspectorProvider(), (Object)new TextInspectorProvider());
    }

    private static GridLayoutManager createLayoutManager(int rows, int columns) {
        Insets margin = new Insets(0, 0, 0, 0);
        return new GridLayoutManager(rows, columns, margin, 0, 0);
    }

    public void setComponent(@NotNull List<NlComponent> components, @NotNull Table<String, String, ? extends NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        this.myInspector.setLayout(null);
        this.myInspector.removeAll();
        this.myRow = 0;
        if (!components.isEmpty()) {
            HashMap propertiesByName = Maps.newHashMapWithExpectedSize((int)properties.size());
            for (NlProperty property : properties.row((Object)"http://schemas.android.com/apk/res/android").values()) {
                propertiesByName.put(property.getName(), property);
            }
            for (NlProperty property : properties.row((Object)"http://schemas.android.com/apk/res-auto").values()) {
                propertiesByName.put(property.getName(), property);
            }
            for (NlProperty property : properties.row((Object)"").values()) {
                propertiesByName.put(property.getName(), property);
            }
            for (NlProperty property : this.myDesignProperties.getKnownProperties(components)) {
                propertiesByName.putIfAbsent(property.getName(), property);
            }
            List<InspectorComponent> inspectors = InspectorPanel.createInspectorComponents(components, propertiesManager, propertiesByName, this.myProviders);
            this.myInspectors = inspectors;
            int rows = 0;
            for (InspectorComponent inspector : inspectors) {
                rows += inspector.getMaxNumberOfRows();
            }
            rows += inspectors.size();
            this.myInspector.setLayout((LayoutManager)InspectorPanel.createLayoutManager(rows += 2, 2));
            for (InspectorComponent inspector : inspectors) {
                this.addSeparator();
                inspector.attachToInspector(this);
            }
            this.endGroup();
            this.addSeparator();
            this.myInspector.add((Component)new Spacer(), new GridConstraints(this.myRow++, 0, 1, 2, 0, 1, 2, 6, null, null, null, 0, false));
            this.addLineComponent(this.myAllPropertiesLink, this.myRow++);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            this.revalidate();
            this.repaint();
            if (this.myActivateEditorAfterLoad) {
                this.activatePreferredEditor();
            }
        });
    }

    public void refresh() {
        ApplicationManager.getApplication().invokeLater(() -> this.myInspectors.stream().forEach(InspectorComponent::refresh));
    }

    @NotNull
    private static List<InspectorComponent> createInspectorComponents(@NotNull List<NlComponent> components, @NotNull NlPropertiesManager propertiesManager, @NotNull Map<String, NlProperty> properties, @NotNull List<InspectorProvider> allProviders) {
        ArrayList inspectors = Lists.newArrayListWithExpectedSize((int)allProviders.size());
        if (components.isEmpty()) {
            return ImmutableList.of((Object)new IdInspectorProvider().createCustomInspector(components, properties, propertiesManager));
        }
        for (InspectorProvider provider : allProviders) {
            if (!provider.isApplicable(components, properties, propertiesManager)) continue;
            inspectors.add(provider.createCustomInspector(components, properties, propertiesManager));
        }
        return inspectors;
    }

    public boolean activatePreferredEditor(boolean activateAfterLoading) {
        if (activateAfterLoading) {
            this.myActivateEditorAfterLoad = true;
        } else {
            this.activatePreferredEditor();
        }
        return true;
    }

    private void activatePreferredEditor() {
        this.myActivateEditorAfterLoad = false;
        for (String preferredPropertyName : PREFERRED_PROPERTY_NAMES) {
            for (InspectorComponent component : this.myInspectors) {
                NlComponentEditor editor = component.getEditorForProperty(preferredPropertyName);
                if (editor == null) continue;
                editor.requestFocus();
                return;
            }
        }
    }

    public JLabel addTitle(@NotNull String title) {
        JLabel label = InspectorPanel.createLabel(title, null, null);
        label.setFont(this.myBoldLabelFont);
        this.addLineComponent(label, this.myRow++);
        return label;
    }

    public void addSeparator() {
        this.endGroup();
        if (this.myRow > 0) {
            this.addLineComponent(new JSeparator(), this.myRow++);
        }
    }

    public JLabel addExpandableComponent(@NotNull String labelText, @Nullable String tooltip, @NotNull Component component) {
        JLabel label = InspectorPanel.createLabel(labelText, tooltip, component);
        this.addLabelComponent(label, this.myRow);
        this.addValueComponent(component, this.myRow++);
        this.startGroup(label);
        return label;
    }

    public JLabel addComponent(@NotNull String labelText, @Nullable String tooltip, @NotNull Component component) {
        JLabel label = InspectorPanel.createLabel(labelText, tooltip, component);
        this.addLabelComponent(label, this.myRow);
        this.addValueComponent(component, this.myRow++);
        return label;
    }

    public void addPanel(@NotNull JComponent panel) {
        this.addLineComponent(panel, this.myRow++);
    }

    private static JLabel createLabel(@NotNull String labelText, @Nullable String tooltip, @Nullable Component component) {
        JBLabel label = new JBLabel(labelText);
        label.setLabelFor(component);
        label.setToolTipText(tooltip);
        return label;
    }

    private void addLineComponent(@NotNull Component component, int row) {
        this.addComponent(component, row, 0, 2, 8, 1);
    }

    private void addLabelComponent(@NotNull Component component, int row) {
        this.addComponent(component, row, 0, 1, 8, 1);
    }

    private void addValueComponent(@NotNull Component component, int row) {
        this.addComponent(component, row, 1, 1, 4, 1);
    }

    private void addComponent(@NotNull Component component, int row, int column, int columnSpan, int anchor, int fill) {
        this.addToGridPanel(this.myInspector, component, row, column, columnSpan, anchor, fill);
        if (this.myGroup != null) {
            this.myGroup.add(component);
            component.setVisible(this.myGroupInitiallyOpen);
        }
    }

    private void addToGridPanel(@NotNull JPanel panel, @NotNull Component component, int row, int column, int columnSpan, int anchor, int fill) {
        this.myConstraints.setRow(row);
        this.myConstraints.setColumn(column);
        this.myConstraints.setColSpan(columnSpan);
        this.myConstraints.setAnchor(anchor);
        this.myConstraints.setFill(fill);
        panel.add(component, this.myConstraints);
    }

    private void startGroup(final @NotNull JLabel label) {
        assert (this.myGroup == null);
        final ArrayList<Component> group = new ArrayList<Component>();
        final String savedKey = "inspector.open." + label.getText();
        this.myGroupInitiallyOpen = PropertiesComponent.getInstance().getBoolean(savedKey);
        label.setIcon(this.myGroupInitiallyOpen ? this.myExpandedIcon : this.myCollapsedIcon);
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                boolean wasExpanded = label.getIcon() == InspectorPanel.this.myExpandedIcon;
                label.setIcon(wasExpanded ? InspectorPanel.this.myCollapsedIcon : InspectorPanel.this.myExpandedIcon);
                group.stream().forEach(component -> component.setVisible(!wasExpanded));
                PropertiesComponent.getInstance().setValue(savedKey, !wasExpanded);
            }
        });
        this.myGroup = group;
    }

    private void endGroup() {
        this.myGroup = null;
    }

    private static class GridInspectorPanel
    extends JPanel {
        private int myWidth;

        private GridInspectorPanel() {
        }

        @Override
        public void setLayout(LayoutManager layoutManager) {
            this.myWidth = -1;
            super.setLayout(layoutManager);
        }

        @Override
        public void doLayout() {
            this.updateGridConstraints();
            super.doLayout();
        }

        private void updateGridConstraints() {
            LayoutManager layoutManager = this.getLayout();
            if (layoutManager instanceof GridLayoutManager) {
                GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
                if (this.getWidth() != this.myWidth) {
                    this.myWidth = this.getWidth();
                    for (Component component : this.getComponents()) {
                        GridConstraints constraints = gridLayoutManager.getConstraintsForComponent(component);
                        if (constraints == null) continue;
                        this.updateMinimumSize(constraints);
                    }
                }
            }
        }

        private void updateMinimumSize(@NotNull GridConstraints constraints) {
            if (constraints.getColSpan() == 1) {
                if (constraints.getColumn() == 0) {
                    constraints.myMinimumSize.setSize((double)(this.myWidth - 12) * 0.4, -1.0);
                } else if (constraints.getColumn() == 1) {
                    constraints.myMinimumSize.setSize((double)(this.myWidth - 12) * 0.6, -1.0);
                }
            }
        }
    }
}

