/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.tools.idea.uibuilder.property.NlProperty;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Quantity
implements Comparable<Quantity> {
    private static final Pattern QUANTITY_PATTERN = Pattern.compile("^(\\d+(\\.\\d+)?)(.*)$");
    private final int myValue;
    private final String myUnit;

    @Nullable
    public static Quantity parse(@NotNull String value) {
        Matcher matcher = QUANTITY_PATTERN.matcher(value);
        if (!matcher.matches()) {
            return null;
        }
        try {
            return new Quantity(Integer.parseInt(matcher.group(1)), matcher.group(3));
        }
        catch (NumberFormatException ignore) {
            return null;
        }
    }

    @NotNull
    public static String addUnit(@NotNull NlProperty property, @NotNull String value) {
        boolean isDimension;
        AttributeDefinition definition = property.getDefinition();
        boolean bl = isDimension = definition != null && definition.getFormats().contains((Object)AttributeFormat.Dimension);
        if (!isDimension) {
            return value;
        }
        Quantity quantity = Quantity.parse(value);
        if (quantity == null || !quantity.myUnit.isEmpty()) {
            return value;
        }
        switch (property.getName()) {
            case "textSize": 
            case "lineSpacingExtra": {
                return quantity.myValue + "sp";
            }
        }
        return quantity.myValue + "dp";
    }

    private Quantity(int value, @NotNull String unit) {
        this.myValue = value;
        this.myUnit = unit;
    }

    private int getValue() {
        return this.myValue;
    }

    @NotNull
    private String getUnit() {
        return this.myUnit;
    }

    @Override
    public int compareTo(@Nullable Quantity other) {
        if (other == null) {
            return -1;
        }
        return Comparator.comparing(Quantity::getUnit).thenComparing(Quantity::getValue).compare(this, other);
    }
}

