/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.assetstudiolib.AndroidVectorIcons;
import com.android.tools.adtui.common.RotatedLabel;
import com.android.tools.idea.uibuilder.property.NlFlagPropertyItem;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlEnumEditor;
import com.android.tools.idea.uibuilder.property.editors.NlGravityEditor;
import com.android.tools.idea.uibuilder.property.editors.NlReferenceEditor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlLayoutEditor
extends JPanel {
    private static final Font SMALL_FONT = UIUtil.getLabelFont().deriveFont(JBUI.scale((float)8.0f));
    private static final Font SMALL_BOLD_FONT = SMALL_FONT.deriveFont(1);
    private static final Font SMALL_LINK_FONT = SMALL_FONT.deriveFont((Map<? extends AttributedCharacterIterator.Attribute, ?>)ImmutableMap.of((Object)TextAttribute.UNDERLINE, (Object)TextAttribute.UNDERLINE_ON));
    private static final JBColor PURPLE = new JBColor(new Color(180, 167, 214), new Color(132, 119, 166));
    private static final JBColor ORANGE = new JBColor(new Color(249, 203, 156), new Color(183, 149, 114));
    private static final JBColor GREEN = new JBColor(new Color(182, 215, 168), new Color(134, 158, 123));
    private static final JBColor RED = new JBColor(new Color(234, 153, 153), new Color(172, 112, 112));
    private static final JBColor YELLOW = new JBColor(new Color(255, 252, 170), new Color(187, 187, 0));
    private static final JBColor BLACK = new JBColor((Color)Gray._0, (Color)Gray._0);
    private static final JBColor WHITE = new JBColor((Color)Gray._255, (Color)Gray._255);
    private static final JBColor LINK_COLOR = JBColor.BLUE;
    private static final Dimension ourFontSize = NlLayoutEditor.measureFontSize();
    private static final int MULTI_CLICK_INTERVAL = NlLayoutEditor.getDefaultClickInterval();
    private static final String GRAVITY_DISPLAY_TABLE_KEY = "GravityDisplayTable";
    private static final String ATTRIBUTE_DEPENDENCY_KEY = "AttributeDependency";
    private static final String DIRECTION_LABEL_KEY = "DirectionLabel";
    private static final String TOP_TITLE_PREFIX = "Top ";
    private static final String BOTTOM_TITLE_PREFIX = "Bottom ";
    private static final String START_TITLE_PREFIX = "Start ";
    private static final String END_TITLE_PREFIX = "End ";
    private static final String LEFT_TITLE_PREFIX = "Left ";
    private static final String RIGHT_TITLE_PREFIX = "Right ";
    private static final String EDIT_TEXT_VALUE = "edit";
    private static final String EMPTY_TEXT_VALUE = " ";
    private final List<CardinalDirectionControls> myControls = new ArrayList<CardinalDirectionControls>();
    private final NlEnumEditor myEnumEditor;
    private final NlReferenceEditor myReferenceEditor;
    private final NlGravityEditor myGravityEditor;
    private final JPanel myConstraintMarginPanel = this.createPanel(ControlGroup.CONSTRAINT_MARGIN, "Constraint Margin", GREEN);
    private final JPanel myLayoutGravityPanel = this.createPanel(ControlGroup.LAYOUT_GRAVITY, "Layout Gravity", ORANGE);
    private final JPanel myLayoutMarginPanel = this.createPanel(ControlGroup.LAYOUT_MARGIN, "Layout Margin", GREEN);
    private final JPanel myPaddingPanel = this.createPanel(ControlGroup.PADDING, "Padding", PURPLE);
    private final JPanel myGravityPanel = this.createPanel(ControlGroup.GRAVITY, "Gravity", RED);
    private final JPanel myLayoutPanel = this.createPanel(ControlGroup.LAYOUT, "Layout", YELLOW);
    private Map<String, NlProperty> myProperties;
    private NlComponentEditor myActiveEditor;

    public NlLayoutEditor(@NotNull Project project) {
        super(new BorderLayout());
        this.myEnumEditor = NlEnumEditor.createForInspector(this.createEnumListener());
        this.myReferenceEditor = NlReferenceEditor.createForInspector(project, this.createReferenceListener());
        this.myGravityEditor = new NlGravityEditor();
    }

    public NlEnumEditor getEnumPropertyEditor() {
        return this.myEnumEditor;
    }

    public NlReferenceEditor getReferencePropertyEditor() {
        return this.myReferenceEditor;
    }

    public NlGravityEditor getGravityEditor() {
        return this.myGravityEditor;
    }

    public void setSelectedComponents(@NotNull Map<String, NlProperty> properties) {
        this.myProperties = properties;
        this.removeAll();
        if (this.hasProperties("gravity")) {
            this.myPaddingPanel.add((Component)this.myGravityPanel, "Center");
        }
        this.myLayoutPanel.add((Component)this.myPaddingPanel, "Center");
        if (this.hasProperties("layout_margin", "layout_gravity")) {
            this.myLayoutMarginPanel.add((Component)this.myLayoutPanel, "Center");
            this.myLayoutGravityPanel.add((Component)this.myLayoutMarginPanel, "Center");
            this.add((Component)this.myLayoutGravityPanel, "Center");
        } else {
            this.myConstraintMarginPanel.add((Component)this.myLayoutPanel, "Center");
            this.add((Component)this.myConstraintMarginPanel, "Center");
        }
    }

    private boolean hasProperties(String ... propertyNames) {
        for (String propertyName : propertyNames) {
            if (this.myProperties.containsKey(propertyName)) continue;
            return false;
        }
        return true;
    }

    public void refresh() {
        this.myControls.forEach(control -> control.refresh(this.myProperties));
        if (this.myActiveEditor != null) {
            this.myActiveEditor.refresh();
        }
    }

    public void setHoverAttributes(@NotNull MouseEvent event, @NotNull Font font, @NotNull Color foregroundColor, @NotNull Color backgroundColor) {
        if (event.getSource() instanceof Component) {
            Component component;
            for (component = (Component)event.getSource(); component != null && !component.isOpaque(); component = component.getParent()) {
            }
            if (component instanceof JComponent) {
                JComponent direction = (JComponent)component;
                Object dependency = direction.getClientProperty(ATTRIBUTE_DEPENDENCY_KEY);
                Object gravityTable = direction.getClientProperty(GRAVITY_DISPLAY_TABLE_KEY);
                if (dependency != null || gravityTable != null) {
                    component.setBackground(backgroundColor);
                    Object directionLabel = direction.getClientProperty(DIRECTION_LABEL_KEY);
                    if (directionLabel instanceof Component) {
                        component = (Component)directionLabel;
                    }
                    if (component instanceof JLabel) {
                        JLabel label = (JLabel)component;
                        label.setFont(font);
                        label.setForeground(foregroundColor);
                        if (foregroundColor.equals(LINK_COLOR)) {
                            if (label.getText().equals(EMPTY_TEXT_VALUE)) {
                                label.setText(EDIT_TEXT_VALUE);
                            }
                        } else if (label.getText().equals(EDIT_TEXT_VALUE)) {
                            label.setText(EMPTY_TEXT_VALUE);
                        }
                    }
                }
            }
        }
    }

    private void startEditing(@NotNull NlComponentEditor editor, @NotNull MouseEvent event) {
        this.closeEditors();
        Object source = event.getSource();
        if (source == null || !(source instanceof JComponent)) {
            return;
        }
        JComponent component = (JComponent)source;
        AttributeDependency dependency = (AttributeDependency)component.getClientProperty(ATTRIBUTE_DEPENDENCY_KEY);
        if (dependency == null) {
            return;
        }
        NlProperty property = this.myProperties.get(dependency.getAttribute());
        if (property == null) {
            return;
        }
        editor.setProperty(property);
        editor.setVisible(true);
        editor.requestFocus();
        JLabel editorLabel = editor.getLabel();
        assert (editorLabel != null);
        editorLabel.setText(dependency.getTitle());
        editorLabel.setToolTipText(property.getTooltipText());
        editorLabel.putClientProperty(ATTRIBUTE_DEPENDENCY_KEY, dependency);
        this.myActiveEditor = editor;
    }

    private void startEditingGravity(@NotNull MouseEvent event) {
        this.closeEditors();
        Object source = event.getSource();
        if (source == null || !(source instanceof JComponent)) {
            return;
        }
        JComponent component = (JComponent)source;
        GravityDisplayTable table = (GravityDisplayTable)component.getClientProperty(GRAVITY_DISPLAY_TABLE_KEY);
        if (table == null) {
            return;
        }
        if (table.initEditor(this.myGravityEditor, this.myProperties)) {
            this.myGravityEditor.setVisible(true);
            this.myActiveEditor = this.myGravityEditor;
        }
    }

    private void closeEditor(@NotNull NlComponentEditor editor) {
        if (editor == this.myActiveEditor) {
            editor.setVisible(false);
            this.myActiveEditor = null;
        }
    }

    private void closeEditors() {
        this.myEnumEditor.setVisible(false);
        this.myReferenceEditor.setVisible(false);
        this.myGravityEditor.setVisible(false);
        this.myActiveEditor = null;
    }

    private void toggleGravityValue(@NotNull MouseEvent event) {
        this.closeEditors();
        Object source = event.getSource();
        if (source == null || !(source instanceof JComponent)) {
            return;
        }
        JComponent component = (JComponent)source;
        GravityDisplayTable displayTable = (GravityDisplayTable)component.getClientProperty(GRAVITY_DISPLAY_TABLE_KEY);
        if (displayTable == null) {
            return;
        }
        displayTable.toggleValue(this.myProperties);
    }

    private JPanel createPanel(@NotNull ControlGroup group, @NotNull String name, @NotNull JBColor color) {
        CardinalDirectionControls controls = new CardinalDirectionControls(group, name, (Color)color);
        this.myControls.add(controls);
        SpringLayout layout = new SpringLayout();
        JPanel header = new JPanel(layout);
        JLabel label = new JLabel(name);
        label.setFont(SMALL_FONT);
        label.setForeground((Color)BLACK);
        JLabel north = controls.myNorth;
        north.setMaximumSize(new Dimension(Integer.MAX_VALUE, NlLayoutEditor.ourFontSize.height));
        layout.putConstraint("North", (Component)label, 0, "North", (Component)header);
        layout.putConstraint("West", (Component)label, 0, "West", (Component)header);
        layout.putConstraint("North", (Component)north, 0, "North", (Component)header);
        layout.putConstraint("HorizontalCenter", (Component)north, 0, "HorizontalCenter", (Component)header);
        header.add(label);
        header.add(north);
        header.setBackground((Color)color);
        header.setOpaque(true);
        north.setOpaque(false);
        header.setPreferredSize(ourFontSize);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground((Color)color);
        panel.add((Component)header, "North");
        panel.add((Component)controls.myEast, "East");
        panel.add((Component)controls.mySouth, "South");
        panel.add((Component)controls.myWest, "West");
        MouseListener listener = this.createMouseListener(group, label, color);
        header.addMouseListener(listener);
        north.addMouseListener(listener);
        controls.mySouth.addMouseListener(listener);
        controls.myEast.addMouseListener(listener);
        controls.myWest.addMouseListener(listener);
        header.putClientProperty(GRAVITY_DISPLAY_TABLE_KEY, north.getClientProperty(GRAVITY_DISPLAY_TABLE_KEY));
        header.putClientProperty(ATTRIBUTE_DEPENDENCY_KEY, north.getClientProperty(ATTRIBUTE_DEPENDENCY_KEY));
        header.putClientProperty(DIRECTION_LABEL_KEY, north);
        return panel;
    }

    private static Dimension measureFontSize() {
        JLabel label = new JLabel(EMPTY_TEXT_VALUE);
        label.setFont(SMALL_FONT);
        return label.getPreferredSize();
    }

    private static int getDefaultClickInterval() {
        Object property = Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
        if (property instanceof Integer) {
            return (Integer)property;
        }
        return 300;
    }

    private MouseListener createMouseListener(final @NotNull ControlGroup group, final @NotNull JLabel label, final @NotNull JBColor backgroundColor) {
        return new MouseAdapter(){
            private final Timer myTimer = new Timer(NlLayoutEditor.access$400(), event -> this.timedOut());
            private MouseEvent myLastEvent;

            @Override
            public void mouseClicked(MouseEvent event) {
                switch (event.getClickCount()) {
                    case 1: {
                        this.myLastEvent = event;
                        this.myTimer.restart();
                        break;
                    }
                    case 2: {
                        this.myTimer.stop();
                        this.mouseDoubleClickEvent(group, event);
                    }
                }
            }

            private void timedOut() {
                this.myTimer.stop();
                this.mouseClickEvent(group, this.myLastEvent);
            }

            @Override
            public void mouseEntered(@NotNull MouseEvent event) {
                NlLayoutEditor.this.setHoverAttributes(event, SMALL_LINK_FONT, (Color)LINK_COLOR, (Color)WHITE);
                label.setFont(SMALL_BOLD_FONT);
            }

            @Override
            public void mouseExited(@NotNull MouseEvent event) {
                NlLayoutEditor.this.setHoverAttributes(event, SMALL_FONT, (Color)BLACK, (Color)backgroundColor);
                label.setFont(SMALL_FONT);
            }

            private void mouseClickEvent(@NotNull ControlGroup group2, @NotNull MouseEvent event) {
                switch (group2) {
                    case LAYOUT: {
                        NlLayoutEditor.this.startEditing(NlLayoutEditor.this.myEnumEditor, event);
                        break;
                    }
                    case PADDING: 
                    case LAYOUT_MARGIN: 
                    case CONSTRAINT_MARGIN: {
                        NlLayoutEditor.this.startEditing(NlLayoutEditor.this.myReferenceEditor, event);
                        break;
                    }
                    case GRAVITY: 
                    case LAYOUT_GRAVITY: {
                        NlLayoutEditor.this.startEditingGravity(event);
                    }
                }
            }

            private void mouseDoubleClickEvent(@NotNull ControlGroup group2, @NotNull MouseEvent event) {
                switch (group2) {
                    case GRAVITY: 
                    case LAYOUT_GRAVITY: {
                        NlLayoutEditor.this.toggleGravityValue(event);
                        break;
                    }
                    case LAYOUT: {
                        NlLayoutEditor.this.startEditing(NlLayoutEditor.this.myEnumEditor, event);
                        break;
                    }
                    case PADDING: 
                    case LAYOUT_MARGIN: 
                    case CONSTRAINT_MARGIN: {
                        NlLayoutEditor.this.startEditing(NlLayoutEditor.this.myReferenceEditor, event);
                    }
                }
            }
        };
    }

    private NlEditingListener createEnumListener() {
        return new NlEditingListener(){

            @Override
            public void stopEditing(@NotNull NlComponentEditor editor, @Nullable Object value) {
                NlProperty property = editor.getProperty();
                if (property != null) {
                    property.setValue(value);
                    NlLayoutEditor.this.closeEditor(editor);
                    NlLayoutEditor.this.refresh();
                }
            }

            @Override
            public void cancelEditing(@NotNull NlComponentEditor editor) {
            }
        };
    }

    private NlEditingListener createReferenceListener() {
        return new NlEditingListener(){

            @Override
            public void stopEditing(@NotNull NlComponentEditor editor, @Nullable Object value) {
                JLabel label = editor.getLabel();
                assert (label != null);
                AttributeDependency dependency = (AttributeDependency)label.getClientProperty(NlLayoutEditor.ATTRIBUTE_DEPENDENCY_KEY);
                assert (dependency != null);
                dependency.setValue(NlLayoutEditor.this.myProperties, value);
                NlLayoutEditor.this.closeEditor(editor);
            }

            @Override
            public void cancelEditing(@NotNull NlComponentEditor editor) {
                NlLayoutEditor.this.closeEditor(editor);
            }
        };
    }

    private static AttributeDependency createLayoutWidthAttributeDependency(@NotNull String title) {
        return AttributeDependency.Builder.newBuilder(title + " Width", "layout_width").build();
    }

    private static AttributeDependency createLayoutHeightAttributeDependency(@NotNull String title) {
        return AttributeDependency.Builder.newBuilder(title + " Height", "layout_height").build();
    }

    private static AttributeDependency createPaddingTopAttributeDependency(@NotNull String title) {
        return AttributeDependency.Builder.newBuilder(TOP_TITLE_PREFIX + title, "paddingTop").addDependencies("paddingTop", "padding").setAllSideAttribute("padding").addOtherSides("paddingBottom", "paddingStart", "paddingEnd").build();
    }

    private static AttributeDependency createPaddingBottomAttributeDependency(@NotNull String title) {
        return AttributeDependency.Builder.newBuilder(BOTTOM_TITLE_PREFIX + title, "paddingBottom").addDependencies("paddingBottom", "padding").setAllSideAttribute("padding").addOtherSides("paddingTop", "paddingStart", "paddingEnd").build();
    }

    private static AttributeDependency createPaddingStartAttributeDependency(@NotNull String title) {
        return AttributeDependency.Builder.newBuilder(START_TITLE_PREFIX + title, "paddingStart").addDependencies("paddingStart", "padding", "paddingLeft").setAllSideAttribute("padding").addOtherSides("paddingTop", "paddingBottom", "paddingEnd").build();
    }

    private static AttributeDependency createPaddingEndAttributeDependency(@NotNull String title) {
        return AttributeDependency.Builder.newBuilder(END_TITLE_PREFIX + title, "paddingEnd").addDependencies("paddingEnd", "padding", "paddingRight").setAllSideAttribute("padding").addOtherSides("paddingTop", "paddingBottom", "paddingStart").build();
    }

    private static AttributeDependency createLayoutMarginTopAttributeDependency(@NotNull String title) {
        return AttributeDependency.Builder.newBuilder(TOP_TITLE_PREFIX + title, "layout_marginTop").addDependencies("layout_margin", "layout_marginTop").setAllSideAttribute("layout_margin").addOtherSides("layout_marginBottom", "layout_marginStart", "layout_marginEnd").build();
    }

    private static AttributeDependency createLayoutMarginBottomAttributeDependency(@NotNull String title) {
        return AttributeDependency.Builder.newBuilder(BOTTOM_TITLE_PREFIX + title, "layout_marginBottom").addDependencies("layout_margin", "layout_marginBottom").setAllSideAttribute("layout_margin").addOtherSides("layout_marginTop", "layout_marginStart", "layout_marginEnd").build();
    }

    private static AttributeDependency createLayoutMarginStartAttributeDependency(@NotNull String title) {
        return AttributeDependency.Builder.newBuilder(START_TITLE_PREFIX + title, "layout_marginStart").addDependencies("layout_margin", "layout_marginStart", "layout_marginLeft").setAllSideAttribute("layout_margin").addOtherSides("layout_marginTop", "layout_marginBottom", "layout_marginEnd").build();
    }

    private static AttributeDependency createLayoutMarginEndAttributeDependency(@NotNull String title) {
        return AttributeDependency.Builder.newBuilder(END_TITLE_PREFIX + title, "layout_marginEnd").addDependencies("layout_margin", "layout_marginEnd", "layout_marginRight").setAllSideAttribute("layout_margin").addOtherSides("layout_marginTop", "layout_marginBottom", "layout_marginStart").build();
    }

    private static AttributeDependency createConstraintMarginTopAttributeDependency(@NotNull String title) {
        return AttributeDependency.Builder.newBuilder(TOP_TITLE_PREFIX + title, "layout_marginTop").build();
    }

    private static AttributeDependency createConstraintMarginBottomAttributeDependency(@NotNull String title) {
        return AttributeDependency.Builder.newBuilder(BOTTOM_TITLE_PREFIX + title, "layout_marginBottom").build();
    }

    private static AttributeDependency createConstraintMarginStartAttributeDependency(@NotNull String title) {
        return AttributeDependency.Builder.newBuilder(LEFT_TITLE_PREFIX + title, "layout_marginLeft").build();
    }

    private static AttributeDependency createConstraintMarginEndAttributeDependency(@NotNull String title) {
        return AttributeDependency.Builder.newBuilder(RIGHT_TITLE_PREFIX + title, "layout_marginRight").build();
    }

    static /* synthetic */ int access$400() {
        return MULTI_CLICK_INTERVAL;
    }

    private static class CardinalDirectionControls {
        private final JLabel myNorth = new JLabel();
        private final JLabel myEast = new RotatedLabel();
        private final JLabel mySouth = new JLabel();
        private final JLabel myWest = new RotatedLabel();

        public CardinalDirectionControls(@NotNull ControlGroup group, @NotNull String title, @NotNull Color backgroundColor) {
            for (JLabel label : new JLabel[]{this.myNorth, this.mySouth, this.myEast, this.myWest}) {
                label.setFont(SMALL_FONT);
                label.setForeground((Color)BLACK);
                label.setOpaque(true);
                label.setBackground(backgroundColor);
            }
            this.mySouth.setHorizontalAlignment(0);
            this.addEditSupport(group, title);
        }

        private void addEditSupport(@NotNull ControlGroup group, @NotNull String title) {
            switch (group) {
                case GRAVITY: {
                    this.myNorth.putClientProperty(NlLayoutEditor.GRAVITY_DISPLAY_TABLE_KEY, new GravityDisplayTable(title, "gravity", "top"));
                    this.mySouth.putClientProperty(NlLayoutEditor.GRAVITY_DISPLAY_TABLE_KEY, new GravityDisplayTable(title, "gravity", "bottom"));
                    this.myWest.putClientProperty(NlLayoutEditor.GRAVITY_DISPLAY_TABLE_KEY, new GravityDisplayTable(title, "gravity", "start"));
                    this.myEast.putClientProperty(NlLayoutEditor.GRAVITY_DISPLAY_TABLE_KEY, new GravityDisplayTable(title, "gravity", "end"));
                    break;
                }
                case LAYOUT_GRAVITY: {
                    this.myNorth.putClientProperty(NlLayoutEditor.GRAVITY_DISPLAY_TABLE_KEY, new GravityDisplayTable(title, "layout_gravity", "top"));
                    this.mySouth.putClientProperty(NlLayoutEditor.GRAVITY_DISPLAY_TABLE_KEY, new GravityDisplayTable(title, "layout_gravity", "bottom"));
                    this.myWest.putClientProperty(NlLayoutEditor.GRAVITY_DISPLAY_TABLE_KEY, new GravityDisplayTable(title, "layout_gravity", "start"));
                    this.myEast.putClientProperty(NlLayoutEditor.GRAVITY_DISPLAY_TABLE_KEY, new GravityDisplayTable(title, "layout_gravity", "end"));
                    break;
                }
                case PADDING: {
                    this.myNorth.putClientProperty(NlLayoutEditor.ATTRIBUTE_DEPENDENCY_KEY, NlLayoutEditor.createPaddingTopAttributeDependency(title));
                    this.mySouth.putClientProperty(NlLayoutEditor.ATTRIBUTE_DEPENDENCY_KEY, NlLayoutEditor.createPaddingBottomAttributeDependency(title));
                    this.myEast.putClientProperty(NlLayoutEditor.ATTRIBUTE_DEPENDENCY_KEY, NlLayoutEditor.createPaddingEndAttributeDependency(title));
                    this.myWest.putClientProperty(NlLayoutEditor.ATTRIBUTE_DEPENDENCY_KEY, NlLayoutEditor.createPaddingStartAttributeDependency(title));
                    break;
                }
                case LAYOUT_MARGIN: {
                    this.myNorth.putClientProperty(NlLayoutEditor.ATTRIBUTE_DEPENDENCY_KEY, NlLayoutEditor.createLayoutMarginTopAttributeDependency(title));
                    this.mySouth.putClientProperty(NlLayoutEditor.ATTRIBUTE_DEPENDENCY_KEY, NlLayoutEditor.createLayoutMarginBottomAttributeDependency(title));
                    this.myEast.putClientProperty(NlLayoutEditor.ATTRIBUTE_DEPENDENCY_KEY, NlLayoutEditor.createLayoutMarginEndAttributeDependency(title));
                    this.myWest.putClientProperty(NlLayoutEditor.ATTRIBUTE_DEPENDENCY_KEY, NlLayoutEditor.createLayoutMarginStartAttributeDependency(title));
                    break;
                }
                case CONSTRAINT_MARGIN: {
                    this.myNorth.putClientProperty(NlLayoutEditor.ATTRIBUTE_DEPENDENCY_KEY, NlLayoutEditor.createConstraintMarginTopAttributeDependency(title));
                    this.mySouth.putClientProperty(NlLayoutEditor.ATTRIBUTE_DEPENDENCY_KEY, NlLayoutEditor.createConstraintMarginBottomAttributeDependency(title));
                    this.myEast.putClientProperty(NlLayoutEditor.ATTRIBUTE_DEPENDENCY_KEY, NlLayoutEditor.createConstraintMarginEndAttributeDependency(title));
                    this.myWest.putClientProperty(NlLayoutEditor.ATTRIBUTE_DEPENDENCY_KEY, NlLayoutEditor.createConstraintMarginStartAttributeDependency(title));
                    break;
                }
                case LAYOUT: {
                    this.mySouth.putClientProperty(NlLayoutEditor.ATTRIBUTE_DEPENDENCY_KEY, NlLayoutEditor.createLayoutWidthAttributeDependency(title));
                    this.myEast.putClientProperty(NlLayoutEditor.ATTRIBUTE_DEPENDENCY_KEY, NlLayoutEditor.createLayoutHeightAttributeDependency(title));
                    this.myNorth.setText(NlLayoutEditor.EMPTY_TEXT_VALUE);
                    this.myWest.setText(NlLayoutEditor.EMPTY_TEXT_VALUE);
                    break;
                }
            }
        }

        public void refresh(@NotNull Map<String, NlProperty> properties) {
            for (JLabel direction : new JLabel[]{this.myNorth, this.mySouth, this.myEast, this.myWest}) {
                GravityDisplayTable displayTable;
                AttributeDependency dependency = (AttributeDependency)direction.getClientProperty(NlLayoutEditor.ATTRIBUTE_DEPENDENCY_KEY);
                if (dependency != null) {
                    direction.setText(dependency.getValue(properties));
                }
                if ((displayTable = (GravityDisplayTable)direction.getClientProperty(NlLayoutEditor.GRAVITY_DISPLAY_TABLE_KEY)) == null) continue;
                direction.setIcon(displayTable.getValue(properties));
            }
        }
    }

    private static class GravityDisplayTable {
        private final String myTitle;
        private final String myAttribute;
        private final String myValue;
        private final String myOppositeValue;
        private final String myCenterValue;
        private final String myOrthogonalCenterValue;
        private final Icon myDefaultIcon;
        private final Icon myGravityOnIcon;

        @NotNull
        public Icon getValue(@NotNull Map<String, NlProperty> properties) {
            return this.isGravityOn(this.getProperty(properties)) ? this.myGravityOnIcon : this.myDefaultIcon;
        }

        public void setValue(@NotNull Map<String, NlProperty> properties, boolean newValue) {
            NlFlagPropertyItem property = this.getProperty(properties);
            if (property == null) {
                return;
            }
            HashSet<String> itemsToRemove = new HashSet<String>(4);
            HashSet<String> itemsToAdd = new HashSet<String>(4);
            if (newValue) {
                if (property.isAnyItemSet(this.myOppositeValue, this.myCenterValue, "center")) {
                    itemsToRemove.add(this.myOppositeValue);
                    itemsToRemove.add(this.myValue);
                    if (property.isAnyItemSet(this.myOrthogonalCenterValue, "center")) {
                        itemsToAdd.add("center");
                        itemsToRemove.add(this.myOrthogonalCenterValue);
                        itemsToRemove.add(this.myCenterValue);
                    } else {
                        itemsToAdd.add(this.myCenterValue);
                    }
                } else {
                    itemsToAdd.add(this.myValue);
                }
            } else {
                itemsToRemove.add(this.myValue);
                if (property.isItemSet("center")) {
                    itemsToRemove.add("center");
                    itemsToAdd.add(this.myOrthogonalCenterValue);
                    itemsToAdd.add(this.myOppositeValue);
                } else if (property.isItemSet(this.myCenterValue)) {
                    itemsToRemove.add(this.myCenterValue);
                    itemsToAdd.add(this.myOppositeValue);
                }
            }
            property.updateItems(itemsToAdd, itemsToRemove);
        }

        public void toggleValue(@NotNull Map<String, NlProperty> properties) {
            this.setValue(properties, !this.isGravityOn(this.getProperty(properties)));
        }

        public boolean initEditor(@NotNull NlGravityEditor editor, @NotNull Map<String, NlProperty> properties) {
            NlFlagPropertyItem property = this.getProperty(properties);
            if (property == null) {
                return false;
            }
            editor.getComponent().putClientProperty(NlLayoutEditor.GRAVITY_DISPLAY_TABLE_KEY, this);
            editor.setProperty(property);
            JLabel label = editor.getLabel();
            assert (label != null);
            label.setText(this.myTitle);
            return true;
        }

        private GravityDisplayTable(@NotNull String title, @NotNull String attribute, @NotNull String value) {
            this.myTitle = title;
            this.myAttribute = attribute;
            this.myValue = value;
            switch (value) {
                case "top": {
                    this.myOppositeValue = "bottom";
                    this.myCenterValue = "center_vertical";
                    this.myOrthogonalCenterValue = "center_horizontal";
                    this.myGravityOnIcon = AndroidVectorIcons.LayoutEditorIcons.ArrowUp;
                    this.myDefaultIcon = AndroidVectorIcons.LayoutEditorIcons.UnSetUp;
                    break;
                }
                case "bottom": {
                    this.myOppositeValue = "top";
                    this.myCenterValue = "center_vertical";
                    this.myOrthogonalCenterValue = "center_horizontal";
                    this.myGravityOnIcon = AndroidVectorIcons.LayoutEditorIcons.ArrowDown;
                    this.myDefaultIcon = AndroidVectorIcons.LayoutEditorIcons.UnSetDown;
                    break;
                }
                case "start": {
                    this.myOppositeValue = "end";
                    this.myCenterValue = "center_horizontal";
                    this.myOrthogonalCenterValue = "center_vertical";
                    this.myGravityOnIcon = AndroidVectorIcons.LayoutEditorIcons.ArrowUp;
                    this.myDefaultIcon = AndroidVectorIcons.LayoutEditorIcons.UnSetUp;
                    break;
                }
                case "end": {
                    this.myOppositeValue = "start";
                    this.myCenterValue = "center_horizontal";
                    this.myOrthogonalCenterValue = "center_vertical";
                    this.myGravityOnIcon = AndroidVectorIcons.LayoutEditorIcons.ArrowDown;
                    this.myDefaultIcon = AndroidVectorIcons.LayoutEditorIcons.UnSetDown;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(value);
                }
            }
        }

        @Nullable
        private NlFlagPropertyItem getProperty(@NotNull Map<String, NlProperty> properties) {
            NlProperty property = properties.get(this.myAttribute);
            return property instanceof NlFlagPropertyItem ? (NlFlagPropertyItem)property : null;
        }

        private boolean isGravityOn(@Nullable NlFlagPropertyItem property) {
            if (property == null) {
                return false;
            }
            return property.isAnyItemSet(this.myValue, this.myCenterValue, "center");
        }
    }

    private static class AttributeDependency {
        private final String myTitle;
        private final String myAttribute;
        private final List<String> myDependentAttributes;
        private final String myAllSideAttribute;
        private final List<String> myOtherSideAttributes;

        private AttributeDependency(@NotNull String title, @NotNull String attribute, @NotNull List<String> dependentAttributes, @Nullable String allSideAttribute, @NotNull List<String> otherSideAttributes) {
            this.myTitle = title;
            this.myAttribute = attribute;
            this.myDependentAttributes = dependentAttributes;
            this.myAllSideAttribute = allSideAttribute;
            this.myOtherSideAttributes = otherSideAttributes;
        }

        @NotNull
        public String getTitle() {
            return this.myTitle;
        }

        @NotNull
        public String getAttribute() {
            return this.myAttribute;
        }

        @NotNull
        public String getValue(@NotNull Map<String, NlProperty> properties) {
            for (String attribute : this.myDependentAttributes) {
                NlProperty property = properties.get(attribute);
                String value = property != null ? property.getResolvedValue() : null;
                if (StringUtil.isEmpty((String)value)) continue;
                return value;
            }
            if (this.myDependentAttributes.isEmpty()) {
                String value;
                NlProperty property = properties.get(this.myAttribute);
                String string = value = property != null ? property.getResolvedValue() : null;
                if (!StringUtil.isEmpty((String)value)) {
                    return value;
                }
            }
            return NlLayoutEditor.EMPTY_TEXT_VALUE;
        }

        public void setValue(@NotNull Map<String, NlProperty> properties, @Nullable Object newValue) {
            NlProperty property = properties.get(this.myAttribute);
            assert (property != null);
            if (newValue != null) {
                for (String attribute : this.myDependentAttributes) {
                    if (attribute.equals(this.myAttribute)) continue;
                    NlProperty dependency = properties.get(attribute);
                    assert (dependency != null);
                    String oldValue = dependency.getValue();
                    if (oldValue == null) continue;
                    if (attribute.equals(this.myAllSideAttribute)) {
                        for (String other : this.myOtherSideAttributes) {
                            NlProperty otherSide = properties.get(other);
                            assert (otherSide != null);
                            otherSide.setValue(oldValue);
                        }
                    }
                    dependency.setValue(null);
                }
            }
            property.setValue(newValue);
        }

        private static class Builder {
            private String myTitle;
            private String myAttribute;
            private ImmutableList.Builder<String> myDependentAttributes;
            private String myAllSideAttribute;
            private ImmutableList.Builder<String> myOtherSideAttributes;

            @NotNull
            public static Builder newBuilder(@NotNull String title, @NotNull String attribute) {
                return new Builder(title, attribute);
            }

            private Builder(@NotNull String title, @NotNull String attribute) {
                this.myTitle = title;
                this.myAttribute = attribute;
                this.myDependentAttributes = ImmutableList.builder();
                this.myOtherSideAttributes = ImmutableList.builder();
            }

            @NotNull
            public Builder addDependencies(String ... dependencies) {
                this.myDependentAttributes.addAll(Arrays.asList(dependencies));
                return this;
            }

            @NotNull
            public Builder setAllSideAttribute(@NotNull String allSideAttribute) {
                this.myAllSideAttribute = allSideAttribute;
                return this;
            }

            @NotNull
            public Builder addOtherSides(String ... others) {
                this.myOtherSideAttributes.addAll(Arrays.asList(others));
                return this;
            }

            @NotNull
            public AttributeDependency build() {
                return new AttributeDependency(this.myTitle, this.myAttribute, (List)this.myDependentAttributes.build(), this.myAllSideAttribute, (List)this.myOtherSideAttributes.build());
            }
        }
    }

    private static enum ControlGroup {
        CONSTRAINT_MARGIN,
        LAYOUT_GRAVITY,
        LAYOUT_MARGIN,
        PADDING,
        GRAVITY,
        LAYOUT;

    }
}

