/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.tools.idea.uibuilder.property.NlProperty;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.ui.ToggleActionButton;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlBooleanIconEditor {
    private static final String INSPECTOR_PLACE = "Inspector Place";
    private final BooleanAction myAction;
    private final ActionButton myButton;
    private final Presentation myPresentation;

    public NlBooleanIconEditor(@NotNull Icon icon, @NotNull String description) {
        this(icon, description, "true", "false");
    }

    public NlBooleanIconEditor(@NotNull Icon icon, @NotNull String description, @NotNull String singleValue) {
        this(icon, description, singleValue, null);
    }

    public NlBooleanIconEditor(@NotNull Icon icon, @NotNull String description, @NotNull String trueValue, @Nullable String falseValue) {
        this.myAction = new BooleanAction(icon, description, trueValue, falseValue);
        this.myPresentation = this.myAction.getTemplatePresentation().clone();
        this.myButton = new ActionButton((AnAction)this.myAction, this.myPresentation, INSPECTOR_PLACE, ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE);
    }

    public Component getComponent() {
        return this.myButton;
    }

    public void setProperty(@NotNull NlProperty property) {
        this.myAction.setProperty(property);
        this.updateDescription(property);
        AnActionEvent event = new AnActionEvent(null, DataManager.getInstance().getDataContext((Component)this.myButton), INSPECTOR_PLACE, this.myPresentation, ActionManager.getInstance(), 0);
        ActionUtil.performDumbAwareUpdate((AnAction)this.myAction, (AnActionEvent)event, (boolean)false);
        this.myButton.updateIcon();
    }

    private void updateDescription(@NotNull NlProperty property) {
        String description;
        AttributeDefinition definition = property.getDefinition();
        if (definition != null && (description = definition.getValueDoc(this.myAction.myTrueValue)) != null) {
            this.myPresentation.setDescription(description);
            this.myPresentation.setText(description);
        }
    }

    private static class BooleanAction
    extends ToggleActionButton {
        private final String myTrueValue;
        private final String myFalseValue;
        private NlProperty myProperty;

        public BooleanAction(@NotNull Icon icon, @Nullable String description, @NotNull String trueValue, @Nullable String falseValue) {
            super(description, icon);
            this.getTemplatePresentation().setIcon(icon);
            this.myTrueValue = trueValue;
            this.myFalseValue = falseValue;
        }

        public void setProperty(@NotNull NlProperty property) {
            this.myProperty = property;
        }

        public boolean isSelected(AnActionEvent event) {
            return this.myProperty != null && this.myTrueValue.equals(this.myProperty.getResolvedValue());
        }

        public void setSelected(AnActionEvent event, boolean selected) {
            this.myProperty.setValue(selected ? this.myTrueValue : this.myFalseValue);
        }
    }
}

