/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.BrowsePanel;
import com.android.tools.idea.uibuilder.property.editors.NlBaseComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlTableCellEditor;
import com.android.tools.idea.uibuilder.property.renderer.NlBooleanRenderer;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlBooleanEditor
extends NlBaseComponentEditor
implements NlComponentEditor {
    private final JPanel myPanel;
    private final ThreeStateCheckBox myCheckbox = new ThreeStateCheckBox();
    private NlProperty myProperty;
    private Object myValue;

    public static NlTableCellEditor createForTable() {
        NlTableCellEditor cellEditor = new NlTableCellEditor();
        cellEditor.init(new NlBooleanEditor(cellEditor, cellEditor));
        return cellEditor;
    }

    public static NlBooleanEditor createForInspector(@NotNull NlEditingListener listener) {
        return new NlBooleanEditor(listener, null);
    }

    private NlBooleanEditor(@NotNull NlEditingListener listener, @Nullable BrowsePanel.Context context) {
        super(listener);
        this.myCheckbox.addActionListener(this::checkboxChanged);
        this.myPanel = new JPanel(new BorderLayout(HORIZONTAL_COMPONENT_GAP, 0));
        this.myPanel.add((Component)this.myCheckbox, "Before");
        this.myPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        if (context != null) {
            this.myPanel.add((Component)this.createBrowsePanel(context), "After");
        }
    }

    @Override
    @Nullable
    public NlProperty getProperty() {
        return this.myProperty;
    }

    @Override
    public void setProperty(@NotNull NlProperty property) {
        this.myProperty = property;
        String propValue = this.myProperty.getValue();
        this.myValue = propValue;
        ThreeStateCheckBox.State state = NlBooleanRenderer.getState(propValue);
        this.myCheckbox.setState(state == null ? ThreeStateCheckBox.State.NOT_SELECTED : state);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.myValue;
    }

    @Override
    public void activate() {
        this.myValue = NlBooleanRenderer.getNextState(this.myCheckbox.getState());
        this.stopEditing(this.myValue);
    }

    private void checkboxChanged(ActionEvent e) {
        this.myValue = NlBooleanRenderer.getBoolean(this.myCheckbox.getState());
        this.stopEditing(this.myValue);
    }
}

