/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.ptable.PTableGroupItem;
import com.intellij.ui.ColoredTableCellRenderer;
import java.util.function.Predicate;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

class NlPropertyAccumulator {
    private final String myGroupName;
    private final Predicate<NlPropertyItem> myFilter;
    private PTableGroupItem myGroupNode;

    public NlPropertyAccumulator(@NotNull String groupName) {
        this.myGroupName = groupName;
        this.myFilter = null;
    }

    public NlPropertyAccumulator(@NotNull String groupName, @NotNull Predicate<NlPropertyItem> isApplicable) {
        this.myGroupName = groupName;
        this.myFilter = isApplicable;
    }

    @NotNull
    public String getGroupName() {
        return this.myGroupName;
    }

    protected boolean isApplicable(@NotNull NlPropertyItem p) {
        assert (this.myFilter != null);
        return this.myFilter.test(p);
    }

    public boolean process(@NotNull NlPropertyItem p) {
        if (!this.isApplicable(p)) {
            return false;
        }
        if (this.myGroupNode == null) {
            this.myGroupNode = this.createGroupNode(this.myGroupName);
        }
        this.myGroupNode.addChild(p);
        return true;
    }

    public boolean hasItems() {
        return this.myGroupNode != null && !this.myGroupNode.getChildren().isEmpty();
    }

    @NotNull
    public PTableGroupItem getGroupNode() {
        return this.myGroupNode == null ? this.createGroupNode(this.myGroupName) : this.myGroupNode;
    }

    @NotNull
    protected PTableGroupItem createGroupNode(@NotNull String groupName) {
        return new GroupNode(groupName);
    }

    public static class PropertyNamePrefixAccumulator
    extends NlPropertyAccumulator {
        public PropertyNamePrefixAccumulator(@NotNull String groupName, @NotNull String prefix) {
            super(groupName, (NlPropertyItem p) -> p != null && p.getName().startsWith(prefix));
        }
    }

    private static class GroupNode
    extends PTableGroupItem {
        private static final ColoredTableCellRenderer EMPTY_VALUE_RENDERER = new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            }
        };
        private final String myStyleable;

        public GroupNode(@NotNull String styleable) {
            this.myStyleable = styleable;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myStyleable;
        }

        @Override
        @NotNull
        public TableCellRenderer getCellRenderer() {
            return EMPTY_VALUE_RENDERER;
        }
    }
}

