/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.rendering.AttributeSnapshot;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlPropertiesGrouper;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class NlPropertiesSorter {
    public List<NlPropertyItem> sort(@NotNull List<NlPropertyItem> groupedProperties, @NotNull List<NlComponent> components) {
        String tagName = NlPropertiesGrouper.getCommonTagName(components);
        Set<String> modifiedAttributeNames = NlPropertiesSorter.getModifiedAttributes(components);
        Collections.sort(groupedProperties, Comparator.comparing(property -> SortOrder.of(property.getName(), property.getName().equalsIgnoreCase(tagName), modifiedAttributeNames.contains(property.getName()))).thenComparing(NlPropertyItem::getName).thenComparing(NlPropertyItem::getNamespace));
        return groupedProperties;
    }

    @NotNull
    public static Set<String> getModifiedAttributes(@NotNull List<NlComponent> components) {
        List<AttributeSnapshot> attrs = components.get(0).getAttributes();
        HashSet modifiedAttrs = Sets.newHashSetWithExpectedSize((int)attrs.size());
        for (NlComponent component : components) {
            attrs = component.getAttributes();
            for (AttributeSnapshot snapshot : attrs) {
                modifiedAttrs.add(snapshot.name);
            }
        }
        return modifiedAttrs;
    }

    private static enum SortOrder {
        id,
        layout_width,
        layout_height,
        layout_constraint,
        layout_margin,
        padding,
        opacity,
        elevation,
        modified,
        accessibility,
        theme,
        styles,
        important,
        expert;


        public static SortOrder of(@NotNull String item, boolean isMainClass, boolean isModifiedAttribute) {
            for (SortOrder order : SortOrder.values()) {
                if (!order.name().equalsIgnoreCase(item)) continue;
                return order;
            }
            if (isMainClass || isModifiedAttribute) {
                return modified;
            }
            return expert;
        }
    }
}

