/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlFlagPropertyItemValue;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.ptable.PTableItem;
import com.android.tools.idea.uibuilder.property.renderer.NlFlagRenderer;
import com.android.tools.idea.uibuilder.property.renderer.NlPropertyRenderers;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlFlagPropertyItem
extends NlPropertyItem
implements NlProperty {
    private List<PTableItem> myItems;
    private long myLastRead;
    private String myLastValue;
    private String myLastFormattedValue;
    private Set<String> myLastValues;
    private boolean myExpanded;
    private static final Splitter VALUE_SPLITTER = Splitter.on((String)"|").trimResults();

    protected NlFlagPropertyItem(@NotNull List<NlComponent> components, @NotNull XmlAttributeDescriptor descriptor, @Nullable String namespace, @Nullable AttributeDefinition attributeDefinition) {
        super(components, descriptor, namespace, attributeDefinition);
        assert (attributeDefinition != null);
    }

    protected NlFlagPropertyItem(@NotNull NlFlagPropertyItem property, @NotNull String namespace) {
        super(property, namespace);
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    @NotNull
    public List<PTableItem> getChildren() {
        if (this.myItems == null) {
            assert (this.myDefinition != null);
            this.myItems = Lists.newArrayListWithCapacity((int)this.myDefinition.getValues().length);
            for (String value : this.myDefinition.getValues()) {
                this.myItems.add(new NlFlagPropertyItemValue(value, this));
            }
        }
        return this.myItems;
    }

    @Override
    @NotNull
    public NlProperty getChildProperty(@NotNull String itemName) {
        for (PTableItem child : this.getChildren()) {
            if (!child.getName().equals(itemName)) continue;
            return (NlProperty)((Object)child);
        }
        throw new IllegalArgumentException(itemName);
    }

    @Override
    @NotNull
    public NlPropertyItem getDesignTimeProperty() {
        if ("http://schemas.android.com/tools".equals(this.getNamespace())) {
            return this;
        }
        return new NlFlagPropertyItem(this, "http://schemas.android.com/tools");
    }

    @Override
    public boolean isExpanded() {
        return this.myExpanded;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.myExpanded = expanded;
    }

    @Override
    public boolean isEditable(int col) {
        return false;
    }

    @Override
    @Nullable
    public String getValue() {
        this.cacheValues();
        return this.myLastValue;
    }

    @Override
    public void setValue(Object value) {
        this.invalidateCachedValues();
        super.setValue(value);
    }

    public String getFormattedValue() {
        this.cacheValues();
        return this.myLastFormattedValue;
    }

    @NotNull
    private Set<String> getValues() {
        this.cacheValues();
        return this.myLastValues;
    }

    private void invalidateCachedValues() {
        this.myLastValues = null;
    }

    private void cacheValues() {
        if (this.myLastValues != null && this.myLastRead == this.getModel().getModificationCount()) {
            return;
        }
        HashSet values = Collections.emptySet();
        String rawValue = super.getValue();
        String formattedValue = "[]";
        if (rawValue != null) {
            List valueList = VALUE_SPLITTER.splitToList((CharSequence)StringUtil.notNullize((String)rawValue));
            values = Sets.newHashSet((Iterable)valueList);
            formattedValue = "[" + Joiner.on((String)", ").join((Iterable)valueList) + "]";
        }
        this.myLastValues = values;
        this.myLastValue = rawValue;
        this.myLastFormattedValue = formattedValue;
        this.myLastRead = this.getModel().getModificationCount();
    }

    public boolean isItemSet(@NotNull NlFlagPropertyItemValue item) {
        return this.isItemSet(item.getName());
    }

    public boolean isItemSet(@NotNull String itemName) {
        return this.getValues().contains(itemName);
    }

    public boolean isAnyItemSet(String ... itemNames) {
        for (String itemName : itemNames) {
            if (!this.getValues().contains(itemName)) continue;
            return true;
        }
        return false;
    }

    public void setItem(@NotNull NlFlagPropertyItemValue changedItem, boolean on) {
        Set<String> removed = on ? Collections.emptySet() : Collections.singleton(changedItem.getName());
        Set<String> added = on ? Collections.singleton(changedItem.getName()) : Collections.emptySet();
        this.updateItems(added, removed);
    }

    public void updateItems(@NotNull Set<String> added, @NotNull Set<String> removed) {
        Set<String> values = this.getValues();
        StringBuilder builder = new StringBuilder();
        this.getChildren().stream().filter(item -> values.contains(item.getName()) && !removed.contains(item.getName()) || added.contains(item.getName())).forEach(item -> {
            if (builder.length() > 0) {
                builder.append("|");
            }
            builder.append(item.getName());
        });
        String newValue = builder.length() == 0 ? null : builder.toString();
        this.setValue(newValue);
    }

    @Override
    public void mousePressed(@NotNull MouseEvent event, @NotNull Rectangle rectRightColumn) {
        NlFlagRenderer renderer = NlPropertyRenderers.getFlagRenderer();
        renderer.mousePressed(event, rectRightColumn);
    }
}

