/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.uibuilder.api.PaletteComponentHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.IconLoader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="palette")
public class Palette {
    @XmlElements(value={@XmlElement(name="group", type=Group.class), @XmlElement(name="item", type=Item.class)})
    private final List<BaseItem> myItems = new ArrayList<BaseItem>();
    private final Set<GradleCoordinate> myGradleCoordinates = new HashSet<GradleCoordinate>();

    private Palette() {
    }

    public static Palette parse(@NotNull Reader xmlReader, @NotNull ViewHandlerManager manager) throws JAXBException {
        Palette palette = Palette.unMarshal(xmlReader);
        palette.resolve(manager);
        palette.addGradleCoordinates(palette.myItems);
        return palette;
    }

    private void addGradleCoordinates(@NotNull Iterable<BaseItem> items) {
        for (BaseItem item : items) {
            if (item instanceof Item) {
                GradleCoordinate coordinate;
                String coordinateAsString = ((Item)item).getGradleCoordinate();
                if (Strings.isNullOrEmpty((String)coordinateAsString) || (coordinate = GradleCoordinate.parseCoordinateString((String)(coordinateAsString + ":+"))) == null) continue;
                this.myGradleCoordinates.add(coordinate);
                continue;
            }
            if (!(item instanceof Group)) continue;
            this.addGradleCoordinates(((Group)item).getItems());
        }
    }

    @NotNull
    public List<BaseItem> getItems() {
        return this.myItems;
    }

    @NotNull
    Set<GradleCoordinate> getGradleCoordinates() {
        return this.myGradleCoordinates;
    }

    private static Palette unMarshal(@NotNull Reader xmlReader) throws JAXBException {
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{Palette.class}).createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                throw new RuntimeException(event.getLinkedException());
            }
        });
        return (Palette)unmarshaller.unmarshal(xmlReader);
    }

    private void resolve(@NotNull ViewHandlerManager manager) {
        for (BaseItem item : this.myItems) {
            item.resolve(manager);
        }
    }

    public static class XmlValuePart {
        @XmlValue
        @Language(value="XML")
        @Nullable
        private String myValue;
        @XmlAttribute(name="reuse")
        private String myReuse;

        @Nullable
        public String getValue() {
            return this.myValue;
        }

        private boolean reuseFor(@NotNull String part) {
            return this.myReuse != null && Splitter.on((String)",").trimResults().splitToList((CharSequence)this.myReuse).contains(part);
        }

        public boolean reuseForPreview() {
            return this.reuseFor("preview");
        }

        public boolean reuseForDragPreview() {
            return this.reuseFor("drag-preview");
        }
    }

    public static class Item
    implements BaseItem {
        @XmlAttribute(required=true, name="tag")
        @NotNull
        private String myTagName;
        @XmlAttribute(name="id")
        @Nullable
        private String myId;
        @XmlAttribute(name="title")
        @Nullable
        private String myTitle;
        @XmlAttribute(name="icon")
        @Nullable
        private String myIconName;
        @XmlAttribute(name="coordinate")
        @Nullable
        private String myGradleCoordinate;
        @XmlAttribute(name="scale")
        @Nullable
        private Double myPreviewScale;
        @XmlAttribute(name="render-separately")
        @Nullable
        private Boolean myPreviewRenderSeparately;
        @XmlElement(name="xml", type=XmlValuePart.class)
        private XmlValuePart myXmlValuePart;
        @Language(value="XML")
        @Nullable
        private String myXml;
        @XmlElement(name="preview")
        @Language(value="XML")
        @Nullable
        private String myPreviewXml;
        @XmlElement(name="drag-preview")
        @Language(value="XML")
        @Nullable
        private String myDragPreviewXml;
        private PaletteComponentHandler myHandler;

        @NotNull
        public String getTagName() {
            return this.myTagName;
        }

        @NotNull
        public String getId() {
            return this.myId != null ? this.myId : this.myTagName;
        }

        @NotNull
        public String getTitle() {
            if (this.myTitle != null) {
                return this.myTitle;
            }
            return this.myHandler.getTitle(this.myTagName);
        }

        @NotNull
        public Icon getIcon() {
            Icon icon;
            if (this.myIconName != null && (icon = IconLoader.findIcon((String)this.myIconName, this.getClass())) != null) {
                return icon;
            }
            return this.myHandler.getIcon(this.myTagName);
        }

        @Nullable
        public String getGradleCoordinate() {
            if (this.myGradleCoordinate != null) {
                return this.myGradleCoordinate;
            }
            return this.myHandler.getGradleCoordinate(this.myTagName);
        }

        @NotNull
        @Language(value="XML")
        public String getXml() {
            if (this.myXml != null) {
                return this.myXml;
            }
            return this.myHandler.getXml(this.myTagName, XmlType.COMPONENT_CREATION);
        }

        @NotNull
        @Language(value="XML")
        public String getPreviewXml() {
            if (this.myPreviewXml != null) {
                return this.myPreviewXml;
            }
            return this.myHandler.getXml(this.myTagName, XmlType.PREVIEW_ON_PALETTE);
        }

        @NotNull
        @Language(value="XML")
        public String getDragPreviewXml() {
            if (this.myDragPreviewXml != null) {
                return this.myDragPreviewXml;
            }
            return this.myHandler.getXml(this.myTagName, XmlType.DRAG_PREVIEW);
        }

        public double getPreviewScale() {
            if (this.myPreviewScale != null) {
                return this.myPreviewScale;
            }
            return this.myHandler.getPreviewScale(this.myTagName);
        }

        public boolean isPreviewRenderedSeparately() {
            if (this.myPreviewRenderSeparately != null) {
                return this.myPreviewRenderSeparately;
            }
            return false;
        }

        @Override
        public void resolve(@NotNull ViewHandlerManager manager) {
            this.myHandler = manager.getHandlerOrDefault(this.myTagName);
            if (this.myXmlValuePart != null) {
                this.myXml = this.myXmlValuePart.getValue();
                if (this.myPreviewXml == null && this.myXmlValuePart.reuseForPreview()) {
                    this.myPreviewXml = this.addId(this.myXml);
                }
                if (this.myDragPreviewXml == null && this.myXmlValuePart.reuseForDragPreview()) {
                    this.myDragPreviewXml = this.myXml;
                }
                this.myXmlValuePart = null;
            }
        }

        @Language(value="XML")
        @Nullable
        private String addId(@Nullable @Language(value="XML") String xml) {
            if (xml == null || this.myId == null) {
                return xml;
            }
            int index = xml.indexOf("<" + this.myTagName);
            if (index < 0) {
                return xml;
            }
            return xml.substring(0, index += 1 + this.myTagName.length()) + "\n  android:id=\"@+id/" + this.getId() + "\"\n" + xml.substring(index);
        }

        @NotNull
        public String toString() {
            return this.myTagName;
        }
    }

    public static class Group
    implements BaseItem {
        @XmlAttribute(required=true, name="name")
        @NotNull
        private String myName;
        @XmlElements(value={@XmlElement(name="group", type=Group.class), @XmlElement(name="item", type=Item.class)})
        private List<BaseItem> myItems = Lists.newArrayList();

        @NotNull
        public String getName() {
            return this.myName;
        }

        @NotNull
        public List<BaseItem> getItems() {
            return this.myItems;
        }

        @NotNull
        public BaseItem getItem(int index) {
            return this.myItems.get(index);
        }

        @Override
        public void resolve(@NotNull ViewHandlerManager manager) {
            for (BaseItem item : this.myItems) {
                item.resolve(manager);
            }
        }

        @NotNull
        public String toString() {
            return this.myName;
        }
    }

    static interface BaseItem {
        public void resolve(@NotNull ViewHandlerManager var1);
    }
}

