/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.NlLayoutType;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.EnumMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.jetbrains.annotations.NotNull;

public class NlPaletteModel {
    public static final String ANDROID_PALETTE = "android-palette";
    public static final String PALETTE_VERSION = "v1";
    private final Map<NlLayoutType, Palette> myTypeToPalette = new EnumMap<NlLayoutType, Palette>(NlLayoutType.class);
    private final Project myProject;

    public static NlPaletteModel get(@NotNull Project project) {
        return (NlPaletteModel)project.getComponent(NlPaletteModel.class);
    }

    private NlPaletteModel(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    Palette getPalette(@NotNull NlLayoutType type) {
        Palette palette;
        if (!type.isSupportedByDesigner()) {
            type = NlLayoutType.LAYOUT;
        }
        if ((palette = this.myTypeToPalette.get((Object)type)) == null) {
            this.loadPalette(type);
            return this.myTypeToPalette.get((Object)type);
        }
        return palette;
    }

    private void loadPalette(@NotNull NlLayoutType type) {
        try {
            String name = type.getPaletteFileName();
            File file = new File(PathManager.getSystemPath(), ANDROID_PALETTE + File.separatorChar + PALETTE_VERSION + File.separatorChar + name);
            if (NlPaletteModel.isOutOfDate(file, name)) {
                NlPaletteModel.copyPredefinedPalette(file, name);
            }
            try (InputStreamReader reader = new InputStreamReader(new FileInputStream(file));){
                this.loadPalette(reader, type);
            }
        }
        catch (IOException | JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    void loadPalette(@NotNull Reader reader, @NotNull NlLayoutType type) throws JAXBException {
        Palette palette = Palette.parse(reader, ViewHandlerManager.get(this.myProject));
        this.myTypeToPalette.put(type, palette);
    }

    private static void copyPredefinedPalette(@NotNull File paletteFile, @NotNull String metadata) throws IOException {
        File folder = paletteFile.getParentFile();
        if (!folder.isDirectory() && !folder.mkdirs()) {
            throw new IOException("Could not create directory: " + folder);
        }
        try (InputStream input = NlPaletteModel.class.getResourceAsStream(metadata);
             FileOutputStream output = new FileOutputStream(paletteFile);){
            FileUtil.copy((InputStream)input, (OutputStream)output);
        }
    }

    private static boolean isOutOfDate(@NotNull File file, @NotNull String metadata) throws IOException {
        if (!file.exists()) {
            return true;
        }
        URL url = NlPaletteModel.class.getResource(metadata);
        URLConnection connection = url.openConnection();
        try (InputStream stream = connection.getInputStream();){
            boolean bl = connection.getLastModified() > file.lastModified();
            return bl;
        }
    }
}

