/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.SegmentType;
import java.awt.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionHandle {
    public static final int PIXEL_RADIUS = 8;
    public static final int PIXEL_MARGIN = 2;
    @NotNull
    public final NlComponent component;
    private final Position myPosition;

    public int getCenterX() {
        return this.component.x + (int)(this.myPosition.alignX * (double)this.component.w);
    }

    public int getCenterY() {
        return this.component.y + (int)(this.myPosition.alignY * (double)this.component.h);
    }

    public SelectionHandle(@NotNull NlComponent component, @NotNull Position position) {
        this.component = component;
        this.myPosition = position;
    }

    public boolean contains(int x, int y, int distance) {
        int xDelta = Math.abs(x - this.getCenterX());
        if (xDelta > distance) {
            return false;
        }
        int yDelta = Math.abs(y - this.getCenterY());
        return yDelta <= distance;
    }

    public Position getPosition() {
        return this.myPosition;
    }

    public int getAwtCursorType() {
        return this.myPosition.getCursorType();
    }

    @NotNull
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(this.getAwtCursorType());
    }

    @Nullable
    public SegmentType getHorizontalEdge() {
        return this.myPosition.isTop() ? SegmentType.TOP : (this.myPosition.isBottom() ? SegmentType.BOTTOM : null);
    }

    @Nullable
    public SegmentType getVerticalEdge() {
        return this.myPosition.isLeft() ? SegmentType.LEFT : (this.myPosition.isRight() ? SegmentType.RIGHT : null);
    }

    public static enum Position {
        TOP_MIDDLE(8, 0.5, 0.0),
        TOP_RIGHT(7, 1.0, 0.0),
        RIGHT_MIDDLE(11, 1.0, 0.5),
        BOTTOM_RIGHT(5, 1.0, 1.0),
        BOTTOM_MIDDLE(9, 0.5, 1.0),
        BOTTOM_LEFT(4, 0.0, 1.0),
        LEFT_MIDDLE(10, 0.0, 0.5),
        TOP_LEFT(6, 0.0, 0.0);

        public final double alignX;
        public final double alignY;
        private final int myAwtCursor;

        private Position(int awtCursor, double alignX, double alignY) {
            this.myAwtCursor = awtCursor;
            this.alignX = alignX;
            this.alignY = alignY;
        }

        private int getCursorType() {
            return this.myAwtCursor;
        }

        public boolean isLeft() {
            return this == TOP_LEFT || this == LEFT_MIDDLE || this == BOTTOM_LEFT;
        }

        public boolean isRight() {
            return this == TOP_RIGHT || this == RIGHT_MIDDLE || this == BOTTOM_RIGHT;
        }

        public boolean isTop() {
            return this == TOP_LEFT || this == TOP_MIDDLE || this == TOP_RIGHT;
        }

        public boolean isBottom() {
            return this == BOTTOM_LEFT || this == BOTTOM_MIDDLE || this == BOTTOM_RIGHT;
        }
    }
}

