/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import android.view.ViewGroup;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.google.common.base.Splitter;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.util.text.StringUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutParamsManager {
    private static final Object MISSING = new Object();
    private static final Cache<String, Map<String, Object>> ourDefaultValuesCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).softValues().build();
    private static final Map<String, Function<String, MappedField>> FIELD_MAPPERS = new HashMap<String, Function<String, MappedField>>();

    public static void registerFieldMapper(@NotNull String layoutParamsClassName, @NotNull Function<String, MappedField> mapper) {
        FIELD_MAPPERS.put(layoutParamsClassName, mapper);
    }

    private static boolean setField(@NotNull Object target, @NotNull MappedField fieldName, @Nullable Object value) {
        try {
            target.getClass().getField(fieldName.name).set(target, value);
            return true;
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            String setterName = "set" + StringUtil.capitalize((String)fieldName.name);
            Optional<Method> setterMethod = Arrays.stream(target.getClass().getMethods()).filter(method -> method.getParameterCount() == 1 && method.getName().equals(setterName)).findFirst();
            if (setterMethod.isPresent()) {
                try {
                    setterMethod.get().invoke(target, value);
                    return true;
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException2) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    @NotNull
    private static Integer getDimensionValue(@NotNull String value, @NotNull Configuration configuration) {
        switch (value) {
            case "fill_parent": 
            case "match_parent": {
                return -1;
            }
            case "wrap_content": {
                return -2;
            }
        }
        ResourceHelper.TypedValue out = new ResourceHelper.TypedValue();
        if (ResourceHelper.parseFloatAttribute(value, out, true)) {
            return ResourceHelper.TypedValue.complexToDimensionPixelSize(out.data, configuration);
        }
        return 0;
    }

    @NotNull
    private static FieldType inferTypeFromField(@NotNull Object layoutParams, @NotNull MappedField mappedField) {
        try {
            Field field = layoutParams.getClass().getField(mappedField.name);
            return FieldType.fromType(field.getType());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return FieldType.UNKNOWN;
        }
    }

    @Nullable
    private static Object getDefaultValue(@NotNull Object layoutParams, @NotNull MappedField field) throws NoSuchElementException {
        Object defaultValue;
        String layoutParamsClassName = layoutParams.getClass().getName();
        Map<String, Object> layoutParamsDefaults = (Map<String, Object>)ourDefaultValuesCache.getIfPresent((Object)layoutParamsClassName);
        if (layoutParamsDefaults == null) {
            layoutParamsDefaults = LayoutParamsManager.getDefaultValuesFromClass(layoutParams.getClass());
            ourDefaultValuesCache.put((Object)layoutParamsClassName, layoutParamsDefaults);
        }
        if ((defaultValue = layoutParamsDefaults.getOrDefault(field.name, MISSING)) == MISSING) {
            throw new NoSuchElementException();
        }
        return defaultValue;
    }

    private static FieldType inferTypeFromValue(@Nullable String value) {
        if (value != null && (value.endsWith("dp") || value.endsWith("dip") || value.endsWith("px"))) {
            return FieldType.DIMENSION;
        }
        return FieldType.UNKNOWN;
    }

    @NotNull
    private static Map<String, Object> getDefaultValuesFromClass(@NotNull Class layoutParamsClass) {
        Object layoutParamsClassInstance = null;
        for (Constructor<?> constructor : layoutParamsClass.getConstructors()) {
            Object[] parameterDefaults;
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != (parameterDefaults = Arrays.stream(parameterTypes).map(type -> {
                if (type == Integer.class || type == Integer.TYPE) {
                    return 0;
                }
                return null;
            }).filter(Objects::nonNull).toArray()).length) continue;
            try {
                layoutParamsClassInstance = constructor.newInstance(parameterDefaults);
                break;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        if (layoutParamsClassInstance == null) {
            return Collections.emptyMap();
        }
        Field[] fields = layoutParamsClass.getFields();
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        Object finalLayoutParamsClassInstance = layoutParamsClassInstance;
        Arrays.stream(fields).filter(field -> !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers())).forEach(field -> {
            try {
                defaults.put(field.getName(), field.get(finalLayoutParamsClassInstance));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        });
        Method[] methods = layoutParamsClass.getMethods();
        Arrays.stream(methods).filter(method -> method.getParameterCount() == 0 && Modifier.isPublic(method.getModifiers()) && method.getName().startsWith("get")).forEach(method -> {
            String propertyName = StringUtil.decapitalize((String)StringUtil.trimStart((String)method.getName(), (String)"get"));
            if (!defaults.containsKey(propertyName)) {
                try {
                    defaults.put(propertyName, method.invoke(finalLayoutParamsClassInstance, new Object[0]));
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
        });
        return defaults;
    }

    @NotNull
    private static MappedField mapField(@NotNull Object layoutParams, @NotNull String attributeName) {
        Class<?> currentClass = layoutParams.getClass();
        while (!currentClass.equals(Object.class)) {
            MappedField mappedField;
            Function<String, MappedField> fieldMapper = FIELD_MAPPERS.get(currentClass.getName());
            if (fieldMapper != null && (mappedField = fieldMapper.apply(attributeName)) != null) {
                try {
                    currentClass.getDeclaredField(mappedField.name);
                    return mappedField;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    String setterName = "set" + StringUtil.capitalize((String)mappedField.name);
                    for (Method method : currentClass.getDeclaredMethods()) {
                        if (!setterName.equals(method.getName())) continue;
                        return mappedField;
                    }
                }
            }
            currentClass = currentClass.getSuperclass();
        }
        return new MappedField(attributeName, FieldType.UNKNOWN);
    }

    public static boolean setAttribute(@NotNull Object layoutParams, @NotNull String attributeName, @Nullable String value, @NotNull NlModel model) {
        boolean fieldSet;
        ResourceValue resourceValue;
        FieldType inferredType = FieldType.UNKNOWN;
        if (value != null && (value.startsWith("@") || value.startsWith("?")) && model.getConfiguration().getResourceResolver() != null && (resourceValue = model.getConfiguration().getResourceResolver().findResValue(value, false)) != null) {
            value = resourceValue.getValue();
            switch (resourceValue.getResourceType()) {
                case INTEGER: 
                case ID: 
                case DIMEN: {
                    inferredType = FieldType.INTEGER;
                    break;
                }
                case FRACTION: {
                    inferredType = FieldType.FLOAT;
                }
            }
            if (resourceValue.getResourceType() == ResourceType.ID) {
                Integer resolvedId = AppResourceRepository.getAppResources(model.getFacet(), true).getResourceId(ResourceType.ID, resourceValue.getName());
                value = resolvedId.toString();
            }
        }
        MappedField mappedField = LayoutParamsManager.mapField(layoutParams, attributeName);
        if (inferredType == FieldType.UNKNOWN) {
            inferredType = mappedField.type;
        }
        if (inferredType == FieldType.UNKNOWN) {
            inferredType = LayoutParamsManager.inferTypeFromValue(value);
        }
        if (inferredType == FieldType.UNKNOWN) {
            inferredType = LayoutParamsManager.inferTypeFromField(layoutParams, mappedField);
        }
        Object defaultValue = null;
        try {
            defaultValue = LayoutParamsManager.getDefaultValue(layoutParams, mappedField);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (defaultValue != null && inferredType == FieldType.UNKNOWN) {
            inferredType = FieldType.fromType(defaultValue.getClass());
        }
        if (value == null) {
            return LayoutParamsManager.setField(layoutParams, mappedField, defaultValue);
        }
        String layoutParamsName = layoutParams.getClass().getName();
        if (inferredType == FieldType.INTEGER && value.equalsIgnoreCase("parent") && layoutParamsName.equalsIgnoreCase("android.support.constraint.ConstraintLayout$LayoutParams")) {
            value = "0";
        }
        switch (inferredType) {
            case DIMENSION: {
                fieldSet = LayoutParamsManager.setField(layoutParams, mappedField, LayoutParamsManager.getDimensionValue(value, model.getConfiguration()));
                break;
            }
            case INTEGER: {
                try {
                    fieldSet = LayoutParamsManager.setField(layoutParams, mappedField, Integer.parseInt(value));
                }
                catch (NumberFormatException e) {
                    fieldSet = false;
                }
                break;
            }
            case STRING: {
                fieldSet = LayoutParamsManager.setField(layoutParams, mappedField, value);
                break;
            }
            case BOOLEAN: {
                fieldSet = LayoutParamsManager.setField(layoutParams, mappedField, Boolean.parseBoolean(value));
                break;
            }
            case FLOAT: {
                try {
                    fieldSet = LayoutParamsManager.setField(layoutParams, mappedField, Float.valueOf(Float.parseFloat(value)));
                }
                catch (NumberFormatException e) {
                    fieldSet = false;
                }
                break;
            }
            default: {
                return false;
            }
        }
        return fieldSet;
    }

    static {
        LayoutParamsManager.registerFieldMapper(ViewGroup.LayoutParams.class.getName(), attributeName -> {
            switch (attributeName) {
                case "width": 
                case "height": {
                    return new MappedField((String)attributeName, FieldType.DIMENSION);
                }
                case "gravity": {
                    return new MappedField((String)attributeName, FieldType.FLAG);
                }
            }
            return null;
        });
        LayoutParamsManager.registerFieldMapper(ViewGroup.MarginLayoutParams.class.getName(), attributeName -> {
            switch (attributeName) {
                case "marginBottom": {
                    return new MappedField("bottomMargin", FieldType.DIMENSION);
                }
                case "marginTop": {
                    return new MappedField("topMargin", FieldType.DIMENSION);
                }
                case "marginLeft": {
                    return new MappedField("leftMargin", FieldType.DIMENSION);
                }
                case "marginRight": {
                    return new MappedField("rightMargin", FieldType.DIMENSION);
                }
                case "marginStart": {
                    return new MappedField((String)attributeName, FieldType.DIMENSION);
                }
                case "marginEnd": {
                    return new MappedField((String)attributeName, FieldType.DIMENSION);
                }
            }
            return null;
        });
        LayoutParamsManager.registerFieldMapper("android.support.constraint.ConstraintLayout$LayoutParams", attributeName -> {
            attributeName = StringUtil.trimStart((String)attributeName, (String)"constraint");
            attributeName = StringUtil.trimEnd((String)attributeName, (String)"Of");
            StringBuilder fieldName = new StringBuilder();
            boolean first = true;
            for (String component : Splitter.on((char)'_').split((CharSequence)attributeName)) {
                fieldName.append(first ? StringUtil.decapitalize((String)component) : StringUtil.capitalize((String)component));
                first = false;
            }
            return new MappedField(fieldName.toString(), FieldType.UNKNOWN);
        });
    }

    private static class MappedField {
        @NotNull
        private final String name;
        @NotNull
        private final FieldType type;

        MappedField(@NotNull String fieldName, @NotNull FieldType type) {
            this.name = fieldName;
            this.type = type;
        }
    }

    private static enum FieldType {
        UNKNOWN,
        INTEGER,
        DIMENSION,
        FLOAT,
        STRING,
        BOOLEAN,
        ENUM,
        FLAG;


        public static FieldType fromType(@NotNull Class type) {
            if (type == Integer.class || type == Integer.TYPE) {
                return INTEGER;
            }
            if (type == Float.class || type == Float.TYPE) {
                return FLOAT;
            }
            if (type == String.class) {
                return STRING;
            }
            return UNKNOWN;
        }
    }
}

