/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.preference;

import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceGroupDragHandler;
import com.android.tools.idea.uibuilder.model.NlComponent;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class PreferenceCategoryDragHandler
extends PreferenceGroupDragHandler {
    PreferenceCategoryDragHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull NlComponent preferenceGroup, @NotNull List<NlComponent> preferences, @NotNull DragType type) {
        super(editor, handler, preferenceGroup, preferences, type);
    }

    @Override
    void drawDropPreviewLine(@NotNull NlGraphics graphics) {
        int count = this.myPreferenceGroup.getChildCount();
        graphics.useStyle(NlDrawingStyle.DROP_PREVIEW);
        if (count == 0) {
            PreferenceCategoryDragHandler.drawBottom(graphics, this.myPreferenceGroup);
        } else if (this.myInsertIndex == -1) {
            PreferenceCategoryDragHandler.drawBottom(graphics, this.getChild(count - 1));
        } else {
            graphics.drawTop(this.getChild(this.myInsertIndex));
        }
    }

    @Override
    void drawDropRecipientLines(@NotNull NlGraphics graphics) {
        int count = this.myPreferenceGroup.getChildCount();
        NlComponent preference = count == 0 ? this.myPreferenceGroup : this.getChild(count - 1);
        graphics.useStyle(NlDrawingStyle.DROP_RECIPIENT);
        graphics.drawTop(this.myPreferenceGroup);
        graphics.drawLine(this.myPreferenceGroup.x, this.myPreferenceGroup.y, this.myPreferenceGroup.x, preference.y + preference.h);
        graphics.drawLine(this.myPreferenceGroup.x + this.myPreferenceGroup.w, this.myPreferenceGroup.y, this.myPreferenceGroup.x + this.myPreferenceGroup.w, preference.y + preference.h);
        if ((count != 0 || this.myInsertIndex != 0) && this.myInsertIndex != -1) {
            PreferenceCategoryDragHandler.drawBottom(graphics, preference);
        }
    }

    @Override
    void drawDropZoneLines(@NotNull NlGraphics graphics) {
        int count = this.myPreferenceGroup.getChildCount();
        if (count == 0) {
            return;
        }
        graphics.useStyle(NlDrawingStyle.DROP_ZONE);
        for (int i = 0; i < count; ++i) {
            if (i == this.myInsertIndex) continue;
            graphics.drawTop(this.getChild(i));
        }
    }
}

