/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.grid;

import com.android.tools.idea.uibuilder.handlers.grid.ChildInfo;
import com.android.tools.idea.uibuilder.model.Insets;
import com.android.tools.idea.uibuilder.model.NlComponent;
import java.awt.Dimension;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

final class GridInfo {
    private static final int NEW_CELL_SIZE = 32;
    private int[] verticalLineLocations;
    private int[] horizontalLineLocations;
    private NlComponent[][] children;
    private final int rowCount;
    private final int columnCount;
    private final NlComponent layout;
    private final Dimension size;

    GridInfo(NlComponent layout) {
        if (layout.children == null || layout.viewInfo == null) {
            throw new IllegalArgumentException();
        }
        this.layout = layout;
        this.size = this.getSize();
        try {
            this.initVerticalLineLocations();
            this.initHorizontalLineLocations();
            Object view = layout.viewInfo.getViewObject();
            Class<?> c = view.getClass();
            this.rowCount = (Integer)c.getDeclaredMethod("getRowCount", new Class[0]).invoke(view, new Object[0]);
            this.columnCount = (Integer)c.getDeclaredMethod("getColumnCount", new Class[0]).invoke(view, new Object[0]);
            this.initChildren();
        }
        catch (NoSuchFieldException exception) {
            throw new IllegalArgumentException(exception);
        }
        catch (IllegalAccessException exception) {
            throw new IllegalArgumentException(exception);
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalArgumentException(exception);
        }
        catch (InvocationTargetException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    private Dimension getSize() {
        Dimension size = new Dimension();
        if (this.layout.children != null) {
            Insets padding = this.layout.getPadding();
            for (NlComponent child : this.layout.children) {
                size.width = Math.max(child.x - this.layout.x - padding.left + child.w, size.width);
                size.height = Math.max(child.y - this.layout.y - padding.top + child.h, size.height);
            }
        }
        return size;
    }

    private void initVerticalLineLocations() throws NoSuchFieldException, IllegalAccessException {
        Insets padding = this.layout.getPadding();
        int[] horizontalAxisLocations = this.getAxisLocations("mHorizontalAxis", "horizontalAxis");
        this.verticalLineLocations = GridInfo.initLineLocations(this.layout.w - padding.width(), this.size.width, horizontalAxisLocations);
        GridInfo.translate(this.verticalLineLocations, this.layout.x + padding.left);
    }

    private void initHorizontalLineLocations() throws NoSuchFieldException, IllegalAccessException {
        Insets padding = this.layout.getPadding();
        int[] verticalAxisLocations = this.getAxisLocations("mVerticalAxis", "verticalAxis");
        this.horizontalLineLocations = GridInfo.initLineLocations(this.layout.h - padding.height(), this.size.height, verticalAxisLocations);
        GridInfo.translate(this.horizontalLineLocations, this.layout.y + padding.top);
    }

    private int[] getAxisLocations(String name1, String name2) throws NoSuchFieldException, IllegalAccessException {
        assert (this.layout.viewInfo != null);
        Object view = this.layout.viewInfo.getViewObject();
        Field axisField = GridInfo.getDeclaredField(view.getClass(), name1, name2);
        axisField.setAccessible(true);
        Object axis = axisField.get(view);
        Field locationsField = axis.getClass().getDeclaredField("locations");
        locationsField.setAccessible(true);
        return (int[])locationsField.get(axis);
    }

    private static Field getDeclaredField(Class<?> c, String name1, String name2) throws NoSuchFieldException {
        try {
            return c.getDeclaredField(name1);
        }
        catch (NoSuchFieldException exception) {
            return c.getDeclaredField(name2);
        }
    }

    static int[] initLineLocations(int layoutSize, int gridInfoSize, int[] axisLocations) {
        int startIndex;
        int difference = layoutSize - gridInfoSize;
        int lineLocationsLength = difference > 0 ? axisLocations.length + difference / 32 : axisLocations.length;
        int[] lineLocations = Arrays.copyOf(axisLocations, lineLocationsLength);
        if (axisLocations.length == 0) {
            startIndex = 1;
        } else {
            lineLocations[axisLocations.length - 1] = gridInfoSize;
            startIndex = axisLocations.length;
        }
        for (int i = startIndex; i < lineLocationsLength; ++i) {
            lineLocations[i] = lineLocations[i - 1] + 32;
        }
        if (lineLocations[lineLocations.length - 1] != layoutSize) {
            lineLocations = Arrays.copyOf(lineLocations, lineLocations.length + 1);
        }
        lineLocations[lineLocations.length - 1] = layoutSize - 1;
        return lineLocations;
    }

    private static void translate(int[] locations, int distance) {
        int i = 0;
        while (i < locations.length) {
            int n = i++;
            locations[n] = locations[n] + distance;
        }
    }

    private void initChildren() throws NoSuchFieldException, IllegalAccessException {
        this.children = new NlComponent[this.rowCount][this.columnCount];
        assert (this.layout.children != null);
        for (NlComponent child : this.layout.children) {
            ChildInfo info = GridInfo.getInfo(child);
            int endRow = Math.min(info.getRow2(), this.rowCount);
            int endColumn = Math.min(info.getColumn2(), this.columnCount);
            for (int row = info.getRow1(); row < endRow; ++row) {
                for (int column = info.getColumn1(); column < endColumn; ++column) {
                    this.children[row][column] = child;
                }
            }
        }
    }

    private static ChildInfo getInfo(NlComponent child) throws NoSuchFieldException, IllegalAccessException {
        assert (child.viewInfo != null);
        Object params = child.viewInfo.getLayoutParamsObject();
        Class<?> paramsClass = params.getClass();
        Object rowSpec = paramsClass.getDeclaredField("rowSpec").get(params);
        Object columnSpec = paramsClass.getDeclaredField("columnSpec").get(params);
        Field span = rowSpec.getClass().getDeclaredField("span");
        span.setAccessible(true);
        return new ChildInfo(span.get(rowSpec), span.get(columnSpec));
    }

    int getRow(int y) {
        return GridInfo.getIndex(this.horizontalLineLocations, y, false);
    }

    int getRowSkippingEqualLineLocations(int y) {
        return GridInfo.getIndex(this.horizontalLineLocations, y, true);
    }

    int getColumn(int x) {
        return GridInfo.getIndex(this.verticalLineLocations, x, false);
    }

    int getColumnSkippingEqualLineLocations(int x) {
        return GridInfo.getIndex(this.verticalLineLocations, x, true);
    }

    static int getIndex(int[] lineLocations, int location, boolean skipEqualLineLocations) {
        if (lineLocations.length < 2) {
            throw new IllegalArgumentException(Arrays.toString(lineLocations));
        }
        if (location < lineLocations[0]) {
            return 0;
        }
        if (location >= lineLocations[lineLocations.length - 1]) {
            return lineLocations.length - 2;
        }
        int j = 0;
        for (int i = 0; i < lineLocations.length - 1; ++i) {
            if (skipEqualLineLocations && lineLocations[i] == lineLocations[i + 1]) continue;
            if (lineLocations[i] <= location && location < lineLocations[i + 1]) {
                return j;
            }
            ++j;
        }
        throw new AssertionError();
    }

    int[] getVerticalLineLocations() {
        return this.verticalLineLocations;
    }

    int[] getHorizontalLineLocations() {
        return this.horizontalLineLocations;
    }

    boolean cellHasChild(int row, int column) {
        return 0 <= row && row < this.rowCount && 0 <= column && column < this.columnCount && this.children[row][column] != null;
    }

    NlComponent[][] getChildren() {
        return this.children;
    }

    int getRowCount() {
        return this.rowCount;
    }

    int getColumnCount() {
        return this.columnCount;
    }
}

