/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import android.support.constraint.solver.widgets.ConstraintWidget;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintModel;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.sherpa.drawing.AndroidColorSet;
import com.android.tools.sherpa.drawing.BlueprintColorSet;
import com.android.tools.sherpa.drawing.ColorSet;
import com.android.tools.sherpa.drawing.SceneDraw;
import com.android.tools.sherpa.drawing.ViewTransform;
import com.android.tools.sherpa.drawing.decorator.WidgetDecorator;
import com.android.tools.sherpa.interaction.MouseInteraction;
import com.android.tools.sherpa.interaction.WidgetMotion;
import com.android.tools.sherpa.interaction.WidgetResize;
import com.android.tools.sherpa.structure.Selection;
import com.android.tools.sherpa.structure.WidgetsScene;
import java.awt.Graphics2D;
import org.jetbrains.annotations.NotNull;

class DrawConstraintModel {
    private final ConstraintModel myConstraintModel;
    private final ViewTransform myViewTransform = new ViewTransform();
    private final SceneDraw mySceneDraw;
    private final MouseInteraction myMouseInteraction;
    private boolean mShowFakeUI = true;

    public DrawConstraintModel(ScreenView screenView, ConstraintModel constraintModel) {
        this.myConstraintModel = constraintModel;
        WidgetsScene widgetsScene = constraintModel.getScene();
        Selection selection = constraintModel.getSelection();
        RepaintSurface repaintSurface = new RepaintSurface();
        repaintSurface.myScreenView = screenView;
        WidgetMotion widgetMotion = new WidgetMotion(widgetsScene, selection);
        WidgetResize widgetResize = new WidgetResize();
        this.mySceneDraw = new SceneDraw((ColorSet)new BlueprintColorSet(), widgetsScene, selection, widgetMotion, widgetResize);
        this.mySceneDraw.setRepaintableSurface((SceneDraw.Repaintable)repaintSurface);
        this.myMouseInteraction = new MouseInteraction(this.myViewTransform, widgetsScene, selection, widgetMotion, widgetResize, this.mySceneDraw, null);
        if (screenView.getScreenViewType() == ScreenView.ScreenViewType.NORMAL) {
            this.mySceneDraw.setColorSet((ColorSet)new AndroidColorSet());
        } else {
            this.mySceneDraw.setColorSet((ColorSet)new BlueprintColorSet());
        }
    }

    public void setInteractionComponent(NlComponent component) {
        WidgetsScene widgetsScene = this.myConstraintModel.getScene();
        ConstraintWidget widget = widgetsScene.getWidget((Object)component);
        this.myMouseInteraction.setInteractionComponent(widget);
    }

    public void repaint() {
        this.mySceneDraw.repaint();
    }

    public void mousePressed(int x, int y) {
        if (this.myMouseInteraction != null) {
            this.myMouseInteraction.mousePressed((float)this.pxToDp(x), (float)this.pxToDp(y), false);
            this.myMouseInteraction.setAutoConnect(ConstraintModel.isAutoConnect());
        }
    }

    public void mouseDragged(int x, int y) {
        if (this.myMouseInteraction != null) {
            this.myMouseInteraction.mouseDragged(this.pxToDp(x), this.pxToDp(y));
        }
    }

    public void mouseReleased(int x, int y) {
        if (this.myMouseInteraction != null) {
            this.myMouseInteraction.mouseReleased(this.pxToDp(x), this.pxToDp(y));
        }
        this.myConstraintModel.requestRender();
    }

    public boolean mouseMoved(int x, int y) {
        if (this.myMouseInteraction != null) {
            this.myMouseInteraction.mouseMoved((float)this.pxToDp(x), (float)this.pxToDp(y));
        }
        return this.mySceneDraw.getCurrentUnderneathAnchor() != null;
    }

    public void updateModifiers(int modifiers) {
        this.myMouseInteraction.setIsControlDown((modifiers & 0x80) != 0 || (modifiers & 2) != 0);
        this.myMouseInteraction.setIsShiftDown((modifiers & 0x40) != 0 || (modifiers & 1) != 0);
        this.myMouseInteraction.setIsAltDown((modifiers & 0x200) != 0 || (modifiers & 8) != 0);
    }

    public MouseInteraction getMouseInteraction() {
        return this.myMouseInteraction;
    }

    public boolean paint(@NotNull Graphics2D gc, ConstraintWidget component, int width, int height, boolean showAllConstraints) {
        Graphics2D g = (Graphics2D)gc.create();
        WidgetDecorator.setShowFakeUI((boolean)this.mShowFakeUI);
        if (this.mySceneDraw.getCurrentStyle() == 0) {
            this.mySceneDraw.drawBackground(this.myConstraintModel.getScene().getWidget((Object)component), this.myViewTransform, g, width, height);
        }
        if (this.myConstraintModel.getNeedsAnimateConstraints() != -1) {
            this.mySceneDraw.animateConstraints(this.myConstraintModel.getNeedsAnimateConstraints());
            this.myConstraintModel.setNeedsAnimateConstraints(-1);
        }
        boolean ret = this.mySceneDraw.paintWidgets(component, width, height, this.myViewTransform, g, showAllConstraints, this.myMouseInteraction);
        g.dispose();
        return ret;
    }

    public int pxToDp(int px) {
        return this.myConstraintModel.pxToDp(px);
    }

    @NotNull
    public ViewTransform getViewTransform() {
        return this.myViewTransform;
    }

    public ConstraintModel getConstraintModel() {
        return this.myConstraintModel;
    }

    private static class RepaintSurface
    implements SceneDraw.Repaintable {
        ScreenView myScreenView;

        private RepaintSurface() {
        }

        public void repaint() {
            if (this.myScreenView != null) {
                this.myScreenView.getSurface().repaint();
            }
        }

        public void repaint(int x, int y, int w, int h) {
            this.myScreenView.getSurface().repaint(x, y, w, h);
        }
    }
}

