/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import android.support.constraint.solver.widgets.ConstraintWidget;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.DirectViewAction;
import com.android.tools.idea.uibuilder.api.actions.NestedViewActionMenu;
import com.android.tools.idea.uibuilder.api.actions.ToggleViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewActionPresentation;
import com.android.tools.idea.uibuilder.api.actions.ViewActionSeparator;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintDragHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintInteraction;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintModel;
import com.android.tools.idea.uibuilder.handlers.constraint.DrawConstraintModel;
import com.android.tools.idea.uibuilder.handlers.constraint.MarginPopup;
import com.android.tools.idea.uibuilder.model.Coordinates;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.Interaction;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.sherpa.drawing.WidgetDraw;
import com.android.tools.sherpa.drawing.decorator.WidgetDecorator;
import com.android.tools.sherpa.interaction.MouseInteraction;
import com.android.tools.sherpa.scout.Scout;
import com.android.tools.sherpa.structure.Selection;
import com.android.tools.sherpa.structure.WidgetsScene;
import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class ConstraintLayoutHandler
extends ViewGroupHandler {
    private static final String PREFERENCE_KEY_PREFIX = "ConstraintLayoutPreference";
    public static final String AUTO_CONNECT_PREF_KEY = "ConstraintLayoutPreferenceAutoConnect";
    public static final String SHOW_CONSTRAINTS_PREF_KEY = "ConstraintLayoutPreferenceShowAllConstraints";
    private boolean myShowAllConstraints = true;
    ArrayList<ViewAction> myActions = new ArrayList();
    ArrayList<ViewAction> myPopupActions = new ArrayList();
    ArrayList<ViewAction> myControlActions = new ArrayList();

    static Image iconToImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage image = UIUtil.createImage((int)w, (int)h, (int)6);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public ConstraintLayoutHandler() {
        ConstraintLayoutHandler.loadWidgetDecoratorImages();
    }

    private static void loadWidgetDecoratorImages() {
        if (WidgetDecorator.sLockImageIcon == null) {
            WidgetDecorator.sLockImageIcon = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.LockConstraints);
        }
        if (WidgetDecorator.sUnlockImageIcon == null) {
            WidgetDecorator.sUnlockImageIcon = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.UnlockConstraints);
        }
        if (WidgetDecorator.sDeleteConnectionsImageIcon == null) {
            WidgetDecorator.sDeleteConnectionsImageIcon = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.DeleteConstraintB);
        }
        if (WidgetDraw.sGuidelineArrowLeft == null) {
            WidgetDraw.sGuidelineArrowLeft = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.ArrowLeft);
        }
        if (WidgetDraw.sGuidelineArrowRight == null) {
            WidgetDraw.sGuidelineArrowRight = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.ArrowRight);
        }
        if (WidgetDraw.sGuidelineArrowUp == null) {
            WidgetDraw.sGuidelineArrowUp = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.ArrowUp);
        }
        if (WidgetDraw.sGuidelineArrowDown == null) {
            WidgetDraw.sGuidelineArrowDown = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.ArrowDown);
        }
        if (WidgetDraw.sGuidelinePercent == null) {
            WidgetDraw.sGuidelinePercent = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.Percent);
        }
    }

    @Override
    @NotNull
    public String getGradleCoordinate(@NotNull String tagName) {
        return "com.android.support.constraint:constraint-layout";
    }

    @Override
    public void addToolbarActions(@NotNull List<ViewAction> actions) {
        this.myActions.clear();
        this.myControlActions.clear();
        actions.add(new ToggleConstraintModeAction());
        actions.add(new ToggleAutoConnectAction());
        actions.add(new ViewActionSeparator());
        actions.add(new ClearConstraintsAction());
        actions.add(new InferAction());
        actions.add(new ViewActionSeparator());
        actions.add(new MarginSelector());
        actions.add(new NestedViewActionMenu("Pack", AndroidIcons.SherpaIcons.PackSelectionVertically, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new ViewAction[]{new AlignAction(Scout.Arrange.HorizontalPack, AndroidIcons.SherpaIcons.PackSelectionHorizontally, "Pack Horizontally"), new AlignAction(Scout.Arrange.VerticalPack, AndroidIcons.SherpaIcons.PackSelectionVertically, "Pack Vertically"), new AlignAction(Scout.Arrange.ExpandHorizontally, AndroidIcons.SherpaIcons.HorizontalExpand, "Expand Horizontally"), new AlignAction(Scout.Arrange.ExpandVertically, AndroidIcons.SherpaIcons.VerticalExpand, "Expand Vertically")}), Lists.newArrayList((Object[])new ViewAction[]{new ViewActionSeparator()}), Lists.newArrayList((Object[])new ViewAction[]{new AlignAction(Scout.Arrange.DistributeHorizontally, AndroidIcons.SherpaIcons.HorizontalDistribute, AndroidIcons.SherpaIcons.HorizontalDistributeB, "Distribute Horizontally"), new AlignAction(Scout.Arrange.DistributeVertically, AndroidIcons.SherpaIcons.verticallyDistribute, AndroidIcons.SherpaIcons.verticallyDistribute, "Distribute Vertically")})})));
        actions.add(new NestedViewActionMenu("Align", AndroidIcons.SherpaIcons.LeftAlignedB, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new ViewAction[]{new AlignAction(Scout.Arrange.AlignHorizontallyLeft, AndroidIcons.SherpaIcons.LeftAligned, AndroidIcons.SherpaIcons.LeftAlignedB, "Align Left Edges"), new AlignAction(Scout.Arrange.AlignHorizontallyCenter, AndroidIcons.SherpaIcons.CenterAligned, AndroidIcons.SherpaIcons.CenterAlignedB, "Align Horizontal Centers"), new AlignAction(Scout.Arrange.AlignHorizontallyRight, AndroidIcons.SherpaIcons.RightAligned, AndroidIcons.SherpaIcons.RightAlignedB, "Align Right Edges")}), Lists.newArrayList((Object[])new ViewAction[]{new AlignAction(Scout.Arrange.AlignVerticallyTop, AndroidIcons.SherpaIcons.TopAlign, AndroidIcons.SherpaIcons.TopAlignB, "Align Top Edges"), new AlignAction(Scout.Arrange.AlignVerticallyMiddle, AndroidIcons.SherpaIcons.MiddleAlign, AndroidIcons.SherpaIcons.MiddleAlignB, "Align Vertical Centers"), new AlignAction(Scout.Arrange.AlignVerticallyBottom, AndroidIcons.SherpaIcons.BottomAlign, AndroidIcons.SherpaIcons.BottomAlignB, "Align Bottom Edges"), new AlignAction(Scout.Arrange.AlignBaseline, AndroidIcons.SherpaIcons.BaselineAlign, AndroidIcons.SherpaIcons.BaselineAlignB, "Align Baselines")}), Lists.newArrayList((Object[])new ViewAction[]{new ViewActionSeparator()}), Lists.newArrayList((Object[])new ViewAction[]{new AlignAction(Scout.Arrange.CenterHorizontally, AndroidIcons.SherpaIcons.HorizontalCenter, AndroidIcons.SherpaIcons.HorizontalCenterB, "Center Horizontally"), new AlignAction(Scout.Arrange.CenterVertically, AndroidIcons.SherpaIcons.VerticalCenter, AndroidIcons.SherpaIcons.VerticalCenterB, "Center Vertically"), new AlignAction(Scout.Arrange.CenterHorizontallyInParent, AndroidIcons.SherpaIcons.HorizontalCenterParent, AndroidIcons.SherpaIcons.HorizontalCenterParentB, "Center Horizontally in Parent"), new AlignAction(Scout.Arrange.CenterVerticallyInParent, AndroidIcons.SherpaIcons.VerticalCenterParent, AndroidIcons.SherpaIcons.VerticalCenterParent, "Center Vertically in Parent")})})));
        actions.add(new NestedViewActionMenu("Guidelines", AndroidIcons.SherpaIcons.GuidelineVertical, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new ViewAction[]{new AddElementAction(1, AndroidIcons.SherpaIcons.GuidelineVertical, "Add Vertical Guideline"), new AddElementAction(0, AndroidIcons.SherpaIcons.GuidelineHorizontal, "Add Horizontal Guideline")})})));
    }

    @Override
    public void addPopupMenuActions(@NotNull List<ViewAction> actions) {
        actions.add(new ClearConstraintsAction());
        String str = "Pack Horizontally";
        DirectViewAction action = new AlignAction(Scout.Arrange.HorizontalPack, AndroidIcons.SherpaIcons.PackSelectionHorizontally, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Pack Vertically";
        action = new AlignAction(Scout.Arrange.VerticalPack, AndroidIcons.SherpaIcons.PackSelectionVertically, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Expand Horizontally";
        action = new AlignAction(Scout.Arrange.ExpandHorizontally, AndroidIcons.SherpaIcons.HorizontalExpand, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Expand Vertically";
        action = new AlignAction(Scout.Arrange.ExpandVertically, AndroidIcons.SherpaIcons.VerticalExpand, str);
        actions.add(action);
        this.myPopupActions.add(action);
        actions.add(new ViewActionSeparator());
        str = "Align Left Edges";
        action = new AlignAction(Scout.Arrange.AlignHorizontallyLeft, AndroidIcons.SherpaIcons.LeftAligned, AndroidIcons.SherpaIcons.LeftAlignedB, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Align Horizontal Centers";
        action = new AlignAction(Scout.Arrange.AlignHorizontallyCenter, AndroidIcons.SherpaIcons.CenterAligned, AndroidIcons.SherpaIcons.CenterAlignedB, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Align Right Edges";
        action = new AlignAction(Scout.Arrange.AlignHorizontallyRight, AndroidIcons.SherpaIcons.RightAligned, AndroidIcons.SherpaIcons.RightAlignedB, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Align Top Edges";
        action = new AlignAction(Scout.Arrange.AlignVerticallyTop, AndroidIcons.SherpaIcons.TopAlign, AndroidIcons.SherpaIcons.TopAlignB, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Align Vertical Centers";
        action = new AlignAction(Scout.Arrange.AlignVerticallyMiddle, AndroidIcons.SherpaIcons.MiddleAlign, AndroidIcons.SherpaIcons.MiddleAlignB, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Align Bottom Edges";
        action = new AlignAction(Scout.Arrange.AlignVerticallyBottom, AndroidIcons.SherpaIcons.BottomAlign, AndroidIcons.SherpaIcons.BottomAlignB, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Align Baselines";
        action = new AlignAction(Scout.Arrange.AlignBaseline, AndroidIcons.SherpaIcons.BaselineAlign, AndroidIcons.SherpaIcons.BottomAlignB, str);
        actions.add(action);
        this.myPopupActions.add(action);
        actions.add(new ViewActionSeparator());
        str = "Center Horizontally";
        action = new AlignAction(Scout.Arrange.CenterHorizontally, AndroidIcons.SherpaIcons.HorizontalCenter, AndroidIcons.SherpaIcons.HorizontalCenterB, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Center Vertically";
        action = new AlignAction(Scout.Arrange.CenterVertically, AndroidIcons.SherpaIcons.VerticalCenter, AndroidIcons.SherpaIcons.VerticalCenterB, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Center Horizontally in Parent";
        action = new AlignAction(Scout.Arrange.CenterHorizontallyInParent, AndroidIcons.SherpaIcons.HorizontalCenterParent, AndroidIcons.SherpaIcons.HorizontalCenterParentB, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Center Vertically in Parent";
        action = new AlignAction(Scout.Arrange.CenterVerticallyInParent, AndroidIcons.SherpaIcons.VerticalCenterParent, AndroidIcons.SherpaIcons.VerticalCenterParentB, str);
        actions.add(action);
        this.myPopupActions.add(action);
        this.addToolbarActionsToMenu("Constraint Layout", actions);
        str = "Add Vertical Guideline";
        action = new AddElementAction(1, AndroidIcons.SherpaIcons.GuidelineVertical, str);
        actions.add(action);
        this.myPopupActions.add(action);
        str = "Add Horizontal Guideline";
        action = new AddElementAction(0, AndroidIcons.SherpaIcons.GuidelineHorizontal, str);
        actions.add(action);
        this.myPopupActions.add(action);
    }

    public void updateActions(Selection selection) {
        Enableable e;
        if (this.myActions == null) {
            return;
        }
        for (ViewAction action : this.myActions) {
            if (!(action instanceof Enableable)) continue;
            e = (Enableable)((Object)action);
            e.enable(selection);
        }
        for (ViewAction action : this.myPopupActions) {
            if (!(action instanceof Enableable)) continue;
            e = (Enableable)((Object)action);
            e.enable(selection);
        }
    }

    @Override
    public Interaction createInteraction(@NotNull ScreenView screenView, @NotNull NlComponent component) {
        return new ConstraintInteraction(screenView, component);
    }

    @Override
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull NlComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        return new ConstraintDragHandler(editor, this, layout, components, type);
    }

    @Override
    public boolean updateCursor(@NotNull ScreenView screenView, int x, int y) {
        DrawConstraintModel drawConstraintModel = ConstraintModel.getDrawConstraintModel(screenView);
        drawConstraintModel.mouseMoved(x, y);
        int cursor = drawConstraintModel.getMouseInteraction().getMouseCursor();
        screenView.getSurface().setCursor(Cursor.getPredefinedCursor(cursor));
        return true;
    }

    @Override
    public boolean handlesPainting() {
        return true;
    }

    @Override
    public boolean drawGroup(@NotNull Graphics2D gc, @NotNull ScreenView screenView, @NotNull NlComponent component) {
        ConstraintModel constraintModel = ConstraintModel.getConstraintModel(screenView.getModel());
        DrawConstraintModel drawConstraintModel = ConstraintModel.getDrawConstraintModel(screenView);
        this.updateActions(constraintModel.getSelection());
        ConstraintWidget widget = constraintModel.getScene().getWidget((Object)component);
        return drawConstraintModel.paint(gc, widget, Coordinates.getSwingDimension(screenView, component.w), Coordinates.getSwingDimension(screenView, component.h), this.myShowAllConstraints);
    }

    private static class MarginSelector
    extends DirectViewAction {
        MarginPopup myMarginPopup = new MarginPopup();
        private int myMarginIconValue;
        private Icon myMarginIcon;

        public MarginSelector() {
            this.setLabel("Default Margins");
            this.myMarginPopup.setActionListener(e -> this.setMargin());
        }

        public void setMargin() {
            Scout.setMargin((int)this.myMarginPopup.getValue());
            MouseInteraction.setMargin((int)this.myMarginPopup.getValue());
        }

        private void updateIcon() {
            final int margin = this.myMarginPopup.getValue();
            if (this.myMarginIconValue != margin) {
                this.myMarginIconValue = margin;
                this.myMarginIcon = new Icon(){

                    @Override
                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        g.setFont(g.getFont().deriveFont(1, 12.0f));
                        String m = Integer.toString(margin);
                        FontMetrics metrics = g.getFontMetrics();
                        int strWidth = metrics.stringWidth(m);
                        int stringY = (this.getIconHeight() - metrics.getHeight()) / 2 + metrics.getAscent();
                        g.drawString(m, x + (this.getIconWidth() - strWidth) / 2, y + stringY);
                    }

                    @Override
                    public int getIconWidth() {
                        return 16;
                    }

                    @Override
                    public int getIconHeight() {
                        return 16;
                    }
                };
            }
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            ConstraintModel model = ConstraintModel.getConstraintModel(editor.getModel());
            if (model == null) {
                return;
            }
            DesignSurface surface = ((ViewEditorImpl)editor).getScreenView().getSurface();
            RelativePoint relativePoint = new RelativePoint((Component)surface, new Point(0, 0));
            JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myMarginPopup, this.myMarginPopup.getTextField()).setRequestFocus(true).createPopup().show(relativePoint);
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            this.updateIcon();
            if (this.myMarginIcon instanceof ControlIcon) {
                ((ControlIcon)this.myMarginIcon).setHighlight(ConstraintModel.isAutoConnect() || (2 & modifiers) != 0);
            }
            presentation.setIcon(this.myMarginIcon);
        }
    }

    private static class AlignAction
    extends DirectViewAction {
        private final Scout.Arrange myActionType;
        private final Icon myAlignIcon;
        private final Icon myConstrainIcon;
        private final String myToolTip;

        AlignAction(Scout.Arrange actionType, Icon alignIcon, String toolTip) {
            this.myActionType = actionType;
            this.myAlignIcon = alignIcon;
            this.myConstrainIcon = null;
            this.myToolTip = toolTip;
        }

        AlignAction(Scout.Arrange actionType, Icon alignIcon, Icon constrainIcon, String toolTip) {
            this.myActionType = actionType;
            this.myAlignIcon = alignIcon;
            this.myConstrainIcon = constrainIcon;
            this.myToolTip = toolTip;
        }

        private boolean isEnabled(int count) {
            switch (this.myActionType) {
                case AlignVerticallyTop: 
                case AlignVerticallyMiddle: 
                case AlignVerticallyBottom: 
                case AlignHorizontallyLeft: 
                case AlignHorizontallyCenter: 
                case AlignHorizontallyRight: 
                case DistributeVertically: 
                case DistributeHorizontally: 
                case VerticalPack: 
                case HorizontalPack: 
                case AlignBaseline: {
                    return count > 1;
                }
                case ExpandVertically: 
                case ExpandHorizontally: 
                case CenterHorizontallyInParent: 
                case CenterVerticallyInParent: 
                case CenterVertically: 
                case CenterHorizontally: {
                    return count >= 1;
                }
            }
            return false;
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            ConstraintModel model = ConstraintModel.getConstraintModel(editor.getModel());
            if (model == null) {
                return;
            }
            Scout.arrangeWidgets((Scout.Arrange)this.myActionType, (ArrayList)model.getSelection().getWidgets(), ((modifiers &= 2) != 0 || ConstraintModel.isAutoConnect() ? 1 : 0) != 0);
            model.saveToXML(true);
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            Icon icon = this.myAlignIcon;
            if (this.myConstrainIcon != null && (ConstraintModel.isAutoConnect() || (2 & modifiers) != 0)) {
                icon = this.myConstrainIcon;
            }
            presentation.setEnabled(this.isEnabled(selectedChildren.size()));
            presentation.setIcon(icon);
            presentation.setLabel(this.myToolTip);
        }
    }

    private static class AddElementAction
    extends DirectViewAction {
        public static final int HORIZONTAL_GUIDELINE = 0;
        public static final int VERTICAL_GUIDELINE = 1;
        final int myType;

        public AddElementAction(int type, Icon icon, String text) {
            super(icon, text);
            this.myType = type;
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            NlComponent parent;
            for (parent = component; parent != null && !parent.isOrHasSuperclass("android.support.constraint.ConstraintLayout"); parent = parent.getParent()) {
            }
            if (parent != null) {
                NlComponent guideline = parent.createChild(editor, "android.support.constraint.Guideline", null, InsertType.CREATE);
                guideline.ensureId();
                guideline.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", "20dp");
                if (this.myType == 0) {
                    guideline.setAttribute("http://schemas.android.com/apk/res/android", "orientation", "horizontal");
                } else {
                    guideline.setAttribute("http://schemas.android.com/apk/res/android", "orientation", "vertical");
                }
            }
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            presentation.setVisible(true);
            presentation.setEnabled(true);
        }
    }

    static class ControlIcon
    implements Icon {
        Icon myIcon;
        boolean myHighlight;

        ControlIcon(Icon icon) {
            this.myIcon = icon;
        }

        public void setHighlight(boolean mHighlight) {
            this.myHighlight = mHighlight;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.myIcon.paintIcon(c, g, x, y);
            if (this.myHighlight) {
                g.setColor(new Color(240116));
                g.fillRect(x, y + this.getIconHeight() - 2, this.getIconWidth(), 2);
            }
        }

        @Override
        public int getIconWidth() {
            return this.myIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.myIcon.getIconHeight();
        }
    }

    private class ToggleConstraintModeAction
    extends ToggleViewAction {
        public ToggleConstraintModeAction() {
            super(AndroidIcons.SherpaIcons.Unhide, AndroidIcons.SherpaIcons.Hide, "Show Constraints", "Hide Constraints");
            ConstraintLayoutHandler.this.myShowAllConstraints = PropertiesComponent.getInstance().getBoolean(ConstraintLayoutHandler.SHOW_CONSTRAINTS_PREF_KEY);
        }

        @Override
        public boolean isSelected(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren) {
            return ConstraintLayoutHandler.this.myShowAllConstraints;
        }

        @Override
        public void setSelected(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren, boolean selected) {
            ConstraintLayoutHandler.this.myShowAllConstraints = selected;
            PropertiesComponent.getInstance().setValue(ConstraintLayoutHandler.SHOW_CONSTRAINTS_PREF_KEY, ConstraintLayoutHandler.this.myShowAllConstraints);
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers, boolean selected) {
            presentation.setIcon(ConstraintLayoutHandler.this.myShowAllConstraints ? AndroidIcons.SherpaIcons.Unhide : AndroidIcons.SherpaIcons.Hide);
        }
    }

    private static class InferAction
    extends DirectViewAction {
        private InferAction() {
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            ConstraintModel model = ConstraintModel.getConstraintModel(editor.getModel());
            if (model == null) {
                return;
            }
            WidgetsScene scene = model.getScene();
            try {
                Scout.inferConstraints((WidgetsScene)scene);
            }
            catch (Exception e) {
                Logger.getInstance(ConstraintLayoutHandler.class).warn("Error in inferring constraints", (Throwable)e);
            }
            model.saveToXML(true);
            model.setNeedsAnimateConstraints(1);
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            presentation.setIcon(AndroidIcons.SherpaIcons.Inference);
            presentation.setLabel("Infer Constraints");
        }
    }

    private static class LockConstraints
    extends DirectViewAction {
        private LockConstraints() {
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            ConstraintModel model = ConstraintModel.getConstraintModel(editor.getModel());
            if (model == null) {
                return;
            }
            if (model.getSelection().getWidgets().size() == 1) {
                WidgetsScene scene = model.getScene();
                scene.toggleLockConstraints((ConstraintWidget)model.getSelection().getWidgets().get(0));
            }
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            presentation.setIcon(AndroidIcons.SherpaIcons.LockConstraints);
            presentation.setLabel("Locks auto inferred constraints");
        }
    }

    private static class ClearConstraintsAction
    extends DirectViewAction {
        private ClearConstraintsAction() {
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            ConstraintModel model = ConstraintModel.getConstraintModel(editor.getModel());
            if (model == null) {
                return;
            }
            WidgetsScene scene = model.getScene();
            scene.clearAllConstraints();
            model.saveToXML(true);
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            presentation.setIcon(AndroidIcons.SherpaIcons.DeleteConstraint);
            presentation.setLabel("Clear All Constraints");
        }
    }

    private static class ToggleAutoConnectAction
    extends ToggleViewAction
    implements Enableable {
        public ToggleAutoConnectAction() {
            super(AndroidIcons.SherpaIcons.AutoConnectOff, AndroidIcons.SherpaIcons.AutoConnect, "Turn On Autoconnect", "Turn Off Autoconnect");
        }

        @Override
        public void enable(Selection selection) {
        }

        @Override
        public boolean isSelected(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren) {
            return ConstraintModel.isAutoConnect();
        }

        @Override
        public void setSelected(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren, boolean selected) {
            ConstraintModel.setAutoConnect(selected);
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers, boolean selected) {
            presentation.setIcon(ConstraintModel.isAutoConnect() ? AndroidIcons.SherpaIcons.AutoConnect : AndroidIcons.SherpaIcons.AutoConnectOff);
        }

        @Override
        public boolean affectsUndo() {
            return false;
        }
    }

    static interface Enableable {
        public void enable(Selection var1);
    }
}

