/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import android.support.constraint.solver.widgets.ConstraintWidget;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintModel;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintUtilities;
import com.android.tools.idea.uibuilder.model.AttributesTransaction;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.sherpa.structure.WidgetCompanion;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstraintDragHandler
extends DragHandler {
    private ConstraintWidget myDragWidget;
    private NlComponent myComponent;

    public ConstraintDragHandler(@NotNull ViewEditor editor, @NotNull ConstraintLayoutHandler constraintLayoutHandler, @NotNull NlComponent layout, @NotNull List<NlComponent> components, DragType type) {
        super(editor, constraintLayoutHandler, layout, components, type);
        if (components.size() == 1) {
            this.myComponent = components.get(0);
            ConstraintModel model = ConstraintModel.getConstraintModel(editor.getModel());
            if (model.getScene().getWidget((Object)this.myComponent) == null) {
                this.myDragWidget = new ConstraintWidget();
                WidgetCompanion companion = WidgetCompanion.create((ConstraintWidget)this.myDragWidget);
                companion.setWidgetModel((Object)this.myComponent);
                companion.setWidgetTag((Object)this.myComponent);
                this.myDragWidget.setCompanionWidget((Object)companion);
            } else {
                this.myComponent = null;
            }
        }
    }

    @Override
    public void start(int x, int y, int modifiers) {
        super.start(x, y, modifiers);
        ConstraintModel model = ConstraintModel.getConstraintModel(this.editor.getModel());
        if (this.myComponent != null && this.myDragWidget != null && model != null && model.getScene() != null && model.getScene().getRoot() != null) {
            model.getSelection().clear();
            model.getScene().getRoot().add(this.myDragWidget);
            model.getScene().addWidget(this.myDragWidget);
            int ax = model.pxToDp(x - this.layout.x - this.layout.getPadding().left - this.myComponent.w / 2);
            int ay = model.pxToDp(y - this.layout.y - this.layout.getPadding().top - this.myComponent.h / 2);
            this.myDragWidget.setDimension(model.pxToDp(this.myComponent.w), model.pxToDp(this.myComponent.h));
            this.myDragWidget.setX(ax);
            this.myDragWidget.setY(ay);
            model.setDragDropWidget(this.myDragWidget);
            model.getSelection().add(this.myDragWidget);
        }
    }

    @Override
    @Nullable
    public String update(int x, int y, int modifiers) {
        String result = super.update(x, y, modifiers);
        if (this.myComponent != null && this.myDragWidget != null) {
            ConstraintModel model = ConstraintModel.getConstraintModel(this.editor.getModel());
            int ax = x - this.layout.x - this.layout.getPadding().left - this.myComponent.w / 2;
            int ay = y - this.layout.y - this.layout.getPadding().top - this.myComponent.h / 2;
            model.dragComponent(ax, ay);
        }
        return result;
    }

    @Override
    public void cancel() {
        if (this.myDragWidget != null) {
            ConstraintModel model = ConstraintModel.getConstraintModel(this.editor.getModel());
            model.removeDragComponent();
        }
    }

    @Override
    public void commit(int x, int y, int modifiers) {
        if (this.myComponent != null) {
            this.myComponent = (NlComponent)this.components.get(0);
            this.myComponent.x = x;
            this.myComponent.y = y;
            NlComponent root = this.myComponent.getRoot();
            root.ensureNamespace("app", "http://schemas.android.com/apk/res-auto");
            ConstraintModel model = ConstraintModel.getConstraintModel(this.editor.getModel());
            if (model != null) {
                int ax = model.pxToDp(x - this.layout.x - this.layout.getPadding().left - this.myComponent.w / 2);
                int ay = model.pxToDp(y - this.layout.y - this.layout.getPadding().top - this.myComponent.h / 2);
                AttributesTransaction attributes = this.myComponent.startAttributeTransaction();
                ConstraintUtilities.setEditorPosition(null, attributes, ax, ay);
                attributes.commit();
            }
            if (this.myDragWidget != null) {
                model.commitDragComponent(this.myComponent);
            }
        }
    }

    @Override
    public void paint(@NotNull NlGraphics graphics) {
    }
}

