/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlBuilder;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Set;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

public class TextViewHandler
extends ViewHandler {
    private static final Set<String> HAVE_REDUCED_SCALE_IN_PREVIEW = ImmutableSet.of((Object)"AutoCompleteTextView", (Object)"EditText", (Object)"MultiAutoCompleteTextView");

    @Override
    @NotNull
    public String getTitleAttributes(@NotNull NlComponent component) {
        String text = component.getAttribute("http://schemas.android.com/apk/res/android", "text");
        if (!StringUtil.isEmpty((String)text)) {
            return String.format("- \"%1$s\"", text);
        }
        return super.getTitleAttributes(component);
    }

    @Override
    @Language(value="XML")
    @NotNull
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        return new XmlBuilder().startTag(tagName).androidAttribute("text", tagName).androidAttribute("layout_width", "wrap_content").androidAttribute("layout_height", "wrap_content").endTag(tagName).toString();
    }

    @Override
    public double getPreviewScale(@NotNull String tagName) {
        if (HAVE_REDUCED_SCALE_IN_PREVIEW.contains(tagName)) {
            return 0.8;
        }
        return super.getPreviewScale(tagName);
    }
}

